/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.PaymentBillModel;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.formplugin.importplugin.BaseBillImport;
import kd.fi.cas.formplugin.importplugin.importservice.ImportHelper;
import kd.fi.cas.formplugin.importplugin.importservice.PaymentBillImportService;
import kd.fi.cas.helper.CasHelper;

public class PaymentBillImport
extends BaseBillImport {
    private PaymentBillImportService impService;
    private static Log logger = LogFactory.getLog(PaymentBillImport.class);

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        logger.info("PaymentBillImport data:{}", (Object)JSONObject.toJSONString(data));
        this.impService = new PaymentBillImportService(data, option);
        ImportHelper importHelper = new ImportHelper("cas_paybill", data);
        try {
            this.billChecks();
            this.impService.queryCheck();
            this.impService.setPayeeInfo();
            this.impService.setPayeeBankInfo();
            this.impService.checkTextLength();
            DynamicObject billType = importHelper.loadBasedata("billtype", 0);
            this.impService.checkBillStatusByKeyFields();
            JSONArray entryList = (JSONArray)data.get("entry");
            String billTypeNumber = billType.getString("number");
            if (entryList != null) {
                for (int i = 0; i < entryList.size(); ++i) {
                    JSONObject row = (JSONObject)entryList.get(i);
                    this.entryChecks(row, i);
                    this.impService.calcEntryAmt(row, billTypeNumber);
                    this.impService.toLocalAmt("e_payableamt", "e_payablelocamt", row);
                    this.impService.toLocalAmt("e_discountamt", "e_discountlocamt", row);
                    this.impService.toLocalAmt("e_actamt", "e_localamt", row);
                }
            }
            HashMap<String, String> sumRelation = new HashMap<String, String>();
            sumRelation.put("e_actamt", "actpayamt");
            sumRelation.put("e_localamt", "localamt");
            this.impService.toSumAmt(sumRelation, entryList);
            this.impService.isZeroPayment(billTypeNumber);
        }
        catch (Exception exc) {
            this.throwException(exc, importlogs);
            return false;
        }
        return true;
    }

    private void billChecks() throws Exception {
        this.impService.checkOrg();
        this.impService.checkNull("bizdate", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"PaymentBillImport_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.impService.checkF7("paymenttype", ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b", (String)"PaymentBillImport_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), true, null);
        this.impService.checkEnum("payeetype", ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b", (String)"PaymentBillImport_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), false, PaymentBillModel.ENUMS_PAYEETYPE, null);
        this.impService.checkNull("billtype", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"PaymentBillImport_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.impService.checkF7("currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"PaymentBillImport_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), true, "CNY");
        this.impService.checkExchangeRate();
        this.impService.checkF7("basecurrency", ResManager.loadKDString((String)"\u516c\u53f8\u672c\u4f4d\u5e01", (String)"PaymentBillImport_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), true, "CNY");
        this.impService.checkEnum("sourcetype", ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf", (String)"PaymentBillImport_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), false, PaymentBillModel.ENUMS_SOURCETYPE, null);
        this.impService.checkEnum("entrance", ResManager.loadKDString((String)"\u65b0\u589e\u5165\u53e3", (String)"PaymentBillImport_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), false, PaymentBillModel.ENUMS_ENTRANCE, null);
        JSONObject value = (JSONObject)this.data.get("settletype");
        if (null != value) {
            Map settletype = (Map)value.toJavaObject(Map.class);
            String number = (String)settletype.get("number");
            String name = (String)settletype.get("name");
            QFilter settleFilter = null;
            if (CasHelper.isNotEmpty((Object)number)) {
                settleFilter = new QFilter("number", "=", (Object)number);
            } else if (CasHelper.isNotEmpty((Object)name)) {
                settleFilter = new QFilter("name", "=", (Object)name);
            }
            DynamicObject settlementtype = BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"settlementtype", (QFilter[])new QFilter[]{settleFilter});
            if (CasHelper.isNotEmpty((Object)settlementtype) && !"0".equals(settlementtype.getString("settlementtype"))) {
                this.impService.checkEnum("paymentmode", ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9\u5f0f", (String)"PaymentBillImport_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), false, PaymentBillModel.ENUMS_PAYMENTMODE, null);
                this.impService.checkF7("payeracctbank", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"PaymentBillImport_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), true, null);
                this.impService.checkF7("payerbank", ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c", (String)"PaymentBillImport_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), true, null);
            }
            JSONObject payerAcctBankJson = (JSONObject)this.data.get("payeracctbank");
            JSONObject payerBankJson = (JSONObject)this.data.get("payerbank");
            this.impService.checkBankAndAcctBank(payerAcctBankJson, payerBankJson, Boolean.TRUE);
            if (CasHelper.isNotEmpty((Object)settlementtype) && "15".equals(settlementtype.getString("settlementtype"))) {
                this.data.put("businesstype", PayBusinessTypeEnum.WALLETTRANSFER.getValue());
            }
        }
    }

    private void entryChecks(JSONObject row, int i) throws Exception {
        this.impService.checkEntryEnum("e_corebilltype", ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b", (String)"PaymentBillImport_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), row, i, false, PaymentBillModel.ENTRY_ENUMS_COREBILLTYPE, null);
    }
}

