/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.fi.cas.consts.ReceivingBillModel;
import kd.fi.cas.formplugin.importplugin.BaseBillImport;
import kd.fi.cas.formplugin.importplugin.importservice.ReceivingBillImportService;

public class ReceivingBillImport
extends BaseBillImport {
    private ReceivingBillImportService impService;

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        this.impService = new ReceivingBillImportService(data, option);
        try {
            this.billChecks();
            this.impService.queryCheck();
            this.impService.setPayerInfo();
            this.impService.setPayerBankInfo();
            this.impService.checkTextLength();
            this.impService.checkBillStatusByKeyFields();
            JSONArray entryList = (JSONArray)data.get("entry");
            JSONObject receivingtype = (JSONObject)data.get("receivingtype");
            String billtype = (String)data.get("biztype");
            if (billtype == null || "".equals(billtype)) {
                billtype = "OtherRec";
                data.put("biztype", billtype);
            }
            if (entryList != null) {
                for (int i = 0; i < entryList.size(); ++i) {
                    JSONObject row = (JSONObject)entryList.get(i);
                    this.impService.calcEntryAmt(row, receivingtype, billtype);
                    this.impService.toLocalAmt("e_actamt", "e_localamt", row);
                    this.impService.toLocalAmt("e_receivableamt", "e_receivablelocamt", row);
                    this.impService.toLocalAmt("e_discountamt", "e_discountlocamt", row);
                }
            }
            HashMap<String, String> sumRelation = new HashMap<String, String>();
            sumRelation.put("e_actamt", "actrecamt");
            sumRelation.put("e_localamt", "localamt");
            this.impService.toSumAmt(sumRelation, entryList);
            this.impService.isZeroReceiving(receivingtype, billtype);
        }
        catch (Exception exc) {
            this.throwException(exc, importlogs);
            return false;
        }
        return true;
    }

    private void billChecks() throws Exception {
        this.impService.checkOrg();
        this.impService.checkNull("bizdate", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"ReceivingBillImport_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.impService.checkF7("receivingtype", ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b", (String)"ReceivingBillImport_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), true, null);
        this.impService.checkEnum("payertype", ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u7c7b\u578b", (String)"ReceivingBillImport_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), false, ReceivingBillModel.HEAD_ENUMS_PAYERTYPE, null);
        this.impService.checkF7("basecurrency", ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"ReceivingBillImport_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), true, "CNY");
        this.impService.checkEnum("biztype", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"ReceivingBillImport_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), false, ReceivingBillModel.HEAD_ENUMS_BIZTYPE, null);
        this.impService.checkExchangeRate();
        JSONObject payeeAcctBankJson = (JSONObject)this.data.get("accountbank");
        JSONObject payeeBankJson = (JSONObject)this.data.get("payeebank");
        this.impService.checkBankAndAcctBank(payeeAcctBankJson, payeeBankJson, Boolean.FALSE);
    }
}

