/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.consts.ReceivingBillModel;
import kd.fi.cas.formplugin.importplugin.importservice.ReceivingBillImportServiceNew;

public class ReceivingBillImportNew
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(ReceivingBillImportNew.class);
    private ReceivingBillImportServiceNew impService;
    private int BATCHSIZE_MIN = 1000;
    private int BATCHSIZE_DEFAULT = 8000;

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return this.getBatchSize();
    }

    protected void beforeSave(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeSave(rowdatas, logger);
        log.info("ReceivingBillImportNew.beforeSave.rowdatas:{}", (Object)rowdatas.size());
        this.check(rowdatas, logger);
    }

    private void check(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.impService = new ReceivingBillImportServiceNew(rowdatas, logger, this.ctx.getOption());
        try {
            this.billChecks(rowdatas, logger);
            this.impService.queryCheck(rowdatas, logger);
            this.impService.setPayerInfo(rowdatas, logger);
            this.impService.setPayerBankInfo(rowdatas, logger);
            this.impService.checkTextLength(rowdatas, logger);
            this.impService.checkBillStatusByKeyFields(rowdatas, logger);
            this.impService.doAmt(rowdatas, logger);
            this.impService.toSumAmt(rowdatas);
            this.impService.isZeroReceiving(rowdatas, logger);
            this.impService.removeErrRows(rowdatas);
        }
        catch (Exception exc) {
            log.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)exc));
            throw new KDException((Throwable)exc, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void billChecks(List<ImportBillData> rowdatas, ImportLogger logger) throws Exception {
        this.impService.checkOrg(rowdatas, logger);
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            if (this.impService.isErrRow(rowdata)) continue;
            this.impService.checkNull(rowdata, logger, data, "bizdate", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"ReceivingBillImport_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            this.impService.checkF7(rowdata, logger, data, "receivingtype", ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b", (String)"ReceivingBillImport_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), true, null);
            this.impService.checkEnum(rowdata, logger, data, "payertype", ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u7c7b\u578b", (String)"ReceivingBillImport_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), false, ReceivingBillModel.HEAD_ENUMS_PAYERTYPE, null);
            this.impService.checkF7(rowdata, logger, data, "basecurrency", ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"ReceivingBillImport_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), true, "CNY");
            this.impService.checkEnum(rowdata, logger, data, "biztype", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"ReceivingBillImport_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), false, ReceivingBillModel.HEAD_ENUMS_BIZTYPE, null);
        }
        this.impService.checkExchangeRate(rowdatas, logger);
    }

    private int getBatchSize() {
        try {
            int batch;
            QFilter batchSize = new QFilter("number", "=", (Object)"fi.cas.import.recbill.batchsize");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            DynamicObject batchDy = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)"configvalue", (QFilter[])new QFilter[]{batchSize, enable});
            if (batchDy != null && (batch = Integer.parseInt(batchDy.getString("configvalue").trim())) > this.BATCHSIZE_MIN) {
                return batch;
            }
        }
        catch (Exception e) {
            return this.BATCHSIZE_DEFAULT;
        }
        return this.BATCHSIZE_DEFAULT;
    }
}

