/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.importplugin.importservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.util.EntityMetadataUtils;

public class ImportHelper {
    private Map<String, Object> importData;
    private String entityKey;

    public ImportHelper(String entityKey, Map<String, Object> importData) {
        this.importData = importData;
        this.entityKey = entityKey;
    }

    public DynamicObject loadBasedata(String key) {
        return this.loadBasedata(key, 0);
    }

    public DynamicObject loadBasedata(String key, int rowIndex) {
        return this.loadBasedata(key, rowIndex, null);
    }

    public DynamicObject loadBasedata(String key, int rowIndex, String selectors) {
        BasedataProp property = (BasedataProp)EntityMetadataUtils.getProperty((String)this.entityKey, (String)key);
        String basedataEntityKey = property.getBaseEntityId();
        JSONObject row = null;
        JSONObject basedataJsonInfo = (JSONObject)this.importData.get(key);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityKey);
        if (EntityMetadataUtils.isEntryField((MainEntityType)dataEntityType, (String)key)) {
            EntryProp entryProp = EntityMetadataUtils.getEntryProp((IDataEntityType)dataEntityType);
            JSONArray entryData = (JSONArray)this.importData.get(entryProp.getName());
            row = (JSONObject)entryData.get(rowIndex);
            basedataJsonInfo = (JSONObject)row.get((Object)key);
        }
        if (property instanceof ItemClassProp) {
            String typePropName = ((ItemClassProp)property).getTypePropName();
            DynamicProperty property2 = EntityMetadataUtils.getProperty((String)this.entityKey, (String)typePropName);
            basedataEntityKey = (String)this.importData.get(property2.getName());
            if (EntityMetadataUtils.isEntryField((MainEntityType)dataEntityType, (String)typePropName) && row != null) {
                basedataEntityKey = (String)row.get((Object)property2.getName());
            }
        }
        if (basedataJsonInfo == null) {
            return null;
        }
        String number = null;
        String name = null;
        BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)basedataEntityKey);
        String nameProperty = basedataEntityType.getNameProperty();
        String numberProperty = basedataEntityType.getNumberProperty();
        if (selectors == null) {
            selectors = String.join((CharSequence)",", "id", nameProperty, numberProperty);
        }
        String numberStr = "number";
        if ("bd_accountbanks".equals(basedataEntityKey)) {
            numberStr = "bankaccountnumber";
        }
        if (basedataJsonInfo.containsKey((Object)numberStr) && basedataJsonInfo.containsKey((Object)"name")) {
            number = basedataJsonInfo.getString(numberStr);
            name = basedataJsonInfo.getString("name");
        } else if (basedataJsonInfo.containsKey((Object)numberStr)) {
            number = basedataJsonInfo.getString(numberStr);
        } else if (basedataJsonInfo.containsKey((Object)"name")) {
            name = basedataJsonInfo.getString("name");
        } else {
            String displayName = basedataEntityType.getDisplayName().getLocaleValue();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u57fa\u7840\u8d44\u6599\u201c%s\u201d\u4fe1\u606f\u4e2d\u6ca1\u6709\u5305\u542b\u9700\u8981\u7684\u5c5e\u6027\uff1a\u540d\u79f0\u3001\u7f16\u7801\u3002", (String)"ImportHelper_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), displayName));
        }
        QFilter filter = null;
        if (number != null && name != null) {
            filter = new QFilter(numberProperty, "=", (Object)number).and(new QFilter(nameProperty, "=", (Object)name));
        } else if (number != null) {
            filter = new QFilter(numberProperty, "=", (Object)number);
        } else if (name != null) {
            filter = new QFilter(nameProperty, "=", (Object)name);
        } else {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u57fa\u7840\u8d44\u6599\u540d\u79f0\u5c5e\u6027\u548c\u7f16\u7801\u5c5e\u6027\u90fd\u4e3a\u7a7a\u3002", (String)"ImportHelper_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        DynamicObject basedata = BusinessDataServiceHelper.loadSingleFromCache((String)basedataEntityKey, (String)selectors, (QFilter[])new QFilter[]{filter});
        if (basedata == null) {
            String displayName = basedataEntityType.getDisplayName().getLocaleValue();
            if (name != null && number != null) {
                if (rowIndex == 0) {
                    this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u4e14\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684%3$s\u3002", (String)"ImportHelper_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), number, name, displayName));
                } else {
                    this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u7cfb\u7edf\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u4e14\u540d\u79f0\u4e3a\u201c%3$s\u201d\u7684%4$s\u3002", (String)"ImportHelper_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowIndex, number, name, displayName));
                }
            } else if (number != null) {
                if (rowIndex == 0) {
                    this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684%2$s\u3002", (String)"ImportHelper_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), number, displayName));
                } else {
                    this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u7cfb\u7edf\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684%3$s\u3002", (String)"ImportHelper_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowIndex, number, displayName));
                }
            } else if (rowIndex == 0) {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%1$s\u201d\u7684%2$s\u3002", (String)"ImportHelper_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), name, displayName));
            } else {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u7cfb\u7edf\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684%3$s\u3002", (String)"ImportHelper_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowIndex, name, displayName));
            }
        }
        return basedata;
    }

    private void addErrMessage(String message) {
        throw new KDBizException(message);
    }

    public BigDecimal getBigDecimal(String key) {
        Object value = this.importData.get(key);
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value != null) {
            try {
                return BigDecimal.valueOf(Double.parseDouble(value.toString()));
            }
            catch (NumberFormatException nfe) {
                this.addErrMessage(nfe.getMessage());
            }
        }
        return null;
    }
}

