/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.EmptyUtil;

public class CasResetInitBalanceEdit
extends AbstractBillPlugIn {
    private List<Long> orgList = null;
    public static final String ORG_LIST = "INIT_BALANCE_ORG_LIST";

    public void initialize() {
        super.initialize();
        this.loadOrg();
        this.initF7();
    }

    public void afterCreateNewData(EventObject e) {
        Object org;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        DynamicObject cashMgtInit = null;
        Long orgId = null;
        if (showParameter != null && showParameter.getCustomParam("showedForm") == null && showParameter.getCustomParam("org") != null && showParameter.getCustomParam("orgId") != null) {
            org = showParameter.getCustomParam("org");
            Object orgIdOject = showParameter.getCustomParam("orgId");
            orgId = orgIdOject instanceof Integer ? Long.valueOf(String.valueOf(orgIdOject)) : (Long)showParameter.getCustomParam("orgId");
            cashMgtInit = PeriodHelper.getCashMgtInit((Object)org);
            this.getModel().setValue("org", org);
            this.getView().getFormShowParameter().setCustomParam("showedForm", (Object)true);
        } else {
            org = (DynamicObject)this.getModel().getValue("org");
            orgId = org.getLong("id");
            cashMgtInit = PeriodHelper.getCashMgtInit((Object)org.getPkValue());
        }
        if (cashMgtInit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u51fa\u7eb3\u521d\u59cb\u5316\u5f02\u5e38", (String)"CashMgtInitEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        this.setValue("startperiod", cashMgtInit.getDynamicObject("startperiod"));
        this.setValue("currentperiod", cashMgtInit.getDynamicObject("currentperiod"));
        this.setValue("resetinitbalperiod", cashMgtInit.getDynamicObject("currentperiod"));
        this.loadAccountBalanceInfo(orgId, cashMgtInit);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            dynamicObject.getDataEntityState().setBizChanged(false);
        }
    }

    private void loadOrg() {
        if (this.orgList != null) {
            return;
        }
        String orgListStr = this.getPageCache().get(ORG_LIST);
        if (orgListStr == null) {
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            List allOrg = OrgHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cas_cashmgtinit", (String)"47150e89000000ac");
            this.orgList = OrgHelper.getInitCasOrgIds((String)"cas_cashmgtinit", (List)allOrg);
            this.getPageCache().put(ORG_LIST, SerializationUtils.toJsonString(this.orgList));
            return;
        }
        this.orgList = new ArrayList<Long>(100);
        List antiSerialOrgList = (List)SerializationUtils.fromJsonString((String)orgListStr, List.class);
        for (int i = 0; i < antiSerialOrgList.size(); ++i) {
            if (antiSerialOrgList.get(i) instanceof Integer) {
                this.orgList.add(new BigDecimal((Integer)antiSerialOrgList.get(i)).longValue());
                continue;
            }
            if (antiSerialOrgList.get(i) instanceof Long) {
                this.orgList.add((Long)antiSerialOrgList.get(i));
                continue;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b\uff1a%s\u3002", (String)"CashMgtInitEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), antiSerialOrgList.get(i).getClass()));
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity;
        DynamicObjectCollection entryEntity;
        super.afterBindData(e);
        String status = this.getModel().getDataEntity().getString("billstatus");
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) && "A".equals(status) && (entryEntity = (dataEntity = this.getModel().getDataEntity()).getDynamicObjectCollection("entryentity")).size() == 0) {
            this.afterCreateNewData(null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String key = op.getOperateKey();
        ArrayList removeDynamicObject = new ArrayList(100);
        if (entryEntity.size() == 0 && ("save".equals(key) || "unsubmit".equals(key) || "unaudit".equals(key))) {
            this.afterCreateNewData(null);
            return;
        }
        if (entryEntity.size() == 0 && "submit".equals(key)) {
            IDataModel dataModel = this.getModel();
            dataModel.deleteEntryData("entryentity");
            return;
        }
        if (removeDynamicObject.size() > 0) {
            this.getView().updateView("entryentity");
        }
    }

    private void initF7() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getView().getControl("org");
        orgCtrl.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                QFilter qFilter = new QFilter("id", "in", (Object)CasResetInitBalanceEdit.this.orgList);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void setValue(String key, Object value) {
        if (value instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)value;
            this.getModel().setValue(key, dy.getPkValue());
        } else {
            this.getModel().setValue(key, value);
        }
    }

    private void loadAccountBalanceInfo(Long orgId, DynamicObject cashMgtInit) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        Map accountCashMap = BusinessDataServiceHelper.loadFromCache((String)"cas_accountcash", (QFilter[])filters);
        for (DynamicObject accountCash : accountCashMap.values()) {
            DynamicObjectCollection currencyList = accountCash.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencyList) {
                int cashEntryIndex = dataModel.createNewEntryRow("entryentity");
                this.setValue("cash_accountcash", accountCash, cashEntryIndex);
                this.setValue("cash_accountcashnumber", CasResetInitBalanceEdit.getAccountCashDisplay(accountCash), cashEntryIndex);
                this.setValue("currency", currency.get("fbasedataid"), cashEntryIndex);
                this.setValue("type", "cash", cashEntryIndex);
                this.setValue("initbalance", null, cashEntryIndex);
            }
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(orgId);
        QFilter accountBankFilterByOrg = AccountBankHelper.getAccountBankFilterByOrg(orgIds);
        boolean isShowInnerAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"am").getId(), (String)"08", (Long)orgId, (String)"isshowinternalaccount");
        if (!isShowInnerAccount) {
            accountBankFilterByOrg.and(new QFilter("finorgtype", "!=", (Object)Character.valueOf('1')));
        }
        Map accountBankMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{accountBankFilterByOrg});
        for (DynamicObject accountbank : accountBankMap.values()) {
            DynamicObjectCollection currencyList = accountbank.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencyList) {
                if (CasHelper.isEmpty((Object)currency) || CasHelper.isEmpty((Object)currency.get("fbasedataid"))) continue;
                int cashEntryIndex = dataModel.createNewEntryRow("entryentity");
                this.setValue("bank_accountbank", accountbank.getPkValue(), cashEntryIndex);
                DynamicObject openOrg = accountbank.getDynamicObject("openorg");
                if (openOrg != null && EmptyUtil.isNoEmpty((DynamicObject)openOrg)) {
                    this.setValue("bank_openorg", openOrg.getPkValue(), cashEntryIndex);
                } else {
                    this.setValue("bank_openorg", accountbank.getLong("openorg_id"), cashEntryIndex);
                }
                this.setValue("bank_bankaccountnumber", CasResetInitBalanceEdit.getAccountBankDisplay(accountbank), cashEntryIndex);
                this.setValue("currency", currency.get("fbasedataid"), cashEntryIndex);
                this.setValue("type", "bank", cashEntryIndex);
                this.setValue("initbalance", null, cashEntryIndex);
            }
        }
    }

    public void setValue(String key, Object value, int rowIndex) {
        if (value instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)value;
            this.getModel().setValue(key, dy.getPkValue(), rowIndex);
        } else {
            this.getModel().setValue(key, value, rowIndex);
        }
    }

    private static String getAccountCashDisplay(DynamicObject accountCash) {
        if (accountCash == null) {
            return "";
        }
        if (accountCash.getString("number") != null && !accountCash.getString("number").trim().equals("")) {
            return accountCash.getString("number") + "\n" + accountCash.getString("name");
        }
        accountCash = AccountCashHelper.getAccountCashById((long)accountCash.getLong("id"));
        return accountCash.getString("number") + "\n" + accountCash.getString("name");
    }

    private static String getAccountBankDisplay(DynamicObject accountBank) {
        if (accountBank == null) {
            return "";
        }
        if (accountBank.getString("bankaccountnumber") != null && !accountBank.getString("bankaccountnumber").trim().equals("")) {
            return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
        }
        accountBank = AccountBankHelper.getAccountBankById((long)accountBank.getLong("id"));
        return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
    }
}

