/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.journalprintall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.formplugin.BankJournalFormRpt;
import kd.fi.cas.formplugin.CashJournalFormRpt;
import kd.fi.cas.formplugin.journalprintall.JournalPrintHelper;
import kd.fi.cas.formplugin.journalprintall.JsonObjectAdapter;
import kd.fi.cas.formplugin.journalprintall.ShowBosPrintingProgress;
import kd.fi.cas.helper.PermissionHelper;

public class JournalPrintFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    protected static final String REPORT_LIST_AP = "reportlistap";
    private final IReportCache reportCache = ReportCacheManager.getInstance().getCache();
    protected static final Log log = LogFactory.getLog(JournalPrintFormPlugin.class);
    private Map<Long, RowDataInfo> org2CacheID;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.getProgressBar().addProgressListener((ProgresssListener)this);
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getControl("multiorgsprint_bar");
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        log.info("JournalPrintFormPlugin.itemclick.key:" + this.getView().getEntityId());
        if ("printbar".equalsIgnoreCase(key)) {
            this.doMultiOrgPrint("printbar".equals(key), this.getView().getEntityId());
        }
        if ("clearprintstatus".equalsIgnoreCase(key)) {
            this.changePrintStatus(PrintStatus.ALL_DONE);
        }
    }

    private HasPermOrgResult getAllPermOrgs(String entityId, String permType) {
        String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
        return PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()), (String)"10", (String)appId, (String)entityId, (String)permType);
    }

    private boolean checkOrgsPerm(String formId, Set<Long> selectOrgs) {
        HasPermOrgResult allPermOrgs = this.getAllPermOrgs(formId, "4730fc9e000000ac");
        if (!allPermOrgs.hasAllOrgPerm()) {
            HashSet permOrgs = new HashSet(allPermOrgs.getHasPermOrgs());
            selectOrgs.removeAll(permOrgs);
            if (selectOrgs.size() > 0) {
                String orgNameStr = QueryServiceHelper.query((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "in", selectOrgs).toArray()).stream().map(dyo -> dyo.getString("name")).collect(Collectors.joining(", "));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u7ec4\u7ec7\u3010%s\u3011\u65e5\u8bb0\u8d26\u201d\u7684\u201c\u6253\u5370\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"JournalPrintFormPlugin_01", (String)"fi-cas-formplugin", (Object[])new Object[0]), orgNameStr));
                return false;
            }
        }
        return true;
    }

    private boolean checkIsNewTemplate(Object templateId) {
        boolean exists = this.exists("bos_manageprinttpl", templateId);
        if (!exists) {
            exists = this.exists("bas_manageprinttpl", templateId);
        }
        return exists;
    }

    private boolean exists(String formId, Object templateId) {
        QFilter qf = new QFilter("printtplid", "=", templateId);
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)formId, (String)"type", (QFilter[])qf.toArray());
        if (defaultObj != null) {
            return "B".equalsIgnoreCase(defaultObj.getString("type"));
        }
        return true;
    }

    private void doMultiOrgPrint(Boolean isPrintAll, String formId) {
        try {
            List<Long> orgValue = this.getOrgValue();
            String appId = this.getView().getFormShowParameter().getAppId();
            boolean hasPermission = PermissionHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgValue.get(0), (String)appId, (String)formId, (String)"4FSLZMX5JTT1");
            if (!hasPermission) {
                String caption = this.getView().getFormShowParameter().getCaption();
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u6253\u5370\u6240\u6709\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JournalPrintFormPlugin_08", (String)"fi-cas-formplugin", (Object[])new Object[0]), caption));
                return;
            }
            if (this.isPrintJobWorking().booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e", (String)"JournalPrintFormPlugin_03", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object defaultTemplateId = JournalPrintHelper.getDefaultTemplateId(formId);
            if (!this.checkIsNewTemplate(defaultTemplateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u6253\u5370\u8bbe\u7f6e\u4e3a\u6a21\u677f\u7c7b\u578b\u4e3a\u65b0\u6a21\u677f\u7684\u6253\u5370\u6a21\u677f\u540e\uff0c\u518d\u4f7f\u7528\u6253\u5370\u6240\u6709\u529f\u80fd", (String)"JournalPrintFormPlugin_04", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (String)"JournalPrintFormPlugin_05", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            log.info("JournalPrintFormPlugin.doMultiOrgPrint.templateId:{}.", (Object)defaultTemplateId.toString());
            this.getReportPageCache().put("isprintall", isPrintAll.toString());
            this.changePrintStatus(PrintStatus.CREATE);
            this.getProgressBar().start();
        }
        catch (Exception e) {
            this.changePrintStatus(PrintStatus.ALL_DONE);
            log.info("doMultiOrgPrint:" + e.getMessage() + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
    }

    private List<Long> getOrgValue() {
        String orgField = "org";
        String orgType = "";
        if ("cas_bankjournalformrpt".equalsIgnoreCase(this.getView().getEntityId())) {
            orgType = this.getModel().getValue("queryorgtype").toString();
        }
        if ("openorg".equalsIgnoreCase(orgType)) {
            orgField = "openorg";
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(orgField);
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    public void onProgress(ProgressEvent progressEvent) {
        try {
            log.info("onProgress.status:{}.", (Object)this.printStatus());
            switch (this.printStatus()) {
                case CREATE: {
                    this.showOrgProgress(this.getView().getPageId(), -1, -1, null);
                    this.changePrintStatus(PrintStatus.WAITING_INIT);
                    break;
                }
                case WAITING_INIT: {
                    this.initAllSingleOrgDS();
                    this.changePrintStatus(PrintStatus.DONE_INIT);
                    break;
                }
                case DONE_INIT: 
                case SINGLE_DONE: {
                    this.moveToNextOrg();
                    break;
                }
                case PRINTING: {
                    break;
                }
                case ALL_DONE: {
                    this.getProgressBar().stop();
                }
            }
        }
        catch (Exception e) {
            this.changePrintStatus(PrintStatus.ALL_DONE);
            log.info("onProgress:" + e.getMessage() + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
    }

    private void showOrgProgress(String printPageID, int totalNum, int doneNum, String orgName) {
        Integer duration = 5000;
        IFormView printView = this.getView().getView(printPageID);
        if (totalNum != -1) {
            printView.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6253\u5370%1$s\u7ec4\u7ec7\u7684\u65e5\u8bb0\u8d26\uff08\u7b2c%2$s\u5bb6/\u5171%3$s\u5bb6\uff09", (String)"JournalPrintFormPlugin_06", (String)"fi-cas-formplugin", (Object[])new Object[0]), orgName, doneNum + 1, totalNum), duration);
        }
        this.getView().sendFormAction(printView);
    }

    private Map<Long, RowDataInfo> getAllSingleOrgDS() {
        if (this.org2CacheID == null) {
            this.org2CacheID = (Map)JSON.parseObject((String)this.getReportPageCache().get("org2dataset"), (TypeReference)new TypeReference<Map<Long, RowDataInfo>>(){}, (Feature[])new Feature[0]);
        }
        return this.org2CacheID;
    }

    private Map<Long, RowDataInfo> initAllSingleOrgDS() {
        this.org2CacheID = this.doSingleOrgResultInit();
        this.getReportPageCache().put("org2dataset", SerializationUtils.toJsonString(this.org2CacheID));
        return this.org2CacheID;
    }

    private Map<Long, RowDataInfo> doSingleOrgResultInit() {
        ReportList reportList = (ReportList)this.getView().getControl(REPORT_LIST_AP);
        ReportListModel reportModel = (ReportListModel)reportList.getReportModel();
        if (Boolean.parseBoolean(this.getReportPageCache().get("isprintall"))) {
            reportModel = this.getExportAllReportModel(reportList);
        } else {
            List ids;
            TreeView reportTree = (TreeView)this.getView().getControl("reporttreeap");
            if (reportTree != null && !(ids = reportTree.getTreeState().getSelectedNodeId()).isEmpty() && ((String)ids.get(0)).equals("0")) {
                this.changePrintStatus(PrintStatus.ALL_DONE);
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e", (String)"JournalPrintFormPlugin_07", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
        ReportTaskResult multiOrgResult = this.reportCache.getReportTaskResult(reportModel.getPageId(), reportModel.getCtrlId());
        return this.splitToSingleOrgDS(multiOrgResult);
    }

    private Map<Long, RowDataInfo> splitToSingleOrgDS(ReportTaskResult multiOrgResult) {
        DataSet multiOrgDS;
        if (multiOrgResult != null && (multiOrgDS = Algo.getCacheDataSet((String)multiOrgResult.getResultId()).toDataSet(Algo.create((String)(((Object)((Object)this)).getClass().getSimpleName() + "#getMultiOrgResult")), false)).hasNext()) {
            HashMap<Long, RowDataInfo> res = new HashMap<Long, RowDataInfo>();
            Long curOrg = -1L;
            int count = 0;
            CachedDataSetBuilder builder = new CachedDataSetBuilder(multiOrgDS.getRowMeta(), CacheHint.getDefault());
            for (Row row : multiOrgDS) {
                Long nextOrg = row.getLong("orgid");
                if (curOrg == -1L) {
                    curOrg = nextOrg;
                }
                if (!curOrg.equals(nextOrg)) {
                    res.put(curOrg, this.getRowDataInfo(builder.build().getCacheId(), count));
                    builder = new CachedDataSetBuilder(multiOrgDS.getRowMeta(), CacheHint.getDefault());
                    curOrg = nextOrg;
                    count = 0;
                }
                builder.append((Row)((AbstractRow)row).persist());
                ++count;
            }
            res.put(curOrg, this.getRowDataInfo(builder.build().getCacheId(), count));
            return res;
        }
        this.changePrintStatus(PrintStatus.ALL_DONE);
        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e", (String)"JournalPrintFormPlugin_07", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    private RowDataInfo getRowDataInfo(String cacheId, Integer count) {
        RowDataInfo returns = new RowDataInfo();
        returns.setCacheId(cacheId);
        returns.setCount(count);
        return returns;
    }

    private ReportListModel getExportAllReportModel(ReportList reportList1) {
        ReportQueryParam queryParam = reportList1.getReportModel().getReportQueryParam();
        ReportList list = (ReportList)this.getControl(REPORT_LIST_AP);
        String acctIds = JournalPrintHelper.getLeftNodesFromCache(queryParam);
        if ("cas_cashjournalformrpt".equalsIgnoreCase(this.getView().getEntityId()) && StringUtils.isBlank((CharSequence)acctIds)) {
            acctIds = new CashJournalFormRpt().buildNodeIdStr(queryParam);
        }
        if ("cas_bankjournalformrpt".equalsIgnoreCase(this.getView().getEntityId()) && StringUtils.isBlank((CharSequence)acctIds)) {
            acctIds = new BankJournalFormRpt().buildNodeIdStr(queryParam);
        }
        if (StringUtils.isBlank((CharSequence)acctIds)) {
            return new ReportListModel();
        }
        String tempPageId = Uuid16.create().toString();
        this.reportCache.setReportQueryParam(tempPageId, queryParam);
        ReportListModel reportModel = (ReportListModel)list.getReportModel();
        reportModel.setPageId(tempPageId);
        list.setAsynQuery(true);
        log.info("getExportAllReportModel.submitTask.begin");
        list.submitTask(queryParam, (Object)acctIds);
        log.info("getExportAllReportModel.submitTask.end");
        return reportModel;
    }

    private IPageCache getReportPageCache() {
        return this.getPageCache();
    }

    private Queue<Long> getOrgQueue(Map<Long, RowDataInfo> allSingleOrgDS) {
        Queue<Long> orgQueue;
        if (this.printStatus() == PrintStatus.DONE_INIT) {
            orgQueue = new LinkedList<Long>(allSingleOrgDS.keySet());
            this.getReportPageCache().put("orgsReadyForPrint", SerializationUtils.serializeToBase64(orgQueue));
        } else {
            String org2CacheIDStr = this.getReportPageCache().get("orgsReadyForPrint");
            orgQueue = (Queue)SerializationUtils.deSerializeFromBase64((String)org2CacheIDStr);
        }
        return orgQueue;
    }

    private void cacheOrgQueue(Queue<Long> queue) {
        this.getReportPageCache().put("orgsReadyForPrint", SerializationUtils.serializeToBase64(queue));
    }

    private void moveToNextOrg() {
        Map<Long, RowDataInfo> allSingleOrgDS = this.getAllSingleOrgDS();
        Queue<Long> orgQueue = this.getOrgQueue(allSingleOrgDS);
        if (allSingleOrgDS.isEmpty() || orgQueue.isEmpty()) {
            this.changePrintStatus(PrintStatus.ALL_DONE);
            log.info("moveToNextOrg.isempty.");
            return;
        }
        Long nextOrg = orgQueue.poll();
        this.cacheOrgQueue(orgQueue);
        DynamicObject orgDyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter("id", "=", (Object)nextOrg).toArray());
        String orgName = orgDyo.getLocaleString("name").getLocaleValue();
        String printPageID = this.executePrint(orgDyo);
        this.showOrgProgress(printPageID, allSingleOrgDS.size(), allSingleOrgDS.size() - orgQueue.size() - 1, orgName);
        this.changePrintStatus(PrintStatus.PRINTING);
    }

    private String executePrint(DynamicObject orgDyo) {
        RowDataInfo dataInfo = this.getAllSingleOrgDS().get(orgDyo.getLong("id"));
        Integer rowCount = dataInfo.getCount();
        String formId = this.getView().getEntityId();
        Object defaultTemplateId = JournalPrintHelper.getDefaultTemplateId(formId);
        ReportView reportView = (ReportView)this.getView();
        String reportPageID = reportView.getPageId();
        IReportCache cache = ReportCacheManager.getInstance().getCache();
        String tmpModelPageID = Uuid16.create().toString();
        ReportQueryParam tmpParam = reportView.getQueryParam();
        tmpParam.getFilter().getFilterItem("org").setValue((Object)orgDyo);
        cache.setReportQueryParam(tmpModelPageID, tmpParam);
        String cacheID = dataInfo.getCacheId();
        List exportColumns = cache.getReportTaskResult(reportPageID, REPORT_LIST_AP).getReportColumns();
        cache.setReportTaskResult(tmpModelPageID, REPORT_LIST_AP, new ReportTaskResult(cacheID, exportColumns));
        JSONObject extParam = JsonObjectAdapter.getEmpty().registerContext("pageIDForPrint", tmpModelPageID).registerContext("printAll", true).getSource();
        this.getReportPageCache().put("extParam", extParam.toJSONString());
        return ShowBosPrintingProgress.showProgressFormV2(rowCount, formId, reportPageID, defaultTemplateId, "", (IFormView)reportView, extParam, (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("printFormClose".equals(e.getActionId())) {
            this.changePrintStatus(PrintStatus.SINGLE_DONE);
            ReportQueryParam queryParam = ((ReportView)this.getView()).getQueryParam();
            ReportCacheManager.getInstance().getCache().setReportQueryParam(this.getView().getPageId(), queryParam);
        }
    }

    private void changePrintStatus(PrintStatus status) {
        this.getReportPageCache().put("printstatus", status.name());
    }

    private PrintStatus printStatus() {
        return PrintStatus.valueOf(this.getReportPageCache().get("printstatus"));
    }

    private Boolean isPrintJobWorking() {
        return this.getReportPageCache().get("printstatus") != null && this.printStatus() != PrintStatus.ALL_DONE;
    }

    static class RowDataInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String cacheId;
        private Integer count;

        RowDataInfo() {
        }

        public String getCacheId() {
            return this.cacheId;
        }

        public void setCacheId(String cacheId) {
            this.cacheId = cacheId;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }
    }

    private static enum PrintStatus {
        CREATE,
        WAITING_INIT,
        DONE_INIT,
        PRINTING,
        SINGLE_DONE,
        ALL_DONE;

    }
}

