/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.journalprintall;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class ShowBosPrintingProgress {
    private static final int INITIAL_CAPACITY = 1;

    private ShowBosPrintingProgress() {
        throw new IllegalStateException("Utility class");
    }

    public static String showProgressFormV2(int selectRows, String formId, String pageId, Object defaultTemplateId, String pkIds, IFormView view, Object extParam, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_printing");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        showParameter.getCustomParams().put("entityname", view.getFormShowParameter().getFormConfig().getCaption().toString());
        String printLangStr = (String)ShowBosPrintingProgress.getPrintSetting(formId).get("printlang");
        if (StringUtils.isBlank((CharSequence)printLangStr)) {
            printLangStr = RequestContext.get().getLang().toString();
        }
        String defaultTempId = defaultTemplateId.toString();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("lang", printLangStr);
        param.put("printdataprovidertype", "report");
        param.put("pageid", pageId);
        param.put("formid", formId);
        param.put("defaulttemplateid", defaultTempId);
        param.put("pkids", pkIds);
        if (ShowBosPrintingProgress.isNewTpl(defaultTempId)) {
            param.put("newDefaultTplId", defaultTempId);
        } else {
            param.put("oldDefaultTplId", defaultTempId);
        }
        if (extParam instanceof Map && !((Map)extParam).isEmpty()) {
            param.put("extParam", extParam);
        }
        showParameter.getCustomParams().put("printParam", param);
        showParameter.getCustomParams().put("selectrows", selectRows);
        showParameter.setShowTitle(Boolean.FALSE.booleanValue());
        if (plugin != null) {
            showParameter.setCloseCallBack(new CloseCallBack(plugin, "printFormClose"));
        }
        String printPageID = showParameter.getPageId();
        view.showForm(showParameter);
        return printPageID;
    }

    public static void showProgressForm(int selectRows, String formId, String pageId, Object defaultTemplateId, String pkIds, IFormView view) {
        ShowBosPrintingProgress.showProgressFormV2(selectRows, formId, pageId, defaultTemplateId, pkIds, view, null, null);
    }

    private static Map<String, Object> getPrintSetting(String formId) {
        Map<String, Object> myPrintSetting = new HashMap<String, Object>(1);
        String configKey = formId + "_printsetting";
        long userId = RequestContext.get().getCurrUserId();
        String settingData = UserConfigServiceHelper.getSetting((long)userId, (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            myPrintSetting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return myPrintSetting;
    }

    private static boolean isNewTpl(String tplId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "=", (Object)tplId)});
        if (dynamicObject == null) {
            return false;
        }
        String type = dynamicObject.getString("type");
        return "B".equals(type);
    }
}

