/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.PaymentTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.AgentPayBillPluginHelper;
import kd.fi.cas.helper.AppLogHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class PayBillBatchInputPlugin
extends BillEditPlugin
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(PayBillBatchInputPlugin.class);
    private Long orgId;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "textorg", "textpayeracctbank", "textpayeracctcash", "textpayerbank", "textentrance", "textpayeetype"});
        TextEdit settletnumber = (TextEdit)this.getView().getControl("settletnumber");
        settletnumber.addButtonClickListener((ClickListener)this);
        TextEdit payeename = (TextEdit)this.getView().getControl("payeename");
        payeename.addButtonClickListener((ClickListener)this);
        TextEdit payeebanknum = (TextEdit)this.getView().getControl("payeebanknum");
        payeebanknum.addButtonClickListener((ClickListener)this);
        TextEdit payeebankname = (TextEdit)this.getView().getControl("payeebankname");
        payeebankname.addButtonClickListener((ClickListener)this);
        this.fillPaymentType();
        this.fillCurrency();
        this.fillEntrustorg();
        this.expenseItem();
        this.fillFundFlow();
        this.fillDpCurrency();
        this.initDraftBillF7();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("btnok".equals(key)) {
            this.checkAndSave();
        } else if ("settletnumber".equals(key)) {
            this.settleNumberClick();
        } else if ("textorg".equals(key) || "textpayeracctbank".equals(key) || "textpayeracctcash".equals(key) || "textpayerbank".equals(key)) {
            this.changePayerPage();
        } else if ("payeename".equals(key) || "payeebanknum".equals(key) || "payeebankname".equals(key)) {
            this.addPayee();
        } else if ("textentrance".equals(key) || "textpayeetype".equals(key)) {
            this.changeEntrancePage();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("newentry".equals(operateKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            this.initRowData(entryEntity.size() - 1);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initRowData(0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int rowIndex = changeData[0].getRowIndex();
        if (newValue == oldValue) {
            return;
        }
        switch (key) {
            case "paymenttype": {
                this.paymentTypeChanged((DynamicObject)newValue, rowIndex);
                break;
            }
            case "bizdate": {
                this.exratedateChanged(newValue, rowIndex);
                break;
            }
            case "exratetable": {
                this.currencyF7Changed(newValue, false, rowIndex);
                this.setRecInfo("dpexratetable", newValue, Boolean.FALSE, rowIndex);
                break;
            }
            case "exratedate": {
                this.currencyF7Changed(newValue, false, rowIndex);
                this.setRecInfo("dpexratedate", newValue, Boolean.FALSE, rowIndex);
                break;
            }
            case "entrustorg": {
                this.entrustorgChange(newValue, rowIndex);
                break;
            }
            case "org": {
                this.setOpenOrg(rowIndex);
                break;
            }
            case "payeetype": {
                DynamicObject bill = this.convertTargetBill((DynamicObject)entryentity.get(rowIndex));
                this.getModel().setValue("ispersonpay", (Object)AgentPayBillPluginHelper.isPersonPay((DynamicObject)bill), rowIndex);
                this.clearPayeeValue(rowIndex);
                break;
            }
            case "entrance": {
                this.setPaymentType((String)newValue, rowIndex);
                break;
            }
            case "paymentchannel": {
                this.paymentchannelChange(rowIndex);
                break;
            }
            case "settletype": {
                this.settleTypeChanged(e, newValue, rowIndex);
                this.settletNumber((DynamicObject)newValue, rowIndex);
                this.isClearSettleType((DynamicObject)oldValue, (DynamicObject)newValue, rowIndex);
                break;
            }
            case "payeracctbank": {
                this.payerAcctBankF7Changed(e, newValue, rowIndex);
                break;
            }
            case "payeracctcash": {
                this.payerAcctCashChanged((DynamicObject)newValue, rowIndex);
                break;
            }
            case "currency": {
                this.orgId = RequestContext.get().getOrgId();
                this.currencyF7Changed(newValue, true, rowIndex);
                this.setRecInfo("dpcurrency", newValue, Boolean.TRUE, rowIndex);
                this.setExratetableVisibility(this.orgId, rowIndex);
                break;
            }
            case "dpcurrency": {
                this.orgId = RequestContext.get().getOrgId();
                this.setRecExchangerateEditable(rowIndex);
                this.setExratetableVisibility(this.orgId, rowIndex);
                break;
            }
            case "dpamt": {
                this.dpAmtChanged(newValue, rowIndex);
                break;
            }
            case "dpexchangerate": 
            case "agreedrate": {
                this.calculateDpAmt(rowIndex);
                break;
            }
            case "exchangerate": 
            case "payquotation": 
            case "agreedquotation": 
            case "dppayquotation": {
                this.calculateAmt(rowIndex);
                break;
            }
            case "isdiffcur": {
                this.isDiffCurChanged(newValue, rowIndex);
                break;
            }
            case "e_payableamt": {
                this.entries_payableAmtChanged((BigDecimal)newValue, oldValue, rowIndex);
                break;
            }
            case "e_discountamt": {
                this.entries_discountAmtChanged((BigDecimal)newValue, oldValue, rowIndex);
                break;
            }
        }
    }

    @Override
    protected String recPayAccount() {
        return "payeracctbank";
    }

    private void paymentTypeChanged(DynamicObject paymentType, int rowIndex) {
        boolean isAp;
        String entrance = (String)this.getModel().getValue("entrance", rowIndex);
        if (paymentType != null && PaymentTypeEnum.OTR.name().equals(entrance)) {
            isAp = paymentType.getBoolean("ispartpayment");
            Long billTypeID = this.getPk("billtype", rowIndex);
            boolean isChange = false;
            if (isAp) {
                if (!BillTypeConstants.PAYBILL_EXP.equals(billTypeID)) {
                    this.setValue("billtype", BusinessDataServiceHelper.loadSingleFromCache((Object)BillTypeConstants.PAYBILL_EXP, (String)"bos_billtype"));
                    isChange = true;
                }
            } else if (!BillTypeConstants.PAYBILL_OTR.equals(billTypeID)) {
                this.setValue("billtype", BusinessDataServiceHelper.loadSingleFromCache((Object)BillTypeConstants.PAYBILL_OTR, (String)"bos_billtype"));
                isChange = true;
            }
            if (isChange) {
                this.getModel().beginInit();
                this.setValue("paymenttype", paymentType, rowIndex);
                this.getModel().endInit();
                this.getView().updateView("paymenttype", rowIndex);
            }
        }
        if (paymentType != null) {
            isAp = paymentType.getBoolean("ispartpayment");
            this.getView().setEnable(Boolean.valueOf(isAp), rowIndex, new String[]{"settleorg"});
            this.settleOrg(false, rowIndex);
            DynamicObject fundflowitem = paymentType.getDynamicObject("fundflowitem");
            this.fillFundflowItem(true, fundflowitem, rowIndex);
        }
    }

    private void exratedateChanged(Object newValue, int rowIndex) {
        if (newValue == null) {
            return;
        }
        Long currencyId = this.getPk("currency", rowIndex);
        Long dpCurrencyId = this.getPk("dpcurrency", rowIndex);
        Long basecurrencyId = this.getPk("basecurrency", rowIndex);
        if (currencyId != null && !currencyId.equals(basecurrencyId) || dpCurrencyId != null && !dpCurrencyId.equals(basecurrencyId)) {
            this.setValue("exratedate", newValue, rowIndex);
        }
        this.setValue("dpexratedate", newValue, rowIndex);
    }

    private void entries_payableAmtChanged(BigDecimal payableAmt, Object oldValue, int rowIndex) {
        FormDataModel model = (FormDataModel)this.getModel();
        BigDecimal discountAmt = (BigDecimal)model.getValue("e_discountamt", rowIndex);
        BigDecimal bigDecimal = discountAmt = discountAmt != null ? discountAmt : BigDecimal.ZERO;
        if (discountAmt.abs().compareTo(payableAmt.abs()) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6298\u6263\u7edd\u5bf9\u503c\u4e0d\u5f97\u8d85\u8fc7\u5e94\u4ed8\u91d1\u989d\u7edd\u5bf9\u503c\u3002", (String)"PaymentBillEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
            this.setValue("e_payableamt", oldValue, rowIndex);
            return;
        }
        this.calculateAmt(rowIndex);
    }

    private void entries_discountAmtChanged(BigDecimal discountAmt, Object oldValue, int rowIndex) {
        FormDataModel model = (FormDataModel)this.getModel();
        BigDecimal payableAmt = (BigDecimal)model.getValue("e_payableamt", rowIndex);
        BigDecimal bigDecimal = payableAmt = payableAmt != null ? payableAmt : BigDecimal.ZERO;
        if (discountAmt.abs().compareTo(payableAmt.abs()) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6298\u6263\u7edd\u5bf9\u503c\u4e0d\u5f97\u8d85\u8fc7\u5e94\u4ed8\u91d1\u989d\u7edd\u5bf9\u503c\u3002", (String)"PaymentBillEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), new Object[0]));
            this.setValue("e_discountamt", oldValue, rowIndex);
            return;
        }
        this.calculateAmt(rowIndex);
    }

    private void paymentchannelChange(int rowIndex) {
        this.ctrBeInfoVisibility(rowIndex);
    }

    private void settleTypeChanged(PropertyChangedArgs e, Object newValue, int rowIndex) {
        this.ctrBeInfoVisibility(rowIndex);
        DynamicObject settleType = (DynamicObject)newValue;
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            DynamicObject accountCash;
            this.setValue("payeracctbank", null, rowIndex);
            this.setValue("payerbank", null, rowIndex);
            this.setValue("textpayeracctbank", null, rowIndex);
            this.setValue("textpayerbank", null, rowIndex);
            if (this.getDynamicObject("payeracctcash", rowIndex) == null) {
                this.setValue("payeracctcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org", rowIndex), (String)"payer"), rowIndex);
            }
            if ((accountCash = this.getDynamicObject("payeracctcash", rowIndex)) != null) {
                this.setValue("textpayeracctcash", accountCash.getString("number"), rowIndex);
            }
            this.setValue("isdiffcur", "0", rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"isdiffcur"});
        } else {
            this.setValue("payeracctcash", null, rowIndex);
            this.setValue("textpayeracctcash", null, rowIndex);
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"isdiffcur"});
        }
        DynamicObject accountBank = this.getDynamicObject("payeracctbank", rowIndex);
        this.setPaymentChannelValue(accountBank, Boolean.TRUE, rowIndex);
    }

    private void ctrBeInfoVisibility(int rowIndex) {
        boolean isBePay = this.isBePay(rowIndex);
        this.getView().setEnable(Boolean.valueOf(!this.isDraft(rowIndex)), rowIndex, new String[]{"settletnumber"});
        this.getView().setEnable(Boolean.valueOf(this.isDraft(rowIndex)), rowIndex, new String[]{"draftbill"});
        this.getView().setEnable(Boolean.valueOf(isBePay), rowIndex, new String[]{"usage"});
    }

    private boolean isDraft(int rowIndex) {
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype", rowIndex);
        if (settleType != null) {
            String settlementType = settleType.getString("settlementtype");
            return Objects.equals(settlementType, SettleMentTypeEnum.BANK.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.BUSINESS.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.CHECK.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.PROMISSORY.getValue());
        }
        return false;
    }

    private void setPaymentChannelValue(DynamicObject payerAcctBank, boolean isAdd, int rowIndex) {
        ComboItem item2;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1);
        ComboEdit paymentChannel = (ComboEdit)this.getControl("paymentchannel");
        DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(PaymentChannelEnum.COUNTER.getValue());
        comboItem.setCaption(new LocaleString(PaymentChannelEnum.COUNTER.getName()));
        ComboItem selectedItem = comboItem;
        comboItems.add(comboItem);
        if (null == payerAcctBank || settleType != null && "14".equals(settleType.getString("settlementtype"))) {
            paymentChannel.setComboItems(comboItems);
            if (isAdd) {
                this.getModel().setValue("paymentchannel", (Object)selectedItem.getValue(), rowIndex);
            }
            return;
        }
        if (payerAcctBank.getBoolean("isopenbank")) {
            item2 = new ComboItem();
            item2.setValue(PaymentChannelEnum.ONLINEBANK.getValue());
            item2.setCaption(new LocaleString(PaymentChannelEnum.ONLINEBANK.getName()));
            selectedItem = item2;
            comboItems.add(item2);
        }
        if (payerAcctBank.getBoolean("issetbankinterface")) {
            item2 = new ComboItem();
            item2.setValue(PaymentChannelEnum.BEI.getValue());
            item2.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.BEI.getName(), (String)"PaymentBillEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            selectedItem = item2;
            comboItems.add(item2);
        }
        String defaultPaymentChannel = "";
        if (Objects.nonNull(settleType)) {
            String paymentChannelRange = settleType.getString("paymentchannel");
            defaultPaymentChannel = settleType.getString("defaultpaymentchannel");
            if (StringUtils.isNotEmpty((CharSequence)paymentChannelRange)) {
                Set paymentChannels = Arrays.stream(paymentChannelRange.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
                comboItems.removeIf(i -> !paymentChannels.contains(i.getValue()));
            }
        }
        paymentChannel.setComboItems(comboItems);
        if (isAdd) {
            String defChannel = selectedItem.getValue();
            if (settleType != null && !SettleMentTypeEnum.COLLECT.getValue().equals(settleType.getString("settlementtype"))) {
                defChannel = PaymentChannelEnum.COUNTER.getValue();
            }
            if (StringUtils.isNotEmpty((CharSequence)defaultPaymentChannel)) {
                defChannel = defaultPaymentChannel;
            }
            String finalDefChannel = defChannel;
            boolean contains = comboItems.stream().anyMatch(item -> Objects.equals(finalDefChannel, item.getValue()));
            if (!contains) {
                defChannel = null;
            }
            this.getModel().setValue("paymentchannel", (Object)defChannel, rowIndex);
        }
    }

    private void setSettleTypeValue(DynamicObject payerAcctBank, int rowIndex) {
        DynamicObjectCollection settlementypes;
        if (payerAcctBank != null && (settlementypes = payerAcctBank.getDynamicObjectCollection("settlementtype")) != null && settlementypes.size() > 0) {
            HashSet<Long> idSet = new HashSet<Long>();
            for (DynamicObject settlementype : settlementypes) {
                idSet.add(((DynamicObject)settlementype.get("fbasedataid")).getLong("id"));
            }
            DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
            if (idSet.size() == 1) {
                DynamicObject settletype = BusinessDataServiceHelper.loadSingleFromCache(idSet.iterator().next(), (String)"bd_settlementtype", (String)"id,settlementtype");
                if (!BaseDataHelper.isSettleTypeCash((DynamicObject)settletype)) {
                    this.setValue("settletype", idSet.iterator().next(), rowIndex);
                }
            } else if (settleType != null && !idSet.contains((Long)settleType.getPkValue())) {
                this.setValue("settletype", null, rowIndex);
            }
        }
    }

    private void isClearSettleType(DynamicObject oldValue, DynamicObject newValue, int rowIndex) {
        String settletnumber = (String)this.getModel().getValue("settletnumber", rowIndex);
        if (EmptyUtil.isNoEmpty((String)settletnumber) && Objects.nonNull(oldValue) && SettleMentTypeEnum.CREDIT.getValue().equals(oldValue.getString("settlementtype")) && (Objects.nonNull(newValue) && !SettleMentTypeEnum.CREDIT.getValue().equals(newValue.getString("settlementtype")) || Objects.isNull(newValue))) {
            this.getModel().setValue("settletnumber", null, rowIndex);
            this.getModel().setValue("sourcebilltype", null, rowIndex);
        }
    }

    private void payerAcctBankF7Changed(PropertyChangedArgs e, Object newValue, int rowIndex) {
        DynamicObject payerAcctBank = (DynamicObject)newValue;
        this.ctrBeInfoVisibility(rowIndex);
        if (payerAcctBank == null) {
            this.setValue("payerbank", null, rowIndex);
            this.setValue("textpayerbank", null, rowIndex);
            this.setPaymentChannelValue(null, Boolean.TRUE, rowIndex);
            this.setCurrencyEditable(rowIndex);
            return;
        }
        DynamicObject bank = payerAcctBank.getDynamicObject("bank");
        this.setValue("payerbank", bank, rowIndex);
        this.setValue("textpayerbank", CasHelper.getLocalValue((DynamicObject)bank, (String)"name"), rowIndex);
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur", rowIndex);
        DynamicObject payCurrency = null;
        payCurrency = isDiffCur != false ? this.getDynamicObject("dpcurrency", rowIndex) : this.getDynamicObject("currency", rowIndex);
        boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"bd_accountbanks", (Object)payerAcctBank.getPkValue(), (DynamicObject)payCurrency);
        if (!containCurrency) {
            Long defaultCurrencyId = (Long)payerAcctBank.get("defaultcurrency.id");
            if (isDiffCur.booleanValue()) {
                this.setValue("dpcurrency", defaultCurrencyId, rowIndex);
            } else {
                this.setValue("currency", defaultCurrencyId, rowIndex);
            }
        }
        this.setCurrencyEditable(rowIndex);
        this.setOpenOrg(rowIndex);
        this.setPaymentChannelValue(payerAcctBank, Boolean.TRUE, rowIndex);
        this.setSettleTypeValue(payerAcctBank, rowIndex);
        this.settleOrg(true, rowIndex);
    }

    private void payerAcctCashChanged(DynamicObject acctCash, int rowIndex) {
        if (acctCash == null) {
            this.setValue("currency", this.getDynamicObject("basecurrency"), rowIndex);
            this.setCurrencyEditable(rowIndex);
            return;
        }
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur", rowIndex);
        DynamicObject payCurrency = null;
        payCurrency = isDiffCur != false ? this.getDynamicObject("dpcurrency", rowIndex) : this.getDynamicObject("currency", rowIndex);
        boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"cas_accountcash", (Object)acctCash.getPkValue(), (DynamicObject)payCurrency);
        if (!containCurrency) {
            DynamicObject defaultCurrency = acctCash.getDynamicObject("defaultcurrency");
            if (isDiffCur.booleanValue()) {
                this.setValue("dpcurrency", defaultCurrency, rowIndex);
            } else {
                this.setValue("currency", defaultCurrency, rowIndex);
            }
        }
        this.setCurrencyEditable(rowIndex);
        this.setValue("openorg", acctCash.getDynamicObject("openorg"), rowIndex);
    }

    private void setCurrencyEditable(int rowIndex) {
        Boolean isCurrencyEditable = Boolean.TRUE;
        DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        if (isCash) {
            DynamicObject accountCash = this.getDynamicObject("payeracctcash", rowIndex);
            if (accountCash != null) {
                isCurrencyEditable = !accountCash.getBoolean("isbycurrency");
            }
        } else {
            DynamicObject accountBank = this.getDynamicObject("payeracctbank", rowIndex);
            if (accountBank != null) {
                isCurrencyEditable = accountBank.getBoolean("ismulcurrency");
            }
        }
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur", rowIndex);
        if (isDiffCur.booleanValue()) {
            this.getView().setEnable(isCurrencyEditable, rowIndex, new String[]{"dpcurrency"});
        } else {
            this.getView().setEnable(isCurrencyEditable, rowIndex, new String[]{"currency"});
        }
    }

    private void setCurrencyEditable(Boolean isDiffCur, int rowIndex) {
        Boolean isCurrencyEditable = Boolean.TRUE;
        DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        if (isCash) {
            DynamicObject accountCash = this.getDynamicObject("payeracctcash", rowIndex);
            if (accountCash != null) {
                isCurrencyEditable = !accountCash.getBoolean("isbycurrency");
            }
        } else {
            DynamicObject accountBank = this.getDynamicObject("payeracctbank", rowIndex);
            if (accountBank != null) {
                isCurrencyEditable = accountBank.getBoolean("ismulcurrency");
            }
        }
        if (isDiffCur.booleanValue()) {
            this.getView().setEnable(isCurrencyEditable, rowIndex, new String[]{"dpcurrency"});
        } else {
            this.getView().setEnable(isCurrencyEditable, rowIndex, new String[]{"currency"});
        }
    }

    private void fillPaymentType() {
        BasedataEdit paymenttypeF7 = (BasedataEdit)this.getControl("paymenttype");
        paymenttypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            Object entrance = this.getModel().getValue("entrance", index);
            if (entrance != null && !"".equals(entrance)) {
                qFilter = PaymentTypeEnum.AP.name().equals(entrance) ? qFilter.and(new QFilter("ispartpayment", "=", (Object)"1")) : qFilter.and(new QFilter("ispartpayment", "=", (Object)"0"));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            Boolean isDiffCur = (Boolean)this.getValue("isdiffcur", index);
            if (!isDiffCur.booleanValue()) {
                DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype", index);
                boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
                if (isCash) {
                    DynamicObject accountCash = (DynamicObject)this.getModel().getValue("payeracctcash", index);
                    if (accountCash != null) {
                        List currencys = AccountCashHelper.getCurrencys(Collections.singletonList((Long)accountCash.getPkValue()));
                        qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
                    }
                } else {
                    DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank", index);
                    if (payerAcctBank != null) {
                        Set currencys = AccountBankHelper.getCurrencyPks((long)((Long)payerAcctBank.getPkValue()));
                        qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
                    }
                }
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void fillEntrustorg() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("entrustorg");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("orgFuncId", (Object)"08");
        });
    }

    protected void expenseItem() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("e_expenseitem");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object[] objects = BusinessDataServiceHelper.load((String)"er_expenseitembill", (String)"id,expenseitem", (QFilter[])new QFilter[]{new QFilter("billtype.bill_number.number", "=", (Object)"cas_paybill")});
            if (EmptyUtil.isEmpty((Object[])objects)) {
                return;
            }
            List ids = Arrays.stream(objects).map(o -> o.get("expenseitem.id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    private void fillFundFlow() {
        BasedataEdit fundFlow = (BasedataEdit)this.getControl("e_fundflowitem");
        fundFlow.addBeforeF7SelectListener(select -> {
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object org = this.getModel().getValue("org", index);
            showParam.setCustomParam("org", (Object)String.valueOf(((DynamicObject)org).getPkValue()));
        });
    }

    private void fillDpCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("dpcurrency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            Boolean isDiffCur = (Boolean)this.getValue("isdiffcur", index);
            if (isDiffCur.booleanValue()) {
                DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype", index);
                boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
                if (isCash) {
                    DynamicObject accountCash = (DynamicObject)this.getModel().getValue("payeracctcash", index);
                    if (accountCash != null) {
                        List currencys = AccountCashHelper.getCurrencys(Collections.singletonList((Long)accountCash.getPkValue()));
                        qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
                    }
                } else {
                    DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank", index);
                    if (payerAcctBank != null) {
                        Set currencys = AccountBankHelper.getCurrencyPks((long)((Long)payerAcctBank.getPkValue()));
                        qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
                    }
                }
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void initDraftBillF7() {
        BasedataEdit draftbill = (BasedataEdit)this.getControl("draftbill");
        draftbill.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List<Long> ids;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object currency = this.getModel().getValue("currency", rowIndex);
            if (CasHelper.isEmpty((Object)currency)) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e01\u79cd\u3002", (String)"PaymentBillDraftEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object payeetype = this.getModel().getValue("payeetype", rowIndex);
            Object payeename = this.getModel().getValue("payeename", rowIndex);
            if (CasHelper.isEmpty((Object)payeetype) || CasHelper.isEmpty((Object)payeename)) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"PaymentBillDraftEditPlugin_0_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            long orgId = this.getModel().getValue("org", rowIndex) == null ? 0L : ((DynamicObject)this.getModel().getValue("org", rowIndex)).getLong("id");
            String orgName = this.getModel().getValue("org", rowIndex) == null ? "" : ((DynamicObject)this.getModel().getValue("org", rowIndex)).getString("name");
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            QFilter receFilter = new QFilter("company.id", "=", (Object)orgId);
            receFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
            receFilter.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("isendorsepay", "=", (Object)"1").and(new QFilter("locksourcebilltype", "=", (Object)"cas_paybill")).and(new QFilter("locksourcebillid", "=", (Object)String.valueOf(this.getModel().getDataEntity().getPkValue())))));
            receFilter.and(new QFilter("currency", "=", ((DynamicObject)currency).get("id")));
            receFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            receFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
            receFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
            receFilter.and(new QFilter("istransfer", "=", (Object)"1"));
            QFilter nullFilter = QFilter.isNull((String)"billpool");
            receFilter.and(new QFilter("billpool", "=", (Object)0).or(nullFilter));
            List<Long> poolIds = this.getBillPoolByCompany(orgId);
            QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
            boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"isShowUnLockBill");
            if (isShowUnLockBill) {
                qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(QFilter.isNull((String)"poollockstatus")).or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId))));
            } else {
                qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId)));
            }
            qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
            qFilterBillPool.and(new QFilter("currency", "=", ((DynamicObject)currency).get("id")));
            qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
            qFilterBillPool.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
            boolean isExcludedBills = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"isexcludedbills");
            if (isExcludedBills && EmptyUtil.isNoEmpty(ids = this.getIsExcludedBills(orgId, currency, orgName, appId)) && ids.size() > 0) {
                qFilterBillPool.and("id", "not in", (Object)ids.toArray());
            }
            QFilter payFilter = new QFilter("company.id", "=", (Object)orgId);
            payFilter.and(new QFilter("source", "in", (Object)new String[]{"handregister", "apply", "cdm"}));
            payFilter.and(new QFilter("rptype", "=", (Object)"paybill"));
            payFilter.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("isendorsepay", "=", (Object)"1").and(new QFilter("locksourcebilltype", "=", (Object)"cas_paybill")).and(new QFilter("locksourcebillid", "=", (Object)String.valueOf(this.getModel().getDataEntity().getPkValue())))));
            payFilter.and(new QFilter("currency", "=", ((DynamicObject)currency).get("id")));
            payFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            payFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
            payFilter.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
            payFilter.and(new QFilter("receivername", "=", payeename));
            Object settleType = this.getModel().getValue("settletype", rowIndex);
            if (settleType != null) {
                DynamicObject settleTypeObj = (DynamicObject)settleType;
                List billTypeIdList = DraftHelper.getBillTypeIdList((Object)settleTypeObj.getPkValue(), (String)settleTypeObj.getString("settlementtype"));
                receFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
                qFilterBillPool.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
                payFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
            }
            QFilter qFilter = receFilter.or(qFilterBillPool).or(payFilter);
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            ArrayList<Long> ids2 = new ArrayList<Long>(0);
            for (int i = 0; i < rowCount; ++i) {
                Object draftbillColl;
                if (rowIndex == i || null == (draftbillColl = this.getModel().getValue("draftbill", i))) continue;
                DynamicObjectCollection colls = (DynamicObjectCollection)draftbillColl;
                for (DynamicObject coll : colls) {
                    ids2.add(coll.getDynamicObject("fbasedataid").getLong("id"));
                }
            }
            if (ids2.size() > 0) {
                qFilter.and(new QFilter("id", "not in", ids2));
            }
            showParameter.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PaymentBillDraftEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    private List<Long> getBillPoolByCompany(long orgId) {
        DynamicObject[] billPools = BusinessDataServiceHelper.load((String)"cdm_billpool", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.e_company", "=", (Object)orgId).or(new QFilter("company", "=", (Object)orgId)), new QFilter("enable", "=", (Object)"1")});
        ArrayList<Long> poolIds = new ArrayList<Long>(billPools.length);
        for (DynamicObject dy0 : billPools) {
            poolIds.add(dy0.getLong("id"));
        }
        return poolIds;
    }

    private List<Long> getIsExcludedBills(long orgId, Object currency, String orgName, String appId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (EmptyUtil.isEmpty((String)orgName)) {
            return ids;
        }
        List<Long> poolIds = this.getBillPoolByCompany(orgId);
        QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
        boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"isShowUnLockBill");
        if (isShowUnLockBill) {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(QFilter.isNull((String)"poollockstatus")).or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId))));
        } else {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId)));
        }
        qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterBillPool.and(new QFilter("currency", "=", ((DynamicObject)currency).get("id")));
        qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilterBillPool.and(new QFilter("draftbilltranstatus", "=", (Object)"success"));
        qFilterBillPool.and(new QFilter("company.id", "!=", (Object)orgId));
        Object[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,delivername,drawername,receivername,endorseentry.id,endorseentry.initiatorname,endorseentry.opponentname", (QFilter[])qFilterBillPool.toArray());
        if (EmptyUtil.isNoEmpty((Object[])receivablebills)) {
            block0: for (Object receivablebill : receivablebills) {
                String delivername = receivablebill.getString("delivername");
                String drawername = receivablebill.getString("drawername");
                String receivername = receivablebill.getString("receivername");
                if (orgName.equals(delivername) || orgName.equals(drawername) || orgName.equals(receivername)) {
                    ids.add(receivablebill.getLong("id"));
                    continue;
                }
                DynamicObjectCollection endorseentrys = receivablebill.getDynamicObjectCollection("endorseentry");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)endorseentrys)) continue;
                for (DynamicObject endorseentry : endorseentrys) {
                    String initiatorname = endorseentry.getString("initiatorname");
                    String opponentname = endorseentry.getString("opponentname");
                    if (!orgName.equals(initiatorname) && !orgName.equals(opponentname)) continue;
                    ids.add(receivablebill.getLong("id"));
                    continue block0;
                }
            }
        }
        return ids;
    }

    private void checkAndSave() {
        DynamicObjectCollection dataRows = this.getModel().getEntryEntity("entryentity");
        if (CasHelper.isEmpty((Object)dataRows)) {
            return;
        }
        DynamicObject[] targetBills = new DynamicObject[dataRows.size()];
        for (int i = 0; i < dataRows.size(); ++i) {
            targetBills[i] = this.convertTargetBill((DynamicObject)dataRows.get(i));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("coderule_billno_from_init", "true");
        option.setVariableValue("batchinput", "batchpaybill");
        OperationResult operationResult = OperateServiceHelper.execOperate((String)"save", (String)"cas_paybill", (DynamicObject[])targetBills, (OperateOption)option, (boolean)true);
        if (!operationResult.isSuccess()) {
            logger.error((Throwable)((Object)operationResult.getAllErrorOrValidateInfo()));
        } else {
            int okCount = operationResult.getSuccessPkIds().size();
            MultiLangEnumBridge opDesc = AppLogHelper.buildMultiLangBridge((String)"\u4ed8\u6b3e\u5355\u5f55\u5165\u6210\u529f\uff0c\u5171%s\u6761\u3002", (String)"PayBillBatch_0", (String)"fi-cas-formplugin");
            String msg = String.format(opDesc.loadKDString(), okCount);
            this.getView().showSuccessNotification(msg, Integer.valueOf(3000));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok", "newentry", "copyentry", "deleteentry"});
            MultiLangEnumBridge opNameBridge = AppLogHelper.buildMultiLangBridge((String)"\u6279\u91cf\u5f55\u5165", (String)"PayBillBatchInputPlugin_2", (String)"fi-cas-formplugin");
            AppLogInfo appLogInfo = AppLogHelper.createAppLog((String)"cas_paybill", (long)RequestContext.get().getOrgId(), (String)"batchinput", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDesc, (Object[])new Object[]{okCount});
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        }
    }

    private DynamicObject convertTargetBill(DynamicObject row) {
        DynamicObject bill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        bill.set("billstatus", row.get("billstatus"));
        bill.set("bizdate", row.get("bizdate"));
        bill.set("expectdate", row.get("expectdate"));
        bill.set("entrustorg", row.get("entrustorg"));
        bill.set("billtype", row.get("billtype"));
        bill.set("entrance", row.get("entrance"));
        bill.set("paymenttype", row.get("paymenttype"));
        bill.set("paymentidentify", row.get("paymentidentify"));
        bill.set("description", row.get("description"));
        bill.set("isdiffcur", row.get("isdiffcur"));
        bill.set("ispersonpay", row.get("ispersonpay"));
        bill.set("payeetype", row.get("payeetype"));
        bill.set("settletype", row.get("settletype"));
        bill.set("openorg", row.get("openorg"));
        bill.set("priority", row.get("priority"));
        bill.set("paymentchannel", row.get("paymentchannel"));
        bill.set("draftbill", row.get("draftbill"));
        bill.set("org", row.get("org"));
        bill.set("basecurrency", row.get("basecurrency"));
        bill.set("payee", row.get("payee"));
        bill.set("payeename", row.get("payeename"));
        bill.set("payeebanknum", row.get("payeebanknum"));
        bill.set("recaccbankname", row.get("recaccbankname"));
        bill.set("payeebankname", row.get("payeebankname"));
        bill.set("recbanknumber", row.get("recbanknumber"));
        bill.set("payeracctcash", row.get("payeracctcash"));
        bill.set("payerbank", row.get("payerbank"));
        bill.set("payeracctbank", row.get("payeracctbank"));
        bill.set("reccountry", row.get("reccountry"));
        bill.set("recprovince", row.get("recprovince"));
        bill.set("reccity", row.get("reccity"));
        bill.set("exratetable", row.get("exratetable"));
        bill.set("exratedate", row.get("exratedate"));
        bill.set("currency", row.get("currency"));
        bill.set("exchangerate", row.get("exchangerate"));
        bill.set("payquotation", row.get("payquotation"));
        bill.set("actpayamt", row.get("actpayamt"));
        bill.set("localamt", row.get("localamt"));
        bill.set("dpexratetable", row.get("dpexratetable"));
        bill.set("dpexratedate", row.get("dpexratedate"));
        bill.set("dpcurrency", row.get("dpcurrency"));
        bill.set("dpexchangerate", row.get("dpexchangerate"));
        bill.set("dppayquotation", row.get("dppayquotation"));
        bill.set("dpamt", row.get("dpamt"));
        bill.set("dplocalamt", row.get("dplocalamt"));
        bill.set("contractno", row.get("contractno"));
        bill.set("agreedrate", row.get("agreedrate"));
        bill.set("agreedquotation", row.get("agreedquotation"));
        bill.set("lossamt", row.get("lossamt"));
        bill.set("usage", row.get("usage"));
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
        DynamicObject entyInfo = entry.addNew();
        entyInfo.set("e_material", row.get("e_material"));
        entyInfo.set("e_expenseitem", row.get("e_expenseitem"));
        entyInfo.set("settleorg", row.get("settleorg"));
        entyInfo.set("e_payableamt", row.get("e_payableamt"));
        entyInfo.set("e_discountamt", row.get("e_discountamt"));
        entyInfo.set("e_actamt", row.get("e_actamt"));
        entyInfo.set("project", row.get("project"));
        entyInfo.set("e_fundflowitem", row.get("e_fundflowitem"));
        entyInfo.set("contractnumber", row.get("contractnumber"));
        entyInfo.set("e_corebilltype", row.get("e_corebilltype"));
        entyInfo.set("e_corebillno", row.get("e_corebillno"));
        entyInfo.set("e_corebillentryseq", row.get("e_corebillentryseq"));
        entyInfo.set("e_remark", row.get("e_remark"));
        entyInfo.set("conbillnumber", row.get("conbillnumber"));
        entyInfo.set("conbillrownum", row.get("conbillrownum"));
        bill.set("entry", (Object)entry);
        DynamicObjectCollection draftbillColl = (DynamicObjectCollection)row.get("draftbill");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftbillColl)) {
            this.updateDraftInfo(bill, draftbillColl);
        }
        return bill;
    }

    private void updateDraftInfo(DynamicObject payBill, DynamicObjectCollection draftbillColl) {
        DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("cas_draftinfo");
        for (DynamicObject draftbill : draftbillColl) {
            DynamicObject entry = entrys.addNew();
            entry.set("draftbillinfo", (Object)draftbill.getDynamicObject("fbasedataid"));
            entry.set("transamount", (Object)draftbill.getDynamicObject("fbasedataid").getBigDecimal("amount"));
            entry.set("paybillcurrency", (Object)draftbill.getDynamicObject("fbasedataid").getDynamicObject("currency"));
            entry.set("srcbilltype", (Object)"cas_paybill");
            entry.set("srcbillindex", (Object)"1");
        }
    }

    private void settleNumberClick() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype", rowIndex);
        if (EmptyUtil.isNoEmpty((DynamicObject)settleType) && SettleMentTypeEnum.CREDIT.getValue().equals(settleType.getString("settlementtype"))) {
            String appId = AppMetadataCache.getAppInfo((String)"lc").getId();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", rowIndex);
            AppParam param = new AppParam();
            param.setAppId(appId);
            param.setOrgId(Long.valueOf(org.getLong("id")));
            param.setViewType("08");
            String paymethod = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"paymethod");
            if ("0".equals(paymethod)) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "settletnumber");
                QFilter qFilterSour = new QFilter("arrivalstatus", "=", (Object)"arrival_confirm");
                qFilterSour.and("arrivalway", "!=", (Object)"protest");
                qFilterSour.and(QFilter.sqlExpress((String)"arrivalamount", (String)">", (String)"flockamount"));
                CasBotpHelper.doBeforeDraw((IFormView)this.getView(), (String)"lc_arrival", (String)this.getModel().getDataEntityType().getName(), (Boolean)false, (QFilter)qFilterSour, (CloseCallBack)closeCallBack);
            }
        }
    }

    private void changePayerPage() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
        Object sourceBillType = this.getModel().getValue("sourcebilltype");
        HashMap<String, Object> payerInfo = new HashMap<String, Object>();
        payerInfo.put("cash", BaseDataHelper.isSettleTypeCash((DynamicObject)settleType));
        payerInfo.put("virtual", BaseDataHelper.isSettleTypeVirtual((DynamicObject)settleType));
        payerInfo.put("sourceBillType", sourceBillType);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_changepayer");
        parameter.getCustomParams().putAll(payerInfo);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_changepayer"));
        this.getView().showForm(parameter);
    }

    private void changePayerValue(Map<String, Object> returnMap) {
        DynamicObject old_bank;
        DynamicObject new_bank;
        DynamicObject old_acctbank;
        DynamicObject new_acctbank;
        DynamicObject old_acctcash;
        DynamicObject new_acctcash;
        boolean isChangeCur = false;
        FormDataModel model = (FormDataModel)this.getModel();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject new_org = (DynamicObject)returnMap.get("org");
        DynamicObject old_org = (DynamicObject)model.getValue("org", rowIndex);
        DynamicObject cur = OrgHelper.getBaseCurrency((long)((Long)new_org.getPkValue()));
        if (!CasHelper.isEquals((Object)new_org, (Object)old_org)) {
            this.setValue("org", new_org, rowIndex);
            this.setValue("textorg", new_org.getString("name"), rowIndex);
            this.setValue("basecurrency", cur, rowIndex);
            this.setValue("draftbill", null, rowIndex);
            isChangeCur = true;
        }
        if (!CasHelper.isEquals((Object)(new_acctcash = (DynamicObject)returnMap.get("payeracctcash")), (Object)(old_acctcash = (DynamicObject)model.getValue("payeracctcash", rowIndex)))) {
            String textpayeracctcash = null;
            if (new_acctcash != null) {
                textpayeracctcash = new_acctcash.getString("number");
            }
            this.setValue("payeracctcash", new_acctcash, rowIndex);
            this.setValue("textpayeracctcash", textpayeracctcash, rowIndex);
            isChangeCur = false;
        }
        if (!CasHelper.isEquals((Object)(new_acctbank = (DynamicObject)returnMap.get("payeracctbank")), (Object)(old_acctbank = (DynamicObject)model.getValue("payeracctbank", rowIndex)))) {
            String textpayeracctbank = null;
            if (new_acctbank != null) {
                textpayeracctbank = kd.fi.cas.util.StringUtils.splitString((String)new_acctbank.getString("bankaccountnumber"), (int)4, (String)" ");
            }
            this.setValue("payeracctbank", new_acctbank, rowIndex);
            this.setValue("textpayeracctbank", textpayeracctbank, rowIndex);
            isChangeCur = false;
        }
        if (!CasHelper.isEquals((Object)(new_bank = (DynamicObject)returnMap.get("payerbank")), (Object)(old_bank = (DynamicObject)model.getValue("payerbank", rowIndex)))) {
            this.setValue("payerbank", new_bank, rowIndex);
            String textpayerbank = "";
            textpayerbank = CasHelper.getLocalValue((DynamicObject)new_bank, (String)"name");
            this.setValue("textpayerbank", textpayerbank, rowIndex);
        }
        this.settleOrg(true, rowIndex);
        if (isChangeCur) {
            this.setValue("currency", cur, rowIndex);
        }
        this.setValue("openorg", returnMap.get("openorg"), rowIndex);
    }

    private void addPayee() {
        this.opreatePayee(Boolean.FALSE);
    }

    private void opreatePayee(Boolean isAddNew) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        paramMap.put("org", this.getPk("org", rowIndex));
        paramMap.put("asstActType", this.getModel().getValue("payeetype", rowIndex));
        paramMap.put("isBE", this.isBePay(rowIndex));
        paramMap.put("billtype", Optional.ofNullable(this.getDynamicObject("billtype", rowIndex)).map(DataEntityBase::getPkValue).orElse(null));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_addpayee");
        parameter.setStatus(isAddNew != false ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        parameter.getCustomParams().putAll(paramMap);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_addpayee"));
        this.getView().showForm(parameter);
    }

    private void addPayeeValue(Map<String, Object> resultMap) {
        DynamicObject old_settletype;
        DynamicObject new_settletype;
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.setValue("payee", resultMap.get("payee"), rowIndex);
        this.setValue("payeename", resultMap.get("payeename"), rowIndex);
        this.setValue("payeebanknum", resultMap.get("payeebanknum"), rowIndex);
        this.setValue("payeebank", resultMap.get("payeebank"), rowIndex);
        this.setValue("payeebankname", resultMap.get("payeebankname"), rowIndex);
        this.setValue("recaccbankname", resultMap.get("recaccbankname"), rowIndex);
        String beBankNumber = (String)resultMap.get("recbanknumber");
        this.setValue("recbanknumber", beBankNumber, rowIndex);
        this.setValue("reccountry", resultMap.get("reccountry"), rowIndex);
        this.setValue("recprovince", resultMap.get("recprovince"), rowIndex);
        this.setValue("reccity", resultMap.get("reccity"), rowIndex);
        if (AsstActTypeEnum.SUPPLIER.getValue().equals(this.getModel().getValue("payeetype", rowIndex)) && !CasHelper.isEquals((Object)(new_settletype = (DynamicObject)resultMap.get("settlment")), (Object)(old_settletype = (DynamicObject)this.getModel().getValue("settletype", rowIndex))) && new_settletype != null) {
            this.setValue("settletype", new_settletype, rowIndex);
        }
    }

    private void changeEntrancePage() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        HashMap<String, String> batchInfo = new HashMap<String, String>();
        batchInfo.put("batchbillname", "cas_batchpaybill");
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cas_batchpayrectype");
        parameter.getCustomParams().putAll(batchInfo);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchpayrectype"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("cas_changepayer".equals(e.getActionId())) {
            Map resultMap = (Map)e.getReturnData();
            if (resultMap != null) {
                this.changePayerValue(resultMap);
            }
        } else if ("cas_addpayee".equals(e.getActionId())) {
            Map resultMap = (Map)e.getReturnData();
            if (resultMap != null) {
                this.addPayeeValue(resultMap);
            }
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"settletnumber")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)rows)) {
                this.getModel().deleteEntryData("entry");
                CasBotpHelper.doDraw((IFormView)this.getView(), (String)"lc_arrival", (String)this.getModel().getDataEntityType().getName(), (ListSelectedRowCollection)rows);
            }
        } else if ("batchpayrectype".equals(e.getActionId())) {
            Map resultMap = (Map)e.getReturnData();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (resultMap != null) {
                String payeetype;
                String entrance = (String)resultMap.get("entrance");
                if (CasHelper.isNotEmpty((Object)entrance)) {
                    String textentrance = (String)this.getName(entrance);
                    this.setValue("textentrance", textentrance, rowIndex);
                }
                if (CasHelper.isNotEmpty((Object)(payeetype = (String)resultMap.get("payeetype")))) {
                    String textpayeetype = (String)this.getName(payeetype);
                    this.setValue("textpayeetype", textpayeetype, rowIndex);
                }
                this.setValue("entrance", entrance, rowIndex);
                this.setValue("payeetype", payeetype, rowIndex);
            }
        }
    }

    private Object getName(String type) {
        String res = "";
        switch (type) {
            case "bos_org": {
                res = AsstActTypeEnum.COMPANY.getName();
                break;
            }
            case "bd_supplier": {
                res = AsstActTypeEnum.SUPPLIER.getName();
                break;
            }
            case "bd_customer": {
                res = AsstActTypeEnum.CUSTOMER.getName();
                break;
            }
            case "bos_user": {
                res = AsstActTypeEnum.EMPLOYEE.getName();
                break;
            }
            case "other": {
                res = AsstActTypeEnum.OTHER.getName();
                break;
            }
            case "AP": {
                res = ResManager.loadKDString((String)"\u91c7\u8d2d\u4ed8\u6b3e", (String)"PayBillBatchInputPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                break;
            }
            case "OTR": {
                res = ResManager.loadKDString((String)"\u5176\u4ed6\u4ed8\u6b3e", (String)"PayBillBatchInputPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return res;
    }

    private boolean isBePay(int rowIndex) {
        DynamicObject payerAcctBank = this.getDynamicObject("payeracctbank", rowIndex);
        String paymentchannel = (String)this.getModel().getValue("paymentchannel", rowIndex);
        if (payerAcctBank != null && PayBillCrossHelper.isIfmBankAcc((DynamicObject)payerAcctBank)) {
            return true;
        }
        return payerAcctBank != null && (Boolean)payerAcctBank.get("issetbankinterface") != false && "bei".equalsIgnoreCase(paymentchannel);
    }

    private void initRowData(int rowIndex) {
        DynamicObject org;
        String entrance = (String)this.getModel().getValue("entrance", rowIndex);
        String formId = "cas_batchpaybill";
        String field = "entrance";
        String entranceTxt = "";
        MainEntityType meta = MetadataServiceHelper.getDataEntityType((String)"cas_batchpaybill");
        if (meta.getAllFields().get(field) instanceof ComboProp) {
            List items = ((ComboProp)meta.getAllFields().get(field)).getComboItems();
            for (ValueMapItem item : items) {
                if (!item.getValue().equalsIgnoreCase(entrance)) continue;
                entranceTxt = item.getName().toString();
                break;
            }
        }
        if (EmptyUtil.isEmpty((String)entranceTxt)) {
            entranceTxt = ResManager.loadKDString((String)"\u91c7\u8d2d\u4ed8\u6b3e", (String)"PayBillBatchInputPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        this.getModel().setValue("textentrance", (Object)entranceTxt);
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"usage"});
        this.getModel().setValue("sourcebilltype", null, rowIndex);
        if (this.getModel().getValue("org", rowIndex) != null) {
            this.orgId = this.getPk("org");
        } else {
            this.orgId = RequestContext.get().getOrgId();
            this.setValue("org", this.orgId, rowIndex);
        }
        this.setValueIfAbsent("bizdate", DateUtils.getCurrentDate(), rowIndex);
        if (this.getModel().getValue("paymenttype", rowIndex) == null) {
            this.setPaymentType(entrance, rowIndex);
        }
        this.setValue("payeetype", AsstActTypeEnum.SUPPLIER.getValue(), rowIndex);
        this.setValue("textpayeetype", AsstActTypeEnum.SUPPLIER.getName(), rowIndex);
        DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)this.orgId);
        this.setValue("basecurrency", baseCurrency, rowIndex);
        this.setValue("currency", baseCurrency, rowIndex);
        this.setValue("dpcurrency", baseCurrency, rowIndex);
        this.setExratetableVisibility(this.orgId, rowIndex);
        DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
        this.setValue("settletype", defaultSettleType, rowIndex);
        if (!BaseDataHelper.isSettleTypeCash((DynamicObject)defaultSettleType)) {
            DynamicObject defaultPayAccount = AccountBankHelper.getDefaultPayAccount((Long)this.orgId);
            if (defaultPayAccount != null && (BaseDataHelper.isSettleTypeVirtual((DynamicObject)defaultSettleType) && VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultPayAccount).booleanValue() || !BaseDataHelper.isSettleTypeVirtual((DynamicObject)defaultSettleType) && !VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultPayAccount).booleanValue())) {
                this.setValue("payeracctbank", defaultPayAccount, rowIndex);
                String textpayeracctbank = kd.fi.cas.util.StringUtils.splitString((String)defaultPayAccount.getString("bankaccountnumber"), (int)4, (String)" ");
                this.setValue("textpayeracctbank", textpayeracctbank, rowIndex);
                this.payerAcctBankF7Changed(null, defaultPayAccount, rowIndex);
                this.currencyF7Changed(baseCurrency, false, rowIndex);
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"exchangerate"});
            }
        }
        if ((org = (DynamicObject)this.getModel().getValue("org", rowIndex)) == null) {
            return;
        }
        this.getModel().setValue("textorg", (Object)CasHelper.getLocalValue((DynamicObject)org, (String)"name"), rowIndex);
        this.setOpenOrg(rowIndex);
        this.setDefaultPaymentChannelValue(rowIndex);
        this.calculateAmt(rowIndex);
        DynamicObject settleType = this.getDynamicObject("settletype", rowIndex);
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            this.setValue("payeracctcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payer"), rowIndex);
        }
        if (Objects.nonNull(settleType)) {
            this.settletNumber(settleType, rowIndex);
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"draftbill"});
        }
        DynamicObject paymenttype = (DynamicObject)this.getModel().getValue("paymenttype", rowIndex);
        if (null != paymenttype && !paymenttype.getBoolean("ispartpayment")) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"settleorg"});
        }
        this.settleOrg(false, rowIndex);
        this.ctrBeInfoVisibility(rowIndex);
        this.getModel().setDataChanged(false);
    }

    private void setPaymentType(String entrance, int rowIndex) {
        long billTypeID = 0L;
        if (PaymentTypeEnum.AP.name().equals(entrance)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("ispartpayment", "=", (Object)"1"), new QFilter("biztype", "=", (Object)"201")};
            this.fillPaymentType(qFilters, rowIndex);
            billTypeID = BillTypeConstants.PAYBILL_PUR;
        } else if (PaymentTypeEnum.OTR.name().equals(entrance)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("biztype", "=", (Object)"999")};
            this.fillPaymentType(qFilters, rowIndex);
            billTypeID = BillTypeConstants.PAYBILL_OTR;
        }
        if (billTypeID != 0L && QueryServiceHelper.exists((String)"bos_billtype", (Object)billTypeID)) {
            this.setValue("billtype", billTypeID, rowIndex);
        }
    }

    private void fillPaymentType(QFilter[] qFilters, int rowIndex) {
        DynamicObject paymentType = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_paymentbilltype", (String)"id,fundflowitem", (QFilter[])qFilters);
        if (paymentType != null) {
            this.setValue("paymenttype", paymentType.getLong("id"), rowIndex);
            DynamicObject fundflowitem = paymentType.getDynamicObject("fundflowitem");
            this.fillFundflowItem(true, fundflowitem, rowIndex);
        } else {
            this.setValue("paymenttype", null);
        }
    }

    private void fillFundflowItem(boolean isCover, DynamicObject defaultFundsItem, int rowIndex) {
        if (defaultFundsItem == null) {
            return;
        }
        if (isCover) {
            this.setValue("e_fundflowitem", defaultFundsItem.getPkValue(), rowIndex);
        } else {
            this.setValueIfAbsent("e_fundflowitem", defaultFundsItem.getPkValue(), rowIndex);
        }
    }

    private void clearPayeeValue(int rowIndex) {
        this.setValue("payee", null, rowIndex);
        this.setValue("payee", null, rowIndex);
        this.setValue("payeebanknum", null, rowIndex);
        this.setValue("recaccbankname", null, rowIndex);
        this.setValue("recbanknumber", null, rowIndex);
        this.setValue("payeebank", null, rowIndex);
        this.setValue("payeebankname", null, rowIndex);
    }

    private void currencyF7Changed(Object newValue, boolean reBalance, int rowIndex) {
        this.setExchangerateEditable(rowIndex);
    }

    private void setRecInfo(String key, Object value, Boolean isCheckDiff, int rowIndex) {
        if (isCheckDiff.booleanValue()) {
            Boolean isDiffCur = (Boolean)this.getModel().getValue("isdiffcur", rowIndex);
            if (!isDiffCur.booleanValue()) {
                this.getModel().setValue(key, value, rowIndex);
            }
        } else {
            this.getModel().setValue(key, value, rowIndex);
        }
    }

    private void entrustorgChange(Object newValue, int rowIndex) {
        if (null != newValue) {
            this.getModel().setValue("settletype", null, rowIndex);
            return;
        }
        DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
        this.setValue("settletype", defaultSettleType, rowIndex);
    }

    private void settletNumber(DynamicObject newValue, int rowIndex) {
        if (Objects.isNull(newValue)) {
            return;
        }
        Object settlementType = newValue.get("settlementtype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org", rowIndex);
        if (Objects.nonNull(org)) {
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            boolean visible = false;
            if (Objects.equals(settlementType, SettleMentTypeEnum.BUSINESS.getValue()) || Objects.equals(settlementType, SettleMentTypeEnum.BANK.getValue())) {
                visible = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)org.getPkValue()), (String)"isdraft");
            } else if (Objects.equals(settlementType, SettleMentTypeEnum.PROMISSORY.getValue())) {
                visible = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)org.getPkValue()), (String)"ischeck");
            } else if (Objects.equals(settlementType, SettleMentTypeEnum.CHECK.getValue())) {
                visible = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)org.getPkValue()), (String)"ispromissorynote");
            }
            this.getView().setEnable(Boolean.valueOf(!visible), rowIndex, new String[]{"settletnumber"});
            this.getView().setEnable(Boolean.valueOf(visible), rowIndex, new String[]{"draftbill"});
        }
    }

    protected void setExchangerateEditable(int rowIndex) {
        DynamicObject srcCurrency = this.getDynamicObject("currency", rowIndex);
        DynamicObject destCurrency = this.getDynamicObject("basecurrency", rowIndex);
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"exchangerate"});
        }
    }

    protected void setRecExchangerateEditable(int rowIndex) {
        DynamicObject srcCurrency = this.getDynamicObject("dpcurrency", rowIndex);
        DynamicObject destCurrency = this.getDynamicObject("basecurrency", rowIndex);
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dpexchangerate"});
        }
    }

    private void setExratetableVisibility(Long orgId, int rowIndex) {
        Long currencyId = this.getPk("currency", rowIndex);
        Long dpCurrencyId = this.getPk("dpcurrency", rowIndex);
        Long basecurrencyId = this.getPk("basecurrency", rowIndex);
        if (currencyId != null && !currencyId.equals(basecurrencyId) || dpCurrencyId != null && !dpCurrencyId.equals(basecurrencyId)) {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"exratetable"});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"exratedate"});
            this.setDefaultExratetable(orgId, rowIndex);
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"exratetable"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"exratedate"});
            this.getModel().setValue("exratetable", null, rowIndex);
            this.getModel().setValue("exratedate", null, rowIndex);
        }
    }

    private void setDefaultExratetable(Long orgId, int rowIndex) {
        Long exchangeRateTableId = 0L;
        try {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getModel().setValue("exratedate", this.getValue("bizdate", rowIndex), rowIndex);
        this.getModel().setValue("exratetable", (Object)exchangeRateTableId, rowIndex);
    }

    protected void setOpenOrg(int rowIndex) {
        DynamicObject openorg;
        DynamicObject acct;
        DynamicObject org = (DynamicObject)this.getValue("org", rowIndex);
        if (org == null) {
            return;
        }
        Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)org.getPkValue()));
        if (null != companyByOrg && companyByOrg.size() > 0) {
            this.setValue("openorg", companyByOrg.get("id"), rowIndex);
            return;
        }
        String accountField = this.recPayAccount();
        if (accountField != null && (acct = (DynamicObject)this.getModel().getValue(this.recPayAccount(), rowIndex)) != null && (openorg = acct.getDynamicObject("openorg")) != null && (openorg = QueryServiceHelper.queryOne((String)"bos_org", (String)"fisaccounting", (QFilter[])new QFilter[]{new QFilter("id", "=", openorg.getPkValue())})).getBoolean("fisaccounting")) {
            this.setValue("openorg", acct.get("openorg"), rowIndex);
            return;
        }
        this.setValue("openorg", null, rowIndex);
    }

    private void setDefaultPaymentChannelValue(int rowIndex) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboEdit paymentChannel = (ComboEdit)this.getControl("paymentchannel");
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(PaymentChannelEnum.COUNTER.getValue());
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)PaymentChannelEnum.COUNTER.getName(), (String)"PaymentBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        comboItems.add(comboItem);
        paymentChannel.setComboItems(comboItems);
        this.getModel().setValue("paymentchannel", (Object)comboItem.getValue(), rowIndex);
    }

    private void calculateAmt(int rowIndex) {
        DynamicObject basecurrency = this.getDynamicObject("basecurrency", rowIndex);
        BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate", rowIndex);
        String quotation = (String)this.getModel().getValue("payquotation", rowIndex);
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        BigDecimal payAmount = this.getBigDecimal("e_payableamt", rowIndex);
        BigDecimal discountAmt = this.getBigDecimal("e_discountamt", rowIndex);
        if (payAmount != null && discountAmt != null) {
            BigDecimal actAmt = payAmount.subtract(discountAmt);
            sumAmt = sumAmt.add(actAmt);
            BigDecimal actLocalAmt = BigDecimal.ZERO;
            actLocalAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
            sumLocalAmt = sumLocalAmt.add(actLocalAmt);
            this.setValue("e_actamt", actAmt, rowIndex);
        }
        this.setValue("actpayamt", sumAmt, rowIndex);
        this.setValue("localamt", sumLocalAmt, rowIndex);
        this.calculateDpAmt(rowIndex);
    }

    private void calculateDpAmt(int rowIndex) {
        DynamicObject dpcurrency = this.getDynamicObject("dpcurrency", rowIndex);
        DynamicObject basecurrency = this.getDynamicObject("basecurrency", rowIndex);
        DynamicObject currency = this.getDynamicObject("currency", rowIndex);
        String dppayquotation = (String)this.getModel().getValue("dppayquotation", rowIndex);
        String agreedquotation = (String)this.getModel().getValue("agreedquotation", rowIndex);
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int dppayround = 10;
        if (dpcurrency != null) {
            dppayround = dpcurrency.getInt("amtprecision");
        }
        BigDecimal actPayAmt = this.getBigDecimal("actpayamt", rowIndex);
        if (currency != null) {
            actPayAmt = actPayAmt.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = this.getBigDecimal("localamt", rowIndex);
        BigDecimal agreedRate = this.getBigDecimal("agreedrate", rowIndex);
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        BigDecimal dpAmt = BigDecimal.ZERO;
        dpAmt = QuotationHelper.callToCurrency((BigDecimal)actPayAmt, (BigDecimal)agreedRate, (String)agreedquotation, (int)dppayround);
        BigDecimal dpExchangeRate = this.getBigDecimal("dpexchangerate", rowIndex);
        BigDecimal dpLocalAmt = BigDecimal.ZERO;
        dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        this.setValue("dpamt", dpAmt, rowIndex);
        this.setValue("lossamt", localAmt.subtract(dpLocalAmt), rowIndex);
    }

    private void dpAmtChanged(Object newValue, int rowIndex) {
        BigDecimal dpAmt = (BigDecimal)newValue;
        String dppayquotation = (String)this.getModel().getValue("dppayquotation", rowIndex);
        DynamicObject basecurrency = this.getDynamicObject("basecurrency", rowIndex);
        if (basecurrency == null) {
            return;
        }
        int round = basecurrency.getInt("amtprecision");
        BigDecimal dpExchangeRate = this.getBigDecimal("dpexchangerate", rowIndex);
        BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        BigDecimal localAmt = this.getBigDecimal("localamt", rowIndex);
        this.setValue("dplocalamt", dpLocalAmt, rowIndex);
        this.setValue("lossamt", localAmt.subtract(dpLocalAmt), rowIndex);
        BigDecimal actPayAmt = this.getBigDecimal("actpayamt", rowIndex);
        if (actPayAmt.compareTo(new BigDecimal(0)) == 0 || dpAmt.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        String agreedquotation = (String)this.getModel().getValue("agreedquotation", rowIndex);
        BigDecimal agreedRate = BigDecimal.ONE;
        agreedRate = "1".equals(agreedquotation) ? actPayAmt.divide(dpAmt, 10, RoundingMode.HALF_UP) : dpAmt.divide(actPayAmt, 10, RoundingMode.HALF_UP);
        this.getModel().beginInit();
        this.setValue("agreedrate", agreedRate, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("agreedrate", rowIndex);
    }

    private void isDiffCurChanged(Object newValue, int rowIndex) {
        Boolean isDiffCur = (Boolean)newValue;
        if (!isDiffCur.booleanValue()) {
            this.getModel().beginInit();
            this.getModel().setValue("exchangerate", this.getModel().getValue("dpexchangerate", rowIndex), rowIndex);
            this.getModel().setValue("agreedrate", (Object)1, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("exchangerate", rowIndex);
            this.getView().updateView("agreedrate", rowIndex);
            this.getModel().setValue("currency", this.getModel().getValue("dpcurrency", rowIndex), rowIndex);
            this.setValue("contractno", null, rowIndex);
        } else {
            DynamicObject payerAcctBank = this.getDynamicObject("payeracctbank", rowIndex);
            if (payerAcctBank != null) {
                Long defaultCurrencyId = (Long)payerAcctBank.get("defaultcurrency.id");
                this.setValue("dpcurrency", defaultCurrencyId, rowIndex);
            }
        }
        this.calculateDpAmt(rowIndex);
        this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dpcurrency"});
        this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"currency"});
        this.setCurrencyEditable(isDiffCur, rowIndex);
    }

    private void settleOrg(boolean isOrg, int rowIndex) {
        Object openOrg;
        DynamicObject paymenttype = (DynamicObject)this.getModel().getValue("paymenttype", rowIndex);
        if (null != paymenttype && paymenttype.getBoolean("ispartpayment") && (openOrg = this.getModel().getValue("openorg", rowIndex)) != null) {
            DynamicObject accountOrg = (DynamicObject)openOrg;
            if (isOrg || CasHelper.isEmpty((Object)this.getModel().getValue("settleorg", rowIndex))) {
                this.setValue("settleorg", accountOrg.getPkValue(), rowIndex);
            }
        }
    }
}

