/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class PayBillCashPlugin
extends BillEditPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"changepayee"});
    }

    public void afterCreateNewData(EventObject e) {
        this.synPayRec();
        this.synSettleType();
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            this.getModel().setValue("businesstype", (Object)PayBusinessTypeEnum.CASHOUT.getValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryVisible();
        this.synAcctBankOrCash(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "org": {
                this.synPayRec();
                break;
            }
            case "businesstype": {
                this.synAcctBankOrCash(true);
                this.synSettleType();
                this.syncMatchFlag();
                break;
            }
            case "currency": {
                this.clearPayeeAcctBankFoCashPay((DynamicObject)newValue);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.click((EventObject)evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "changepayee": {
                String businessType;
                DynamicObject billtype = this.getDynamicObject("billtype");
                if (billtype == null || !BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue()) || !EmptyUtil.isEmpty((String)(businessType = this.getString("businesstype")))) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PayBillCashPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void synPayRec() {
        DynamicObject org = this.getDynamicObject("org");
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (org != null && billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            this.setValue("payee", org.getPkValue());
            this.setValue("payeename", org.getLocaleString("name").getLocaleValue());
            this.setValue("payeeformid", this.getString("payeetype"));
            this.setPayeeInfo4Lb();
            this.clearPayeeAccValue();
        }
    }

    private void synSettleType() {
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            String businessType = this.getString("businesstype");
            String settlementtype = "";
            if (PayBusinessTypeEnum.CASHIN.getValue().equals(businessType)) {
                settlementtype = SettleMentTypeEnum.MONEY.getValue();
                this.setValue("payeracctbank", null);
                this.setValue("payerbank", null);
            } else if (PayBusinessTypeEnum.CASHOUT.getValue().equals(businessType)) {
                settlementtype = SettleMentTypeEnum.COLLECT.getValue();
                this.setValue("payeracctcash", null);
            } else {
                return;
            }
            DynamicObject settleType = this.loadSettleType(settlementtype);
            if (settleType != null) {
                this.setValue("settletype", settleType.getPkValue());
            }
        }
    }

    private void syncMatchFlag() {
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            String businessType = this.getString("businesstype");
            if (PayBusinessTypeEnum.CASHIN.getValue().equals(businessType)) {
                Boolean relateOtherFlow = (Boolean)this.getValue("relateotherflow");
                if (relateOtherFlow.booleanValue()) {
                    this.setValue("matchflag", AutoMatchFlagEnum.NONE.getValue());
                } else {
                    this.setValue("matchflag", AutoMatchFlagEnum.NONEED.getValue());
                }
            }
        }
    }

    private void synAcctBankOrCash(boolean isChange) {
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            if (isChange) {
                this.setValue("payeeaccformid", null);
                this.setValue("payeeacctbank", null);
                this.setValue("payeeacctcash", null);
                this.setValue("payeebanknum", null);
                this.setValue("payeebank", null);
                this.setValue("payeebankname", null);
            }
            String businessType = this.getString("businesstype");
            if (PayBusinessTypeEnum.CASHOUT.getValue().equals(businessType)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"payeebanknamelb", "payeebanknamev"});
            } else if (PayBusinessTypeEnum.CASHIN.getValue().equals(businessType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"payeebanknamelb", "payeebanknamev"});
            }
            this.setPayeeAcctInfo4Lb();
        }
    }

    private void clearPayeeAcctBankFoCashPay(DynamicObject currency) {
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (currency != null && billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            QFilter currFilter;
            QFilter pkFilter;
            boolean isExists;
            Object payeeacctId;
            String entityName = "";
            String businesstype = this.getString("businesstype");
            if (PayBusinessTypeEnum.CASHOUT.getValue().equals(businesstype)) {
                payeeacctId = this.getValue("payeeacctcash");
                entityName = "cas_accountcash";
            } else {
                payeeacctId = this.getValue("payeeacctbank");
                entityName = "bd_accountbanks";
            }
            if (payeeacctId != null && Long.parseLong(payeeacctId.toString()) != 0L && !(isExists = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{pkFilter = new QFilter("id", "=", payeeacctId), currFilter = new QFilter("currency.fbasedataid.id", "=", (Object)currency.getLong("id"))}))) {
                Object value = null;
                this.setValue("payeeaccformid", value);
                this.setValue("payeeacctbank", value);
                this.setValue("payeeacctcash", value);
                this.setValue("payeebanknum", value);
                this.setValue("payeebank", value);
                this.setValue("payeebankname", value);
                this.setValue("recaccbankname", value);
                this.setValue("recbanknumber", value);
                this.setPayeeAcctInfo4Lb();
            }
        }
    }

    private DynamicObject loadSettleType(String settlementtype) {
        QFilter[] filters = new QFilter[]{new QFilter("settlementtype", "=", (Object)settlementtype), new QFilter("enable", "=", (Object)"1")};
        return BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id", (QFilter[])filters);
    }

    private void setPayeeInfo4Lb() {
        this.setValue("payeenamev", this.getValue("payeename"));
        Image payeePic = (Image)this.getControl("payeepic");
        String payeeformid = this.getString("payeeformid");
        long payeeId = (Long)this.getValue("payee");
        String defaultUrl = BaseDataHelper.getPictureUrl((Long)payeeId, (String)payeeformid);
        defaultUrl = defaultUrl == null ? "/kingdee/tmc/images/pc/icon/entrance/sky_skf_80_80.png" : defaultUrl;
        payeePic.setUrl(defaultUrl);
    }

    private void setPayeeAcctInfo4Lb() {
        ((Label)this.getControl("payeebanknumv")).setText(StringUtils.splitString((String)this.getString("payeebanknum"), (int)4, (String)" "));
        ((Label)this.getControl("payeebanknamev")).setText(this.getString("payeebankname"));
        ((Label)this.getControl("recaccbanknamev")).setText(this.getString("recaccbankname"));
        ((Label)this.getControl("recbanknumberv")).setText(this.getString("recbanknumber"));
    }

    private void setEntryVisible() {
        DynamicObject billtype = this.getDynamicObject("billtype");
        if (billtype != null && BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdiffcur"});
            PaymentBillPluginHelper.initBusinessType((IFormView)this.getView(), (String[])new String[]{PayBusinessTypeEnum.CASHOUT.getValue(), PayBusinessTypeEnum.CASHIN.getValue()});
        }
    }

    private void clearPayeeAccValue() {
        Object value = null;
        this.setValue("payeeaccformid", value);
        this.setValue("payeeacctbank", value);
        this.setValue("payeeacctcash", value);
        this.setValue("payeebanknum", value);
        this.setValue("payeebank", value);
        this.setValue("payeebankname", value);
        this.setValue("recaccbankname", value);
        this.setValue("recbanknumber", value);
        this.setValue("payeenumber", null);
        this.setPayeeAcctInfo4Lb();
    }
}

