/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.helper.PaymentPayeeInfo;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class PayBillDcepEdit
extends BillEditPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit settleType = (BasedataEdit)this.getControl("settletype");
        settleType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"changepayer", "changepayee", "flex_baseinfo"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setValue("businesstype", PayBusinessTypeEnum.WALLETUP.getValue());
        this.initSettleType();
        this.synPay2Rec();
        this.synAcctBankInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        PaymentBillPluginHelper.initBusinessType((IFormView)this.getView(), (String[])new String[]{PayBusinessTypeEnum.WALLETUP.getValue(), PayBusinessTypeEnum.WALLETESSAY.getValue()});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "org": {
                this.synPay2Rec();
                break;
            }
            case "businesstype": {
                this.synAcctBankInfo();
                break;
            }
            case "payeracctbank": {
                this.synAcctBankInfo();
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.click((EventObject)evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "changepayer": 
            case "changepayee": {
                String businessType = this.getString("businesstype");
                if (!EmptyUtil.isEmpty((String)businessType)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PayBillCashPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    private void initSettleType() {
        DynamicObject settleType = DcepConverHelper.getDcepSettleType();
        if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
            this.setValue("settletype", settleType.getPkValue());
        }
    }

    private void synPay2Rec() {
        DynamicObject org = this.getDynamicObject("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            this.setValue("payee", org.getPkValue());
            this.setValue("payeename", org.getLocaleString("name").getLocaleValue());
            this.setValue("payeeformid", this.getString("payeetype"));
            this.setPayeeInfo4Lb();
            this.clearPayeeAccValue();
        }
    }

    private void setPayeeInfo4Lb() {
        this.setValue("payeenamev", this.getValue("payeename"));
    }

    private void clearPayeeAccValue() {
        Object value = null;
        this.setValue("payeeaccformid", value);
        this.setValue("payeeacctbank", value);
        this.setValue("payeebanknum", value);
        this.setValue("payeebankname", value);
        this.setValue("payeebank", value);
        this.setValue("payeebankname", value);
        this.setValue("payeenumber", value);
        this.setValue("recbanknumber", value);
        this.setValue("recaccbankname", value);
        this.setValue("reccountry", value);
        this.setValue("recprovince", value);
        this.setValue("reccity", value);
        this.setValue("institutioncode", value);
        this.setValue("institutionname", value);
        this.setPayeeAcctInfo4Lb();
    }

    private void setPayeeAcctInfo4Lb() {
        ((Label)this.getControl("payeebanknumv")).setText(StringUtils.splitString((String)this.getString("payeebanknum"), (int)4, (String)" "));
        ((Label)this.getControl("payeebanknamev")).setText(this.getString("payeebankname"));
        ((Label)this.getControl("recaccbanknamev")).setText(this.getString("recaccbankname"));
        ((Label)this.getControl("recbanknumberv")).setText(this.getString("recbanknumber"));
    }

    private void synAcctBankInfo() {
        String businessType = (String)this.getValue("businesstype");
        if (EmptyUtil.isEmpty((String)businessType)) {
            this.clearPayeeAccValue();
            this.clearPayAccValue();
        }
        if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
            this.clearPayeeAccValue();
            DynamicObject payAccBank = (DynamicObject)this.getValue("payeracctbank");
            if (EmptyUtil.isNoEmpty((DynamicObject)payAccBank) && !payAccBank.getBoolean("iselecpayment")) {
                Object pkValue = payAccBank.getPkValue();
                QFilter bdFilter = new QFilter("iselecpayment", "=", (Object)"1");
                bdFilter.and("relatedsettleacct.fbasedataid.id", "=", pkValue);
                bdFilter.and("acctstatus", "=", (Object)"normal");
                this.setRecInfo(bdFilter);
                String institutioncode = DcepConverHelper.getInstitUtionCode((DynamicObject)payAccBank);
                this.setValue("institutioncode", institutioncode);
                String institutionName = DcepConverHelper.getInstitutionName((DynamicObject)payAccBank);
                this.setValue("institutionname", institutionName);
            } else {
                this.clearPayAccValue();
            }
        } else if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
            this.clearPayeeAccValue();
            DynamicObject payAccBank = (DynamicObject)this.getValue("payeracctbank");
            if (EmptyUtil.isNoEmpty((DynamicObject)payAccBank) && !payAccBank.getBoolean("iselecpayment") || EmptyUtil.isEmpty((DynamicObject)payAccBank)) {
                this.clearPayAccValue();
            } else {
                Object recBank;
                DynamicObjectCollection relatedsettleacct = payAccBank.getDynamicObjectCollection("relatedsettleacct");
                List accId = relatedsettleacct.stream().map(o -> o.get("fbasedataid_id")).collect(Collectors.toList());
                if (accId.size() == 1) {
                    QFilter bdFilter = new QFilter("id", "=", accId.get(0));
                    bdFilter.and("iselecpayment", "=", (Object)"0");
                    bdFilter.and("acctstatus", "=", (Object)"normal");
                    this.setRecInfo(bdFilter);
                }
                if (EmptyUtil.isNoEmpty((Object)(recBank = this.getValue("payeeacctbank")))) {
                    DynamicObject dcepAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)recBank, (String)"bd_accountbanks", (String)"bank");
                    String institutioncode = DcepConverHelper.getInstitUtionCode((DynamicObject)dcepAccount);
                    this.setValue("institutioncode", institutioncode);
                    String institutionName = DcepConverHelper.getInstitutionName((DynamicObject)dcepAccount);
                    this.setValue("institutionname", institutionName);
                }
            }
        }
        this.setPayeeAcctInfo4Lb();
    }

    private void clearPayAccValue() {
        this.setValue("payeracctbank", null);
        this.setValue("payerbank", null);
        this.setValue("institutioncode", null);
        this.setValue("institutionname", null);
        this.setPayerInfo4Lb();
    }

    private void setRecInfo(QFilter bdFilter) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter accountAuthAssignFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
        bdFilter.and(accountAuthAssignFilter);
        DynamicObject dcepAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,bankaccountnumber,bank,openorg,acctname", (QFilter[])bdFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)dcepAccount)) {
            this.setValue("payeeaccformid", "bd_accountbanks");
            this.setValue("payeeacctbank", dcepAccount.getPkValue());
            PaymentPayeeInfo paymentPayeeInfo = PaymentPayeeInfo.createByAccountBank((DynamicObject)dcepAccount);
            this.setValue("payeebanknum", paymentPayeeInfo.getAccountNumber());
            this.setValue("payeebankname", paymentPayeeInfo.getPayeeBankName());
            this.setValue("recbanknumber", paymentPayeeInfo.getBankNumber());
            this.setValue("recaccbankname", paymentPayeeInfo.getPayeeRecName());
            this.setValue("reccountry", paymentPayeeInfo.getCountryId());
            this.setValue("recprovince", paymentPayeeInfo.getProvince());
            this.setValue("reccity", paymentPayeeInfo.getCity());
        }
    }

    private void setPayerInfo4Lb() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        this.getModel().setValue("orgv", (Object)CasHelper.getLocalValue((DynamicObject)org, (String)"name"));
        DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
        String v_payerbanknum = EmptyUtil.isEmpty((DynamicObject)payerAcctBank) ? "" : StringUtils.splitString((String)payerAcctBank.getString("bankaccountnumber"), (int)4, (String)" ");
        ((Label)this.getControl("payerbanknumv")).setText(v_payerbanknum);
        DynamicObject payerBank = (DynamicObject)this.getModel().getValue("payerbank");
        String v_payerbankname = "";
        if (payerBank != null) {
            v_payerbankname = CasHelper.getLocalValue((DynamicObject)payerBank, (String)"name");
        }
        ((Label)this.getControl("payerbanknamev")).setText(v_payerbankname);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName = event.getProperty().getName();
        if ("settletype".equals(propName)) {
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and("settlementtype", "=", (Object)SettleMentTypeEnum.DCEP.getValue());
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }
}

