/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.SysParamCs1046Enum;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.PaymentQueryHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.DateUtils;

public class PayBillDiffPayPlugin
extends DynamicFormPlugin {
    private static List<String> props = Arrays.asList("payamt", "agreedrate", "fee");
    private static List<String> notInitPropArr = Collections.singletonList("paydate");
    private static Log logger = LogFactory.getLog(PayBillDiffPayPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.initF7();
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject payBill;
        DynamicObject settletype;
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("payBillId", String.valueOf(customParams.get("payBillId")));
        String payBillId = (String)customParams.get("payBillId");
        if (payBillId != null && (settletype = (payBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill", (String)"id,settletype")).getDynamicObject("settletype")) != null && SettleMentTypeEnum.MONEY.getValue().equals(settletype.getString("settlementtype"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fee"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"singlestream"});
        }
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            Object expectdate;
            String propName = property.getName();
            if (customParams.containsKey(propName) && !notInitPropArr.contains(propName)) {
                this.setValue(propName, customParams.get(propName));
            }
            if (!"paydate".equals(propName) || (expectdate = customParams.get("expectdate")) == null) continue;
            this.setValue(propName, expectdate);
        }
        if (((Boolean)this.getValue("singlestream")).booleanValue()) {
            this.setValue("feepaydate", this.getValue("paydate"));
        }
        this.setFieldEnable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        String propName = e.getProperty().getName();
        if (((Boolean)this.getValue("isdiffcur")).booleanValue() && props.contains(propName)) {
            this.diffPropChange(propName);
        }
        switch (propName) {
            case "feeactbank": {
                this.feeActBankF7Changed(newValue);
                break;
            }
            case "dpexchangerate": {
                this.calDpLocalAmt();
                break;
            }
            case "singlestream": {
                if (newValue == null || !((Boolean)newValue).booleanValue()) break;
                this.setValue("feepaydate", this.getValue("paydate"));
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnok": {
                BigDecimal tuningRate;
                BigDecimal fee = (BigDecimal)this.getModel().getValue("fee");
                if (fee.compareTo(new BigDecimal(0)) < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u7eed\u8d39\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"PayBillDiffPayPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject org = this.getDynamicObject("org");
                long orgId = org.getLong("id");
                String payBillId = this.getPageCache().get("payBillId");
                DynamicObject dbData = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill", (String)"id,expectdate,bizdate,auditdate,fee,totalpayamt,agreedrate,settletype,feepayer");
                Date paydate = (Date)this.getModel().getValue("paydate");
                if (paydate == null) {
                    paydate = this.getConfirmPayDate(orgId, dbData);
                }
                if (paydate != null && DateUtils.getDiffDays((Date)DateUtils.getCurrentDate(), (Date)paydate) > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PayBillDiffPayPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date feepaydate = (Date)this.getModel().getValue("feepaydate");
                if (feepaydate != null && DateUtils.getDiffDays((Date)DateUtils.getCurrentDate(), (Date)feepaydate) > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PayBillDiffPayPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject settletype = dbData.getDynamicObject("settletype");
                String feepayer = dbData.getString("feepayer");
                boolean checkOurAcc = PaymentQueryHelper.isCheckOurAccBySysParam((DynamicObject)org, (DynamicObject)settletype);
                if (!"02".equals(feepayer) && settletype != null && !SettleMentTypeEnum.MONEY.getValue().equals(settletype.getString("settlementtype")) && this.getModel().getValue("feeactbank") == null && checkOurAcc) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u5151\u652f\u4ed8\u6d89\u53ca\u624b\u7eed\u8d39\uff0c\u624b\u7eed\u8d39\u8d26\u6237\u3001\u624b\u7eed\u8d39\u5e01\u79cd\u5b57\u6bb5\u5fc5\u5f55\u3002", (String)"PayBillDiffPayPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set cs1046 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs1046");
                int cs1045 = SystemParameterHelper.getParameterInteger((long)orgId, (String)"cs1045");
                boolean isExceeded = this.checkTuningRate(cs1045, tuningRate = SystemParameterHelper.getTuningRate((long)orgId), cs1046, dbData);
                if (isExceeded) {
                    String rate = tuningRate.stripTrailingZeros().toPlainString();
                    String msg = String.format(ResManager.loadKDString((String)"\u6700\u5927\u53ef\u8c03\u6574%s%%\uff0c\u8d85\u51fa\u7cfb\u7edf\u8bbe\u5b9a\u7684\u5fae\u8c03\u6bd4\u4f8b\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"PayBillDiffPayPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), rate);
                    this.getView().showTipNotification(msg);
                    return;
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    String propName = property.getName();
                    Object value = this.getValue(propName);
                    if (value instanceof DynamicObject) {
                        dataMap.put(propName, ((DynamicObject)value).getPkValue());
                        continue;
                    }
                    if (value instanceof Date) {
                        dataMap.put(propName, DateUtils.formatString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    dataMap.put(propName, value);
                }
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                String matchFlag = (String)customParams.get("matchFlag");
                String sourceBillType = (String)customParams.get("sourcebilltype");
                if (!"0".equalsIgnoreCase(matchFlag) && fee.compareTo(new BigDecimal(0)) > 0 && "bei_intelpay".equalsIgnoreCase(sourceBillType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u636e\u5df2\u5173\u8054\u4e86\u4ea4\u6613\u660e\u7ec6\uff0c\u624b\u7eed\u8d39\u4e0d\u80fd\u4fee\u6539\u3002", (String)"PayBillDiffPayPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                dataMap.put("paySelectLcNo", customParams.get("paySelectLcNo"));
                dataMap.put("cs1046", StringUtils.join((Object[])cs1046.toArray(new String[0]), (String)","));
                this.getView().returnDataToParent(dataMap);
                this.getView().close();
            }
        }
    }

    private void updateActualInfo() {
        BigDecimal payAmt = (BigDecimal)this.getModel().getValue("payamt");
        BigDecimal agreeRate = (BigDecimal)this.getModel().getValue("agreedrate");
        BigDecimal payamount = (BigDecimal)this.getModel().getValue("payamount");
        BigDecimal fee = (BigDecimal)this.getModel().getValue("fee");
        String agreedquotation = (String)this.getModel().getValue("agreedquotation");
        DynamicObject cry = (DynamicObject)this.getModel().getValue("dpcurrency");
        int round = 10;
        if (cry != null) {
            round = cry.getInt("amtprecision");
        }
        DynamicObject org = this.getDynamicObject("org");
        int cs1045 = SystemParameterHelper.getParameterInteger((long)org.getLong("id"), (String)"cs1045");
        switch (cs1045) {
            case 1: {
                if (payAmt == null || agreeRate == null || BigDecimal.ZERO.compareTo(payAmt) == 0 || BigDecimal.ZERO.compareTo(agreeRate) == 0) {
                    return;
                }
                BigDecimal dpAmt = QuotationHelper.callToCurrency((BigDecimal)payamount, (BigDecimal)agreeRate, (String)agreedquotation, (int)round);
                this.getModel().beginInit();
                this.getModel().setValue("dpamt", (Object)dpAmt);
                this.getModel().setValue("fee", (Object)payAmt.add(dpAmt.negate()));
                this.getModel().endInit();
                this.getView().updateView("dpamt");
                this.getView().updateView("fee");
                break;
            }
            case 2: {
                if (agreeRate == null || BigDecimal.ZERO.compareTo(agreeRate) == 0) {
                    return;
                }
                BigDecimal calAmt = QuotationHelper.callToCurrency((BigDecimal)payamount, (BigDecimal)agreeRate, (String)agreedquotation, (int)round);
                this.getModel().beginInit();
                this.getModel().setValue("dpamt", (Object)calAmt);
                this.getModel().setValue("payamt", (Object)calAmt.add(fee));
                this.getModel().endInit();
                this.getView().updateView("dpamt");
                this.getView().updateView("payamt");
                break;
            }
            case 3: {
                BigDecimal calAmt2 = payAmt.subtract(fee);
                BigDecimal agreedRate = BigDecimal.ZERO;
                agreedRate = "0".equals(agreedquotation) ? calAmt2.divide(payamount, 10, RoundingMode.HALF_UP) : payamount.divide(calAmt2, 10, RoundingMode.HALF_UP);
                this.getModel().beginInit();
                this.getModel().setValue("dpamt", (Object)calAmt2);
                this.getModel().setValue("agreedrate", (Object)agreedRate);
                this.getModel().endInit();
                this.getView().updateView("dpamt");
                this.getView().updateView("agreedrate");
            }
        }
        this.calDpLocalAmt();
    }

    private void setFieldEnable() {
        DynamicObject org = this.getDynamicObject("org");
        if (org == null) {
            return;
        }
        Set cs1046 = SystemParameterHelper.getParameterComboxs((long)org.getLong("id"), (String)"cs1046");
        if (!cs1046.contains(SysParamCs1046Enum.DIFF.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_diffinfo"});
        }
        if (!cs1046.contains(SysParamCs1046Enum.FEE.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_feeinfo"});
        }
        if (!cs1046.contains(SysParamCs1046Enum.FOREIGN.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_payinfo"});
        }
        if (!cs1046.contains(SysParamCs1046Enum.PAYDATE.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"paydate"});
        }
        if (((Boolean)this.getValue("isdiffcur")).booleanValue() && cs1046.contains(SysParamCs1046Enum.DIFF.getValue())) {
            int cs1045 = SystemParameterHelper.getParameterInteger((long)org.getLong("id"), (String)"cs1045");
            switch (cs1045) {
                case 1: {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"payamt"});
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"agreedrate"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"fee"});
                    break;
                }
                case 2: {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"payamt"});
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"agreedrate"});
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"fee"});
                    break;
                }
                case 3: {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"payamt"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"agreedrate"});
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"fee"});
                }
            }
        }
    }

    private void feeActBankF7Changed(Object newValue) {
        DynamicObject feeActBank = (DynamicObject)newValue;
        if (feeActBank == null) {
            return;
        }
        DynamicObject feeCurrency = this.getDynamicObject("feecurrency");
        boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"bd_accountbanks", (Object)feeActBank.getPkValue(), (DynamicObject)feeCurrency);
        if (!containCurrency) {
            Long defaultCurrencyId = (Long)feeActBank.get("defaultcurrency.id");
            this.setValue("feecurrency", defaultCurrencyId);
        }
        Boolean isCurrencyEditable = feeActBank.getBoolean("ismulcurrency");
        this.getView().setEnable(isCurrencyEditable, new String[]{"feecurrency"});
    }

    private void initF7() {
        this.fillFeeCurrency();
        this.fillFeeActBank();
    }

    private void fillFeeActBank() {
        BasedataEdit feeActBank = (BasedataEdit)this.getControl("feeactbank");
        feeActBank.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setIsolationOrg(false);
            DynamicObject org = this.getDynamicObject("org");
            if (org == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba", (String)"PayBillCrossPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            long orgID = org.getPkValue() == null ? 0L : Long.parseLong(org.getPkValue().toString());
            QFilter accountAuthAssignFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)orgID);
            ArrayList<QFilter> listQ = new ArrayList<QFilter>(2);
            listQ.add(accountAuthAssignFilter);
            listQ.add(AccountBankHelper.getUsableFilter());
            listQ.add(VisibleVirtualAcctHelper.virtualOrNotAcctQf((Boolean)false));
            showParameter.getListFilterParameter().setQFilters(listQ);
        });
    }

    private void fillFeeCurrency() {
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("feecurrency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject feeActBank = (DynamicObject)this.getModel().getValue("feeactbank");
            if (feeActBank == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u624b\u7eed\u8d39\u8d26\u6237", (String)"PayBillDiffPayPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Set currencys = AccountBankHelper.getCurrencyPks((long)((Long)feeActBank.getPkValue()));
            qFilter = qFilter.and(new QFilter("id", "in", (Object)currencys));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void calDpLocalAmt() {
        BigDecimal dpamt = (BigDecimal)this.getModel().getValue("dpamt");
        BigDecimal dpexchangerate = (BigDecimal)this.getModel().getValue("dpexchangerate");
        String dppayquotation = (String)this.getModel().getValue("dppayquotation");
        DynamicObject cry = (DynamicObject)this.getModel().getValue("basecurrency");
        if (dpamt == null || dpexchangerate == null || BigDecimal.ZERO.compareTo(dpamt) == 0 || BigDecimal.ZERO.compareTo(dpexchangerate) == 0) {
            return;
        }
        int round = 10;
        if (cry != null) {
            round = cry.getInt("amtprecision");
        }
        BigDecimal calAmt = QuotationHelper.callToCurrency((BigDecimal)dpamt, (BigDecimal)dpexchangerate, (String)dppayquotation, (int)round);
        this.getModel().beginInit();
        this.getModel().setValue("dplocalamt", (Object)calAmt);
        this.getModel().endInit();
        this.getView().updateView("dplocalamt");
    }

    private void diffPropChange(String propName) {
        DynamicObject org = this.getDynamicObject("org");
        Set cs1046 = SystemParameterHelper.getParameterComboxs((long)org.getLong("id"), (String)"cs1046");
        if (cs1046.contains(SysParamCs1046Enum.DIFF.getValue())) {
            int cs1045 = SystemParameterHelper.getParameterInteger((long)org.getLong("id"), (String)"cs1045");
            if (cs1045 == 2 && "payamt".equals(propName)) {
                BigDecimal payAmt = (BigDecimal)this.getModel().getValue("payamt");
                BigDecimal fee = (BigDecimal)this.getModel().getValue("fee");
                BigDecimal dpAmt = payAmt.subtract(fee);
                this.getModel().beginInit();
                this.getModel().setValue("dpamt", (Object)dpAmt);
                this.getModel().endInit();
                this.getView().updateView("dpamt");
                this.calDpLocalAmt();
            } else {
                this.updateActualInfo();
            }
        }
    }

    private boolean checkTuningRate(int cs1045, BigDecimal tuningRate, Set<String> cs1046, DynamicObject dbData) {
        boolean newIsZero;
        BigDecimal oldValue = BigDecimal.ZERO;
        BigDecimal newValue = BigDecimal.ZERO;
        switch (cs1045) {
            case 1: {
                oldValue = dbData.getBigDecimal("fee");
                newValue = (BigDecimal)this.getModel().getValue("fee");
                break;
            }
            case 2: {
                oldValue = dbData.getBigDecimal("totalpayamt");
                newValue = (BigDecimal)this.getModel().getValue("payamt");
                break;
            }
            case 3: {
                oldValue = dbData.getBigDecimal("agreedrate");
                newValue = (BigDecimal)this.getModel().getValue("agreedrate");
                break;
            }
        }
        boolean oldIsZero = oldValue.compareTo(BigDecimal.ZERO) == 0;
        boolean bl = newIsZero = newValue.compareTo(BigDecimal.ZERO) == 0;
        if (oldIsZero || newIsZero) {
            return false;
        }
        if (oldValue.compareTo(newValue) == 0) {
            return false;
        }
        if (BigDecimal.ZERO.compareTo(tuningRate) == 0 && oldValue.compareTo(newValue) != 0) {
            return true;
        }
        BigDecimal changRate = newValue.subtract(oldValue).divide(oldValue, 4, 4).multiply(new BigDecimal(100)).abs();
        logger.info("oldValue={},newValue={},changRate={},tuningRate={}", new Object[]{oldValue, newValue, changRate, tuningRate});
        BigDecimal amtChgRate = BigDecimal.ZERO;
        if (cs1046.contains(SysParamCs1046Enum.DIFF.getValue())) {
            boolean isSameAmt;
            BigDecimal dbPayAmt = dbData.getBigDecimal("totalpayamt");
            BigDecimal curPayAmt = (BigDecimal)this.getModel().getValue("payamt");
            boolean dbIsZero = dbPayAmt.compareTo(BigDecimal.ZERO) == 0;
            boolean curIsZero = curPayAmt.compareTo(BigDecimal.ZERO) == 0;
            boolean bl2 = isSameAmt = dbPayAmt.compareTo(curPayAmt) == 0;
            if (!(dbIsZero || curIsZero || isSameAmt)) {
                amtChgRate = curPayAmt.subtract(dbPayAmt).divide(dbPayAmt, 4, 4).multiply(new BigDecimal(100)).abs();
                logger.info("dbPayAmt={},curPayAmt={},amtChgRate={},tuningRate={}", new Object[]{dbPayAmt, curPayAmt, amtChgRate, tuningRate});
            }
        }
        BigDecimal bigDecimal = changRate = changRate.compareTo(amtChgRate) >= 0 ? changRate : amtChgRate;
        return changRate.compareTo(tuningRate) > 0;
    }

    private Date getConfirmPayDate(Long orgId, DynamicObject dbData) {
        Date payDate;
        String selectpaydate;
        switch (selectpaydate = SystemParameterHelper.getParameterString((long)orgId, (String)"selectpaydate")) {
            case "expectdate": {
                payDate = dbData.getDate("expectdate");
                break;
            }
            case "bizdate": {
                payDate = dbData.getDate("bizdate");
                break;
            }
            case "sysdate": {
                payDate = new Date();
                break;
            }
            case "auditdate": {
                payDate = dbData.getDate("auditdate");
                break;
            }
            default: {
                payDate = new Date();
            }
        }
        return payDate;
    }
}

