/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.pay;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.SourceTypeEnum;

public class PayBillSpanEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setPaymentTypeFilter();
    }

    private void setPaymentTypeFilter() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (Objects.nonNull(billType) && Objects.equals(billType.getPkValue(), BillTypeConstants.PAYBILL_SPAN)) {
            BasedataEdit paymentType = (BasedataEdit)this.getControl("paymenttype");
            paymentType.addBeforeF7SelectListener(evt -> {
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter filter = new QFilter("biztype", "=", (Object)PayAndRecBizTypeEnum.SPAN_MAIN_PART.getValue());
                parameter.getListFilterParameter().setFilter(filter);
            });
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (Objects.equals(appId, "fca")) {
            this.getModel().setValue("sourcetype", (Object)SourceTypeEnum.FCA.name());
        }
    }

    public void afterCreateNewData(EventObject e) {
        String appId;
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (Objects.nonNull(billType) && Objects.equals(billType.getPkValue(), BillTypeConstants.PAYBILL_SPAN)) {
            this.getModel().setValue("payeetype", (Object)"bos_org");
        }
        if (Objects.equals(appId = this.getView().getFormShowParameter().getAppId(), "fca")) {
            this.getModel().setValue("sourcetype", (Object)SourceTypeEnum.FCA.name());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryVisible();
    }

    private void setEntryVisible() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        Object sourceBillType = this.getModel().getValue("sourcebilltype");
        if (billType != null && BillTypeConstants.PAYBILL_SPAN.equals(billType.getPkValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            if (Objects.equals(sourceBillType, "cas_transferapply")) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"settletype", "isdiffcur", "flex_payinfo", "flex_recinfo", "actpayamt", "currency", "dpcurrency", "dpamt"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayer", "changepayee"});
            }
        }
    }
}

