/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.payapply.PayApplyEntryEdit;
import kd.fi.cas.formplugin.payapply.PaymentChannelHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyAmountCalcPlugin
extends AbstractFormPlugin {
    private static final String KEY_PAYACCTCLOSEACTION = "KEY_PAYACCTCLOSEACTION";
    private boolean isSkipPropChange = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setPayerAccBankListener();
        this.setPayerCurrencyListener();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isSkipPropChange) {
            this.isSkipPropChange = false;
            return;
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        if ("entry_payeraccbank".equals(fieldKey) && this.isChangeRow(rowIndex)) {
            DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
            DynamicObject settleMentType = (DynamicObject)this.getModel().getValue("entry_settlementtype", rowIndex);
            this.getModel().setValue("entry_paycurrency", null, rowIndex);
            PaymentChannelHelper.initPaymentChannel(rowIndex, null, newValue, this.getView());
            if (EmptyUtil.isEmpty((DynamicObject)settleMentType) || EmptyUtil.isEmpty((DynamicObject)newValue)) {
                this.getModel().setValue("entry_payeraccbank", null, rowIndex);
                this.getModel().setValue("entry_payerbank", null, rowIndex);
                this.getModel().setValue("entry_paymentchannel", null, rowIndex);
                return;
            }
            DynamicObject bank = (DynamicObject)newValue.get("bank");
            String defChannel = PayApplyEntryEdit.getPaymentChannelValue((ComboEdit)this.getControl("entry_paymentchannel"), newValue, this.getModel(), rowIndex);
            this.getModel().setValue("entry_paymentchannel", (Object)defChannel, rowIndex);
            this.getModel().setValue("entry_payerbank", (Object)bank, rowIndex);
            DynamicObject defaultCurrency = newValue.getDynamicObject("defaultcurrency");
            this.setValue("entry_paycurrency", defaultCurrency, rowIndex);
        }
        if ("entry_paycurrency".equals(fieldKey)) {
            this.setDiffPay(rowIndex);
        }
        if ("entry_payeetype".equals(fieldKey) || "entry_payeename".equals(fieldKey)) {
            model.setValue("entry_draftbill", null, rowIndex);
        }
        if ("entry_payeeamount".equals(fieldKey) || "entry_exchangerate".equals(fieldKey) || "entry_quotation".equals(fieldKey)) {
            BigDecimal payeeAmount = (BigDecimal)this.getValue("entry_payeeamount", rowIndex);
            BigDecimal exchangeRate = (BigDecimal)this.getValue("entry_exchangerate", rowIndex);
            DynamicObject payCurrency = this.getDynamicObject("entry_paycurrency", rowIndex);
            String quotation = "0";
            if (this.getValue("entry_quotation", rowIndex) != null) {
                quotation = (String)this.getValue("entry_quotation", rowIndex);
            }
            if (payCurrency != null) {
                this.setValue("entry_payamount", QuotationHelper.callToCurrency((BigDecimal)payeeAmount, (BigDecimal)exchangeRate, (String)quotation, (int)payCurrency.getInt("amtprecision")), rowIndex);
            } else {
                this.setValue("entry_payamount", null, rowIndex);
            }
        }
        if ("entry_payamount".equals(fieldKey)) {
            BigDecimal totalAmt = model.getEntryEntity("cas_payinfo").stream().map(o -> o.getBigDecimal("entry_payamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            this.setValue("payamount", totalAmt);
        }
        if (fieldKey.equals("payeecurrency")) {
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("cas_payinfo");
            for (int i = 0; i < entryList.size(); ++i) {
                this.setDiffPay(i);
            }
        }
    }

    private boolean isChangeRow(int rowIndex) {
        String row = this.getPageCache().get(KEY_PAYACCTCLOSEACTION);
        return !EmptyUtil.isEmpty((String)row) && Integer.parseInt(row) == rowIndex;
    }

    private void setDiffPay(int row) {
        DynamicObject payCurrency = this.getDynamicObject("entry_paycurrency", row);
        DynamicObject payeeCurrency = this.getDynamicObject("payeecurrency");
        Boolean currIsDiffPay = payCurrency != null && payeeCurrency != null && !payCurrency.getPkValue().equals(payeeCurrency.getPkValue());
        Boolean prevIsDiffPay = (Boolean)this.getValue("entry_isdiffcur", row);
        this.setValue("entry_isdiffcur", currIsDiffPay, row);
        if (currIsDiffPay.booleanValue() && !prevIsDiffPay.booleanValue()) {
            DynamicObject payOrg = (DynamicObject)this.getModel().getValue("payorg");
            DynamicObject exrateTable = SystemStatusCtrolHelper.getExrateTable((long)((Long)payOrg.getPkValue()));
            if (this.getValue("entry_exratetable", row) == null) {
                this.isSkipPropChange = true;
                this.setValue("entry_exratetable", exrateTable, row);
                this.isSkipPropChange = false;
            }
            if (this.getValue("entry_exratedate", row) == null) {
                this.isSkipPropChange = true;
                this.setValue("entry_exratedate", new Date(), row);
                this.isSkipPropChange = false;
            }
        } else if (!currIsDiffPay.booleanValue()) {
            this.setValue("entry_exratetable", null, row);
            this.setValue("entry_exratedate", null, row);
        }
    }

    private void setPayerCurrencyListener() {
        BasedataEdit payCurrencyEdit = (BasedataEdit)this.getControl("entry_paycurrency");
        IDataModel model = this.getModel();
        payCurrencyEdit.addBeforeF7SelectListener(evt -> {
            int row = evt.getRow();
            DynamicObject payAcct = (DynamicObject)model.getValue("entry_payeraccbank", row);
            if (EmptyUtil.isEmpty((DynamicObject)payAcct)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u8d26\u53f7", (String)"PayApplyEntryEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection currencyList = payAcct.getDynamicObjectCollection("currency");
            Object[] currencyIdArr = currencyList.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).toArray();
            QFilter qFilter = new QFilter("id", "in", (Object)currencyIdArr);
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            parameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void setPayerAccBankListener() {
        BasedataEdit payerAccBankBillEdit = (BasedataEdit)this.getControl("entry_payeraccbank");
        IDataModel model = this.getModel();
        payerAccBankBillEdit.addBeforeF7SelectListener(evt -> {
            int row = evt.getRow();
            DynamicObject payOrg = (DynamicObject)model.getValue("payorg");
            int index = model.getEntryCurrentRowIndex("cas_payinfo");
            DynamicObject settleMentType = (DynamicObject)model.getValue("entry_settlementtype", index);
            if (EmptyUtil.isEmpty((DynamicObject)payOrg) || EmptyUtil.isEmpty((DynamicObject)settleMentType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ed8\u6b3e\u7ec4\u7ec7\u3001\u7ed3\u7b97\u65b9\u5f0f", (String)"PayApplyEntryEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String settleType = settleMentType.getString("settlementtype");
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("acctstatus", "in", (Object)new String[]{"normal", "freeze", "closing", "changing"});
            if (SettleMentTypeEnum.MONEY.getValue().equals(settleType)) {
                qFilter.and(new QFilter("settlementtype.fbasedataid.settlementtype", "=", (Object)SettleMentTypeEnum.MONEY.getValue()));
            }
            if (SettleMentTypeEnum.VIRTUAL.getValue().equals(settleType)) {
                qFilter.and(new QFilter("isvirtual", "=", (Object)"1"));
            }
            parameter.getListFilterParameter().setFilter(qFilter);
            this.getPageCache().put(KEY_PAYACCTCLOSEACTION, String.valueOf(row));
        });
    }

    public void setValueIfAbsent(String key, Object value) {
        if (CasHelper.isEmpty((Object)this.getModel().getValue(key))) {
            this.setValue(key, value);
        }
    }

    public void setValueIfAbsent(String key, Object value, int index) {
        if (CasHelper.isEmpty((Object)this.getModel().getValue(key, index))) {
            this.setValue(key, value, index);
        }
    }

    public void setValue(String key, Object value) {
        if (value instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)value;
            this.getModel().setValue(key, dy.getPkValue());
        } else {
            this.getModel().setValue(key, value);
        }
    }

    public void setValue(String key, Object value, int rowIndex) {
        if (value instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)value;
            this.getModel().setValue(key, dy.getPkValue(), rowIndex);
        } else {
            this.getModel().setValue(key, value, rowIndex);
        }
    }

    public DynamicObject getDynamicObject(String key) {
        return (DynamicObject)this.getModel().getValue(key);
    }

    public DynamicObject getDynamicObject(String key, int rowIndex) {
        return (DynamicObject)this.getModel().getValue(key, rowIndex);
    }

    public Long getPk(String key) {
        DynamicObject basedata = this.getDynamicObject(key);
        return basedata == null ? null : (Long)basedata.getPkValue();
    }

    public Long getPk(String key, int i) {
        DynamicObject basedata = this.getDynamicObject(key, i);
        return basedata == null ? null : (Long)basedata.getPkValue();
    }

    public BigDecimal getBigDecimal(String key) {
        return (BigDecimal)this.getModel().getValue(key);
    }

    public BigDecimal getBigDecimal(String key, int rowIndex) {
        return (BigDecimal)this.getModel().getValue(key, rowIndex);
    }

    public String getString(String key) {
        return (String)this.getModel().getValue(key);
    }

    public Object getValue(String key) {
        return this.getModel().getValue(key);
    }

    public Object getValue(String key, int rowindex) {
        return this.getModel().getValue(key, rowindex);
    }
}

