/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyElecPaymentEdit
extends BillEditPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        int rowIdx = e.getChangeSet()[0].getRowIndex();
        DynamicObjectCollection payInfoEntry = this.getModel().getEntryEntity("cas_payinfo");
        switch (fieldKey) {
            case "e_payeeaccbank": {
                this.setInstitutionCode("e_payeeaccbank", rowIdx);
                break;
            }
            case "entry_payeraccbank": {
                this.setInstitutionCode("entry_payeraccbank", rowIdx);
                break;
            }
            case "e_institutioncode": {
                if (rowIdx >= payInfoEntry.size()) break;
                this.setValue("entry_recinstitutioncode", newValue, rowIdx);
                break;
            }
            case "e_institutionname": {
                if (rowIdx >= payInfoEntry.size()) break;
                this.setValue("entry_recinstitutionname", newValue, rowIdx);
                break;
            }
            case "paymenttype": {
                DynamicObjectCollection payApplyEntry = this.getModel().getEntryEntity("cas_payapplyentry");
                payApplyEntry.forEach(entry -> entry.set("e_businesstype", null));
                this.getModel().updateEntryCache(payApplyEntry);
                this.getView().updateView("cas_payapplyentry");
                break;
            }
        }
    }

    private void setInstitutionCode(String acctFieldName, int rowIdx) {
        DynamicObject acct = (DynamicObject)this.getModel().getValue(acctFieldName);
        String institutionCode = DcepConverHelper.getInstitUtionCode((DynamicObject)acct);
        String institutionName = DcepConverHelper.getInstitutionName((DynamicObject)acct);
        if (EmptyUtil.isNoEmpty((String)institutionCode)) {
            if ("e_payeeaccbank".equals(acctFieldName)) {
                this.setValue("e_institutioncode", institutionCode, rowIdx);
                this.setValue("e_institutionname", institutionName, rowIdx);
                this.getView().setEnable(Boolean.FALSE, rowIdx, new String[]{"e_institutioncode"});
                DynamicObjectCollection payInfoEntry = this.getModel().getEntryEntity("cas_payinfo");
                if (rowIdx < payInfoEntry.size()) {
                    this.setValue("entry_recinstitutioncode", institutionCode, rowIdx);
                    this.setValue("entry_recinstitutionname", institutionName, rowIdx);
                }
            } else {
                this.setValue("entry_payinstitutioncode", institutionCode, rowIdx);
                this.setValue("entry_payinstitutionname", institutionName, rowIdx);
            }
        } else if ("e_payeeaccbank".equals(acctFieldName)) {
            this.getModel().setValue("e_institutioncode", null, rowIdx);
            this.getModel().setValue("e_institutionname", null, rowIdx);
        } else {
            this.getModel().setValue("entry_payinstitutioncode", null, rowIdx);
            this.getModel().setValue("entry_payinstitutionname", null, rowIdx);
        }
    }
}

