/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.helper.PayApplyHelper;

public class PayApplyReceiptEditPlugin
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(PayApplyReceiptEditPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("cas_payinfo");
        switch (operateKey) {
            case "receipt": {
                this.receipt(dynamicObjectCollection, operationResult);
                break;
            }
            case "receiptentry": {
                this.receiptentry(operationResult);
                break;
            }
        }
    }

    private void receipt(DynamicObjectCollection dynamicObjectCollection, OperationResult operationResult) {
        DynamicObject[] payBills;
        ArrayList<String> payBillno = new ArrayList<String>(5);
        ArrayList<Object> payBillIds = new ArrayList<Object>(5);
        for (DynamicObject obj : dynamicObjectCollection) {
            payBillno.add(obj.getString("entry_paybillno"));
        }
        QFilter qfilter = new QFilter("billno", "in", payBillno);
        for (DynamicObject obj : payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,bankcheckflag,bankcheckflag_tag", (QFilter[])new QFilter[]{qfilter})) {
            payBillIds.add(obj.getPkValue());
        }
        Set isAllSet = HandLinkBillHelper.showBotpRtansDetails((Object[])payBillIds.toArray(), (String)"cas_paybill");
        PayApplyHelper.payApplyReceipt((DynamicObject[])payBills, (Set)isAllSet, (OperationResult)operationResult, (IFormView)this.getView(), (Object[])payBillIds.toArray());
    }

    private void receiptentry(OperationResult operationResult) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("cas_payinfo");
        String payBillno1 = (String)this.getModel().getValue("entry_paybillno", entryCurrentRowIndex);
        List<String> payBillNoList = Arrays.asList(payBillno1.split(","));
        QFilter qfilter1 = new QFilter("billno", "in", payBillNoList);
        DynamicObject[] payBills1 = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,bankcheckflag,bankcheckflag_tag", (QFilter[])new QFilter[]{qfilter1});
        if (payBills1 == null || payBills1.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355\u3002", (String)"ClaimNoticeReceiptEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] payBillIds = Arrays.stream(payBills1).map(o -> o.getPkValue()).toArray();
        Set isAllSet1 = HandLinkBillHelper.showBotpRtansDetails((Object[])payBillIds, (String)"cas_paybill");
        PayApplyHelper.payApplyReceipt((DynamicObject[])payBills1, (Set)isAllSet1, (OperationResult)operationResult, (IFormView)this.getView(), (Object[])payBillIds);
    }
}

