/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.helper.PayApplyHelper;

public class PayApplyReceiptListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(PayApplyReceiptListPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "receipt": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                ArrayList<String> payBillno = new ArrayList<String>();
                for (ListSelectedRow listRow : selectedRows) {
                    Object primaryKeyValue = listRow.getPrimaryKeyValue();
                    DynamicObject[] loadSingle = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"cas_payapplybill");
                    DynamicObjectCollection dynamicObjectCollection = loadSingle.getDynamicObjectCollection("cas_payinfo");
                    for (DynamicObject obj : dynamicObjectCollection) {
                        payBillno.add(obj.getString("entry_paybillno"));
                    }
                }
                QFilter qfilter = new QFilter("billno", "in", payBillno);
                DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,bankcheckflag,bankcheckflag_tag", (QFilter[])new QFilter[]{qfilter});
                ArrayList<Object> payBillIds = new ArrayList<Object>(payBills.length);
                for (DynamicObject obj : payBills) {
                    payBillIds.add(obj.getPkValue());
                }
                if (selectedRows.size() > 0) {
                    logger.info("\u9009\u4e2d\u4ed8\u6b3e\u5355ID:" + payBillIds);
                }
                Set isAllSet = HandLinkBillHelper.showBotpRtansDetails((Object[])payBillIds.toArray(), (String)"cas_paybill");
                logger.info("\u4ea4\u6613\u660e\u7ec6ID:" + isAllSet);
                PayApplyHelper.payApplyReceipt((DynamicObject[])payBills, (Set)isAllSet, (OperationResult)operationResult, (IFormView)this.getView(), (Object[])payBillIds.toArray());
            }
        }
    }
}

