/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.payapply;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.LoggerPrintHelper;

public class PayApplySchePlugin
extends BillEditPlugin {
    private static Log logger = LogFactory.getLog(PayApplySchePlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("batchsche".equals(operateKey) && args.getOperationResult().isSuccess()) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            this.getView().invokeOperation("save");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cas_doscheinfo");
            showParameter.setAppId("cas");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("successPkIds", (Object)successPkIds);
            Object payOrgId = Optional.ofNullable(this.getModel().getValue("payorg")).map(o -> ((DynamicObject)o).getPkValue()).orElseGet(() -> null);
            showParameter.setCustomParam("payOrgId", payOrgId);
            Object payCurrencyId = Optional.ofNullable(this.getModel().getValue("entry_paycurrency")).map(o -> ((DynamicObject)o).getPkValue()).orElseGet(() -> null);
            showParameter.setCustomParam("payCurrencyId", payCurrencyId);
            Object payeeCurrencyId = Optional.ofNullable(this.getModel().getValue("payeecurrency")).map(o -> ((DynamicObject)o).getPkValue()).orElseGet(() -> null);
            showParameter.setCustomParam("payeeCurrencyId", payeeCurrencyId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "DOSCHE_CALLBACK"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if ("canclecomfirmsche".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        } else if ("comfirmsche".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String opKey = this.getView().getPageCache().get("op");
            if ("comfirmscheandpushpay".equals(opKey)) {
                this.getView().invokeOperation("push");
                this.getView().getPageCache().remove("op");
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("DOSCHE_CALLBACK".equals(actionId)) {
            Map params = (Map)closedCallBackEvent.getReturnData();
            if (null == params) {
                return;
            }
            String op = (String)params.get("op");
            this.getView().getPageCache().put("op", op);
            String doScheJSONStr = (String)params.get("doScheInfo");
            List successPkIds = JSON.parseArray((String)((String)params.get("successPkIds")), Long.class);
            logger.info(String.format("\u6392\u6b3e\u4fe1\u606f\u754c\u9762\u4f20\u9012\u7684\u53c2\u6570: \u64cd\u4f5c\u7c7b\u578b = {%s}; \u6392\u6b3e\u4fe1\u606f = {%s}; \u6821\u9a8c\u6210\u529f\u7684ID = {%s}", op, doScheJSONStr, LoggerPrintHelper.printCollectionLogger((Collection)successPkIds)));
            OperateOption option = OperateOption.create();
            option.setVariableValue("doScheInfo", doScheJSONStr);
            option.setVariableValue("isCheck", "0");
            this.getView().invokeOperation("comfirmsche", option);
        }
    }
}

