/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.paybill.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.consts.Constants;
import kd.fi.cas.util.DraftBillUtils;
import kd.fi.cas.util.EmptyUtil;

public class PaymentBillEndorseConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(PaymentBillEndorseConvertPlugin.class);

    protected String getSourceKey() {
        return "draftbill";
    }

    protected String getTargetKey() {
        return "draftbill";
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField(this.getSourceKey());
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map variables = this.getOption().getVariables();
        String autoallocation = (String)variables.get("autoallocation");
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject entry;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
            logger.info("PaymentBillEndorseConvertPlugin is start" + sourceBill.getString("billno"));
            HashMap draftDraftBillnoAndAmountMap = new HashMap(8);
            DynamicObjectCollection sourceFieldRows = sourceBill.getDynamicObjectCollection(this.getSourceKey());
            HashMap<Long, BigDecimal> transAmoutMap = new HashMap<Long, BigDecimal>();
            HashMap<String, String> draftNoAndDyMap = new HashMap<String, String>();
            HashMap<Long, Long> logIdMap = new HashMap<Long, Long>();
            long payOrgId = sourceBill.getDynamicObject("org").getLong("id");
            int payEntryBillSize = 0;
            DynamicObjectCollection entryEntitys = sourceBill.getDynamicObjectCollection("cas_draftinfo");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntitys) && entryEntitys.size() > 0) {
                payEntryBillSize = (int)entryEntitys.stream().filter(draft -> DraftBillUtils.isReceiveBill((String)draft.getDynamicObject("draftbillinfo").getString("rptype"))).filter(x -> payOrgId != x.getDynamicObject("draftbillinfo").getDynamicObject("company").getLong("id")).count();
                for (DynamicObject entryEntity : entryEntitys) {
                    DynamicObject draftbillinfo = entryEntity.getDynamicObject("draftbillinfo");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)draftbillinfo) || !DraftBillUtils.isReceiveBill((String)draftbillinfo.getString("rptype"))) continue;
                    BigDecimal transamount = entryEntity.getBigDecimal("transamount");
                    String draftBillno = draftbillinfo.getString("draftbillno");
                    transAmoutMap.put(draftbillinfo.getLong("id"), transamount);
                    draftNoAndDyMap.put(draftBillno, draftbillinfo.getString("subbillrange"));
                    logIdMap.put(draftbillinfo.getLong("id"), entryEntity.getLong("draftbilllogid"));
                    long draftbillOrgId = draftbillinfo.getDynamicObject("company").getLong("id");
                    if (payOrgId == draftbillOrgId) continue;
                    if (!draftDraftBillnoAndAmountMap.containsKey(draftBillno)) {
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                        list.add(transamount);
                        draftDraftBillnoAndAmountMap.put(draftBillno, list);
                        continue;
                    }
                    ((List)draftDraftBillnoAndAmountMap.get(draftBillno)).add(transamount);
                }
            } else {
                payEntryBillSize = (int)sourceFieldRows.stream().filter(draft -> DraftBillUtils.isReceiveBill((String)draft.getDynamicObject("fbasedataid").getString("rptype"))).filter(x -> payOrgId != x.getDynamicObject("fbasedataid").getDynamicObject("company").getLong("id")).count();
                for (DynamicObject srcFieldRow : sourceFieldRows) {
                    long id = srcFieldRow.getDynamicObject("fbasedataid").getLong("id");
                    DynamicObject fbasedataid = srcFieldRow.getDynamicObject("fbasedataid");
                    if (!DraftBillUtils.isReceiveBill((String)fbasedataid.getString("rptype"))) continue;
                    BigDecimal transamount = fbasedataid.getBigDecimal("amount");
                    String billno = fbasedataid.getString("draftbillno");
                    transAmoutMap.put(id, transamount);
                    draftNoAndDyMap.put(billno, fbasedataid.getString("subbillrange"));
                    long draftbillOrgId = fbasedataid.getDynamicObject("company").getLong("id");
                    if (payOrgId == draftbillOrgId) continue;
                    if (!draftDraftBillnoAndAmountMap.containsKey(billno)) {
                        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
                        arrayList.add(transamount);
                        draftDraftBillnoAndAmountMap.put(billno, arrayList);
                        continue;
                    }
                    ((List)draftDraftBillnoAndAmountMap.get(billno)).add(transamount);
                }
            }
            BigDecimal draftAmt = Constants.ZERO;
            int draftcount = 0;
            for (DynamicObject srcFieldRow : sourceFieldRows) {
                if ("paybill".equals(((DynamicObject)srcFieldRow.get("fbasedataid")).getString("rptype"))) continue;
                entry = targetBill.getDynamicObjectCollection("entrys").addNew();
                BigDecimal amount = (BigDecimal)transAmoutMap.get(((DynamicObject)srcFieldRow.get("fbasedataid")).getLong("id"));
                entry.set(this.getTargetKey(), (Object)((DynamicObject)srcFieldRow.get("fbasedataid")));
                entry.set("billamt", transAmoutMap.get(((DynamicObject)srcFieldRow.get("fbasedataid")).getLong("id")));
                entry.set("oldstatus", ((DynamicObject)srcFieldRow.get("fbasedataid")).get("draftbillstatus"));
                entry.set("billlogid", logIdMap.get(((DynamicObject)srcFieldRow.get("fbasedataid")).getLong("id")));
                draftAmt = draftAmt.add(amount);
                ++draftcount;
            }
            targetBill.set("billtype", (Object)"747565928803545088");
            targetBill.set("amount", (Object)draftAmt);
            targetBill.set("draftcount", (Object)draftcount);
            try {
                DynamicObject modifier;
                DynamicObject creator;
                if ((EmptyUtil.isNoEmpty((String)autoallocation) || "true".equals(autoallocation)) && EmptyUtil.isEmpty((DynamicObject)(creator = targetBill.getDynamicObject("creator")))) {
                    logger.info("creator is null");
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(modifier = sourceBill.getDynamicObject("modifier")))) {
                    logger.info("userId is that:" + modifier.getLong("id"));
                    targetBill.set("creator", (Object)modifier);
                    targetBill.set("modifier", (Object)modifier);
                }
            }
            catch (Exception e1) {
                logger.error("has error get userId", (Throwable)e1);
            }
            targetBill.set("bizfinishdate", (Object)sourceBill.getDate("bizdate"));
            DynamicObject[] draftBills = (DynamicObject[])sourceBill.getDynamicObjectCollection("draftbill").stream().filter(draft -> DraftBillUtils.isReceiveBill((String)draft.getDynamicObject("fbasedataid").getString("rptype"))).map(d -> d.getDynamicObject("fbasedataid")).toArray(DynamicObject[]::new);
            DynamicObject[] receivableBills = null;
            if (this.isSubmitEle(draftBills[0])) {
                List draftBillIdList = Arrays.stream(draftBills).map(d -> d.getString("id")).collect(Collectors.toList());
                logger.info("draftBillIdList is:" + SerializationUtils.toJsonString(draftBillIdList));
                List draftBillIds = Arrays.stream(draftBills).map(d -> d.getString("draftbillno")).collect(Collectors.toList());
                DynamicObject[] draftBillNoFilter = new QFilter("draftbillno", "in", draftBillIds);
                QFilter draftBillStatusFilter = new QFilter("draftbillstatus", "=", (Object)"registered");
                QFilter rptypeFilter = new QFilter("rptype", "=", (Object)"receivebill");
                QFilter qFilter = new QFilter("company", "=", sourceBill.getDynamicObject("org").getPkValue());
                QFilter draftStatusFilter = new QFilter("billstatus", "=", (Object)"C");
                if (null != transAmoutMap && transAmoutMap.size() > 0) {
                    HashSet draftBillAmounts = new HashSet(transAmoutMap.values());
                    QFilter lockAmountFilter = new QFilter("availableamount", "in", draftBillAmounts);
                    receivableBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,billpool,amount,rptype,issplit,subbillrange,billidentitycode,draftbillno,availableamount", (QFilter[])draftBillNoFilter.and(draftBillStatusFilter).and(qFilter).and(rptypeFilter).and(draftStatusFilter).and(lockAmountFilter).toArray());
                } else {
                    receivableBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,billpool,amount,rptype,issplit,subbillrange,billidentitycode,draftbillno,availableamount", (QFilter[])draftBillNoFilter.and(draftBillStatusFilter).and(qFilter).and(rptypeFilter).and(draftStatusFilter).toArray());
                }
            } else {
                logger.info("draftBillIdList is by getGenerateReceivableBills");
                receivableBills = this.getGenerateReceivableBills(draftBills);
            }
            if (null != receivableBills && receivableBills.length > 0) {
                logger.info("receivableBills size:" + receivableBills.length);
                logger.info("receivableBills is:" + SerializationUtils.toJsonString((Object)receivableBills));
                List<DynamicObject> recBillList = Arrays.stream(receivableBills).filter(x -> "receivebill".equals(x.getString("rptype"))).collect(Collectors.toList());
                if (null != recBillList && recBillList.size() > 0) {
                    receivableBills = recBillList.toArray(new DynamicObject[0]);
                }
                logger.info("after receivableBills size:" + receivableBills.length);
                logger.info("after receivableBills is:" + SerializationUtils.toJsonString((Object)receivableBills));
                HashMap billnoAndAmountDbMap = new HashMap(8);
                for (DynamicObject dynamicObject : receivableBills) {
                    BigDecimal amount = dynamicObject.getBigDecimal("availableamount");
                    String draftbillnoStr = dynamicObject.getString("draftbillno");
                    if (!billnoAndAmountDbMap.containsKey(draftbillnoStr)) {
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                        list.add(amount);
                        billnoAndAmountDbMap.put(draftbillnoStr, list);
                        continue;
                    }
                    ((List)billnoAndAmountDbMap.get(draftbillnoStr)).add(amount);
                }
                if (EmptyUtil.isNoEmpty((Object)payEntryBillSize)) {
                    Set draftbillnoSet = billnoAndAmountDbMap.keySet();
                    Set billNosSet = draftDraftBillnoAndAmountMap.keySet();
                    ArrayList bigDecimalList = new ArrayList(8);
                    for (Map.Entry entry2 : billnoAndAmountDbMap.entrySet()) {
                        List value = (List)entry2.getValue();
                        bigDecimalList.addAll(value);
                    }
                    if (draftbillnoSet.size() >= billNosSet.size() && bigDecimalList.size() >= payEntryBillSize) {
                        for (Map.Entry entry2 : draftDraftBillnoAndAmountMap.entrySet()) {
                            String payKey = (String)entry2.getKey();
                            List payValue = (List)entry2.getValue();
                            List amountValueDb = (List)billnoAndAmountDbMap.get(payKey);
                            logger.info("recIds payKey is:" + payKey + ",payValue is:" + SerializationUtils.toJsonString((Object)payValue) + ",amountValueDb is:" + SerializationUtils.toJsonString((Object)amountValueDb));
                            if (!EmptyUtil.isEmpty((Collection)amountValueDb) && amountValueDb.containsAll(payValue)) {
                                if (amountValueDb.stream().filter(payValue::contains).count() >= (long)payValue.size()) continue;
                            }
                            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u5ea6\u80cc\u4e66\u751f\u6210\u7684\u5e94\u6536\u7968\u636e\u4e0d\u8db3\u3002", (String)"PaymentBillEndorseConvertPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
            } else {
                logger.info("receivableBills is null");
            }
            entry = targetBill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entry) || entry.size() == 0) {
                logger.info("after entry is null");
            } else {
                logger.info("after entry size:" + entry.size());
            }
            entry.removeIf(row -> ((Long)sourceBill.getDynamicObject("org").getPkValue()).compareTo((Long)row.getDynamicObject("draftbill").getDynamicObject("company").getPkValue()) != 0);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entry) || entry.size() == 0) {
                logger.info("after remove entry is null");
            } else {
                logger.info("after remove entry size:" + entry.size());
            }
            Set draftBillIdList = entry.stream().map(row -> (Long)row.getDynamicObject("draftbill").getPkValue()).collect(Collectors.toSet());
            if (null != receivableBills) {
                logger.info("after draftBillIdList is:" + SerializationUtils.toJsonString(draftBillIdList));
                for (DynamicObject dynamicObject : receivableBills) {
                    long draftId = dynamicObject.getLong("id");
                    logger.info("after draftId is:" + draftId);
                    if (draftBillIdList.contains(draftId)) continue;
                    String draftbillno = dynamicObject.getString("draftbillno");
                    String paySubbillrange = (String)draftNoAndDyMap.get(draftbillno);
                    String queryBillSubBillRange = dynamicObject.getString("subbillrange");
                    boolean issplit = dynamicObject.getBoolean("issplit");
                    if (this.isEmptySubRange(paySubbillrange) && this.isEmptySubRange(queryBillSubBillRange)) {
                        if (issplit) {
                            logger.info("isEmptySubRange and issplit");
                            continue;
                        }
                    } else {
                        if (!this.isEmptySubRange(paySubbillrange) && this.isEmptySubRange(queryBillSubBillRange)) {
                            logger.info("pay isEmptySubRange and query not isEmptySubRange");
                            continue;
                        }
                        if (this.isEmptySubRange(paySubbillrange) && !this.isEmptySubRange(queryBillSubBillRange)) {
                            logger.info("pay not isEmptySubRange and query isEmptySubRange");
                            continue;
                        }
                        if (!(this.isEmptySubRange(paySubbillrange) || this.isEmptySubRange(queryBillSubBillRange) || paySubbillrange.equals(queryBillSubBillRange))) {
                            if (EmptyUtil.isNoEmpty((String)autoallocation) || "true".equals(autoallocation)) {
                                logger.info("pay not isEmptySubRange and query not isEmptySubRange and not equals but is autoallocation");
                            } else {
                                logger.info("pay not isEmptySubRange and query not isEmptySubRange but not equals");
                                continue;
                            }
                        }
                    }
                    DynamicObject row2 = entry.addNew();
                    row2.set("draftbill", (Object)dynamicObject);
                    row2.set("billamt", (Object)dynamicObject.getBigDecimal("availableamount"));
                }
            }
            BigDecimal amount = targetBill.getDynamicObjectCollection("entrys").stream().map(row -> row.getBigDecimal("billamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            targetBill.set("amount", (Object)amount);
            targetBill.set("draftcount", (Object)targetBill.getDynamicObjectCollection("entrys").size());
            Set draftBillTypeSet = Arrays.stream(draftBills).map(x -> x.getDynamicObject("draftbilltype").getLong("id")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(draftBillTypeSet) && draftBillTypeSet.size() == 1) {
                DynamicObject draftbilltypeDy = draftBills[0].getDynamicObject("draftbilltype");
                targetBill.set("drafttype", (Object)draftbilltypeDy);
            }
            DynamicObjectCollection tradentrys = targetBill.getDynamicObjectCollection("entrys");
            DynamicObject dynamicObject = targetBill.getDynamicObject("drafttype");
            DynamicObject drafttypedata = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"cdm_billtype");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)tradentrys) || tradentrys.size() <= 0) continue;
            for (DynamicObject tradentry : tradentrys) {
                BigDecimal billamt = tradentry.getBigDecimal("billamt");
                BigDecimal billamountavailable = tradentry.getDynamicObject("draftbill").getBigDecimal("amount");
                if (dynamicObject == null || !"2".equals(drafttypedata.getString("billmedium")) || billamt == null || billamountavailable == null || billamt.compareTo(billamountavailable) == 0) continue;
                tradentry.set("isneedsplit", (Object)true);
            }
        }
    }

    private boolean isEmptySubRange(String subRange) {
        return EmptyUtil.isEmpty((String)subRange) || "0".equals(subRange);
    }

    private DynamicObject[] getGenerateReceivableBills(DynamicObject[] draftBills) {
        Object[] receivableBillIds = Arrays.stream(draftBills).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] loadFromDB = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,availableamount,amount", (QFilter[])new QFilter("sourcedraft", "in", (Object)receivableBillIds).toArray());
        if (loadFromDB.length == 0) {
            return draftBills;
        }
        receivableBillIds = Arrays.stream(loadFromDB).map(DataEntityBase::getPkValue).toArray();
        draftBills = BusinessDataServiceHelper.load((Object[])receivableBillIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_draftbillf7"));
        return this.getGenerateReceivableBills(draftBills);
    }

    protected boolean isSubmitEle(DynamicObject draftBill) {
        DynamicObject draftBillType = draftBill.getDynamicObject("draftbilltype");
        draftBillType = BusinessDataServiceHelper.loadSingle((Object)draftBillType.getPkValue(), (String)"cdm_billtype");
        String billMedium = draftBillType.getString("billmedium");
        DynamicObject company = draftBill.getDynamicObject("company");
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        boolean isElectronicBill = this.isElectronicbill(company.getLong("id"));
        return isElectronicBill && Objects.equals(billMedium, "2");
    }

    private boolean isElectronicbill(Long companyId) {
        AppParam param = new AppParam();
        param.setAppId(AppMetadataCache.getAppInfo((String)"cdm").getId());
        param.setOrgId(companyId);
        param.setViewType("08");
        Object value = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"iselectronicbill");
        return value != null && Boolean.parseBoolean(value.toString());
    }
}

