/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.paybill.convert;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCreateTargetEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.formplugin.paybill.convert.Pay2RecConvertPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class Rec2PayConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(Pay2RecConvertPlugin.class);

    public void afterCreateTarget(AfterCreateTargetEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterCreateTarget(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject internal_company;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object id = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcData.get(0));
            DynamicObject payertypeDO = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_recbill", (String)"payertype,payer");
            Long payer = payertypeDO.getLong("payer");
            Object pkValue = null;
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payertypeDO.getString("payertype"))) {
                DynamicObject supplierDO = BusinessDataServiceHelper.loadSingle((Object)payer, (String)AsstActTypeEnum.SUPPLIER.getValue());
                internal_company = supplierDO.getDynamicObject("internal_company");
                if (CasHelper.isEmpty((Object)internal_company)) {
                    return;
                }
                pkValue = internal_company.getPkValue();
            } else if (AsstActTypeEnum.CUSTOMER.getValue().equals(payertypeDO.getString("payertype"))) {
                DynamicObject customerDO = BusinessDataServiceHelper.loadSingle((Object)payer, (String)AsstActTypeEnum.CUSTOMER.getValue());
                internal_company = customerDO.getDynamicObject("internal_company");
                if (CasHelper.isEmpty((Object)internal_company)) {
                    return;
                }
                pkValue = internal_company.getPkValue();
            } else {
                pkValue = payer;
            }
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bos_org");
            targetBill.set("org", (Object)org);
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            String payquotation;
            DynamicObject companyDO;
            long orgId;
            DynamicObject baseCurrency;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object id = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcData.get(0));
            DynamicObject payertypeDO = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_recbill", (String)"payeracctbank,payeracctbanknum,basecurrency");
            DynamicObject payeeAccount = null;
            Long payeracctbank = payertypeDO.getLong("payeracctbank");
            if (payeracctbank != null && payeracctbank != 0L) {
                payeeAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,openorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payeracctbank)});
            }
            if (payeeAccount == null) {
                String payeracctbanknum = payertypeDO.getString("payeracctbanknum");
                QFilter banknumFilter = new QFilter("bankaccountnumber", "=", (Object)payeracctbanknum);
                QFilter acctstatusFilter = new QFilter("acctstatus", "=", (Object)"normal");
                QFilter companyFilter = new QFilter("company", "=", targetBill.getDynamicObject("org").getPkValue());
                payeeAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,openorg", (QFilter[])new QFilter[]{banknumFilter, acctstatusFilter, companyFilter});
            }
            if (payeeAccount != null) {
                targetBill.set("payeracctbank", payeeAccount);
                this.setValueIfAbsent(targetBill, "payerbank", payeeAccount.getDynamicObject("bank"));
                this.setValueIfAbsent(targetBill, "openorg", payeeAccount.getDynamicObject("openorg"));
                this.setSettleorg(targetBill);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(baseCurrency = OrgHelper.getBaseCurrency((long)(orgId = ((Long)(companyDO = targetBill.getDynamicObject("org")).getPkValue()).longValue()))))) {
                targetBill.set("basecurrency", (Object)baseCurrency);
            }
            this.setValueIfAbsent(targetBill, "exratedate", DateUtils.getCurrentDate());
            if (CasHelper.isEmpty((Object)targetBill.getDynamicObject("exratetable"))) {
                Rec2PayConvertPlugin.setDefaultExratetable(targetBill, orgId);
            }
            DynamicObject currency = targetBill.getDynamicObject("currency");
            BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
            if (CasHelper.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ONE) == 0) {
                exchangeRate = BigDecimal.ONE;
                payquotation = "0";
                if (currency != null && baseCurrency != null) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurrencyId, (Long)destCurrencyId, (Long)exrateTable.getLong("id"), (Date)exrateDate);
                            if (exchangeRateMap.get("exchangeRate") != null) {
                                exchangeRate = (BigDecimal)exchangeRateMap.get("exchangeRate");
                            }
                            if (exchangeRateMap.get("quoteType") != null && ((Boolean)exchangeRateMap.get("quoteType")).booleanValue()) {
                                payquotation = "1";
                            }
                        }
                    }
                }
                targetBill.set("exchangerate", (Object)exchangeRate);
                targetBill.set("payquotation", (Object)payquotation);
            } else {
                this.setValueIfAbsent(targetBill, "payquotation", "0");
            }
            payquotation = targetBill.getString("payquotation");
            DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
            int round = 10;
            if (basecurrency != null) {
                round = basecurrency.getInt("amtprecision");
            }
            DynamicObjectCollection entries = (DynamicObjectCollection)targetBill.get("entry");
            BigDecimal sumLocAmt = BigDecimal.ZERO;
            for (DynamicObject entry : entries) {
                BigDecimal discountAmt;
                BigDecimal payAmount = entry.getBigDecimal("e_payableamt");
                if (payAmount != null) {
                    BigDecimal payLocAmt = QuotationHelper.callToCurrency((BigDecimal)payAmount, (BigDecimal)exchangeRate, (String)payquotation, (int)round);
                    entry.set("e_payablelocamt", (Object)payLocAmt);
                }
                if ((discountAmt = entry.getBigDecimal("e_discountamt")) != null) {
                    BigDecimal disLocAmt = QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)payquotation, (int)round);
                    entry.set("e_discountlocamt", (Object)disLocAmt);
                }
                BigDecimal actAmt = entry.getBigDecimal("e_actamt");
                if (payAmount != null && discountAmt != null && CasHelper.isEmpty((Object)actAmt)) {
                    actAmt = payAmount.subtract(discountAmt);
                    entry.set("e_actamt", (Object)actAmt);
                }
                if (CasHelper.isNotEmpty((Object)(actAmt = entry.getBigDecimal("e_actamt")))) {
                    BigDecimal actLocAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)payquotation, (int)round);
                    entry.set("e_localamt", (Object)actLocAmt);
                }
                BigDecimal actLocalAmt = entry.getBigDecimal("e_localamt");
                sumLocAmt = sumLocAmt.add(actLocalAmt);
            }
            targetBill.set("localamt", (Object)sumLocAmt);
        }
    }

    private void setSettleorg(DynamicObject targetBill) {
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        DynamicObject openorg = targetBill.getDynamicObject("openorg");
        for (DynamicObject rowInfo : entry) {
            this.setValueIfAbsent(rowInfo, "settleorg", openorg);
        }
    }

    private void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty((Object)targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }

    private static void setDefaultExratetable(DynamicObject targetBill, Long orgId) {
        DynamicObject exchangeRateTable = null;
        try {
            exchangeRateTable = SystemStatusCtrolHelper.getExrateTable((long)orgId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        targetBill.set("exratetable", (Object)exchangeRateTable);
    }
}

