/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.paybill.convert;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecevieBillRecbookConverter
extends AbstractConvertPlugIn {
    protected String getSourceKey() {
        return "org,payeracctbank,f7_payeracctbank";
    }

    protected String getTargetKey() {
        return "draweraccountname,drawerbank,drawerbankno";
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField(this.getSourceKey());
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            String recount;
            DynamicObject acct;
            DynamicObject bank;
            QFilter filter;
            DynamicObject[] accountBank;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cas_recbill");
            DynamicObject type = sourceBill.getDynamicObject("settletype");
            BigDecimal actrecamt = sourceBill.getBigDecimal("actrecamt");
            targetBill.set("casamount", (Object)actrecamt);
            targetBill.set("supperbillamount", (Object)actrecamt);
            DraftHelper.setSubBillInfo((DynamicObject)targetBill, (BigDecimal)actrecamt);
            String settlementType = type.getString("settlementtype");
            boolean isBussiness = SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType);
            if (isBussiness) {
                String acceptername = targetBill.getString("acceptername");
                if (EmptyUtil.isEmpty((String)acceptername)) {
                    targetBill.set("acceptername", targetBill.get("drawername"));
                }
            } else if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                String accepterbankname;
                DynamicObject drawerbankDy;
                DynamicObject accepterbank;
                DynamicObject accepterbebank = targetBill.getDynamicObject("accepterbebank");
                if (EmptyUtil.isEmpty((DynamicObject)accepterbebank)) {
                    targetBill.set("accepterbebank", targetBill.get("drawerbank"));
                }
                if (EmptyUtil.isEmpty((DynamicObject)(accepterbank = targetBill.getDynamicObject("accepterbank")))) {
                    targetBill.set("accepterbank", targetBill.get("drawerbank"));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(drawerbankDy = (DynamicObject)targetBill.get("drawerbank"))) && EmptyUtil.isEmpty((String)(accepterbankname = targetBill.getString("accepterbankname")))) {
                    targetBill.set("accepterbankname", (Object)drawerbankDy.getString("name"));
                }
            }
            if (!CasHelper.isEmpty((Object)sourceBill.getString("payeracctbanknum")) && null != (accountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber,bank", (QFilter[])new QFilter[]{filter = new QFilter("bankaccountnumber", "=", (Object)sourceBill.getString("payeracctbanknum"))})) && accountBank.length != 0 && null != (bank = (acct = accountBank[0]).getDynamicObject("bank"))) {
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"drawerbankno", (Object)bank.get("union_number"));
                Object beBank = bank.get("bebank");
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"drawerbank", (Object)beBank);
                if (SettleMentTypeEnum.CHECK.getValue().equals(type.get("settlementtype"))) {
                    targetBill.set("drawer", beBank);
                }
                if (!isBussiness) {
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"accepterbankno", (Object)bank.get("union_number"));
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"accepterbankno", (Object)(null != beBank ? ((DynamicObject)beBank).get("name") : ""));
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"accepterbankname", (Object)(null != beBank ? ((DynamicObject)beBank).get("name") : ""));
                }
            }
            if (!CasHelper.isEmpty((Object)sourceBill.get("f7_payerbank"))) {
                DynamicObject drawerbank = sourceBill.getDynamicObject("f7_payerbank");
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"drawerbankno", (Object)drawerbank.get("union_number"));
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"deliveropenbanknum", (Object)drawerbank.get("union_number"));
                if (!isBussiness) {
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"accepterbankno", (Object)drawerbank.get("union_number"));
                } else {
                    targetBill.set("accepterbank", (Object)drawerbank);
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"accepterbankname", (Object)drawerbank.get("name"));
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"accepterbankno", (Object)drawerbank.get("union_number"));
                }
            }
            if (CasHelper.isEmpty((Object)(recount = targetBill.getString("receiveraccount"))) || "0".equals(recount)) {
                QFilter statusFilter;
                QFilter recFilter;
                DynamicObject org = sourceBill.getDynamicObject("org");
                QFilter filter2 = new QFilter("company", "=", org.getPkValue());
                DynamicObject[] accountBank2 = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber,bank,isdefaultrec", (QFilter[])new QFilter[]{filter2, recFilter = new QFilter("isdefaultrec", "=", (Object)true), statusFilter = new QFilter("acctstatus", "=", (Object)"normal")});
                if (null == accountBank2 || accountBank2.length <= 0) continue;
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"receiveraccount", (Object)accountBank2[0].get("bankaccountnumber"));
                targetBill.set("receiverbank", accountBank2[0].get("bank.bebank"));
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"receiverbankno", (Object)accountBank2[0].get("bank.union_number"));
                continue;
            }
            QFilter filter3 = new QFilter("bankaccountnumber", "=", (Object)recount);
            DynamicObject[] accountBank3 = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber,bank", (QFilter[])new QFilter[]{filter3});
            if (null == accountBank3 || accountBank3.length == 0) continue;
            DynamicObject acct2 = accountBank3[0];
            targetBill.set("receiverbank", acct2.get("bank.bebank"));
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)targetBill, (String)"receiverbankno", (Object)acct2.get("bank.union_number"));
        }
    }
}

