/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.rec.matchRecBill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.rec.matchRecBill.ISallOrderMatchRecParams;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.param.SallDetailParams;
import kd.fi.cas.param.SallOrderMatchResult;
import kd.fi.cas.param.SallOrderParams;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;

public class SallOrderMatchRecParamsImpl
implements ISallOrderMatchRecParams {
    private static Log log = LogFactory.getLog(SallOrderMatchRecParamsImpl.class);

    @Override
    public SallOrderMatchResult match(SallOrderParams sallOrderParams) {
        return this.sallOrderMatch(sallOrderParams);
    }

    @Override
    public SallOrderMatchResult canceMatch(SallOrderParams cancelMatchParams) {
        return this.sallCanceMatch(cancelMatchParams);
    }

    @Override
    public SallOrderMatchResult matchValidate(SallOrderParams sallOrderParams) {
        return this.validateData(sallOrderParams);
    }

    private SallOrderMatchResult validateData(SallOrderParams sallOrderParams) {
        SallOrderMatchResult result = new SallOrderMatchResult();
        String operateStr = sallOrderParams.getOperate();
        try {
            ArrayList<String> errorList = new ArrayList<String>();
            HashMap<Long, List<Long>> billAndEntryIdMap = new HashMap<Long, List<Long>>();
            HashSet<Long> keys = new HashSet<Long>();
            List detailParamsList = sallOrderParams.getDetails();
            for (SallDetailParams detailParams : detailParamsList) {
                Long billId = detailParams.getBillId();
                Long billEntryId = detailParams.getBillEntryId();
                if (detailParams.getMatchAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    errorList.add("money is error");
                    detailParams.setStatus("ERROR");
                    if ("matchValidate".equalsIgnoreCase(operateStr)) {
                        detailParams.setErrMsg(ResManager.loadKDString((String)"\u5339\u914d\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0", (String)"SallOrderMatchRecParamsImpl_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    } else if ("cancelMatchValidate".equalsIgnoreCase(operateStr)) {
                        detailParams.setErrMsg(ResManager.loadKDString((String)"\u53d6\u6d88\u5339\u914d\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0", (String)"SallOrderMatchRecParamsImpl_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    }
                }
                if (billAndEntryIdMap.containsKey(billId)) {
                    ((List)billAndEntryIdMap.get(billId)).add(billEntryId);
                    continue;
                }
                ArrayList<Long> billEntryList = new ArrayList<Long>();
                billEntryList.add(billEntryId);
                billAndEntryIdMap.put(billId, billEntryList);
                keys.add(billId);
            }
            List<SallDetailParams> sallDetailParamsList = this.validateBillData(detailParamsList, keys, billAndEntryIdMap, errorList, operateStr);
            result.setDetails(sallDetailParamsList);
            if (errorList.size() > 0) {
                result.setStatus("ERROR");
                result.setErrMsg(ResManager.loadKDString((String)"\u5b58\u5728\u5339\u914d\u5931\u8d25\u6570\u636e", (String)"SallOrderMatchRecParamsImpl_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                result.setStatus("SUCCESS");
                result.setErrMsg("");
            }
        }
        catch (Exception e) {
            log.error("e", (Object)e.getMessage());
            result.setStatus("ERROR");
            result.setErrMsg("SystemException" + e.getMessage());
            result.setDetails(null);
        }
        return result;
    }

    private List<SallDetailParams> validateBillData(List<SallDetailParams> detailParamsList, Set<Long> keys, Map<Long, List<Long>> billAndEntryIdMap, List<String> errorList, String operateStr) {
        DynamicObject[] billEntryDataArr;
        Map<Long, List<SallDetailParams>> billAndDetailBenaMap = detailParamsList.stream().collect(Collectors.groupingBy(e -> e.getBillId()));
        Map<Long, List<SallDetailParams>> billEntryIdAndDetailBenaListMap = detailParamsList.stream().collect(Collectors.groupingBy(e -> e.getBillEntryId()));
        List BillEntryIdList = detailParamsList.stream().map(o -> o.getBillEntryId()).collect(Collectors.toList());
        DynamicObject[] sallDetailObjs = BusinessDataServiceHelper.load((String)"cas_salldetail", (String)"id,matchamt,billentryid", (QFilter[])new QFilter[]{new QFilter("billentryid", "in", BillEntryIdList)});
        Map<Long, List<DynamicObject>> sallDetailListMap = Arrays.stream(sallDetailObjs).collect(Collectors.groupingBy(e -> e.getLong("billentryid")));
        Object[] arr = keys.toArray();
        for (DynamicObject billData : billEntryDataArr = BusinessDataServiceHelper.load((Object[])arr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"))) {
            DynamicObject receivingtype;
            boolean ispartreceivable;
            StringJoiner stringJoiner = new StringJoiner("\uff1b");
            List<Long> billEntryIdList = billAndEntryIdMap.get(billData.getLong("id"));
            String billno = billData.getString("billno");
            DynamicObjectCollection billEntrys = billData.getDynamicObjectCollection("entry");
            for (DynamicObject billEntry : billEntrys) {
                if (!EmptyUtil.isNoEmpty(billEntryIdList) || !billEntryIdList.contains(billEntry.getLong("id"))) continue;
                List<SallDetailParams> sallDetailParams = billEntryIdAndDetailBenaListMap.get(billEntry.getLong("id"));
                StringJoiner stringJoiner1 = new StringJoiner("\uff1b");
                String e_corebillno = billEntry.getString("e_corebillno");
                BigDecimal e_unlockamt = billEntry.getBigDecimal("e_unlockamt");
                String e_corebilltype = billEntry.getString("e_corebilltype");
                BigDecimal e_settledamt = billEntry.getBigDecimal("e_settledamt");
                Boolean e_matchselltag = billEntry.getBoolean("e_matchselltag");
                BigDecimal amt = sallDetailParams.stream().map(SallDetailParams::getMatchAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                int entrySeq = billEntry.getInt("seq");
                if (operateStr.equalsIgnoreCase("matchValidate")) {
                    List<DynamicObject> sallDetailList = sallDetailListMap.get(billEntry.getLong("id"));
                    BigDecimal sallDetailAmt = BigDecimal.ZERO;
                    if (CasHelper.isNotEmpty(sallDetailList)) {
                        sallDetailAmt = sallDetailList.stream().map(o -> o.getBigDecimal("matchamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    if (EmptyUtil.isNoEmpty((String)e_corebillno)) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u6838\u5fc3\u5355\u636e\u53f7\u4e0d\u4e3a\u7a7a", (String)"SallOrderMatchRecParamsImpl_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    }
                    if (EmptyUtil.isNoEmpty((Object)e_matchselltag) && e_matchselltag.booleanValue()) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5df2\u7ecf\u5339\u914d\u4e86\u9500\u552e\u8ba2\u5355\u6216\u8005\u9500\u552e\u5408\u540c", (String)"SallOrderMatchRecParamsImpl_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    }
                    if (BigDecimal.ZERO.compareTo(e_unlockamt) >= 0) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u672a\u9501\u5b9a\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u5df2\u7ecf\u5168\u90e8\u9501\u5b9a", (String)"SallOrderMatchRecParamsImpl_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    }
                    if (e_unlockamt.compareTo(amt) < 0) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u5339\u914d\u91d1\u989d\u8d85\u8fc7\u672a\u9501\u5b9a\u91d1\u989d", (String)"SallOrderMatchRecParamsImpl_4", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    } else if (e_unlockamt.compareTo(sallDetailAmt.add(amt)) < 0) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u5339\u914d\u91d1\u989d\u5df2\u7ecf\u8d85\u989d", (String)"SallOrderMatchRecParamsImpl_12", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    }
                } else if (operateStr.equalsIgnoreCase("cancelMatchValidate")) {
                    if (EmptyUtil.isEmpty((String)e_corebillno)) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u6838\u5fc3\u5355\u636e\u53f7\u4e3a\u7a7a", (String)"SallOrderMatchRecParamsImpl_5", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    }
                    if (!"sm_salorder".equalsIgnoreCase(e_corebilltype) && !"conm_salcontract".equalsIgnoreCase(e_corebilltype)) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e0d\u4e3a\u9500\u552e\u8ba2\u5355\u6216\u8005\u9500\u552e\u5408\u540c", (String)"SallOrderMatchRecParamsImpl_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    }
                    if (EmptyUtil.isEmpty((Object)e_matchselltag) || !e_matchselltag.booleanValue()) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u672a\u5339\u914d\u9500\u552e\u8ba2\u5355\u6216\u8005\u9500\u552e\u5408\u540c", (String)"SallOrderMatchRecParamsImpl_14", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    }
                    if (BigDecimal.ZERO.compareTo(e_settledamt) != 0) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0d\u4e3a0\uff0c\u5df2\u7ecf\u4ea7\u751f\u7ed3\u7b97\u8bb0\u5f55", (String)"SallOrderMatchRecParamsImpl_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    }
                    if (e_unlockamt.compareTo(amt) != 0) {
                        stringJoiner1.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u672a\u9501\u5b9a\u91d1\u989d\u4e0e\u53d6\u6d88\u5339\u914d\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"SallOrderMatchRecParamsImpl_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), entrySeq));
                    }
                }
                this.setErrorMsgAndStatusForDetail(stringJoiner1, sallDetailParams, errorList, entrySeq, billno, true);
            }
            Long billId = billData.getLong("id");
            String billStatus = billData.getString("billstatus");
            if (!"D".equalsIgnoreCase(billStatus)) {
                stringJoiner.add(ResManager.loadKDString((String)"\u8be5\u6536\u6b3e\u5355\u7684\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u6536\u6b3e", (String)"SallOrderMatchRecParamsImpl_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            if (!(ispartreceivable = (receivingtype = billData.getDynamicObject("receivingtype")).getBoolean("ispartreceivable"))) {
                stringJoiner.add(ResManager.loadKDString((String)"\u8be5\u6536\u6b3e\u5355\u7684\u6536\u6b3e\u7c7b\u578b\u4e0d\u53c2\u4e0e\u5e94\u6536\u7ed3\u7b97\u3002", (String)"SallOrderMatchRecParamsImpl_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
            HashSet<String> sameBillEntryIdAndbillId = new HashSet<String>(16);
            for (SallDetailParams sallDetailParams : billAndDetailBenaMap.get(billId)) {
                String idStr = billId + "_" + sallDetailParams.getBillEntryId();
                if (sameBillEntryIdAndbillId.contains(idStr)) continue;
                sameBillEntryIdAndbillId.add(idStr);
                List<SallDetailParams> sallDetailParams1 = billEntryIdAndDetailBenaListMap.get(sallDetailParams.getBillEntryId());
                this.setErrorMsgAndStatusForDetail(stringJoiner, sallDetailParams1, errorList, null, null, false);
            }
        }
        ArrayList<SallDetailParams> list = new ArrayList<SallDetailParams>();
        billEntryIdAndDetailBenaListMap.forEach((key, value) -> list.addAll((Collection<SallDetailParams>)value));
        if (operateStr.equalsIgnoreCase("matchValidate")) {
            ArrayList<DynamicObject> sallDetailList = new ArrayList<DynamicObject>(10);
            for (SallDetailParams sallDetailParams : list) {
                DynamicObject sallDetail = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_salldetail"));
                sallDetail.set("salldetailid", (Object)sallDetailParams.getSallDetailId());
                sallDetail.set("billid", (Object)sallDetailParams.getBillId());
                sallDetail.set("billentryid", (Object)sallDetailParams.getBillEntryId());
                sallDetail.set("sourcebillid", (Object)sallDetailParams.getSourceBillId());
                sallDetail.set("sourcebillentryid", (Object)sallDetailParams.getSourceBillEntryId());
                sallDetail.set("matchamt", (Object)sallDetailParams.getMatchAmt());
                sallDetailList.add(sallDetail);
            }
            if (sallDetailList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])sallDetailList.toArray(new DynamicObject[0]));
            }
        }
        return list;
    }

    private void setErrorMsgAndStatusForDetail(StringJoiner stringJoiner, List<SallDetailParams> sallDetailParamList, List<String> errorList, Integer entryIndex, String billNo, boolean isEntry) {
        for (SallDetailParams sallDetailParams : sallDetailParamList) {
            if (isEntry) {
                sallDetailParams.setBillEntryIndex(entryIndex);
                sallDetailParams.setBillno(billNo);
            }
            String errorMsg = sallDetailParams.getErrMsg();
            StringJoiner stringJoiner2 = new StringJoiner("\uff1b");
            if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                stringJoiner2.add(errorMsg);
            }
            if (EmptyUtil.isNoEmpty((String)stringJoiner.toString())) {
                stringJoiner2.merge(stringJoiner);
            }
            sallDetailParams.setErrMsg(stringJoiner2.toString());
            if (EmptyUtil.isEmpty((String)stringJoiner2.toString())) {
                sallDetailParams.setStatus("SUCCESS");
                continue;
            }
            sallDetailParams.setStatus("ERROR");
            errorList.add(stringJoiner2.toString());
        }
    }

    @Override
    public SallOrderMatchResult canceMatchValidate(SallOrderParams cancelMatchParams) {
        return this.validateData(cancelMatchParams);
    }

    private SallOrderMatchResult sallOrderMatch(SallOrderParams sallOrderParams) {
        SallOrderMatchResult result = new SallOrderMatchResult();
        List detailParamsList = sallOrderParams.getDetails();
        ArrayList<SallDetailParams> detailParamsListNew = new ArrayList<SallDetailParams>(detailParamsList.size());
        ArrayList<DynamicObject> recBillList = new ArrayList<DynamicObject>(10);
        ArrayList<Long> successIdList = new ArrayList(10);
        ArrayList<String> serializeRecList = new ArrayList<String>(10);
        Map<Long, List<SallDetailParams>> billAndDetailBenaMap = detailParamsList.stream().collect(Collectors.groupingBy(e -> e.getBillId()));
        try (TXHandle h = TX.requiresNew();){
            try {
                Iterator<Map.Entry<Long, List<SallDetailParams>>> iterator = billAndDetailBenaMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    log.info("iterator start! ");
                    Map.Entry<Long, List<SallDetailParams>> entry = iterator.next();
                    Long recBillId = entry.getKey();
                    DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)recBillId, (String)"cas_recbill");
                    String serializeRec = SerializeHelper.serializeDynamicObj((Object)recBill);
                    serializeRecList.add(serializeRec);
                    for (SallDetailParams detailParams : entry.getValue()) {
                        log.info("detailParams fill Data start! ");
                        Long recBillEntryId = detailParams.getBillEntryId();
                        BigDecimal money = detailParams.getMatchAmt();
                        String sourceBillType = detailParams.getSourceBillType();
                        Long sourceBillId = detailParams.getSourceBillId();
                        Long sourceBillEntryId = detailParams.getSourceBillEntryId();
                        Long sourceBillEntrySeq = detailParams.getSourceBillEntrySeq();
                        String sourceBillNo = detailParams.getSourceBillNo();
                        if (null != recBill) {
                            String quotation;
                            BigDecimal exchangeRate = recBill.getBigDecimal("exchangerate");
                            if (exchangeRate == null) {
                                exchangeRate = BigDecimal.ONE;
                            }
                            DynamicObject currency = recBill.getDynamicObject("currency");
                            int round = 10;
                            if (currency != null) {
                                round = currency.getInt("amtprecision");
                            }
                            if (null == (quotation = recBill.getString("quotation"))) {
                                quotation = this.quoteType(recBill);
                            }
                            DynamicObjectCollection recBillCol = recBill.getDynamicObjectCollection("entry");
                            DynamicObject recBillEntryNew = null;
                            for (DynamicObject recBillEntry : recBillCol) {
                                if (recBillEntryId.compareTo(recBillEntry.getLong("id")) != 0) continue;
                                detailParams.setStatus("SUCCESS");
                                detailParams.setBillno(recBill.getString("billno"));
                                if (money.compareTo(recBillEntry.getBigDecimal("e_unlockamt")) == 0) {
                                    recBillEntry.set("e_matchselltag", (Object)"1");
                                    recBillEntry.set("e_corebilltype", (Object)sourceBillType);
                                    recBillEntry.set("e_corebillno", (Object)sourceBillNo);
                                    recBillEntry.set("e_corebillid", (Object)sourceBillId);
                                    recBillEntry.set("e_corebillentryid", (Object)sourceBillEntryId);
                                    recBillEntry.set("e_corebillentryseq", (Object)sourceBillEntrySeq);
                                    if ("conm_salcontract".equals(sourceBillType)) {
                                        DynamicObject bosEntityobject = BusinessDataServiceHelper.loadSingle((Object)sourceBillType, (String)"bos_entityobject");
                                        recBillEntry.set("conbillentity", (Object)bosEntityobject);
                                        recBillEntry.set("conbillnumber", (Object)sourceBillNo);
                                        recBillEntry.set("conbillid", (Object)detailParams.getSourceBillId());
                                    }
                                    detailParams.setBillEntryIndex(Integer.valueOf(recBillEntry.getInt("seq")));
                                    detailParams.setNewBillEntryId(Long.valueOf(recBillEntry.getLong("id")));
                                } else {
                                    BigDecimal rceDecimal = recBillEntry.getBigDecimal("e_receivableamt");
                                    BigDecimal erceivableamt = rceDecimal.subtract(money);
                                    recBillEntry.set("e_receivableamt", (Object)erceivableamt);
                                    recBillEntry.set("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)erceivableamt, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                                    BigDecimal disCountAmtRatio = erceivableamt.divide(rceDecimal, 2, 4);
                                    BigDecimal disCountAmtRatioNew = new BigDecimal("1").subtract(disCountAmtRatio);
                                    BigDecimal edisCountAmt = recBillEntry.getBigDecimal("e_discountamt");
                                    recBillEntry.set("e_discountamt", (Object)disCountAmtRatio.multiply(edisCountAmt));
                                    BigDecimal feeAmt = recBillEntry.getBigDecimal("e_fee");
                                    recBillEntry.set("e_fee", (Object)disCountAmtRatio.multiply(feeAmt));
                                    recBillEntry.set("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)disCountAmtRatio.multiply(edisCountAmt), (BigDecimal)exchangeRate, (String)quotation, (int)round));
                                    BigDecimal eactAmt = erceivableamt.subtract(disCountAmtRatio.multiply(feeAmt)).subtract(disCountAmtRatio.multiply(edisCountAmt));
                                    recBillEntry.set("e_actamt", (Object)eactAmt);
                                    recBillEntry.set("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)eactAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                                    recBillEntry.set("e_unlockamt", (Object)recBillEntry.getBigDecimal("e_unlockamt").subtract(money));
                                    BigDecimal eunSettledAmt = recBillEntry.getBigDecimal("e_unsettledamt").subtract(money);
                                    recBillEntry.set("e_unsettledamt", (Object)eunSettledAmt);
                                    recBillEntry.set("e_unsettledlocalamt", (Object)QuotationHelper.callToCurrency((BigDecimal)eunSettledAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                                    recBillEntryNew = SallOrderMatchRecParamsImpl.clone(recBillEntry);
                                    recBillEntryNew.set("e_receivableamt", (Object)money);
                                    recBillEntryNew.set("e_receivablelocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)money, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                                    BigDecimal edisCountAmtNew = disCountAmtRatioNew.multiply(edisCountAmt);
                                    recBillEntryNew.set("e_discountamt", (Object)edisCountAmtNew);
                                    recBillEntryNew.set("e_discountlocamt", (Object)QuotationHelper.callToCurrency((BigDecimal)edisCountAmtNew, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                                    BigDecimal feeAmtNew = disCountAmtRatioNew.multiply(feeAmt);
                                    recBillEntryNew.set("e_fee", (Object)feeAmtNew);
                                    BigDecimal eactAmtNew = money.subtract(feeAmtNew).subtract(edisCountAmtNew);
                                    recBillEntryNew.set("e_actamt", (Object)eactAmtNew);
                                    recBillEntryNew.set("e_localamt", (Object)QuotationHelper.callToCurrency((BigDecimal)eactAmtNew, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                                    recBillEntryNew.set("e_unlockamt", (Object)money);
                                    recBillEntryNew.set("e_lockamt", (Object)BigDecimal.ZERO);
                                    recBillEntryNew.set("e_unsettledamt", (Object)money);
                                    recBillEntryNew.set("e_unsettledlocalamt", (Object)QuotationHelper.callToCurrency((BigDecimal)money, (BigDecimal)exchangeRate, (String)quotation, (int)round));
                                    recBillEntryNew.set("e_settledamt", (Object)BigDecimal.ZERO);
                                    recBillEntryNew.set("e_settledlocalamt", (Object)BigDecimal.ZERO);
                                    recBillEntryNew.set("e_matchselltag", (Object)"1");
                                    recBillEntryNew.set("e_corebilltype", (Object)sourceBillType);
                                    recBillEntryNew.set("e_corebillno", (Object)sourceBillNo);
                                    recBillEntryNew.set("e_corebillid", (Object)sourceBillId);
                                    recBillEntryNew.set("e_corebillentryid", (Object)sourceBillEntryId);
                                    recBillEntryNew.set("e_corebillentryseq", (Object)sourceBillEntrySeq);
                                    if ("conm_salcontract".equals(sourceBillType)) {
                                        DynamicObject bosEntityobject = BusinessDataServiceHelper.loadSingle((Object)sourceBillType, (String)"bos_entityobject");
                                        recBillEntryNew.set("conbillentity", (Object)bosEntityobject);
                                        recBillEntryNew.set("conbillnumber", (Object)sourceBillNo);
                                        recBillEntryNew.set("conbillid", (Object)detailParams.getSourceBillId());
                                    }
                                    Long recBillEntryIdNew = DB.genLongId((String)"T_CAS_ReceivingBillEntry");
                                    recBillEntryNew.set("id", (Object)recBillEntryIdNew);
                                    detailParams.setNewBillEntryId(recBillEntryIdNew);
                                    recBillEntryNew.set("seq", (Object)(recBillCol.size() + 1));
                                    detailParams.setBillEntryIndex(Integer.valueOf(recBillCol.size() + 1));
                                }
                                detailParamsListNew.add(detailParams);
                            }
                            if (null != recBillEntryNew) {
                                recBillCol.add(recBillEntryNew);
                            }
                        }
                        log.info("detailParams fill Data end! ");
                    }
                    recBillList.add(recBill);
                }
                DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])recBillList.toArray(new DynamicObject[0]));
                successIdList = Arrays.stream(save).map(o -> o.getLong("id")).collect(Collectors.toList());
                result.setStatus("SUCCESS");
                result.setDetails(detailParamsListNew);
                SallOrderMatchRecParamsImpl.deleteSallDetail(detailParamsList);
            }
            catch (Exception e2) {
                log.error("e", (Object)e2.getMessage());
                result.setStatus("ERROR");
                result.setErrMsg("SystemException---" + e2.getMessage());
                result.setDetails(null);
                SallOrderMatchRecParamsImpl.deleteSallDetail(detailParamsList);
            }
        }
        SallOrderMatchRecParamsImpl.pushRecBillChange(successIdList, "sallMatch", serializeRecList);
        SallOrderMatchRecParamsImpl.saveSallResult(sallOrderParams, result);
        return result;
    }

    private SallOrderMatchResult sallCanceMatch(SallOrderParams sallOrderParams) {
        SallOrderMatchResult result = new SallOrderMatchResult();
        List detailParamsList = sallOrderParams.getDetails();
        Map<Long, List<SallDetailParams>> billAndDetailBenaMap = detailParamsList.stream().collect(Collectors.groupingBy(e -> e.getBillId()));
        ArrayList<DynamicObject> recBillList = new ArrayList<DynamicObject>(10);
        ArrayList<Long> successIdList = new ArrayList(10);
        ArrayList<String> serializeRecList = new ArrayList<String>(10);
        try (TXHandle h = TX.requiresNew();){
            try {
                for (Map.Entry<Long, List<SallDetailParams>> entry : billAndDetailBenaMap.entrySet()) {
                    Long recBillId = entry.getKey();
                    DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)recBillId, (String)"cas_recbill");
                    String serializeRec = SerializeHelper.serializeDynamicObj((Object)recBill);
                    serializeRecList.add(serializeRec);
                    for (SallDetailParams detailParams : entry.getValue()) {
                        Long recBillEntryId = detailParams.getBillEntryId();
                        if (null == recBill) continue;
                        DynamicObjectCollection recBillCol = recBill.getDynamicObjectCollection("entry");
                        for (DynamicObject recBillEntry : recBillCol) {
                            if (recBillEntryId.compareTo(recBillEntry.getLong("id")) != 0) continue;
                            recBillEntry.set("e_matchselltag", (Object)"0");
                            recBillEntry.set("e_corebilltype", null);
                            recBillEntry.set("e_corebillno", (Object)"");
                            recBillEntry.set("e_corebillid", (Object)"");
                            recBillEntry.set("conbillentity", null);
                            recBillEntry.set("conbillnumber", (Object)"");
                            recBillEntry.set("conbillid", (Object)0);
                            recBillEntry.set("e_corebillentryid", (Object)0);
                            recBillEntry.set("e_corebillentryseq", (Object)0);
                        }
                    }
                    recBillList.add(recBill);
                }
                DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])recBillList.toArray(new DynamicObject[0]));
                successIdList = Arrays.stream(save).map(o -> o.getLong("id")).collect(Collectors.toList());
                result.setStatus("SUCCESS");
                result.setDetails(detailParamsList);
            }
            catch (Exception e2) {
                log.error("e", (Object)e2.getMessage());
                result.setStatus("ERROR");
                result.setErrMsg("SystemException" + e2.getMessage());
                result.setDetails(null);
            }
        }
        SallOrderMatchRecParamsImpl.pushRecBillChange(successIdList, "sallCanceMatch", serializeRecList);
        return result;
    }

    private static DynamicObject clone(DynamicObject info) {
        return (DynamicObject)OrmUtils.clone((Object)info, (IDataEntityType)info.getDataEntityType(), (boolean)true, (boolean)true);
    }

    private static void deleteSallDetail(List<SallDetailParams> detailParamsList) {
        List getSallDetailIdList = detailParamsList.stream().map(o -> o.getSallDetailId()).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)"cas_salldetail", (QFilter[])new QFilter[]{new QFilter("salldetailid", "in", getSallDetailIdList)});
    }

    private static void pushRecBillChange(List<Long> successIdList, String operate, List<String> serializeRecList) {
        if (successIdList.size() > 0) {
            DynamicObject[] recBillObjs;
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cas_recbill");
            for (DynamicObject recBillObj : recBillObjs = BusinessDataServiceHelper.load((Object[])successIdList.toArray(), (DynamicObjectType)type)) {
                SallOrderMatchRecParamsImpl.updateJournal(recBillObj);
            }
        }
        try (TXHandle h = TX.requiresNew((String)"pushRecBillChange");){
            try {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("serializeRecList", JSON.toJSONString(serializeRecList));
                operateOption.setVariableValue("source", "sm");
                operateOption.setVariableValue("operate", operate);
                OperationServiceHelper.executeOperate((String)"pushchgsave", (String)"cas_recbill", (Object[])successIdList.toArray(new Long[0]), (OperateOption)operateOption);
            }
            catch (Exception e) {
                log.error("e", (Object)("SallOrderMatchRecParamsImpl----" + e.getMessage()));
            }
        }
    }

    private static void saveSallResult(SallOrderParams sallOrderParams, SallOrderMatchResult result) {
        DynamicObject sallResultObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_salldetailparams"));
        sallResultObj.set("batchnumber", (Object)sallOrderParams.getBatchNumber());
        sallResultObj.set("message", (Object)CasHelper.subFlag((String)JSON.toJSONString((Object)result)));
        sallResultObj.set("message_tag", (Object)JSON.toJSONString((Object)result));
        sallResultObj.set("successflag", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sallResultObj});
    }

    private static void updateJournal(DynamicObject bill) {
        if (!BillStatusEnum.PAY.getValue().equals(bill.getString("billstatus"))) {
            return;
        }
        DynamicObject[] journals = null;
        QFilter filters = new QFilter("sourcebilltype", "=", (Object)"cas_recbill").and("sourcebillid", "=", bill.getPkValue());
        if (bill.getDynamicObject("accountbank") != null) {
            journals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)String.join((CharSequence)",", EntityPropertyHelper.getEntryPropertys((String)"cas_bankjournal", (String)"")), (QFilter[])new QFilter[]{filters});
        } else if (bill.getDynamicObject("accountcash") != null) {
            journals = BusinessDataServiceHelper.load((String)"cas_cashjournal", (String)"id,settlementtype,settlementnumber,direction,bizdate,bookdate,oppunit,oppacctnumber,oppbank,org,accountbank,entry.e_amount,entry.e_localamount,entry.e_fundflowitem", (QFilter[])new QFilter[]{filters});
        }
        if (journals == null) {
            return;
        }
        for (DynamicObject journal : journals) {
            journal.set("settlementtype", bill.get("settletype"));
            journal.set("settlementnumber", bill.get("settletnumber"));
            journal.set("bizdate", bill.get("bizdate"));
            int CS104 = SystemParameterHelper.getParameterInteger((long)bill.getDynamicObject("org").getLong("id"), (String)"cs104");
            if (1 == CS104) {
                journal.set("bookdate", bill.get("bizdate"));
            }
            journal.set("oppunit", bill.get("payername"));
            journal.set("oppacctnumber", bill.get("payeracctbanknum"));
            DynamicObject payerBank = bill.getDynamicObject("f7_payerbank");
            if (payerBank != null) {
                journal.set("oppbank", (Object)payerBank.getString("name"));
            } else {
                journal.set("oppbank", (Object)bill.getString("payerbankname"));
            }
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            DynamicObjectCollection journalEntrys = journal.getDynamicObjectCollection("entry");
            journalEntrys.clear();
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject journalEntry = journalEntrys.addNew();
                DynamicObject recentryInfo = (DynamicObject)entry.get(i);
                journalEntry.set("e_amount", (Object)recentryInfo.getBigDecimal("e_actamt"));
                journalEntry.set("e_localamount", (Object)recentryInfo.getBigDecimal("e_localamt"));
                journalEntry.set("e_fundflowitem", (Object)recentryInfo.getDynamicObject("e_fundflowitem"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])journals);
        CasBankJournalHelper.updateBillValue((DynamicObject[])journals);
    }

    private String quoteType(DynamicObject recBill) {
        Map exchangeRateByRules;
        DynamicObject currency = recBill.getDynamicObject("currency");
        DynamicObject baseCurrency = recBill.getDynamicObject("basecurrency");
        DynamicObject exRateTable = recBill.getDynamicObject("exratetable");
        Date exRateDate = (Date)recBill.get("exratedate");
        String quoteType = "0";
        if (currency != null && baseCurrency != null && exRateTable != null && exRateDate != null && (exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency.getLong("id"), (Long)baseCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exRateDate)).get("quoteType") != null && ((Boolean)exchangeRateByRules.get("quoteType")).booleanValue()) {
            quoteType = "1";
        }
        return quoteType;
    }
}

