/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recchg;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.RecTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecBillChangeEditPlugin
extends BillEditPlugin {
    private static boolean matchBoolean;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "generatevoucher"});
        this.fillRecType();
        this.setEnable();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("generatevoucher")) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            OperationResult connOperate = OperateServiceHelper.execOperateWithoutThrow((String)"generatevoucher", (String)"cas_recchgbill", (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create());
            if (connOperate.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"RecBillChangeEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(connOperate.getMessage());
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.fillSettleType();
    }

    private void fillRecType() {
        BasedataEdit receivabletypeF7 = (BasedataEdit)this.getControl("receivingtype");
        receivabletypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object sourcebillid = this.getModel().getValue("sourcebillid");
        String sourcebilltype = (String)this.getModel().getValue("sourcebilltype");
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)sourcebilltype);
        matchBoolean = this.isMatchBoolean(recBill);
    }

    public void afterBindData(EventObject e) {
        String billStatus;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"changepayee"});
        Object sourcebillid = this.getModel().getValue("sourcebillid");
        Object sourcebilltype = this.getModel().getValue("sourcebilltype");
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((String)sourcebilltype.toString(), (String)"id,billstatus,org,payer,payername,accountcash,sourcebilltype,entry,entry.e_settledamt,entry.e_matchselltag", (QFilter[])new QFilter[]{new QFilter("id", "=", sourcebillid)});
        int changeType = SystemParameterHelper.getParameterInteger((long)recBill.getDynamicObject("org").getLong("id"), (String)"cs113");
        if (changeType == 2) {
            this.getView().setEnable(Boolean.valueOf("C".equals(recBill.getString("billstatus"))), new String[]{"bizdate"});
        }
        if (CasHelper.isNotEmpty((Object)(billStatus = (String)this.getModel().getValue("billstatus"))) && ("B".equals(billStatus) || "C".equals(billStatus))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnchg", "btn_save"});
        }
        String sourceBillType = recBill.getString("sourcebilltype");
        boolean matchBoolean = this.isMatchBoolean(recBill);
        if (EmptyUtil.isNoEmpty((String)sourceBillType) && "cas_claimcenterbill".equals(sourceBillType) || matchBoolean) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"multireceivingtype"});
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entry");
            for (int i = 0; i < entries.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_receivingtype"});
            }
        }
        if (CasHelper.isNotEmpty((Object)recBill.get("accountcash"))) {
            Object accountcashId = ((DynamicObject)recBill.get("accountcash")).getPkValue();
            String accountcashText = ((DynamicObject)recBill.get("accountcash")).getLocaleString("name").toString();
            this.getModel().setValue("accountcash", accountcashId);
            ((Label)this.getControl("payeebanknumv")).setText(accountcashText);
            this.getPageCache().put("accountcashId", accountcashId.toString());
            this.getPageCache().put("accountcashText", accountcashText);
        }
        this.getModel().setDataChanged(false);
        this.getView().setVisible(Boolean.TRUE, new String[]{"changepayer"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"billno"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"payertype"});
        this.enableSettleNum();
        this.setVisibleBtn();
        this.changeRecType();
        this.setVisableFromPermission();
        this.setEnable();
    }

    private void setVisableFromPermission() {
        long orgId = RequestContext.get().getOrgId();
        boolean hasAudit = PermissionHelper.checkCurrentUserPermission((long)orgId, (String)"cas_recchgbill", (String)"47162f66000000ac");
        boolean hasDelete = PermissionHelper.checkCurrentUserPermission((long)orgId, (String)"cas_recchgbill", (String)"4715e1f1000000ac");
        if (!hasAudit) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_auditnew"});
        }
        if (!hasDelete) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_delnew"});
        }
    }

    private void setEnable() {
        Long sourceBillId = (Long)this.getModel().getValue("sourcebillid");
        DynamicObject dbData = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"));
        String sourceBillType = (String)dbData.get("sourcebilltype");
        DynamicObjectCollection recEntryCol = dbData.getDynamicObjectCollection("entry");
        boolean matchBoolean = false;
        for (DynamicObject recEntry : recEntryCol) {
            BigDecimal amt = recEntry.getBigDecimal("e_settledamt");
            if (amt.compareTo(new BigDecimal("0")) == 0 && !recEntry.getBoolean("e_matchselltag")) continue;
            matchBoolean = true;
            break;
        }
        if (matchBoolean || "cas_claimcenterbill".equals(sourceBillType)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bizdate", "receivingtype", "payertype", "fee"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"changepayer"});
        }
        if (!matchBoolean) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"matchhitinfo"});
        }
        if ("cas_claimcenterbill".equals(sourceBillType)) {
            int iRow = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < iRow; ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"realreccompany", "e_fee", "e_settleorg", "e_material", "e_expenseitem", "e_receivableamt", "e_discountamt", "e_actamt", "project"});
            }
        }
        boolean entryBoolean = true;
        for (DynamicObject recEntry : recEntryCol) {
            BigDecimal amt = recEntry.getBigDecimal("e_settledamt");
            if (amt.compareTo(new BigDecimal("0")) != 0 || recEntry.getBoolean("e_matchselltag")) continue;
            entryBoolean = false;
            break;
        }
        if (entryBoolean) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"addrow", "copyentryrow", "deleterow"});
        }
    }

    private void changeRecType() {
        Object receivingType = this.getModel().getValue("receivingtype");
        if (receivingType != null) {
            ComboEdit payertypeCbo = (ComboEdit)this.getView().getControl("payertype");
            String rectype = this.getValue("biztype").toString();
            boolean multiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject receivingtype = (DynamicObject)receivingType;
            boolean isSelectAllPayerType = false;
            if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
                isSelectAllPayerType = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"selectallpayertype");
            }
            ArrayList<ComboItem> comboItem = new ArrayList<ComboItem>();
            if (rectype.equals(RecTypeEnum.OtherRec.toString())) {
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
                if (multiReceivingType || !receivingtype.getBoolean("ispartreceivable") || receivingtype.getBoolean("ispartreceivable") && isSelectAllPayerType) {
                    comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.OTHER.getName()), AsstActTypeEnum.OTHER.getValue()));
                    comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue()));
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_material"});
            } else {
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()), AsstActTypeEnum.CUSTOMER.getValue()));
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()), AsstActTypeEnum.SUPPLIER.getValue()));
                comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()), AsstActTypeEnum.EMPLOYEE.getValue()));
                if (multiReceivingType || receivingtype.getBoolean("ispartreceivable") && isSelectAllPayerType) {
                    comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.OTHER.getName()), AsstActTypeEnum.OTHER.getValue()));
                    comboItem.add(new ComboItem(new LocaleString(AsstActTypeEnum.COMPANY.getName()), AsstActTypeEnum.COMPANY.getValue()));
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_material"});
            }
            payertypeCbo.setComboItems(comboItem);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryevent = e.getEntryProp();
        IDataModel model = this.getModel();
        if ("entry".equals(entryevent.getName())) {
            int[] idxs;
            for (int idx : idxs = e.getRowIndexs()) {
                DynamicObject recEntry = model.getEntryRowEntity(entryevent.getName(), idx);
                BigDecimal amt = recEntry.getBigDecimal("e_settledamt");
                if (amt.compareTo(new BigDecimal("0")) == 0 && !recEntry.getBoolean("e_matchselltag")) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u7ed3\u7b97\u91d1\u989d\u4e0d\u7b49\u4e8e0\u6216\u5df2\u5339\u914d\u6838\u5fc3\u5355\u636e\u7684\u6570\u636e\u3002", (String)"RecBillChangeEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String opKey = evt.getOperationKey();
        if ("submit".equals(opKey) || "save".equals(opKey)) {
            BigDecimal actrecamtsour;
            BigDecimal actrecamt = (BigDecimal)this.getModel().getValue("actrecamt");
            if (actrecamt.compareTo(actrecamtsour = (BigDecimal)this.getModel().getValue("actrecamtsour")) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u603b\u91d1\u989d\u4e0e\u6536\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"RecBillChangeEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            Object sourcebillid = this.getModel().getValue("sourcebillid");
            String sourcebilltype = (String)this.getModel().getValue("sourcebilltype");
            DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)sourcebilltype);
            if (!matchBoolean && this.isMatchBoolean(recBill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25\u3002\u6536\u6b3e\u5355\u5df2\u7ed3\u7b97/\u5df2\u5339\u914d\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5148\u524d\u5f80\u5e94\u6536\u6a21\u5757\u53cd\u7ed3\u7b97\u6216\u8005\u524d\u5f80\u5408\u540c\u7ba1\u7406/\u9500\u552e\u7ba1\u7406\u53d6\u6d88\u5339\u914d\u518d\u53d1\u8d77\u53d8\u66f4\u3002", (String)"RecBillChangeEditPlugin_01", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null) {
            return;
        }
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if ("submit".equals(opKey) && success) {
            String busKey;
            List allApprovalRecord;
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long pkValue = (Long)dataEntity.getPkValue();
            Long sourcebillid = (Long)this.getModel().getValue("sourcebillid");
            String sourcebilltype = (String)this.getModel().getValue("sourcebilltype");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("cas_recchgbill");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "recchgbill"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("content");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"contentpanelflex"});
            showParameter.setParentPageId(this.getView().getParentView().getFormShowParameter().getPageId());
            showParameter.setParentFormId(this.getView().getParentView().getFormShowParameter().getFormId());
            showParameter.setPkId((Object)pkValue);
            this.getView().showForm((FormShowParameter)showParameter);
            this.getView().close();
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds != null && successPkIds.size() > 0 && ((allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)(busKey = String.valueOf(successPkIds.get(0))))) == null || allApprovalRecord.size() == 0)) {
                WorkflowServiceHelper.tryTriggerProcess((String)busKey, (String)"submit", (String)"cas_recchgbill", null);
            }
            CasBotpHelper.deleteRation((Long)sourcebillid, (Long)pkValue);
            CasBotpHelper.saveRelation((String)sourcebilltype, (Long)sourcebillid, (String)"cas_recchgbill", (Long)pkValue);
        } else if ("unsubmit".equals(opKey) && success) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long pkValue = (Long)dataEntity.getPkValue();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("cas_recbill_change");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("content");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "recchgbill"));
            showParameter.setParentPageId(this.getView().getParentView().getFormShowParameter().getPageId());
            showParameter.setParentFormId(this.getView().getParentView().getFormShowParameter().getFormId());
            showParameter.setPkId((Object)pkValue);
            this.getView().close();
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("save".equals(opKey) && success) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"changepayer"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("recchgbill".equals(actionId)) {
            this.getView().invokeOperation("close");
        }
    }

    private void setVisibleBtn() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"addrow", "copyentryrow", "deleterow", "moveentryup", "moveentrydown"});
    }

    private void enableSettleNum() {
        Object accountbank = this.getModel().getValue("accountbank");
        Object accountcash = this.getModel().getValue("accountcash");
        if (CasHelper.isNotEmpty((Object)accountbank)) {
            Object settlementtype;
            DynamicObject settletype = (DynamicObject)this.getModel().getValue("settletype");
            Object object = settlementtype = CasHelper.isEmpty((Object)settletype) ? null : settletype.get("settlementtype");
            if ("6".equals(settlementtype) || "5".equals(settlementtype) || "1".equals(settlementtype)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"settletnumber"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"settletnumber"});
            }
        } else if (CasHelper.isNotEmpty((Object)accountcash)) {
            String accountcashId = this.getPageCache().get("accountcashId");
            String accountcashText = this.getPageCache().get("accountcashText");
            this.getModel().setValue("accountcash", (Object)accountcashId);
            ((Label)this.getControl("payeebanknumv")).setText(accountcashText);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        switch (propName) {
            case "settletype": {
                this.enableSettleNum();
                break;
            }
            case "receivingtype": {
                this.changeRecType();
                break;
            }
        }
    }

    private void fillSettleType() {
        BasedataEdit settleTypeF7 = (BasedataEdit)this.getControl("settletype");
        settleTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object accountbank = this.getModel().getValue("accountbank");
            QFilter qFilter = new QFilter("settlementtype", CasHelper.isNotEmpty((Object)accountbank) ? "!=" : "=", (Object)"0");
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private boolean isMatchBoolean(DynamicObject recBill) {
        DynamicObjectCollection recEntryCol = recBill.getDynamicObjectCollection("entry");
        boolean matchBoolean = false;
        for (DynamicObject recEntry : recEntryCol) {
            BigDecimal amt = recEntry.getBigDecimal("e_settledamt");
            if (amt.compareTo(new BigDecimal("0")) == 0 && !recEntry.getBoolean("e_matchselltag")) continue;
            matchBoolean = true;
            break;
        }
        return matchBoolean;
    }
}

