/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.claimappeal;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.util.EmptyUtil;

public class ClaimAppealEditPlugin
extends BillEditPlugin
implements HyperLinkClickListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String claimbill = (String)this.getModel().getValue("billno");
        DynamicObject claimPerson = (DynamicObject)this.getModel().getValue("creator");
        String claimtype = (String)this.getModel().getValue("claimtype");
        DynamicObjectCollection entryentity = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        BigDecimal fee = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryentity)) {
            entryentity.stream().forEach(dy -> {
                dy.set("e_claimbill", (Object)claimbill);
                dy.set("e_claimperson", (Object)claimPerson);
                dy.set("e_claimtype", (Object)claimtype);
            });
            fee = entryentity.stream().map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        this.getModel().setValue("fee", (Object)fee);
        String payment = (String)this.getModel().getValue("paymenttype");
        if (EmptyUtil.isNotEmpty((String)payment) && !StringUtils.equals((CharSequence)payment, (CharSequence)"other")) {
            this.getModel().setValue("paymentbasetype", (Object)payment);
            this.getModel().setValue("recbasepayer", this.getModel().getValue("recpayer"));
            Object recbasepayerDy = this.getModel().getValue("recbasepayer");
            if (EmptyUtil.isEmpty((Object)recbasepayerDy)) {
                this.getModel().setValue("recviewpayer", null);
            } else {
                this.getModel().setValue("recviewpayer", (Object)((DynamicObject)recbasepayerDy).getString("name"));
            }
        } else {
            this.getModel().setValue("recviewpayer", this.getModel().getValue("recpayer"));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"recviewpayer"});
        if (StringUtils.equals((CharSequence)claimtype, (CharSequence)ClaimTypeEnum.CHANGE.getValue())) {
            HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u8ba4\u9886\u53d8\u66f4\u4fe1\u606f", (String)"ClaimAppealEditPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            this.getView().updateControlMetadata("contentpanelflex", props);
            props = new HashMap(1);
            props.put("text", new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u660e\u7ec6", (String)"ClaimAppealEditPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            this.getView().updateControlMetadata("advconap", props);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control entryentity = this.getView().getControl("entryentity");
        EntryGrid entry = (EntryGrid)entryentity;
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String key = evt.getFieldName();
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"e_claimbill")) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            String e_claimbill = entryRowEntity.getString("e_claimbill");
            QFilter billno = new QFilter("billno", "=", (Object)e_claimbill);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{billno});
            if (ids.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba4\u9886\u5355\u6570\u636e\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ClaimNoticeEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("cas_claimbill");
            showParameter.setPkId(ids[0].getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("onlyView", (Object)"yes");
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"e_corebillno")) {
            RecClaimHelper.openCoreBillNo((IFormView)this.getView(), (int)rowIndex);
        }
    }
}

