/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.claimhandle;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.AmountColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.formplugin.recclaim.CommonOperationHandler;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.result.InvokeResult;
import kd.fi.cas.util.EmptyUtil;

public class ClaimHandleListPlugin
extends AbstractListPlugin {
    private Map<String, BigDecimal> claimedMap = new HashMap<String, BigDecimal>();
    private Map<String, BigDecimal> unclaimMap = new HashMap<String, BigDecimal>();

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        for (QFilter filter : qFilters) {
            Object value = filter.getValue();
            if (!"1".equals(filter.getProperty()) || !CasHelper.isNotEmpty((Object)value)) continue;
            String replaceStr = String.valueOf(value).replace(",rejectreason", "");
            String dealStr = replaceStr.replace("%", "");
            filter.__setValue((Object)dealStr);
            String[] split = String.valueOf(value).split("#");
            String mount = split[1];
            if (mount.contains(".") && mount.endsWith("0")) {
                while (mount.endsWith("0")) {
                    mount = mount.substring(0, mount.length() - 1);
                }
                if (mount.endsWith(".")) {
                    mount = mount.substring(0, mount.length() - 1);
                }
            }
            if (!CasHelper.isNum((String)mount)) continue;
            filter.or(new QFilter("claimamount", "=", (Object)new BigDecimal(mount)));
        }
        Object hasright = this.getView().getFormShowParameter().getCustomParam("hasright");
        if (hasright == null || !"yes".equals(hasright)) {
            QFilter qFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
            qFilter.or(new QFilter("auditor", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
            e.getQFilters().add(qFilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                HashSet<String> claimNos = new HashSet<String>(rows.size());
                HashSet claimIds = new HashSet(rows.size());
                rows.forEach(row -> claimIds.add(row.getLong("id")));
                DataSet casClaimbillDs = QueryServiceHelper.queryDataSet((String)"listDataQuery", (String)"cas_claimbill", (String)"claimno", (QFilter[])new QFilter[]{new QFilter("id", "in", claimIds)}, (String)"");
                while (casClaimbillDs.hasNext()) {
                    claimNos.add(casClaimbillDs.next().getString("claimno"));
                }
                QFilter claimNoQ = new QFilter("billno", "in", claimNos);
                DataSet claimDs = QueryServiceHelper.queryDataSet((String)"listDataQueryCenter", (String)"cas_claimcenterbill", (String)"billno,claimedamount,unclaimamount", (QFilter[])new QFilter[]{claimNoQ}, (String)"");
                while (claimDs.hasNext()) {
                    Row row2 = claimDs.next();
                    ClaimHandleListPlugin.this.claimedMap.put(row2.getString("billno"), row2.getBigDecimal("claimedamount"));
                    ClaimHandleListPlugin.this.unclaimMap.put(row2.getString("billno"), row2.getBigDecimal("unclaimamount"));
                }
                return rows;
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject claimBill = e.getRowData();
        AbstractColumnDesc column = (AbstractColumnDesc)e.getSource();
        String columnName = column.getFieldKey();
        if ("claimedamount".equalsIgnoreCase(columnName)) {
            AmountColumnDesc amountColumnDesc = (AmountColumnDesc)column;
            BigDecimal amount = this.claimedMap.get(claimBill.get("claimno"));
            if (EmptyUtil.isEmpty((BigDecimal)amount)) {
                amount = BigDecimal.ZERO;
            }
            Object amountFmt = amountColumnDesc.formatCell(claimBill, (Object)amount);
            Object[] formatValue = new Object[]{amountFmt, amountFmt};
            e.setFormatValue((Object)formatValue);
        } else if ("unclaimamount".equalsIgnoreCase(columnName)) {
            AmountColumnDesc amountColumnDesc = (AmountColumnDesc)column;
            BigDecimal amount = this.unclaimMap.get(claimBill.get("claimno"));
            if (EmptyUtil.isEmpty((BigDecimal)amount)) {
                amount = BigDecimal.ZERO;
            }
            Object amountFmt = amountColumnDesc.formatCell(claimBill, (Object)amount);
            Object[] formatValue = new Object[]{amountFmt, amountFmt};
            e.setFormatValue((Object)formatValue);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        Object[] selectPks = listSelectedData.getPrimaryKeyValues();
        if ((StringUtils.equals((CharSequence)operateKey, (CharSequence)"change") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"adjust")) && selectPks.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ClaimHandleListPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"change")) {
            InvokeResult ret = CommonOperationHandler.beforeChangeClaimBill(selectPks[0]);
            if (!ret.isSuccess()) {
                if (ret.get("recentDateId") != null) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("cas_claimbill");
                    showParameter.setPkId(ret.get("recentDateId"));
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setCustomParam("showTips", (Object)ret.getMsg());
                    this.getView().showForm((FormShowParameter)showParameter);
                } else {
                    this.getView().showTipNotification(ret.getMsg());
                }
                args.setCancel(true);
            } else {
                boolean flag = ret.isSettleAmtIsZero();
                if (!flag) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("cas_unsettleconfirm");
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setCustomParam("unSetBillSet", (Object)ret.getUnSetBillSet());
                    showParameter.setCustomParam("operation", (Object)"change");
                    this.getView().showForm(showParameter);
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || operationResult.isSuccess()) {
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"mydelete")) {
                this.getView().invokeOperation("delete");
            }
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"mydelete") || StringUtils.equals((CharSequence)"unsubmit", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"unsubmitaudit", (CharSequence)operateKey)) {
                ((ListView)this.getView()).refresh();
            }
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"claimannounce")) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setPageId(operateKey + operateKey);
                showParameter.setBillFormId("cas_claimannounce");
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setCustomParam("showConer", (Object)true);
    }
}

