/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.claimnotice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BusinessTypeEnum;
import kd.fi.cas.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.enums.ClaimPaymentTypeEnum;
import kd.fi.cas.enums.RecBizTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CoreBillSettingHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.ViewInputHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;

public class BatchClaimEditPlugin
extends BillEditPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"corebillno"});
        this.addClickListeners(new String[]{"corebillnoinput"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Boolean isBatchEdit = (Boolean)showParameter.getCustomParam("isbatchedit");
        if (!isBatchEdit.booleanValue()) {
            Object payerbasetype;
            String paymenttype;
            Object recpaytype = showParameter.getCustomParam("recpaytype");
            if (CasHelper.isNotEmpty((Object)recpaytype)) {
                this.getModel().setValue("recpaytype", recpaytype);
            }
            if (CasHelper.isNotEmpty((Object)(paymenttype = (String)showParameter.getCustomParam("paymenttype")))) {
                this.getModel().setValue("paymenttype", (Object)paymenttype);
                this.getModel().setValue("payerbasetype", (Object)paymenttype);
            }
            if (CasHelper.isNotEmpty((Object)(payerbasetype = showParameter.getCustomParam("payerbasetype")))) {
                this.getModel().setValue("payerbasetype", payerbasetype);
            }
            Object accountbank = showParameter.getCustomParam("accountbank");
            this.getModel().setValue("accountbank", accountbank);
            Object orgObj = showParameter.getCustomParam("org");
            this.getModel().setValue("org", orgObj);
            Object settleOrgObj = showParameter.getCustomParam("settleorg");
            this.getModel().setValue("settleorg", settleOrgObj);
            Object oppbanknumber = showParameter.getCustomParam("oppbanknumber");
            this.getModel().setValue("oppbanknumber", oppbanknumber);
            Object payer = showParameter.getCustomParam("payer");
            this.getModel().setValue("payer", payer);
            Object recpayer = showParameter.getCustomParam("recpayer");
            if (CasHelper.isNotEmpty((Object)paymenttype) && !"other".equals(paymenttype)) {
                this.getModel().setValue("payerid", recpayer);
            }
            Object corebilltype = showParameter.getCustomParam("corebilltype");
            this.getModel().setValue("corebilltype", corebilltype);
            Object corebillno = showParameter.getCustomParam("corebillno");
            this.getModel().setValue("corebillno", corebillno);
            this.getModel().setValue("corebillnoinput", corebillno);
        } else {
            Object settleOrgObj = showParameter.getCustomParam("settleorg");
            this.getModel().setValue("settleorg", settleOrgObj);
            Object orgObj = showParameter.getCustomParam("org");
            this.getModel().setValue("org", orgObj == null ? settleOrgObj : orgObj);
            JSONArray accountSet = (JSONArray)this.getView().getFormShowParameter().getCustomParam("accountbank");
            if (accountSet != null && accountSet.size() > 0) {
                this.getModel().setValue("accountbank", accountSet.get(0));
            }
        }
        String businessType = (String)showParameter.getCustomParam("businesstype");
        this.getModel().setValue("businesstype", (Object)businessType);
        Object currencyId = ((JSONObject)showParameter.getCustomParam("currency")).get((Object)"id");
        this.getModel().setValue("currency", currencyId);
        boolean claimTag = (Boolean)showParameter.getCustomParam("claimtag");
        this.setEnable(claimTag);
        ComboEdit payerTypeField = (ComboEdit)this.getControl("paymenttype");
        this.setTypeVisible(this.getDynamicObject("recpaytype"), payerTypeField, "ispartreceivable", Boolean.TRUE);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.initF7();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            this.returnDataToParent();
        } else if (StringUtils.equals((CharSequence)"corebillno", (CharSequence)key) || StringUtils.equals((CharSequence)"corebillnoinput", (CharSequence)key)) {
            Boolean isBatchEdit;
            String corebilltype = (String)this.getModel().getValue("corebilltype");
            if (StringUtils.isEmpty((CharSequence)corebilltype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"ClaimHandleEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject recPayType = (DynamicObject)this.getModel().getValue("recpaytype");
            boolean isPartReceivable = false;
            if (recPayType != null) {
                isPartReceivable = recPayType.getBoolean("ispartreceivable");
            }
            if (Boolean.TRUE.equals(isBatchEdit = (Boolean)this.getView().getFormShowParameter().getCustomParam("isbatchedit"))) {
                JSONArray accountSet = (JSONArray)this.getView().getFormShowParameter().getCustomParam("accountbank");
                JSONArray oppAccountSet = (JSONArray)this.getView().getFormShowParameter().getCustomParam("oppbanknumber");
                if ((accountSet.size() != 1 || oppAccountSet.size() != 1) && StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.PAYBILL.getValue()) && !isPartReceivable) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u9009\u6279\u91cf\u7f16\u8f91\u6570\u636e\u7684\u94f6\u884c\u8d26\u53f7\u6216\u5bf9\u65b9\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClaimHandleEditPlugin_22", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else {
                    this.showCoreBillF7();
                }
            } else {
                this.showCoreBillF7();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        switch (propName) {
            case "recpaytype": {
                if (CasHelper.isNotEmpty((Object)newValue) && newValue.equals(oldValue)) {
                    return;
                }
                if (CasHelper.isEmpty((Object)newValue)) {
                    this.getModel().setValue("paymenttype", (Object)"");
                    this.getModel().setValue("corebilltype", null);
                    this.getModel().setValue("corebillno", null);
                    this.getModel().setValue("corebillnoinput", null);
                    return;
                }
                this.getModel().setValue("corebilltype", null);
                this.getModel().setValue("corebillno", null);
                this.getModel().setValue("corebillnoinput", null);
                ComboEdit payerTypeField = (ComboEdit)this.getControl("paymenttype");
                this.setTypeVisible(newValue, payerTypeField, "ispartreceivable", Boolean.FALSE);
                break;
            }
            case "paymenttype": {
                if (CasHelper.isNotEmpty((Object)newValue) && newValue.equals(oldValue)) {
                    return;
                }
                if (CasHelper.isNotEmpty((Object)newValue) && "other".equals(newValue)) {
                    this.getModel().setValue("payerbasetype", (Object)"");
                    this.getModel().setValue("payerid", (Object)"");
                    this.getModel().setValue("payer", (Object)"");
                    break;
                }
                this.getModel().setValue("payerid", (Object)"");
                this.getModel().setValue("payer", (Object)"");
                this.getModel().setValue("payerbasetype", newValue);
                break;
            }
            case "corebilltype": {
                if (CasHelper.isNotEmpty((Object)newValue) && newValue.equals(oldValue)) {
                    return;
                }
                this.getModel().setValue("corebillno", null);
                this.getModel().setValue("corebillnoinput", null);
                if ("ar_finarbill".equals(newValue)) {
                    DynamicObject[] claimControls = BusinessDataServiceHelper.load((String)"cas_claimcontrol", (String)"id,entry.claimdimension,entry.claimcomtrol", (QFilter[])new QFilter[0]);
                    if (CasHelper.isNotEmpty((Object)claimControls) && claimControls.length > 0) {
                        DynamicObject claimControl = claimControls[0];
                        if (claimControl.getDynamicObjectCollection("entry").size() <= 0) break;
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"corebillno", "corebillnoinput"});
                        break;
                    }
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"corebillno", "corebillnoinput"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"corebillno", "corebillnoinput"});
                break;
            }
            case "payerid": {
                Object payerid = this.getModel().getValue("payerid");
                if (payerid != null) {
                    this.getModel().setValue("payer", ((DynamicObject)payerid).getPkValue());
                    break;
                }
                this.getModel().setValue("payer", (Object)"");
                break;
            }
            case "corebillno": {
                Object newValueObj = e.getChangeSet()[0].getNewValue();
                if (!EmptyUtil.isNoEmpty((Object)newValueObj)) break;
                ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"corebillid", null);
                Object coreBillTypeObj = this.getModel().getValue("corebilltype");
                if (EmptyUtil.isNoEmpty((Object)coreBillTypeObj)) {
                    Object[] coreBillColl;
                    List coreBillSettings;
                    DynamicObject coreBillSetting;
                    String coreBillType = (String)coreBillTypeObj;
                    DynamicObject recPayType = (DynamicObject)this.getModel().getValue("recpaytype");
                    boolean isPartReceivable = false;
                    if (recPayType != null) {
                        isPartReceivable = recPayType.getBoolean("ispartreceivable");
                    }
                    if (CasHelper.isNotEmpty((Object)(coreBillSetting = CoreBillSettingHelper.filterCoreBillSetting((List)(coreBillSettings = CoreBillSettingHelper.loadCoreBillSetting((String)"cas_claimbill", (boolean)false, (boolean)isPartReceivable)), (String)coreBillType)))) {
                        boolean isHandInput = coreBillSetting.getBoolean("handinput");
                        if (!isHandInput) break;
                        DynamicObject settleorg = (DynamicObject)this.getModel().getValue("settleorg");
                        if (EmptyUtil.isEmpty((DynamicObject)settleorg)) {
                            this.getModel().setValue("corebillno", null);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ed3\u7b97\u7ec4\u7ec7", (String)"ClaimHandleEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        Map showParams = CoreBillSettingHelper.dealShowF7CustomParams((DynamicObject)coreBillSetting, (IDataModel)this.getModel(), (boolean)true);
                        showParams.put("billno", newValueObj);
                        showParams.put("entitynumber", coreBillType);
                        showParams.put("IS_BATCH_OP", "true");
                        CoreBillSettingHelper.setCoreBillInfo((DynamicObject)coreBillSetting, (Map)showParams, (IFormView)this.getView(), (int)-1, (boolean)true);
                        break;
                    }
                    if (!EmptyUtil.isNoEmpty((String)ClaimCoreBillTypeEnum.getName((String)coreBillType))) break;
                    String corebillno = (String)newValueObj;
                    QFilter filter = new QFilter("billno", "=", (Object)corebillno);
                    ArrayList<QFilter> coreBillFilters = new ArrayList<QFilter>(2);
                    coreBillFilters.add(filter);
                    Object currencyId = ((JSONObject)this.getView().getFormShowParameter().getCustomParam("currency")).get((Object)"id");
                    String businessType = (String)this.getModel().getValue("businesstype");
                    DynamicObject settleorg = (DynamicObject)this.getModel().getValue("settleorg");
                    if (Arrays.asList(BusinessTypeEnum.REC.getValue(), BusinessTypeEnum.RECTICKET.getValue(), BusinessTypeEnum.REC.getName(), BusinessTypeEnum.RECTICKET.getName()).contains(businessType) && isPartReceivable && StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.PAYBILL.getValue())) {
                        coreBillFilters.addAll(this.getRecTypePayBillFilter(currencyId, settleorg));
                    }
                    if (!EmptyUtil.isEmpty((Object[])(coreBillColl = BusinessDataServiceHelper.load((String)coreBillType, (String)"id", (QFilter[])coreBillFilters.toArray(new QFilter[0]))))) break;
                    this.getModel().setValue("corebillno", null);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\u6b64\u6838\u5fc3\u5355\u636e\u7f16\u53f7", (String)"ClaimHandleEditPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().setValue("corebillno", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"ClaimHandleEditPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        if (("corebillno".equals(e.getActionId()) || "corebillnoinput".equals(e.getActionId())) && !CasHelper.isEmpty((Object)(returnData = e.getReturnData()))) {
            IDataModel model = this.getModel();
            String coreBillType = (String)model.getValue("corebilltype");
            String coreBillSettingStr = this.getPageCache().get("CORE_BILL_SETTING");
            DynamicObject coreBillSetting = null;
            if (CasHelper.isNotEmpty((Object)coreBillSettingStr)) {
                coreBillSetting = SerializeHelper.deserializeDynamicObj((String)"cas_corebill_setting", (String)coreBillSettingStr);
            }
            if (coreBillSetting != null) {
                List coreBillCollection = (List)returnData;
                for (Map selectedRow : coreBillCollection) {
                    if (selectedRow.containsKey("corebillno")) {
                        model.setValue("corebillnoinput", selectedRow.get("corebillno"));
                    }
                    CoreBillSettingHelper.setClosedCallBackInfo((Map)selectedRow, (DynamicObject)coreBillSetting, (IFormView)this.getView(), (IDataModel)model, (int)-1);
                }
            } else {
                if (EmptyUtil.isEmpty((String)ClaimCoreBillTypeEnum.getName((String)coreBillType))) {
                    return;
                }
                ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)returnData;
                model.setValue("corebillno", (Object)coreBillCollection.get(0).getBillNo());
                model.setValue("corebillnoinput", (Object)coreBillCollection.get(0).getBillNo());
            }
        }
    }

    private void returnDataToParent() {
        IDataModel model = this.getModel();
        HashMap<String, Object> data = new HashMap<String, Object>();
        DynamicObject recpaytype = (DynamicObject)model.getValue("recpaytype");
        Object paymenttype = model.getValue("paymenttype");
        Object payerbasetype = model.getValue("payerbasetype");
        Object settleorg = model.getValue("settleorg");
        Object corebilltype = model.getValue("corebilltype");
        Object corebillno = model.getValue("corebillno");
        data.put("recpaytype", recpaytype);
        data.put("paymenttype", paymenttype);
        data.put("payerbasetype", payerbasetype);
        data.put("settleorg", settleorg);
        data.put("corebilltype", corebilltype);
        data.put("corebillno", corebillno);
        data.put("corebillid", model.getValue("corebillid"));
        if ("other".equals(paymenttype)) {
            Object payer = model.getValue("payer");
            data.put("payer", payer);
        } else if (CasHelper.isNotEmpty((Object)paymenttype)) {
            DynamicObject payerid = (DynamicObject)model.getValue("payerid");
            if (CasHelper.isNotEmpty((Object)payerid)) {
                String payer = payerid.getLocaleString("name").getLocaleValue();
                data.put("payer", payer);
            }
            data.put("payerid", payerid);
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        data.put("isbatchedit", showParameter.getCustomParam("isbatchedit"));
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private void initF7() {
        this.fillSettleOrg();
        this.fillPayOrg();
        this.fillRecBasePayer();
    }

    private void fillSettleOrg() {
        BasedataEdit settleorg = (BasedataEdit)this.getControl("settleorg");
        settleorg.addBeforeF7SelectListener(select -> {
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            showParam.setCustomParam("orgFuncId", (Object)"10");
        });
    }

    private void fillRecBasePayer() {
        BasedataEdit recbasepayer = (BasedataEdit)this.getControl("payerid");
        recbasepayer.addBeforeF7SelectListener(evt -> {
            String paymenttype = this.getString("paymenttype");
            if (StringUtils.isBlank((CharSequence)paymenttype)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed8\u6b3e\u4eba\u7c7b\u578b", (String)"ClaimNoticeEditPlugin_38", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        });
    }

    private void fillPayOrg() {
        Object paymentbasetype = this.getModel().getValue("payerbasetype");
        if (EmptyUtil.isNoEmpty((Object)paymentbasetype) && StringUtils.equals((CharSequence)"bos_org", (CharSequence)paymentbasetype.toString())) {
            BasedataEdit orgF7 = (BasedataEdit)this.getControl("payerid");
            orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                qFilter.and(new QFilter("fisbankroll", "=", (Object)"1"));
                showParameter.getListFilterParameter().setFilter(qFilter);
            });
        }
    }

    private void rebuildCoreBillType(boolean ispartreceivable) {
        List comboItems;
        ArrayList<ComboItem> coreComboItem = new ArrayList<ComboItem>();
        ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_claimbill").getProperty(ispartreceivable ? "settlecorebilltype" : "unsettlecorebilltype");
        if (EmptyUtil.isNoEmpty((Object)property) && EmptyUtil.isNoEmpty((Object)(comboItems = property.getComboItems()))) {
            for (ValueMapItem valueMapItem : comboItems) {
                ComboItem comboItem = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
                coreComboItem.add(comboItem);
            }
        }
        CoreBillSettingHelper.setCoreBillTypeComboItem((String)"cas_claimbill", (boolean)false, (boolean)ispartreceivable, coreComboItem);
        ComboEdit coreCbo = (ComboEdit)this.getView().getControl("corebilltype");
        coreCbo.setComboItems(coreComboItem);
    }

    private void setEnable(boolean claimTag) {
        if (claimTag) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"recpaytype", "paymenttype", "payerid", "payer"});
        }
    }

    private void setTypeVisible(Object newValue, ComboEdit payerTypeField, String isPartProp, boolean isInit) {
        boolean ispartreceivable = true;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem customerCI = new ComboItem();
        customerCI.setCaption(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()));
        customerCI.setValue(AsstActTypeEnum.CUSTOMER.getValue());
        ComboItem supplierCI = new ComboItem();
        supplierCI.setCaption(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()));
        supplierCI.setValue(AsstActTypeEnum.SUPPLIER.getValue());
        ComboItem employeeCI = new ComboItem();
        employeeCI.setCaption(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()));
        employeeCI.setValue(AsstActTypeEnum.EMPLOYEE.getValue());
        ComboItem companyCI = new ComboItem();
        companyCI.setCaption(new LocaleString(AsstActTypeEnum.COMPANY.getName()));
        companyCI.setValue(AsstActTypeEnum.COMPANY.getValue());
        ComboItem otherCI = new ComboItem();
        otherCI.setCaption(new LocaleString(AsstActTypeEnum.OTHER.getName()));
        otherCI.setValue(AsstActTypeEnum.OTHER.getValue());
        DynamicObject receivingType = (DynamicObject)newValue;
        String paymentType = "";
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object orgObj = showParameter.getCustomParam("org");
        long orgId = 0L;
        if (orgObj instanceof Long) {
            orgId = (Long)orgObj;
        } else if (orgObj instanceof Integer) {
            orgId = ((Integer)orgObj).longValue();
        }
        boolean selectAllType = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"selectallpayertype");
        if (!CasHelper.isEmpty((Object)receivingType)) {
            boolean isPart = receivingType.getBoolean(isPartProp);
            if (isPart) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"corebillnoinput"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"settleorg", "corebillno"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"corebillnoinput"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"settleorg", "corebillno"});
            }
            if (RecBizTypeEnum.AGENT_RECEIVING.getValue().equals(receivingType.getString("biztype"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"settleorg"});
            }
            if (isPart && !selectAllType) {
                comboItems.add(customerCI);
                comboItems.add(supplierCI);
                comboItems.add(employeeCI);
                payerTypeField.setComboItems(comboItems);
                paymentType = ClaimPaymentTypeEnum.CUSTOMER.getValue();
            } else {
                comboItems.add(customerCI);
                comboItems.add(supplierCI);
                comboItems.add(employeeCI);
                comboItems.add(companyCI);
                comboItems.add(otherCI);
                payerTypeField.setComboItems(comboItems);
                paymentType = ClaimPaymentTypeEnum.OTHER.getValue();
            }
            ispartreceivable = isPart;
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"corebillnoinput"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"corebillno"});
        }
        boolean needInitPaymentType = Boolean.FALSE;
        if (selectAllType) {
            needInitPaymentType = Boolean.FALSE;
        } else {
            String oldPaymentType = (String)this.getModel().getValue("paymenttype");
            boolean isMatch = comboItems.stream().anyMatch(o -> o.getValue().equals(oldPaymentType));
            if (!isMatch) {
                needInitPaymentType = Boolean.TRUE;
            }
        }
        if (needInitPaymentType && !isInit) {
            this.getModel().beginInit();
            this.getModel().setValue("payerid", (Object)"");
            this.getModel().setValue("payerbasetype", (Object)(StringUtils.equals((CharSequence)"other", (CharSequence)paymentType) ? "" : paymentType));
            this.getModel().endInit();
            this.getModel().setValue("paymenttype", (Object)paymentType);
            this.getView().updateView("payerid");
            this.getView().updateView("payerbasetype");
        }
        this.rebuildCoreBillType(ispartreceivable);
    }

    private void showCoreBillF7() {
        String corebilltype = (String)this.getModel().getValue("corebilltype");
        DynamicObject recPayType = (DynamicObject)this.getModel().getValue("recpaytype");
        boolean isPartReceivable = false;
        if (recPayType != null) {
            isPartReceivable = recPayType.getBoolean("ispartreceivable");
        }
        Set billList = Stream.of(ClaimCoreBillTypeEnum.FINARBILL.getValue(), ClaimCoreBillTypeEnum.SALORDER.getValue(), ClaimCoreBillTypeEnum.GLREIMBILL.getValue(), ClaimCoreBillTypeEnum.GLREIMRECBILL.getValue()).collect(Collectors.toSet());
        DynamicObject settleorg = (DynamicObject)this.getModel().getValue("settleorg");
        List coreBillSettings = CoreBillSettingHelper.loadCoreBillSetting((String)"cas_claimbill", (boolean)false, (boolean)isPartReceivable);
        Set coreNumbers = CoreBillSettingHelper.getNumberBySetting((List)coreBillSettings);
        billList.addAll(coreNumbers);
        if (EmptyUtil.isEmpty((DynamicObject)settleorg) && (billList.contains(corebilltype) || isPartReceivable && StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.PAYBILL.getValue()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ed3\u7b97\u7ec4\u7ec7", (String)"ClaimHandleEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        String showFormId = corebilltype;
        DynamicObject coreBillSetting = CoreBillSettingHelper.filterCoreBillSetting((List)coreBillSettings, (String)corebilltype);
        if (CasHelper.isNotEmpty((Object)coreBillSetting)) {
            this.getPageCache().put("CORE_BILL_SETTING", SerializeHelper.serializeDynamicObj((Object)coreBillSetting));
            showFormId = coreBillSetting.getString("formid");
        } else {
            this.getPageCache().remove("CORE_BILL_SETTING");
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)showFormId, (boolean)true, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        if (StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.FINARBILL.getValue())) {
            lfp.setFilter(new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"}));
            lfp.setFilter(new QFilter("org", "=", settleorg.getPkValue()));
        }
        if (StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.SALORDER.getValue())) {
            DynamicObject org;
            String appId = AppMetadataCache.getAppInfo((String)"ar").getId();
            boolean isAutoCreateBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"10", (Long)(org = (DynamicObject)this.getModel().getValue("org")).getLong("id"), (String)"ar_011");
            if (isAutoCreateBill) {
                lfp.setFilter(new QFilter("paymode", "=", (Object)"CREDIT"));
            } else {
                lfp.setFilter(new QFilter("paymode", "in", (Object)new String[]{"CREDIT", "CASH"}));
            }
            lfp.setFilter(new QFilter("billentry.entrysettleorg", "=", settleorg.getPkValue()));
            lfp.setFilter(QFilter.of((String)" receiptamount < totalallamount ", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.GLREIMBILL.getValue()) || StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.GLREIMRECBILL.getValue())) {
            lfp.setFilter(new QFilter("accountingorg", "=", settleorg.getPkValue()));
            lfp.setFilter(new QFilter("castorecamount", ">=", (Object)0));
        }
        if (StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.SALCONTRACT.getValue())) {
            lfp.setFilter(new QFilter("billentry.entrysettleorg", "=", settleorg.getPkValue()));
            lfp.setFilter(new QFilter("validstatus", "<>", (Object)"A"));
            lfp.setFilter(new QFilter("changestatus", "<>", (Object)"B"));
            lfp.setFilter(QFilter.of((String)" receiptallamount < totalallamount ", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.GLREIMBILL.getValue()) || StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.GLREIMRECBILL.getValue())) {
            lfp.setFilter(new QFilter("billstatus", "=", (Object)"D"));
        } else if (StringUtils.equals((CharSequence)corebilltype, (CharSequence)ClaimCoreBillTypeEnum.REPAYMENTBILL.getValue())) {
            lfp.setFilter(new QFilter("billstatus", "=", (Object)"E"));
        } else if (!ClaimCoreBillTypeEnum.MSCON_PERFORMPLANIN.getValue().equals(corebilltype) && !coreNumbers.contains(corebilltype)) {
            lfp.setFilter(new QFilter("billstatus", "=", (Object)"C"));
        }
        if (CasHelper.isNotEmpty((Object)coreBillSetting)) {
            Map showParams = CoreBillSettingHelper.dealShowF7CustomParams((DynamicObject)coreBillSetting, (IDataModel)this.getModel(), (boolean)true);
            showParams.put("IS_BATCH_OP", "true");
            lsp.setCustomParams(showParams);
        }
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.setListFilterParameter(lfp);
        lsp.setMultiSelect(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "corebillno");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<QFilter> getRecTypePayBillFilter(Object currencyId, DynamicObject settleorg) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("paymenttype.ispartpayment", "=", (Object)"1"));
        qFilters.add(new QFilter("dpcurrency", "=", currencyId));
        qFilters.add(new QFilter("billstatus", "=", (Object)"D"));
        qFilters.add(new QFilter("entry.settleorg", "=", settleorg.getPkValue()));
        return qFilters;
    }
}

