/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.claimnotice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.ClaimPaymentTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class BatchPayClaimEditPlugin
extends BillEditPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"corebillno"});
        this.addClickListeners(new String[]{"corebillnoinput"});
    }

    public void beforeBindData(EventObject e) {
        String payeetype;
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object paytype = showParameter.getCustomParam("paytype");
        if (CasHelper.isNotEmpty((Object)paytype)) {
            this.getModel().setValue("paytype", paytype);
        }
        if (CasHelper.isNotEmpty((Object)(payeetype = (String)showParameter.getCustomParam("payeetype")))) {
            this.getModel().setValue("payeetype", (Object)payeetype);
            this.getModel().setValue("recbasetype", (Object)payeetype);
        }
        Object settleOrgObj = showParameter.getCustomParam("settleorg");
        this.getModel().setValue("settleorg", settleOrgObj);
        Object recpayee = showParameter.getCustomParam("recpayee");
        this.getModel().setValue("recpayee", recpayee);
        if (CasHelper.isNotEmpty((Object)payeetype) && !"other".equals(payeetype)) {
            this.getModel().setValue("recbasepayee", recpayee);
        }
        ComboEdit payeeTypeField = (ComboEdit)this.getControl("payeetype");
        this.setTypeVisible(this.getDynamicObject("paytype"), payeeTypeField, "ispartpayment", "");
        boolean claimTag = (Boolean)showParameter.getCustomParam("claimtag");
        this.setEnable(claimTag);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.initF7();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            this.returnDataToParent();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        switch (propName) {
            case "paytype": {
                if (CasHelper.isNotEmpty((Object)newValue) && newValue.equals(oldValue)) {
                    return;
                }
                if (CasHelper.isEmpty((Object)newValue)) {
                    this.getModel().setValue("payeetype", (Object)"");
                    return;
                }
                ComboEdit payerTypeField = (ComboEdit)this.getControl("payeetype");
                this.setTypeVisible(newValue, payerTypeField, "ispartpayment", "pay");
                break;
            }
            case "payeetype": {
                if (CasHelper.isNotEmpty((Object)newValue) && newValue.equals(oldValue)) {
                    return;
                }
                if (CasHelper.isNotEmpty((Object)newValue) && "other".equals(newValue)) {
                    this.getModel().setValue("recbasetype", (Object)"");
                    this.getModel().setValue("recbasepayee", (Object)"");
                    this.getModel().setValue("recpayee", (Object)"");
                    break;
                }
                this.getModel().setValue("recbasepayee", (Object)"");
                this.getModel().setValue("recpayee", (Object)"");
                this.getModel().setValue("recbasetype", newValue);
                break;
            }
        }
    }

    private void returnDataToParent() {
        IDataModel model = this.getModel();
        HashMap<String, Object> data = new HashMap<String, Object>();
        DynamicObject paytype = (DynamicObject)model.getValue("paytype");
        Object payeetype = model.getValue("payeetype");
        Object recbasetype = model.getValue("recbasetype");
        Object settleorg = model.getValue("settleorg");
        data.put("paytype", paytype);
        data.put("payeetype", payeetype);
        data.put("recbasetype", recbasetype);
        data.put("settleorg", settleorg);
        if ("other".equals(payeetype)) {
            Object recpayee = model.getValue("recpayee");
            data.put("recpayee", recpayee);
        } else if (CasHelper.isNotEmpty((Object)payeetype)) {
            DynamicObject recbasepayee = (DynamicObject)model.getValue("recbasepayee");
            if (CasHelper.isNotEmpty((Object)recbasepayee)) {
                String recpayee = recbasepayee.getLocaleString("name").getLocaleValue();
                data.put("recpayee", recpayee);
            }
            data.put("recbasepayee", recbasepayee);
        }
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private void initF7() {
        this.fillRecBasePayer();
    }

    private void fillRecBasePayer() {
        BasedataEdit recbasepayer = (BasedataEdit)this.getControl("recbasepayee");
        recbasepayer.addBeforeF7SelectListener(evt -> {
            String payeetype = this.getString("payeetype");
            if (StringUtils.isBlank((CharSequence)payeetype)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b", (String)"ClaimNoticeEditPlugin_38_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
        });
    }

    private void setEnable(boolean claimTag) {
        if (claimTag) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"paytype", "payeetype", "recbasepayee", "recpayee"});
        }
    }

    private void setTypeVisible(Object newValue, ComboEdit payeeTypeField, String isPartProp, String type) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem customerCI = new ComboItem();
        customerCI.setCaption(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()));
        customerCI.setValue(AsstActTypeEnum.CUSTOMER.getValue());
        ComboItem supplierCI = new ComboItem();
        supplierCI.setCaption(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()));
        supplierCI.setValue(AsstActTypeEnum.SUPPLIER.getValue());
        ComboItem employeeCI = new ComboItem();
        employeeCI.setCaption(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()));
        employeeCI.setValue(AsstActTypeEnum.EMPLOYEE.getValue());
        ComboItem companyCI = new ComboItem();
        companyCI.setCaption(new LocaleString(AsstActTypeEnum.COMPANY.getName()));
        companyCI.setValue(AsstActTypeEnum.COMPANY.getValue());
        ComboItem otherCI = new ComboItem();
        otherCI.setCaption(new LocaleString(AsstActTypeEnum.OTHER.getName()));
        otherCI.setValue(AsstActTypeEnum.OTHER.getValue());
        DynamicObject payType = (DynamicObject)newValue;
        String paytype = "";
        if (!CasHelper.isEmpty((Object)payType)) {
            boolean ispart = payType.getBoolean(isPartProp);
            if (ispart) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"settleorg"});
                comboItems.add(customerCI);
                comboItems.add(supplierCI);
                comboItems.add(employeeCI);
                payeeTypeField.setComboItems(comboItems);
                if (EmptyUtil.isNoEmpty((String)type)) {
                    if (type.equals("pay")) {
                        this.getModel().setValue("payeetype", (Object)AsstActTypeEnum.CUSTOMER.getValue());
                    } else {
                        this.getModel().setValue("payeetype", (Object)AsstActTypeEnum.SUPPLIER.getValue());
                    }
                }
                paytype = ClaimPaymentTypeEnum.CUSTOMER.getValue();
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"settleorg", ""});
                paytype = ClaimPaymentTypeEnum.OTHER.getValue();
                comboItems.add(customerCI);
                comboItems.add(supplierCI);
                comboItems.add(employeeCI);
                comboItems.add(companyCI);
                comboItems.add(otherCI);
                payeeTypeField.setComboItems(comboItems);
                if (EmptyUtil.isNoEmpty((String)type)) {
                    this.getModel().setValue("payeetype", (Object)AsstActTypeEnum.OTHER.getValue());
                }
            }
        }
        String oldpaymenttype = (String)this.getModel().getValue("payeetype");
        if (!(StringUtils.equals((CharSequence)ClaimPaymentTypeEnum.CUSTOMER.getValue(), (CharSequence)oldpaymenttype) || StringUtils.equals((CharSequence)ClaimPaymentTypeEnum.SUPPLIER.getValue(), (CharSequence)oldpaymenttype) || StringUtils.equals((CharSequence)ClaimPaymentTypeEnum.USER.getValue(), (CharSequence)oldpaymenttype))) {
            this.getModel().beginInit();
            this.getModel().setValue("recbasepayee", (Object)"");
            this.getModel().setValue("recbasetype", (Object)(StringUtils.equals((CharSequence)"other", (CharSequence)paytype) ? "" : paytype));
            this.getModel().endInit();
            this.getModel().setValue("payeetype", (Object)paytype);
        }
    }
}

