/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeGetSourceDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasDetailInfoExtFieldsHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class Claim2RecBillConvertPlugin
extends AbstractConvertPlugIn {
    public void beforeGetSourceData(BeforeGetSourceDataEventArgs e) {
        super.beforeGetSourceData(e);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        List orgOppBankNumber;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        ArrayList<DynamicObject[]> claimNoticeIdList = new ArrayList<DynamicObject[]>(billDataEntitys.length);
        Map extDataEntity = e.getTargetExtDataEntitySet().getExtDataEntityMap();
        HashMap<Long, DynamicObject> recTypes = new HashMap<Long, DynamicObject>(2);
        boolean replaceType = this.isReplaceType(extDataEntity, recTypes);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            if (replaceType) {
                DynamicObject dynamicObject = billDataEntity.getDataEntity();
                dynamicObject.set("receivingtype", recTypes.values().iterator().next());
            }
            DynamicObject[] pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            claimNoticeIdList.add(pkValue);
        }
        DynamicObject[] claimNoticeDts = BusinessDataServiceHelper.load((Object[])claimNoticeIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_claimcenterbill"));
        Map claimNoticeMap = Arrays.stream(claimNoticeDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        HashMap allChildNoticeBatchBill = RecClaimHelper.getAllChildNoticeBatchBill((DynamicObject[])claimNoticeDts);
        ArrayList claimNoticeIdBeiList = new ArrayList(10);
        ArrayList claimNoticeIdCdmList = new ArrayList(10);
        for (DynamicObject claimNoticeDt : claimNoticeDts) {
            String businessType = claimNoticeDt.getString("businesstype");
            List transIdList = (List)allChildNoticeBatchBill.get(claimNoticeDt.getPkValue());
            if (StringUtils.equals((CharSequence)businessType, (CharSequence)"rec") && null != transIdList) {
                claimNoticeIdBeiList.addAll(transIdList);
                continue;
            }
            if (!StringUtils.equals((CharSequence)businessType, (CharSequence)"recticket") || null == transIdList) continue;
            claimNoticeIdCdmList.addAll(transIdList);
        }
        Map beiMap = null;
        Map cdmMap = null;
        if (claimNoticeIdBeiList.size() > 0) {
            DynamicObject[] beiDts = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)String.join((CharSequence)",", EntityPropertyHelper.getPropertys((String)"bei_transdetail")), (QFilter[])new QFilter[]{new QFilter("id", "in", claimNoticeIdBeiList)});
            beiMap = Arrays.stream(beiDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        }
        if (claimNoticeIdCdmList.size() > 0) {
            DynamicObject[] cdmDts = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)String.join((CharSequence)",", EntityPropertyHelper.getPropertys((String)"cdm_receivablebill")), (QFilter[])new QFilter[]{new QFilter("id", "in", claimNoticeIdCdmList)});
            cdmMap = Arrays.stream(cdmDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        }
        Map<String, List<DynamicObject>> claimNoticeGroupMap = Arrays.stream(claimNoticeDts).collect(Collectors.groupingBy(o -> o.getString("paymenttype")));
        List<DynamicObject> orgTypeDtList = claimNoticeGroupMap.get("bos_org");
        List<DynamicObject> userTypeDtList = claimNoticeGroupMap.get("bos_user");
        DynamicObject[] orgBaseBills = null;
        Map orgBankMap = null;
        DynamicObject[] userBaseBills = null;
        Map userBankMap = null;
        if (CasHelper.isNotEmpty(orgTypeDtList) && CasHelper.isNotEmpty(orgOppBankNumber = orgTypeDtList.stream().map(o -> o.getString("oppbanknumber")).collect(Collectors.toList()))) {
            orgBaseBills = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", orgOppBankNumber)});
        }
        if (null != orgBaseBills) {
            orgBankMap = Arrays.stream(orgBaseBills).collect(Collectors.toMap(o -> o.getString("bankaccountnumber"), Function.identity(), (a, b) -> b));
        }
        if (CasHelper.isNotEmpty(userTypeDtList) && CasHelper.isNotEmpty(orgOppBankNumber = userTypeDtList.stream().map(o -> o.getString("oppbanknumber")).collect(Collectors.toList()))) {
            userBaseBills = BusinessDataServiceHelper.load((String)"er_payeer", (String)"id,payeraccount", (QFilter[])new QFilter[]{new QFilter("payeraccount", "in", orgOppBankNumber), new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("enable", "=", (Object)"1")});
        }
        if (null != userBaseBills) {
            userBankMap = Arrays.stream(userBaseBills).collect(Collectors.toMap(o -> o.getString("payeraccount"), Function.identity(), (k1, k2) -> k2));
        }
        Map<Object, DynamicObject> supplierDtIds = this.getPayerIds(claimNoticeGroupMap, "bd_supplier");
        Map<Object, DynamicObject> customerDtIds = this.getPayerIds(claimNoticeGroupMap, "bd_customer");
        Map<Object, DynamicObject> orgDtIds = this.getPayerIds(claimNoticeGroupMap, "bos_org");
        Map<Object, DynamicObject> userDtIds = this.getPayerIds(claimNoticeGroupMap, "bos_user");
        List settlementtypeList = Arrays.stream(claimNoticeDts).map(o -> o.getString("settlementtype")).collect(Collectors.toList());
        Object[] sourceCdmDys = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,draftbillno,currency,amount,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", claimNoticeIdCdmList)});
        Map cdmDtMap = Arrays.stream(sourceCdmDys).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity(), (e1, e2) -> e1));
        QFilter[] filters = new QFilter[]{new QFilter("settlementtype", "in", settlementtypeList), new QFilter("enable", "=", (Object)"1")};
        DynamicObject[] settleDy = BusinessDataServiceHelper.load((String)"bd_settlementtype", (String)"id,settlementtype", (QFilter[])filters);
        Map settlementtypeMap = Arrays.stream(settleDy).collect(Collectors.toMap(o -> o.getString("settlementtype"), Function.identity(), (e1, e2) -> e1));
        DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
        QFilter filter = new QFilter("sourceid", "in", claimNoticeIdList.stream().map(String::valueOf).collect(Collectors.toList())).and(new QFilter("sourcetype", "=", (Object)"cas_claimcenterbill")).and(new QFilter("claimtype", "in", (Object)new String[]{ClaimTypeEnum.APPEAL.getValue(), ClaimTypeEnum.CHANGE.getValue()})).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue()));
        DynamicObject[] claims = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,sourceid,claimtype,recpaytype,paymenttype,inneraccount,recpayer,bizdate", (QFilter[])new QFilter[]{filter}, (String)" auditdate asc ");
        Map<String, List<DynamicObject>> claimMap = Arrays.stream(claims).collect(Collectors.groupingBy(o -> o.getString("sourceid")));
        DynamicObject[] details = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)("id,billno,bizdate,currency,bankcheckflag,debitamount,creditamount" + CasDetailInfoExtFieldsHelper.getSrcDetailInfoSelectFields((String)targetEntityNumber)), (QFilter[])new QFilter[]{new QFilter("bankcheckflag", "in", claimNoticeMap.values().stream().flatMap(claim -> claim.getDynamicObjectCollection("bankcheckentity").stream().map(entry -> entry.getString("ebankcheckflag"))).collect(Collectors.toSet()))});
        Map detailInfoFieldsMap = CasDetailInfoExtFieldsHelper.getDetailInfoFields((String)targetEntityNumber);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            String strFlag;
            DynamicObject org;
            Object settleType;
            String bankAccount;
            DynamicObjectCollection entryBankDtCol;
            DynamicObject recPayerDt;
            Long recPayer;
            Object sourceDy;
            StringBuilder str = new StringBuilder();
            ArrayList<Object> sourceDys = new ArrayList<Object>(10);
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            List sourceIdList = (List)allChildNoticeBatchBill.get(pkValue);
            DynamicObject sourceBill = (DynamicObject)claimNoticeMap.get(pkValue);
            String businessType = sourceBill.getString("businesstype");
            RecClaimHelper.setRefundDetailId((DynamicObject)sourceBill, (DynamicObject)targetBill);
            if (StringUtils.equals((CharSequence)businessType, (CharSequence)"rec") && null != beiMap) {
                for (Object sourceId : sourceIdList) {
                    if (!EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)beiMap.get(sourceId)))) continue;
                    sourceDy = (DynamicObject)beiMap.get(sourceId);
                    sourceDys.add(sourceDy);
                }
            } else if (StringUtils.equals((CharSequence)businessType, (CharSequence)"recticket") && null != cdmMap) {
                for (Object sourceId : sourceIdList) {
                    if (!EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)cdmMap.get(sourceId)))) continue;
                    sourceDy = (DynamicObject)cdmMap.get(sourceId);
                    sourceDys.add(sourceDy);
                }
            }
            if (sourceDys.size() > 0) {
                DynamicObjectCollection voucher = targetBill.getDynamicObjectCollection("infoentry");
                Set changeFields = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"infoentry.");
                if (StringUtils.equals((CharSequence)businessType, (CharSequence)"rec")) {
                    changeFields = changeFields.stream().filter(f -> f.startsWith("bei_")).collect(Collectors.toCollection(HashSet::new));
                } else if (StringUtils.equals((CharSequence)businessType, (CharSequence)"recticket")) {
                    changeFields = changeFields.stream().filter(f -> f.startsWith("cdm_")).collect(Collectors.toCollection(HashSet::new));
                }
                for (DynamicObject dynamicObject : sourceDys) {
                    DynamicObject addNew = voucher.addNew();
                    addNew.set("infoid", dynamicObject.getPkValue());
                    for (String changeField : changeFields) {
                        addNew.set(changeField, dynamicObject.get(changeField.substring(4)));
                    }
                }
            }
            DynamicObjectCollection entrys = sourceBill.getDynamicObjectCollection("entryentity");
            List entryIds = entrys.stream().filter(entry -> entry.getBoolean("e_billstatus")).map(entry -> entry.getLong("id")).collect(Collectors.toList());
            String paymentType = sourceBill.getString("paymenttype");
            String string = sourceBill.getString("oppbanknumber");
            String payerFormId = "other";
            Long payerAcctBank = 0L;
            if ("bd_supplier".equals(paymentType)) {
                recPayer = Long.valueOf(sourceBill.getString("recpayer"));
                recPayerDt = supplierDtIds.get(recPayer);
                if (CasHelper.isNotEmpty((Object)recPayerDt)) {
                    this.setTargetBill(targetBill, recPayerDt);
                    entryBankDtCol = recPayerDt.getDynamicObjectCollection("entry_bank");
                    if (CasHelper.isNotEmpty((Object)entryBankDtCol)) {
                        for (DynamicObject entryBankDt : entryBankDtCol) {
                            bankAccount = entryBankDt.getString("bankaccount");
                            if (null == string || !string.equals(bankAccount)) continue;
                            payerFormId = "bd_accountbanks";
                            payerAcctBank = recPayerDt.getLong("id");
                        }
                    }
                }
            } else if ("bd_customer".equals(paymentType)) {
                recPayer = Long.valueOf(sourceBill.getString("recpayer"));
                recPayerDt = customerDtIds.get(recPayer);
                if (CasHelper.isNotEmpty((Object)recPayerDt)) {
                    this.setTargetBill(targetBill, recPayerDt);
                    entryBankDtCol = recPayerDt.getDynamicObjectCollection("entry_bank");
                    if (CasHelper.isNotEmpty((Object)entryBankDtCol)) {
                        for (DynamicObject entryBankDt : entryBankDtCol) {
                            bankAccount = entryBankDt.getString("bankaccount");
                            if (null == string || !string.equals(bankAccount)) continue;
                            payerFormId = "bd_accountbanks";
                            payerAcctBank = recPayerDt.getLong("id");
                        }
                    }
                }
            } else if ("bos_org".equals(paymentType)) {
                recPayer = Long.valueOf(sourceBill.getString("recpayer"));
                recPayerDt = orgDtIds.get(recPayer);
                if (CasHelper.isNotEmpty((Object)recPayerDt)) {
                    this.setTargetBill(targetBill, recPayerDt);
                }
                if (CasHelper.isNotEmpty((Object)string) && null != orgBankMap && null != orgBankMap.get(string)) {
                    payerFormId = "bd_accountbanks";
                    payerAcctBank = ((DynamicObject)orgBankMap.get(string)).getLong("id");
                }
            } else if ("bos_user".equals(paymentType)) {
                recPayer = Long.valueOf(sourceBill.getString("recpayer"));
                recPayerDt = userDtIds.get(recPayer);
                if (CasHelper.isNotEmpty((Object)recPayerDt)) {
                    this.setTargetBill(targetBill, recPayerDt);
                }
                payerFormId = "er_payeer";
                if (CasHelper.isNotEmpty((Object)string) && null != userBankMap && null != userBankMap.get(string)) {
                    payerAcctBank = ((DynamicObject)userBankMap.get(string)).getLong("id");
                }
            } else {
                targetBill.set("payername", (Object)sourceBill.getString("recpayer"));
            }
            targetBill.set("payeraccformid", (Object)payerFormId);
            long oriPayerAcctBank = targetBill.getLong("payeracctbank");
            if (oriPayerAcctBank <= 0L) {
                targetBill.set("payeracctbank", (Object)payerAcctBank);
            }
            if (CasHelper.isEmpty((Object)(settleType = targetBill.get("settletype")))) {
                DynamicObject settleTypeDy = null;
                if (StringUtils.equals((CharSequence)sourceBill.getString("businesstype"), (CharSequence)"recticket")) {
                    DynamicObject draftBillType = sourceBill.getDynamicObject("draftbilltype");
                    DynamicObjectCollection settTypeColl = null;
                    if (draftBillType != null) {
                        DynamicObjectCollection dynamicObjectCollection = settTypeColl = draftBillType.get("settlementtypebd") == null ? null : draftBillType.getDynamicObjectCollection("settlementtypebd");
                    }
                    if (!CollectionUtils.isEmpty(settTypeColl)) {
                        List sortedList = settTypeColl.stream().map(i -> i.getDynamicObject("fbasedataid")).sorted((a, b) -> a.getString("number").compareTo(b.getString("number"))).collect(Collectors.toList());
                        settleTypeDy = (DynamicObject)sortedList.get(0);
                    } else {
                        String settlementtype = sourceBill.getString("settlementtype");
                        if (null != settlementtype && EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)settlementtypeMap.get(settlementtype)))) {
                            settleTypeDy = (DynamicObject)settlementtypeMap.get(settlementtype);
                        }
                    }
                    ArrayList<DynamicObject> sourceCdmDysList = new ArrayList<DynamicObject>(10);
                    List transIdList = (List)allChildNoticeBatchBill.get(sourceBill.getPkValue());
                    if (EmptyUtil.isNoEmpty((Object)transIdList)) {
                        for (Object transId : transIdList) {
                            if (null == cdmDtMap.get(transId)) continue;
                            sourceCdmDysList.add((DynamicObject)cdmDtMap.get(transId));
                        }
                    }
                    if (EmptyUtil.isNoEmpty((Object[])sourceCdmDys)) {
                        targetBill.set("settletnumber", (Object)sourceCdmDysList.stream().map(dy -> dy.getString("draftbillno")).collect(Collectors.joining(",")));
                        DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)targetBill, (String)"settletnumber");
                        this.fillDraftBillEntry(targetBill, sourceCdmDysList);
                    }
                }
                if (EmptyUtil.isEmpty(settleTypeDy) && EmptyUtil.isNoEmpty((DynamicObject)(settleTypeDy = defaultSettleType)) && "0".equals(settleTypeDy.getString("settlementtype"))) {
                    settleTypeDy = null;
                }
                targetBill.set("settletype", (Object)settleTypeDy);
            }
            this.setDecpSettleType(targetBill, sourceBill);
            DynamicObjectCollection tarEntrys = targetBill.getDynamicObjectCollection("entry");
            Iterator iterator = tarEntrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry2 = (DynamicObject)iterator.next();
                if (!entryIds.contains(entry2.getLong("e_sourcebillentryid"))) continue;
                iterator.remove();
            }
            List<DynamicObject> claimList = claimMap.get(sourceBill.getPkValue().toString());
            Boolean isaddfee = sourceBill.getBoolean("isaddfee");
            if (isaddfee.booleanValue()) {
                BigDecimal allfee = sourceBill.getBigDecimal("fee");
                DynamicObject currency = sourceBill.getDynamicObject("currency");
                DynamicObject entry3 = null;
                BigDecimal fee = BigDecimal.ZERO;
                BigDecimal totolfee = BigDecimal.ZERO;
                BigDecimal actamt = BigDecimal.ZERO;
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)tarEntrys)) {
                    tarEntrys.sort((dy1, dy2) -> dy1.getLong("e_sourcebillentryid") - dy2.getLong("e_sourcebillentryid") > 0L ? 1 : -1);
                    BigDecimal totolamt = tarEntrys.stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    for (int i2 = 0; i2 < tarEntrys.size(); ++i2) {
                        List claimType;
                        entry3 = (DynamicObject)tarEntrys.get(i2);
                        fee = entry3.getBigDecimal("e_receivableamt");
                        fee = fee.multiply(allfee).divide(totolamt, currency.getInt("amtprecision"), RoundingMode.DOWN);
                        if (i2 == tarEntrys.size() - 1) {
                            fee = allfee.subtract(totolfee);
                        } else {
                            totolfee = totolfee.add(fee);
                        }
                        entry3.set("e_fee", (Object)fee);
                        Boolean actAmtBol = false;
                        if (CasHelper.isNotEmpty(claimList) && null != (claimType = claimList.stream().filter(o -> ClaimTypeEnum.CHANGE.getValue().equals(o.getString("claimtype"))).collect(Collectors.toList())) && claimType.size() > 0) {
                            actAmtBol = true;
                        }
                        actamt = actAmtBol != false ? entry3.getBigDecimal("e_actamt").add(fee).subtract(fee) : entry3.getBigDecimal("e_actamt").subtract(fee);
                        entry3.set("e_actamt", (Object)actamt);
                    }
                }
            }
            if (CasHelper.isNotEmpty(claimList)) {
                for (DynamicObject claim2 : claimList) {
                    String payType = claim2.getString("paymenttype");
                    targetBill.set("payerformid", (Object)payType);
                    targetBill.set("itempayertype", (Object)payType);
                    targetBill.set("receivingtype", (Object)claim2.getDynamicObject("recpaytype"));
                    targetBill.set("payertype", (Object)payType);
                    targetBill.set("inneraccount", (Object)claim2.getDynamicObject("inneraccount"));
                    String recPayerCal = claim2.getString("recpayer");
                    if ("other".equals(payType)) {
                        targetBill.set("payername", (Object)recPayerCal);
                    } else {
                        targetBill.set("payer", (Object)recPayerCal);
                        targetBill.set("itempayer", (Object)recPayerCal);
                        DynamicObject[] payer = BusinessDataServiceHelper.load((Object[])new Object[]{Long.valueOf(recPayerCal)}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)payType));
                        if (payer != null && payer.length > 0) {
                            targetBill.set("payername", payer[0].get("name"));
                            targetBill.set("payernumber", payer[0].get("number"));
                        }
                    }
                    targetBill.set("bizdate", (Object)claim2.getDate("bizdate"));
                }
            }
            if ((org = targetBill.getDynamicObject("org")) != null) {
                DynamicObject baseCurrency;
                long orgId = org.getLong("id");
                DynamicObject currency = targetBill.getDynamicObject("currency");
                if (currency != null && CasHelper.isNotEmpty((Object)(currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (String)"bd_currency")))) {
                    targetBill.set("currency", (Object)currency);
                }
                if ((baseCurrency = OrgHelper.getBaseCurrency((long)orgId)) != null) {
                    targetBill.set("basecurrency", (Object)baseCurrency);
                }
                this.setValueIfAbsent(targetBill, "exratetable", SystemStatusCtrolHelper.getExrateTable((long)orgId));
                this.setValueIfAbsent(targetBill, "exratedate", DateUtils.getCurrentDate());
                BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
                if (CasHelper.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ONE) == 0) {
                    if (currency != null && baseCurrency != null) {
                        long destCurrencyId;
                        boolean isCurrencyDifferent;
                        long srcCurrencyId = currency.getLong("id");
                        boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                        if (isCurrencyDifferent) {
                            Date exrateDate = targetBill.getDate("exratedate");
                            DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                            if (CasHelper.isNotEmpty((Object)exrateTable)) {
                                exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                            }
                        }
                    }
                    targetBill.set("exchangerate", (Object)exchangeRate);
                    DynamicObject accountBank = targetBill.getDynamicObject("accountbank");
                    if (accountBank != null) {
                        targetBill.set("payeebank", (Object)accountBank.getDynamicObject("bank"));
                        this.setValueIfAbsent(targetBill, "openorg", accountBank.getDynamicObject("openorg"));
                    }
                }
            }
            this.setSettleOrg(targetBill);
            if (sourceBill != null) {
                Object bankCheckFlag;
                DynamicObjectCollection bankCheckEntity = sourceBill.getDynamicObjectCollection("bankcheckentity");
                if (bankCheckEntity != null && !bankCheckEntity.isEmpty() && details != null && details.length > 0) {
                    DynamicObjectCollection banFlagEntry = targetBill.getDynamicObjectCollection("bankcheckentity");
                    for (DynamicObject entry4 : bankCheckEntity) {
                        String ebankcheckflag = entry4.getString("ebankcheckflag");
                        if (!EmptyUtil.isNoEmpty((String)ebankcheckflag)) continue;
                        Set detailSet = Arrays.stream(details).filter(detail -> ebankcheckflag.equals(detail.getString("bankcheckflag"))).collect(Collectors.toSet());
                        DynamicObject dynamicObject = banFlagEntry.addNew();
                        dynamicObject.set("ebankcheckflag", (Object)ebankcheckflag);
                        if (detailSet.isEmpty()) continue;
                        CasDetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)((DynamicObject)detailSet.iterator().next()), (DynamicObject)dynamicObject, (Map)detailInfoFieldsMap);
                    }
                }
                if (EmptyUtil.isNoEmpty((Object)(bankCheckFlag = sourceBill.get("bankcheckflag")))) {
                    str.append(bankCheckFlag);
                    str.append(",");
                }
            }
            if (EmptyUtil.isNotEmpty((String)(strFlag = str.toString())) && strFlag.length() >= 1) {
                strFlag = strFlag.substring(0, strFlag.length() - 1);
            }
            targetBill.set("bankcheckflag_tag", (Object)strFlag);
            targetBill.set("bankcheckflag", (Object)strFlag);
        }
    }

    private boolean isReplaceType(Map<String, List<ExtendedDataEntity>> extDataEntity, Map<Long, DynamicObject> recTypes) {
        boolean replaceType = false;
        if (extDataEntity.containsKey("entry")) {
            ExtendedDataEntity extendedData;
            DynamicObject recType;
            List<ExtendedDataEntity> extendedDataEntities = extDataEntity.get("entry");
            Iterator<ExtendedDataEntity> iterator = extendedDataEntities.iterator();
            while (iterator.hasNext() && (recType = (DynamicObject)(extendedData = iterator.next()).getValue("e_receivingtype")) != null && !EmptyUtil.isEmpty((DynamicObject)recType)) {
                Long recTypeId = recType.getLong("id");
                recTypes.put(recTypeId, recType);
            }
            if (recTypes.size() == 1) {
                replaceType = true;
            }
        }
        return replaceType;
    }

    private void setDecpSettleType(DynamicObject targetBill, DynamicObject sourceBill) {
        String recAccount;
        ArrayList<String> accList = new ArrayList<String>(16);
        DynamicObject accountbank = sourceBill.getDynamicObject("accountbank");
        if (EmptyUtil.isNoEmpty((DynamicObject)accountbank)) {
            accList.add(accountbank.getString("bankaccountnumber"));
        }
        if (EmptyUtil.isNoEmpty((String)(recAccount = sourceBill.getString("oppbanknumber")))) {
            accList.add(recAccount);
        }
        DcepConverHelper.setSettleType((DynamicObject)targetBill, accList);
    }

    private Map<Object, DynamicObject> getPayerIds(Map<String, List<DynamicObject>> claimNoticeGroupMap, String type) {
        Map<Object, Object> recPayerMap = new HashMap<Object, DynamicObject>();
        List<DynamicObject> typeDtList = claimNoticeGroupMap.get(type);
        if (CasHelper.isEmpty(typeDtList)) {
            return recPayerMap;
        }
        List typeList = typeDtList.stream().map(o -> o.getString("recpayer")).collect(Collectors.toList());
        DynamicObject[] baseBills = null;
        baseBills = "bos_org".equals(type) || "bos_user".equals(type) ? BusinessDataServiceHelper.load((String)type, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", typeList.stream().map(o -> Long.valueOf(o)).collect(Collectors.toList()))}) : BusinessDataServiceHelper.load((String)type, (String)"id,number,name,entry_bank.bankaccount", (QFilter[])new QFilter[]{new QFilter("id", "in", typeList.stream().map(o -> Long.valueOf(o)).collect(Collectors.toList()))});
        if (CasHelper.isNotEmpty((Object)baseBills)) {
            recPayerMap = Arrays.stream(baseBills).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        }
        return recPayerMap;
    }

    private void setTargetBill(DynamicObject targetBill, DynamicObject baseBill) {
        targetBill.set("payername", (Object)baseBill.getString("name"));
        targetBill.set("payer", baseBill.getPkValue());
        targetBill.set("itempayer", baseBill.getPkValue());
        targetBill.set("payernumber", baseBill.get("number"));
    }

    public void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty((Object)targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }

    private void setSettleOrg(DynamicObject targetBill) {
        DynamicObject receivingtype = targetBill.getDynamicObject("receivingtype");
        Object org = null;
        if (receivingtype != null && receivingtype.getBoolean("ispartreceivable")) {
            DynamicObject recOrg = targetBill.getDynamicObject("org");
            if ((recOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting")).getBoolean("fisaccounting")) {
                org = recOrg;
            } else {
                DynamicObject recAccount = targetBill.getDynamicObject("accountbank");
                if (recAccount != null) {
                    org = recAccount.get("openorg");
                }
            }
        } else {
            org = targetBill.get("openorg");
        }
        for (DynamicObject entry : targetBill.getDynamicObjectCollection("entry")) {
            if (org == null || entry.getDynamicObject("e_settleorg") != null) continue;
            entry.set("e_settleorg", org);
        }
    }

    private void fillDraftBillEntry(DynamicObject targetBill, List<DynamicObject> sourceCdmDysList) {
        DynamicObjectCollection draftBills = targetBill.getDynamicObjectCollection("draftbill");
        DynamicObjectCollection draftEntryInfo = targetBill.getDynamicObjectCollection("cas_draftinfo");
        Map draftBaseData = BusinessDataServiceHelper.loadFromCache((Object[])sourceCdmDysList.stream().map(DataEntityBase::getPkValue).toArray(), (String)"cdm_payandrecdraft_f7");
        draftBills.clear();
        draftEntryInfo.clear();
        for (DynamicObject draftBill : sourceCdmDysList) {
            DynamicObject newDraftBill = new DynamicObject(draftBills.getDynamicObjectType());
            newDraftBill.set("fbasedataid", draftBaseData.get(draftBill.getPkValue()));
            draftBills.add((Object)newDraftBill);
            DynamicObject newDraftEntry = new DynamicObject(draftEntryInfo.getDynamicObjectType());
            newDraftEntry.set("transamount", (Object)draftBill.getBigDecimal("amount"));
            newDraftEntry.set("recbillcurrency", (Object)draftBill.getDynamicObject("currency"));
            newDraftEntry.set("draftbillinfo", draftBaseData.get(draftBill.getPkValue()));
            draftEntryInfo.add((Object)newDraftEntry);
        }
        targetBill.set("draftbill", (Object)draftBills);
        targetBill.set("cas_draftinfo", (Object)draftEntryInfo);
    }
}

