/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.param.RecPayRuleParam;
import kd.fi.cas.util.EmptyUtil;

public class ClaimHandleConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map<Long, DynamicObject> sourceBillMap = this.getSourceBills(e, billDataEntitys);
        Map<Long, DynamicObject> targetBillMap = this.getTargetBills(billDataEntitys);
        Map<Object, DynamicObject> claimNoticeBillMap = this.getClaimNoticeBills(targetBillMap);
        DynamicObjectCollection recPayRuleCollection = this.getRecPayRules(sourceBillMap, targetBillMap);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            String claimstatus;
            DynamicObjectCollection entryEntity;
            List<DynamicObject> ruleCollect;
            DynamicObject recpayrule;
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = sourceBillMap.get(pkValue);
            DynamicObject targetBill = billDataEntity.getDataEntity();
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)targetBill.getDataEntityType().getName()).findProperty("entryentity");
            DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
            DynamicObject entryObject = new DynamicObject(dt);
            entryObject.set("e_settleorg", (Object)this.setSettleValue(targetBill));
            EntryProp payProp = (EntryProp)EntityMetadataCache.getDataEntityType((String)targetBill.getDataEntityType().getName()).findProperty("payentity");
            DynamicObjectType payDt = payProp.getDynamicCollectionItemPropertyType();
            DynamicObject patEntryObject = new DynamicObject(payDt);
            patEntryObject.set("e_paysettleorg", (Object)this.setSettleValue(targetBill));
            String rulesname = sourceBill.getString("rulesname");
            String biztype = "rec";
            String handlescheme = "recv";
            if (StringUtils.equals((CharSequence)"recticket", (CharSequence)targetBill.getString("businesstype"))) {
                biztype = "recticket";
                handlescheme = "ticket";
            }
            RecPayRuleParam recPayRuleParam = new RecPayRuleParam();
            recPayRuleParam.setBusinessType(targetBill.getString("businesstype"));
            recPayRuleParam.setOrg(Long.valueOf(targetBill.getDynamicObject("org").getLong("id")));
            recPayRuleParam.setName(targetBill.get("oppunit"));
            recPayRuleParam.setOppBankNumber(targetBill.get("oppbanknumber"));
            recPayRuleParam.setIsMatch(false);
            if (!EmptyUtil.isEmpty((String)rulesname) && EmptyUtil.isNoEmpty((DynamicObject)(recpayrule = this.getRecPayRule(ruleCollect = recPayRuleCollection.stream().filter(o -> rulesname.equalsIgnoreCase(o.getString("entryentity.e_rulesname"))).collect(Collectors.toList()), targetBill.getDynamicObject("org").getLong("id"), biztype, handlescheme, rulesname)))) {
                Object[] recpaytypeArr = BusinessDataServiceHelper.load((Object[])new Object[]{recpayrule.get("entryentity.e_receivingtype")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_receivingbilltype"));
                if (!EmptyUtil.isEmpty((Object[])recpaytypeArr)) {
                    targetBill.set("recpaytype", recpaytypeArr[0]);
                    DynamicObjectCollection entries = targetBill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entries) {
                        entry.set("e_receivingtype", recpaytypeArr[0]);
                    }
                }
                recPayRuleParam.setPayerType(recpayrule.get("entryentity.e_payertype"));
                recPayRuleParam.setPayer(recpayrule.get("entryentity.e_payer"));
                Object[] load = BusinessDataServiceHelper.load((Object[])new Object[]{recpayrule.get("entryentity.e_fundflowitem")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_fundflowitem"));
                if (!EmptyUtil.isEmpty((Object[])load)) {
                    entryObject.set("e_fundflowitem", load[0]);
                }
                recPayRuleParam.setIsMatch(true);
                recPayRuleParam.setSaveNotifiTAG(recpayrule.getString("entryentity.e_datafilter_TAG"));
            }
            if (CasHelper.isNotEmpty((Object)(entryEntity = targetBill.getDynamicObjectCollection("entryentity"))) && entryEntity.size() > 0) {
                ((DynamicObject)entryEntity.get(0)).set("e_settleorg", entryObject.get("e_settleorg"));
                Object object = entryObject.get("e_fundflowitem");
                if (object != null) {
                    ((DynamicObject)entryEntity.get(0)).set("e_fundflowitem", object);
                }
            } else {
                entryEntity.add((Object)entryObject);
            }
            DynamicObjectCollection payEntryEntity = targetBill.getDynamicObjectCollection("payentity");
            if (CasHelper.isNotEmpty((Object)payEntryEntity) && payEntryEntity.size() > 0) {
                ((DynamicObject)payEntryEntity.get(0)).set("e_paysettleorg", patEntryObject.get("e_paysettleorg"));
                Object object = patEntryObject.get("e_payfundflowitem");
                if (object != null) {
                    ((DynamicObject)payEntryEntity.get(0)).set("e_payfundflowitem", object);
                }
            } else {
                payEntryEntity.add((Object)patEntryObject);
            }
            RecClaimHelper.matchInfo((RecPayRuleParam)recPayRuleParam);
            targetBill.set("paymenttype", recPayRuleParam.getPayerType());
            targetBill.set("recpayer", recPayRuleParam.getPayer());
            String claimtype = ClaimTypeEnum.CLAIM.getValue();
            DynamicObject noticeClaim = claimNoticeBillMap.get(targetBill.getString("claimno"));
            if (!EmptyUtil.isEmpty((DynamicObject)noticeClaim) && (StringUtils.equals((CharSequence)(claimstatus = noticeClaim.getString("claimstatus")), (CharSequence)ClaimStatusEnum.SURE.getValue()) || StringUtils.equals((CharSequence)claimstatus, (CharSequence)ClaimStatusEnum.APPEAL.getValue()))) {
                claimtype = ClaimTypeEnum.APPEAL.getValue();
                targetBill.set("bizdate", (Object)new Date());
                targetBill.set("multireceivingtype", (Object)false);
                targetBill.set("recpaytype", null);
                targetBill.set("paymenttype", null);
                targetBill.set("recbasepayer", null);
                DynamicObjectCollection entries = targetBill.getDynamicObjectCollection("entryentity");
                entries.clear();
                DynamicObject entry = entries.addNew();
                entry.set("e_settleorg", targetBill.get("org"));
            }
            targetBill.set("claimtype", (Object)claimtype);
        }
    }

    private DynamicObject getRecPayRule(List<DynamicObject> ruleCollect, long orgId, String bizType, String handleScheme, String ruleName) {
        DynamicObject result = null;
        for (DynamicObject rule : ruleCollect) {
            boolean flag;
            long uOrg = rule.getLong("org_entry.u_org");
            String oBizType = rule.getString("biztype");
            String eHandleScheme = rule.getString("entryentity.e_handlescheme");
            String eRuleName = rule.getString("entryentity.e_rulesname");
            boolean bl = flag = StringUtils.equals((CharSequence)bizType, (CharSequence)oBizType) && StringUtils.equals((CharSequence)handleScheme, (CharSequence)eHandleScheme) && StringUtils.equals((CharSequence)ruleName, (CharSequence)eRuleName);
            if (orgId == uOrg && flag) {
                result = rule;
                break;
            }
            if (!EmptyUtil.isEmpty((Long)uOrg) || !flag) continue;
            result = rule;
            break;
        }
        return result;
    }

    private DynamicObjectCollection getRecPayRules(Map<Long, DynamicObject> sourceBillMap, Map<Long, DynamicObject> targetBillMap) {
        ArrayList<String> bizTypeList = new ArrayList<String>(2);
        bizTypeList.add("rec");
        bizTypeList.add("recticket");
        ArrayList<String> handleSchemeList = new ArrayList<String>(2);
        handleSchemeList.add("recv");
        handleSchemeList.add("ticket");
        ArrayList<String> ruleNames = new ArrayList<String>(10);
        for (Map.Entry<Long, DynamicObject> mapEntry : sourceBillMap.entrySet()) {
            DynamicObject value = mapEntry.getValue();
            if (value == null) continue;
            ruleNames.add(value.getString("rulesname"));
        }
        QFilter ruleFilter = new QFilter("biztype", "in", bizTypeList);
        ruleFilter.and("enable", "=", (Object)Boolean.TRUE);
        ruleFilter.and(new QFilter("entryentity.e_handlescheme", "in", handleSchemeList));
        ruleFilter.and(new QFilter("entryentity.e_rulesname", "in", ruleNames));
        String properties = "id,org_entry.u_org,biztype,entryentity.e_handlescheme,entryentity.e_rulesname,entryentity.e_receivingtype, entryentity.e_payertype, entryentity.e_payer, entryentity.e_fundflowitem ,entryentity.e_datafilter_TAG";
        DynamicObjectCollection recPayRuleCollection = QueryServiceHelper.query((String)"cas_recpayrule", (String)properties, (QFilter[])new QFilter[]{ruleFilter}, (String)"org_entry.u_org desc");
        return recPayRuleCollection;
    }

    private Map<Object, DynamicObject> getClaimNoticeBills(Map<Long, DynamicObject> targetBillMap) {
        HashSet<String> billNoSet = new HashSet<String>(10);
        Map<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(10);
        if (targetBillMap != null) {
            for (Map.Entry<Long, DynamicObject> mapEntry : targetBillMap.entrySet()) {
                DynamicObject value = mapEntry.getValue();
                if (value == null) continue;
                billNoSet.add(value.getString("claimno"));
            }
        }
        if (billNoSet.size() > 0) {
            String properties = "billno,claimstatus";
            QFilter transFilter = new QFilter("billno", "in", billNoSet);
            DynamicObject[] noticeClaim = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)properties, (QFilter[])new QFilter[]{transFilter});
            result = Arrays.stream(noticeClaim).collect(Collectors.toMap(k -> k.getString("billno"), v -> v));
        }
        return result;
    }

    private Map<Long, DynamicObject> getTargetBills(ExtendedDataEntity[] billDataEntitys) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(10);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            result.put(targetBill.getLong("id"), targetBill);
        }
        return result;
    }

    private DynamicObject setSettleValue(DynamicObject targetBill) {
        DynamicObject recOrg = (DynamicObject)targetBill.get("org");
        if (EmptyUtil.isEmpty((DynamicObject)recOrg)) {
            return null;
        }
        DynamicObject centerOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting");
        if (!EmptyUtil.isEmpty((DynamicObject)centerOrg) && centerOrg.getBoolean("fisaccounting")) {
            return recOrg;
        }
        DynamicObject recAccount = targetBill.getDynamicObject("accountbank");
        if (recAccount != null) {
            DynamicObject openOrg = recAccount.getDynamicObject("openorg");
            DynamicObject openOrgObj = BusinessDataServiceHelper.loadSingle((Object)openOrg.getPkValue(), (String)openOrg.getDynamicObjectType().getName(), (String)"fisaccounting");
            if (!EmptyUtil.isEmpty((DynamicObject)openOrgObj) && openOrgObj.getBoolean("fisaccounting")) {
                return openOrg;
            }
            return null;
        }
        return null;
    }

    private Map<Long, DynamicObject> getSourceBills(AfterFieldMappingEventArgs e, ExtendedDataEntity[] billDataEntitys) {
        ArrayList<Object> pkValueList = new ArrayList<Object>(10);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            pkValueList.add(pkValue);
        }
        DynamicObject[] sourceBill = BusinessDataServiceHelper.load((Object[])pkValueList.toArray(new Object[0]), (DynamicObjectType)this.getSrcMainType());
        Map<Long, DynamicObject> result = Arrays.stream(sourceBill).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        return result;
    }
}

