/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeGetSourceDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasDetailInfoExtFieldsHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class ClaimPayBillConvertPlugin
extends AbstractConvertPlugIn {
    public void beforeGetSourceData(BeforeGetSourceDataEventArgs e) {
        super.beforeGetSourceData(e);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        ArrayList<Object> claimNoticeIdList = new ArrayList<Object>(billDataEntitys.length);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            claimNoticeIdList.add(pkValue);
        }
        DynamicObject[] claimNoticeDts = BusinessDataServiceHelper.load((Object[])claimNoticeIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_claimcenterbill"));
        Map claimNoticeMap = Arrays.stream(claimNoticeDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        DynamicObject settleTypeDy = BaseDataHelper.getDefaultSettleType();
        DynamicObject[] details = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)("id,billno,bizdate,currency,bankcheckflag,debitamount,creditamount" + CasDetailInfoExtFieldsHelper.getSrcDetailInfoSelectFields((String)targetEntityNumber)), (QFilter[])new QFilter[]{new QFilter("bankcheckflag", "in", claimNoticeMap.values().stream().flatMap(claim -> claim.getDynamicObjectCollection("bankcheckentity").stream().map(entry -> entry.getString("ebankcheckflag"))).collect(Collectors.toSet()))});
        Map detailInfoFieldsMap = CasDetailInfoExtFieldsHelper.getDetailInfoFields((String)targetEntityNumber);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            String recAccount;
            String strFlag;
            Object bankCheckFlag;
            DynamicObjectCollection bankCheckEntity;
            Object settleType;
            String settlementtype;
            StringBuilder str = new StringBuilder();
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = (DynamicObject)claimNoticeMap.get(pkValue);
            String paymentType = sourceBill.getString("payeetype");
            DynamicObject recbasetype = sourceBill.getDynamicObject("recbasepayee");
            if (!"other".equals(paymentType)) {
                if (CasHelper.isEmpty((Object)recbasetype)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e0b\u63a8\u4ed8\u6b3e\u5355\u3002", (String)"Claim2RecBillConvertPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                DynamicObject[] baseBills = BusinessDataServiceHelper.load((String)paymentType, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", recbasetype.getPkValue())});
                if (!CasHelper.isEmpty((DynamicObject[])baseBills)) {
                    DynamicObject baseBill = baseBills[0];
                    targetBill.set("payeename", (Object)baseBill.getString("name"));
                    targetBill.set("payee", baseBill.getPkValue());
                }
            }
            if (settleTypeDy != null && StringUtils.isNotBlank((CharSequence)(settlementtype = settleTypeDy.getString("settlementtype"))) && "0".equals(settlementtype)) {
                settleTypeDy = null;
            }
            if (CasHelper.isEmpty((Object)(settleType = targetBill.get("settletype")))) {
                targetBill.set("settletype", (Object)settleTypeDy);
            }
            if ((bankCheckEntity = sourceBill.getDynamicObjectCollection("bankcheckentity")) != null && !bankCheckEntity.isEmpty() && details != null && details.length > 0) {
                DynamicObjectCollection banFlagEntry = targetBill.getDynamicObjectCollection("bankcheckentity");
                for (DynamicObject entry : bankCheckEntity) {
                    String ebankcheckflag = entry.getString("ebankcheckflag");
                    if (!EmptyUtil.isNoEmpty((String)ebankcheckflag)) continue;
                    Set detailSet = Arrays.stream(details).filter(detail -> ebankcheckflag.equals(detail.getString("bankcheckflag"))).collect(Collectors.toSet());
                    DynamicObject dynamicObject = banFlagEntry.addNew();
                    dynamicObject.set("ebankcheckflag", (Object)ebankcheckflag);
                    if (detailSet.isEmpty()) continue;
                    CasDetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)((DynamicObject)detailSet.iterator().next()), (DynamicObject)dynamicObject, (Map)detailInfoFieldsMap);
                }
            }
            if (EmptyUtil.isNoEmpty((Object)(bankCheckFlag = sourceBill.get("bankcheckflag")))) {
                str.append(bankCheckFlag);
                str.append(",");
            }
            if (EmptyUtil.isNotEmpty((String)(strFlag = str.toString())) && strFlag.length() >= 1) {
                strFlag = strFlag.substring(0, strFlag.length() - 1);
            }
            targetBill.set("bankcheckflag_tag", (Object)strFlag);
            targetBill.set("bankcheckflag", (Object)strFlag);
            ArrayList<String> accList = new ArrayList<String>(16);
            DynamicObject accountbank = sourceBill.getDynamicObject("accountbank");
            if (EmptyUtil.isNoEmpty((DynamicObject)accountbank)) {
                accList.add(accountbank.getString("bankaccountnumber"));
            }
            if (EmptyUtil.isNoEmpty((String)(recAccount = sourceBill.getString("oppbanknumber")))) {
                accList.add(recAccount);
            }
            DcepConverHelper.setSettleType((DynamicObject)targetBill, accList);
        }
    }
}

