/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recclaim.recpayrule;

import java.util.ArrayList;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.fi.cas.enums.RecPayRuleTypeEnum;
import kd.fi.cas.formplugin.recclaim.recpayrule.IRevPayRuleEditPlugin;

public class RevPayRuleEditFactory {
    private static final int INIT_CAPACITY_ONE = 1;
    private static final int INIT_CAPACITY_TWO = 2;

    public static RevPayRuleEditFactory getInstance() {
        return Singleton.instance;
    }

    public IRevPayRuleEditPlugin getBean(String businessType) {
        if ("recticket".equals(businessType) || "electicket".equals(businessType)) {
            return new TicketBusiness();
        }
        if ("pay".equals(businessType)) {
            return new PayBusiness();
        }
        return new ReceiveBusiness();
    }

    static class ReceiveBusiness
    implements IRevPayRuleEditPlugin {
        ReceiveBusiness() {
        }

        @Override
        public void changeHandleScheme(ComboEdit eHandleScheme, IDataModel dataModel, int entryEntity) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(RecPayRuleTypeEnum.RECV.getName()));
            comboItem.setValue(RecPayRuleTypeEnum.RECV.getValue());
            comboItems.add(comboItem);
            ComboItem comboItemRule = new ComboItem();
            comboItemRule.setCaption(new LocaleString(RecPayRuleTypeEnum.RULE.getName()));
            comboItemRule.setValue(RecPayRuleTypeEnum.RULE.getValue());
            comboItems.add(comboItemRule);
            eHandleScheme.setComboItems(comboItems);
            if (dataModel == null) {
                return;
            }
            for (int i = 0; i < entryEntity; ++i) {
                dataModel.setValue("e_handlescheme", (Object)RecPayRuleTypeEnum.RECV.getValue(), i);
            }
        }
    }

    static class PayBusiness
    implements IRevPayRuleEditPlugin {
        PayBusiness() {
        }

        @Override
        public void changeHandleScheme(ComboEdit eHandleScheme, IDataModel dataModel, int entryEntity) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(RecPayRuleTypeEnum.PAY.getName()));
            comboItem.setValue(RecPayRuleTypeEnum.PAY.getValue());
            comboItems.add(comboItem);
            ComboItem comboItemRule = new ComboItem();
            comboItemRule.setCaption(new LocaleString(RecPayRuleTypeEnum.RULE.getName()));
            comboItemRule.setValue(RecPayRuleTypeEnum.RULE.getValue());
            comboItems.add(comboItemRule);
            eHandleScheme.setComboItems(comboItems);
            if (dataModel == null) {
                return;
            }
            for (int i = 0; i < entryEntity; ++i) {
                dataModel.setValue("e_handlescheme", (Object)RecPayRuleTypeEnum.PAY.getValue(), i);
            }
        }
    }

    static class TicketBusiness
    implements IRevPayRuleEditPlugin {
        TicketBusiness() {
        }

        @Override
        public void changeHandleScheme(ComboEdit eHandleScheme, IDataModel dataModel, int entryEntity) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(RecPayRuleTypeEnum.TICKET.getName()));
            comboItem.setValue(RecPayRuleTypeEnum.TICKET.getValue());
            comboItems.add(comboItem);
            eHandleScheme.setComboItems(comboItems);
            if (dataModel == null) {
                return;
            }
            for (int i = 0; i < entryEntity; ++i) {
                dataModel.setValue("e_handlescheme", (Object)RecPayRuleTypeEnum.TICKET.getValue(), i);
            }
        }
    }

    static class Singleton {
        private static RevPayRuleEditFactory instance = new RevPayRuleEditFactory();

        Singleton() {
        }
    }
}

