/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.reconciliation;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.cas.enums.MatchPlanEnum;
import kd.fi.cas.helper.CasHelper;

public class ApplicableConditionsPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initFieldColumn();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        String matchplanInfo = (String)customParams.get("matchplanInfo");
        if (matchplanInfo != null && !CasHelper.isEmpty((Object)matchplanInfo)) {
            List list = (List)SerializationUtils.fromJsonString((String)matchplanInfo, List.class);
            IDataModel model = this.getModel();
            for (Map map : list) {
                int index = model.createNewEntryRow("entryentity");
                Set entrySet = map.entrySet();
                for (Map.Entry entry : entrySet) {
                    model.setValue((String)entry.getKey(), entry.getValue(), index);
                }
                if (map.containsKey("isallnullmatch")) continue;
                model.setValue("isallnullmatch", map.get("isnullmatch"), index);
            }
        } else {
            IDataModel model = this.getModel();
            model.createNewEntryRow("entryentity");
            model.setValue("bankjournal", (Object)"creditamount", 0);
            model.setValue("condition", (Object)MatchPlanEnum.EQUALS.getValue(), 0);
            model.setValue("bankstatement", (Object)"debitamount", 0);
            model.createNewEntryRow("entryentity");
            model.setValue("bankjournal", (Object)"debitamount", 1);
            model.setValue("condition", (Object)MatchPlanEnum.EQUALS.getValue(), 1);
            model.setValue("bankstatement", (Object)"creditamount", 1);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"num"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                if (!this.verify()) break;
                this.returnDataToParent();
                break;
            }
            case "btncancel": {
                this.getView().close();
            }
        }
    }

    private boolean verify() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntitys = model.getEntryEntity("entryentity");
        if (!entryEntitys.isEmpty()) {
            StringBuilder blankLineBuf = new StringBuilder();
            StringBuilder blankLineNumBuf = new StringBuilder();
            String blankLine = null;
            String blankLineNum = null;
            String errMessage = null;
            for (int i = 0; i < entryEntitys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntitys.get(i);
                int temp = i + 1;
                if (entry.get("bankjournal") == null || entry.get("condition") == null || entry.get("bankstatement") == null || CasHelper.isEmpty((Object)entry.get("bankjournal")) || CasHelper.isEmpty((Object)entry.get("condition")) || CasHelper.isEmpty((Object)((Object)((Object)this)).equals(entry.get("bankstatement")))) {
                    blankLineBuf.append(temp).append(",");
                    continue;
                }
                if (MatchPlanEnum.DIFF != entry.get("condition") || entry.get("num") != null && !CasHelper.isEmpty((Object)entry.get("num"))) continue;
                blankLineNumBuf.append(temp).append(",");
            }
            if (blankLineBuf.length() > 0) {
                blankLine = blankLineBuf.substring(0, blankLineBuf.length() - 1);
                errMessage = ResManager.loadKDString((String)"\u7b2c", (String)"ApplicableConditionsPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]) + blankLine + ResManager.loadKDString((String)"\u884c\u6709\u672a\u5f55\u5165\u5b57\u6bb5\uff0c\u8bf7\u5f55\u5165\u3002", (String)"ApplicableConditionsPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (blankLineNumBuf.length() > 0) {
                blankLineNum = blankLineNumBuf.substring(0, blankLineNumBuf.length() - 1);
                errMessage = errMessage == null ? ResManager.loadKDString((String)"\u7b2c", (String)"ApplicableConditionsPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]) + blankLineNum + ResManager.loadKDString((String)"\u884c\u8bf7\u9009\u62e9\u76f8\u5dee\u5c0f\u4e8e\u7684\u5929\u6570", (String)"MatchPlanPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]) : errMessage + ";" + ResManager.loadKDString((String)"\u7b2c", (String)"ApplicableConditionsPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]) + blankLineNum + ResManager.loadKDString((String)"\u884c\u8bf7\u9009\u62e9\u76f8\u5dee\u5c0f\u4e8e\u7684\u5929\u6570", (String)"MatchPlanPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (errMessage != null) {
                errMessage = errMessage.substring(1);
                this.getView().showTipNotification(errMessage);
                return false;
            }
        }
        return true;
    }

    private void returnDataToParent() {
        IDataModel model = this.getModel();
        HashMap<String, String> data = new HashMap<String, String>();
        DynamicObjectCollection entryEntitys = model.getEntryEntity("entryentity");
        if (entryEntitys.size() > 0) {
            ArrayList list = new ArrayList();
            String e_datafilterdesc = "";
            StringBuilder descBuilder = new StringBuilder();
            EntityTypeUtil entityTypeUtil2 = new EntityTypeUtil();
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            block16: for (DynamicObject entrydy : entryEntitys) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("bankjournal", entrydy.get("bankjournal"));
                map.put("condition", entrydy.get("condition"));
                map.put("bankstatement", entrydy.get("bankstatement"));
                map.put("isnullmatch", entrydy.get("isnullmatch"));
                map.put("isallnullmatch", entrydy.get("isallnullmatch"));
                map.put("num", entrydy.get("num"));
                list.add(map);
                String bankjournal = entrydy.getString("bankjournal");
                String condition = entrydy.getString("condition");
                String bankstatement = entrydy.getString("bankstatement");
                MainEntityType entityType2 = EntityMetadataCache.getDataEntityType((String)"cas_bankstatement");
                List filterFields2 = entityTypeUtil2.getFilterFields((IDataEntityType)entityType2);
                for (FilterField field : filterFields2) {
                    LocaleString caption = field.getCaption();
                    String fullFieldName = field.getFullFieldName();
                    if (!fullFieldName.equals(bankstatement)) continue;
                    descBuilder.append(" and ").append('\'').append(caption).append('\'');
                    break;
                }
                switch (condition) {
                    case "equals": {
                        descBuilder.append(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"ApplicableConditionsPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "diff": {
                        descBuilder.append(ResManager.loadKDString((String)"\u76f8\u5dee\u5c0f\u4e8e", (String)"ApplicableConditionsPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0])).append(entrydy.getString("num")).append(ResManager.loadKDString((String)"\u5929 ", (String)"ApplicableConditionsPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "like": {
                        descBuilder.append(ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d(\u5de6\u5305\u542b\u53f3)", (String)"ApplicableConditionsPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "likeright": {
                        descBuilder.append(ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d(\u53f3\u5305\u542b\u5de6)", (String)"ApplicableConditionsPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "likeboth": {
                        descBuilder.append(ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d(\u53cc\u5411)", (String)"ApplicableConditionsPlugin_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "contain": {
                        descBuilder.append(ResManager.loadKDString((String)"\u5305\u542b", (String)"ApplicableConditionsPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    }
                }
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_bankjournal");
                List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
                for (FilterField field : filterFields) {
                    LocaleString caption = field.getCaption();
                    String fullFieldName = field.getFullFieldName();
                    if (!fullFieldName.equals(bankjournal)) continue;
                    descBuilder.append('\'').append(caption).append('\'');
                    continue block16;
                }
            }
            e_datafilterdesc = descBuilder.toString();
            String jsonString = SerializationUtils.toJsonString(list);
            data.put("matchplanInfo", jsonString);
            data.put("displayInfo", e_datafilterdesc.substring(5));
        } else {
            data.put("matchplanInfo", null);
            data.put("displayInfo", "");
        }
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        block3 : switch (name = e.getProperty().getName()) {
            case "condition": {
                String format;
                LocaleString caption;
                IDataEntityProperty fieldProp;
                List filterFields;
                EntityTypeUtil entityTypeUtil;
                MainEntityType entityType;
                if (newValue != null && (model.getValue("bankstatement") == null || CasHelper.isEmpty((Object)model.getValue("bankstatement")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u94f6\u884c\u5bf9\u8d26\u5355\u5b57\u6bb5\uff0c\u518d\u8bbe\u7f6e\u5339\u914d\u5173\u7cfb\u3002", (String)"ApplicableConditionsPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    model.setValue("condition", null);
                }
                if (!MatchPlanEnum.DIFF.getValue().equals(newValue)) {
                    model.setValue("num", null);
                }
                if (MatchPlanEnum.DIFF.getValue().equals(newValue)) {
                    entityType = EntityMetadataCache.getDataEntityType((String)"cas_bankstatement");
                    entityTypeUtil = new EntityTypeUtil();
                    filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
                    for (FilterField filterField : filterFields) {
                        fieldProp = filterField.getFieldProp();
                        if (!filterField.getFullFieldName().equals(model.getValue("bankstatement")) || fieldProp instanceof DateProp || fieldProp instanceof TimeProp || fieldProp instanceof DateTimeProp || fieldProp instanceof ModifyDateProp || fieldProp instanceof CreateDateProp) continue;
                        caption = filterField.getCaption();
                        format = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5339\u914d\u5173\u7cfb\u201c%1$s\u201d\u4e0e\u60a8\u9009\u62e9\u7684\u94f6\u884c\u5bf9\u8d26\u5355\u5b57\u6bb5\u201c%2$s\u201d\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ApplicableConditionsPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76f8\u5dee\u5c0f\u4e8e", (String)"ApplicableConditionsPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), caption);
                        format = format.substring(2);
                        model.setValue("condition", null);
                        this.getView().showTipNotification(format);
                        break;
                    }
                }
                if (!MatchPlanEnum.LIKE.getValue().equals(newValue)) break;
                entityType = EntityMetadataCache.getDataEntityType((String)"cas_bankstatement");
                entityTypeUtil = new EntityTypeUtil();
                filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
                for (FilterField filterField : filterFields) {
                    fieldProp = filterField.getFieldProp();
                    if (!filterField.getFullFieldName().equals(model.getValue("bankstatement")) || fieldProp instanceof TextProp) continue;
                    caption = filterField.getCaption();
                    format = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5339\u914d\u5173\u7cfb\u201c%1$s\u201d\u4e0e\u60a8\u9009\u62e9\u7684\u94f6\u884c\u5bf9\u8d26\u5355\u5b57\u6bb5\u201c%2$s\u201d\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ApplicableConditionsPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d", (String)"ApplicableConditionsPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), caption);
                    format = format.substring(6);
                    model.setValue("condition", null);
                    this.getView().showTipNotification(format);
                    break block3;
                }
                break;
            }
        }
    }

    private void initFieldColumn() {
        ComboEdit fields1 = (ComboEdit)this.getControl("bankjournal");
        MainEntityType entityType1 = EntityMetadataCache.getDataEntityType((String)"cas_bankjournal");
        EntityTypeUtil entityTypeUtil1 = new EntityTypeUtil();
        List filterFields1 = entityTypeUtil1.getFilterFields((IDataEntityType)entityType1);
        ArrayList<ComboItem> items1 = new ArrayList<ComboItem>(filterFields1.size());
        for (FilterField field : filterFields1) {
            LocaleString caption1 = field.getCaption();
            String fullFieldName1 = field.getFullFieldName();
            ComboItem item1 = new ComboItem(caption1, fullFieldName1);
            items1.add(item1);
        }
        ComboEdit fields2 = (ComboEdit)this.getControl("bankstatement");
        MainEntityType entityType2 = EntityMetadataCache.getDataEntityType((String)"cas_bankstatement");
        EntityTypeUtil entityTypeUtil2 = new EntityTypeUtil();
        List filterFields2 = entityTypeUtil2.getFilterFields((IDataEntityType)entityType2);
        ArrayList<ComboItem> items2 = new ArrayList<ComboItem>(filterFields2.size());
        for (FilterField field2 : filterFields2) {
            LocaleString caption2 = field2.getCaption();
            String fullFieldName2 = field2.getFullFieldName();
            if ("transtime".equals(fullFieldName2)) continue;
            ComboItem item2 = new ComboItem(caption2, fullFieldName2);
            items2.add(item2);
        }
        fields1.setComboItems(items1);
        fields2.setComboItems(items2);
    }
}

