/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.recpayrule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.EntityFieldTreeOption;
import kd.fi.cas.util.EntityFieldTreeResult;
import kd.fi.cas.util.EntityTreeUtil;
import kd.fi.cas.util.ExpressionType;

public class RecPayRuleEdit
extends AbstractBasePlugIn
implements ClickListener {
    private static final String NON_FIELDS = "non_fields";
    private static Map<String, String> mapFields = new HashMap<String, String>(4);

    public RecPayRuleEdit() {
        mapFields.put("e_rulesname", ResManager.loadKDString((String)"\u89c4\u5219\u9879\u540d\u79f0", (String)"RecPayRuleEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        mapFields.put("e_handlescheme", ResManager.loadKDString((String)"\u5904\u7406\u65b9\u6848", (String)"RecPayRuleEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        mapFields.put("e_paymenttype", ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b", (String)"RecPayRuleEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        mapFields.put("e_payeetype", ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b", (String)"RecPayRuleEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"e_datafilterdesc"});
        this.fillOrgF7();
    }

    private void fillOrgF7() {
        BasedataEdit uOrgF7 = (BasedataEdit)this.getControl("u_org");
        uOrgF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            List orgList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"cas_recpayrule", (String)"47156aff000000ac");
            showParameter.setCustomParam("range", (Object)orgList);
            DynamicObjectCollection uEntryDOC = this.getModel().getEntryEntity("org_entry");
            int row = evt.getRow();
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)uEntryDOC)) {
                ArrayList<Long> yetChooseIdList = new ArrayList<Long>(10);
                for (int i = 0; i < uEntryDOC.size(); ++i) {
                    DynamicObject uEntryDO = (DynamicObject)uEntryDOC.get(i);
                    if (i == row || !EmptyUtil.isNoEmpty((DynamicObject)uEntryDO) || !EmptyUtil.isNoEmpty((DynamicObject)uEntryDO.getDynamicObject("u_org"))) continue;
                    yetChooseIdList.add((Long)uEntryDO.getDynamicObject("u_org").getPkValue());
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList).and(new QFilter("id", "not in", yetChooseIdList)));
            } else {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
            }
        });
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "e_datafilterdesc": {
                int index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.fillFields("e_datafilter", ExpressionType.Condition, false, null);
                this.showConditionForm(index, "e_datafilter", this.getPageCache().get("e_datafilter"));
            }
        }
    }

    private void showConditionForm(int rowIndex, String sourceCtrlKey, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_condition");
        String conditionJson = (String)this.getModel().getValue(sourceCtrlKey + "_TAG", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        String handle = (String)this.getModel().getValue("biztype");
        String entity = "recticket".equals(handle) ? "cdm_receivablebill" : ("electicket".equals(handle) ? "cdm_electronic_sign_deal" : "bei_transdetail_cas");
        showParameter.getCustomParams().put("entitynumber", entity);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("e_datafilter".equals(e.getActionId())) {
            this.receiveExpressionSet(e, "entryentity", "e_datafilter", "e_datafilter");
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey, String descFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
                this.getModel().setValue(expressionFldKey + "_TAG", (Object)str, row);
                String desp = "";
                if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                    desp = filterObj.getExprTran();
                }
                if (desp.length() > 1024) {
                    desp = desp.substring(0, 1024);
                }
                this.getModel().setValue("e_datafilterdesc", (Object)desp, row);
            }
        }
    }

    private void fillFields(String key, ExpressionType type, boolean readChildEntity, Class<?> cls) {
        MainEntityType srcMainET = this.readSrcMainET();
        if (srcMainET == null) {
            this.getPageCache().put(key, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(readChildEntity);
            option.setExprType(type);
            option.setFieldType(cls);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(key, toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    private MainEntityType readSrcMainET() {
        return EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus == OperationStatus.ADDNEW) {
            this.setVisibleStatus();
        }
        if (opStatus == OperationStatus.EDIT) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"biztype"});
            String biztype = this.getModel().getValue("biztype").toString();
            if (biztype.equals("rec") || biztype.equals("recticket") || biztype.equals("electicket")) {
                this.setVisibleStatus();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (propName) {
            case "biztype": {
                if (newValue.equals("rec") || newValue.equals("recticket") || newValue.equals("electicket")) {
                    this.setVisibleStatus();
                    if (row == -1) break;
                    this.getModel().setValue("e_paymenttype", (Object)"");
                    this.getModel().setValue("e_payeetype", (Object)"");
                    this.getModel().setValue("e_paymenttypestr", (Object)"");
                    this.getModel().setValue("e_payeetypestr", (Object)"");
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_paymenttype", "e_payeetype"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_receivingtype", "e_payertype"});
                if (row == -1) break;
                this.getModel().setValue("e_receivingtype", (Object)"");
                this.getModel().setValue("e_payertype", (Object)"");
                break;
            }
            case "e_receivingtype": {
                this.setTypeVisible(e, "e_payertype", "e_receivingtype", "ispartreceivable", "rec");
                break;
            }
            case "e_paymenttype": {
                this.setTypeVisible(e, "e_payeetype", "e_paymenttype", "ispartpayment", "pay");
                break;
            }
            case "e_datafilterdesc": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getPageCache().put("e_datafilter", "");
                this.getModel().setValue("e_datafilter", (Object)"", rowIndex);
                this.getModel().setValue("e_datafilter_TAG", (Object)"", rowIndex);
            }
        }
    }

    private void setTypeVisible(PropertyChangedArgs e, String payer_payeeType, String rec_payType, String isPartProp, String type) {
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        if (CasHelper.isEmpty((Object)newValue)) {
            this.getModel().setValue(payer_payeeType, (Object)"");
            return;
        }
        if (newValue.equals(oldValue)) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboEdit payerTypeField = (ComboEdit)this.getControl(payer_payeeType);
        ComboItem customerCI = new ComboItem();
        customerCI.setCaption(new LocaleString(AsstActTypeEnum.CUSTOMER.getName()));
        customerCI.setValue(AsstActTypeEnum.CUSTOMER.getValue());
        ComboItem supplierCI = new ComboItem();
        supplierCI.setCaption(new LocaleString(AsstActTypeEnum.SUPPLIER.getName()));
        supplierCI.setValue(AsstActTypeEnum.SUPPLIER.getValue());
        ComboItem employeeCI = new ComboItem();
        employeeCI.setCaption(new LocaleString(AsstActTypeEnum.EMPLOYEE.getName()));
        employeeCI.setValue(AsstActTypeEnum.EMPLOYEE.getValue());
        ComboItem companyCI = new ComboItem();
        companyCI.setCaption(new LocaleString(AsstActTypeEnum.COMPANY.getName()));
        companyCI.setValue(AsstActTypeEnum.COMPANY.getValue());
        ComboItem otherCI = new ComboItem();
        otherCI.setCaption(new LocaleString(AsstActTypeEnum.OTHER.getName()));
        otherCI.setValue(AsstActTypeEnum.OTHER.getValue());
        DynamicObject receivingtype = (DynamicObject)this.getModel().getValue(rec_payType);
        if (!CasHelper.isEmpty((Object)receivingtype)) {
            boolean ispart = receivingtype.getBoolean(isPartProp);
            if (ispart) {
                comboItems.add(customerCI);
                comboItems.add(supplierCI);
                payerTypeField.setComboItems(comboItems);
                if (type.equals("rec")) {
                    this.getModel().setValue(payer_payeeType, (Object)AsstActTypeEnum.CUSTOMER.getValue());
                } else {
                    this.getModel().setValue(payer_payeeType, (Object)AsstActTypeEnum.SUPPLIER.getValue());
                }
            } else {
                comboItems.add(customerCI);
                comboItems.add(supplierCI);
                comboItems.add(employeeCI);
                comboItems.add(companyCI);
                comboItems.add(otherCI);
                payerTypeField.setComboItems(comboItems);
                this.getModel().setValue(payer_payeeType, (Object)AsstActTypeEnum.OTHER.getValue());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        String opKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && StringUtils.equals((CharSequence)(opKey = (oper = (AbstractOperate)args.getSource()).getOperateKey()), (CharSequence)"save")) {
            int row = this.getModel().getEntryRowCount("entryentity");
            if (row == 0) {
                return;
            }
            if (this.checkDraft()) {
                args.setCancel(true);
            }
        }
    }

    private void setVisibleStatus() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"e_receivingtype", "e_payertype"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"e_paymenttype", "e_payeetype"});
    }

    private boolean checkDraft() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return true;
        }
        Set sets = rows.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getString("e_rulesname"))).map(o -> o.getString("e_rulesname")).collect(Collectors.toSet());
        if (sets.size() > 0 && sets.size() < rows.size()) {
            Object number = this.getModel().getValue("number");
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s: \u672a\u5f55\u5165\u6216\u91cd\u590d\u547d\u540d\u89c4\u5219\u9879\uff0c\u8bf7\u6b63\u786e\u5f55\u5165\u6216\u68c0\u67e5\u4fee\u6539\u3002", (String)"RecPayRuleEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), number));
            return true;
        }
        int index = 0;
        for (DynamicObject row : rows) {
            boolean flag;
            ++index;
            String biztype = this.getModel().getValue("biztype").toString();
            String e_rulesname = row.getString("e_rulesname");
            if (biztype.equals("rec") || biztype.equals("recticket") || biztype.equals("electicket") || biztype.equals("pay")) {
                String e_handlescheme = row.getString("e_handlescheme");
                HashMap<String, String> checkMap = new HashMap<String, String>(2);
                checkMap.put("e_rulesname", e_rulesname);
                checkMap.put("e_handlescheme", e_handlescheme);
                String getResult = this.checkFields(checkMap);
                if (!StringUtils.isNotEmpty((CharSequence)getResult)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\uff0c\u7b2c%1$s\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RecPayRuleEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), index, getResult));
                return true;
            }
            String e_paymenttype = row.getString("e_paymenttype");
            String e_payeetype = row.getString("e_payeetype");
            if (!StringUtils.isEmpty((CharSequence)e_rulesname) && !StringUtils.isEmpty((CharSequence)e_paymenttype) && !StringUtils.isEmpty((CharSequence)e_payeetype)) continue;
            String handleBill = row.getString("e_handlebill");
            boolean bl = flag = "upbill".equals(handleBill) || "downbill".equals(handleBill);
            if (flag) {
                return false;
            }
            HashMap<String, String> proofMap = new HashMap<String, String>(3);
            proofMap.put("e_rulesname", e_rulesname);
            proofMap.put("e_paymenttype", e_paymenttype);
            proofMap.put("e_payeetype", e_payeetype);
            String getResult = this.checkFields(proofMap);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5165\u8d26\u89c4\u5219\uff0c\u7b2c%1$s\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RecPayRuleEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), index, getResult));
            return true;
        }
        return false;
    }

    private String checkFields(Map<String, String> fields) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        for (Map.Entry<String, String> field : fields.entrySet()) {
            String key = field.getKey();
            String value = field.getValue();
            if (!StringUtils.isEmpty((CharSequence)value)) continue;
            sb.append(mapFields.get(key));
            sb.append("\u3001");
        }
        if (sb.length() > 0) {
            result = sb.substring(0, sb.length() - 1);
        }
        return result;
    }
}

