/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.refund;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.formplugin.refund.RefundCommonFormPlugin;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.pojo.ReceiptRefund;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RefundReleBillPlugin
extends RefundCommonFormPlugin {
    private static final Log logger = LogFactory.getLog(RefundReleBillPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.setDynamicBillTitle();
        this.getPageData(null, Collections.singleton("payeebanknum"));
    }

    @Override
    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        List searchFields = evt.getSearchFields();
        HashSet<String> searchKeys = new HashSet<String>(3);
        if (CollectionUtils.isNotEmpty((Collection)searchFields)) {
            for (Map searchField : searchFields) {
                List fieldNames = (List)searchField.get("fieldName");
                searchKeys.addAll(fieldNames);
            }
        }
        this.getPageData(searchText, searchKeys);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (ArrayUtils.isEmpty((int[])selectRows)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c", (String)"RefundReleBillPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String releBillType = (String)showParameter.getCustomParam("releBillType");
            Function<DynamicObject, Long> setEntryIdFun = "cas_agentpaybill".equals(releBillType) ? entry -> entry.getLong("entryid") : entry -> null;
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
            ArrayList<ReceiptRefund> refundList = new ArrayList<ReceiptRefund>(selectRows.length);
            for (int rowIdx : selectRows) {
                DynamicObject entry2 = (DynamicObject)entryList.get(rowIdx);
                ReceiptRefund refundInfo = new ReceiptRefund();
                refundInfo.setId(entry2.getLong("id"));
                refundInfo.setBillType(releBillType);
                refundInfo.setEntryid(setEntryIdFun.apply(entry2));
                refundList.add(refundInfo);
            }
            this.getView().returnDataToParent(refundList);
            this.getView().close();
        }
    }

    private void setDynamicBillTitle() {
        Label labelTitle = (Label)this.getControl("labeltitle");
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String releBillType = (String)showParameter.getCustomParam("releBillType");
        String titleName = "cas_paybill".equals(releBillType) ? ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406", (String)"CasWorkFlowService_1", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ("cas_agentpaybill".equals(releBillType) ? ResManager.loadKDString((String)"\u4ee3\u53d1\u5904\u7406", (String)"CasWorkFlowService_2", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406", (String)"RefundReleBillPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        labelTitle.setText(titleName);
    }

    private void getPageData(String searchText, Set<String> searchKeys) {
        String releBillType;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object revBillId = showParameter.getCustomParam("revBillId");
        if (revBillId == null) {
            return;
        }
        DynamicObject revbill = BusinessDataServiceHelper.loadSingle((Object)revBillId, (String)"cas_recbill");
        if (searchText == null) {
            searchText = revbill.getString("payeracctbanknum");
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("payeebanknum", searchText);
            clientViewProxy.invokeControlMethod("searchap", "setSearchCondition", new Object[]{map});
        }
        List<ReceiptRefund> dataList = "cas_paybill".equals(releBillType = (String)showParameter.getCustomParam("releBillType")) ? this.loadPayBills(searchText, searchKeys) : ("ifm_transhandlebill".equals(releBillType) ? this.loadTransHandleBills(revbill, searchText, searchKeys) : this.loadAgentBills(searchText, searchKeys));
        this.addRows(dataList);
    }

    public List<ReceiptRefund> loadPayBills(String searchText, Set<String> searchKeys) {
        DynamicObject[] payBills;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long revBillId = (Long)showParameter.getCustomParam("revBillId");
        String operateKey = (String)showParameter.getCustomParam("operateKey");
        List<QFilter> lstFilters = RefundReleBillPlugin.buildSearchFilter(searchText, searchKeys, "payeename", "payeebanknum");
        lstFilters.add(new QFilter("totalremainrefundamt", "!=", (Object)BigDecimal.ZERO));
        lstFilters.add(new QFilter("entrustorg", "=", (Object)0).or("entrustorg", "is null", null));
        lstFilters.add(new QFilter("settletype.settlementtype", "!=", (Object)SettleMentTypeEnum.CREDITOPEN.getValue()));
        if ("refund".equals(operateKey)) {
            lstFilters.add(new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.PAY.getValue(), BillStatusEnum.REFUND.getValue()}));
            lstFilters.add(new QFilter("billtype", "not in", Arrays.asList(BillTypeConstants.PAYBILL_SYN, BillTypeConstants.PAYBILL_SPAN)));
            payBills = RefundHelper.loadPaymentBillsRefund((Long)revBillId, lstFilters);
        } else {
            lstFilters.add(new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.PAY.getValue(), BillStatusEnum.RENOTE.getValue()}));
            payBills = RefundHelper.loadPaymentBillsRenote((Long)revBillId, lstFilters);
        }
        return Stream.of(payBills).map(b -> new ReceiptRefund(b, "cas_paybill")).collect(Collectors.toList());
    }

    private List<ReceiptRefund> loadTransHandleBills(DynamicObject recbill, String searchText, Set<String> searchKeys) {
        List<QFilter> filters = RefundReleBillPlugin.buildSearchFilter(searchText, searchKeys, "payeename", "payeebanknum");
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String operateKey = (String)showParameter.getCustomParam("operateKey");
        if ("refund".equals(operateKey)) {
            filters.add(new QFilter("payee", "=", recbill.get("payer")));
        } else {
            filters.add(new QFilter("agentpayeraccount.id", "=", (Object)recbill.getLong("accountbank.id")));
        }
        DynamicObjectCollection billList = RefundHelper.loadIfmTransHandleBills((DynamicObject)recbill, filters);
        return billList.stream().map(b -> new ReceiptRefund(b, "ifm_transhandlebill")).collect(Collectors.toList());
    }

    private List<ReceiptRefund> loadAgentBills(String searchText, Set<String> searchKeys) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long revBillId = (Long)showParameter.getCustomParam("revBillId");
        String operateKey = (String)showParameter.getCustomParam("operateKey");
        List<QFilter> qFilters = RefundReleBillPlugin.buildSearchFilter(searchText, searchKeys, "entry.payeename", "entry.payeeacctbank");
        qFilters.add(new QFilter("delegorg", "=", (Object)0).or("delegorg", "is null", null));
        boolean searchPayee = searchKeys.size() == 1 && searchKeys.contains("payee");
        boolean searchBankNum = searchKeys.size() == 1 && searchKeys.contains("payeebanknum");
        DynamicObject[] agentBills = "refund".equals(operateKey) ? RefundHelper.loadAgentPayBillsRefund((Long)revBillId, qFilters) : RefundHelper.loadAgentPayBillsRenote((Long)revBillId, qFilters);
        ArrayList<ReceiptRefund> dataList = new ArrayList<ReceiptRefund>(agentBills.length);
        for (DynamicObject bill : agentBills) {
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryList) {
                if (entry.getBigDecimal("e_remainrefundamt").compareTo(BigDecimal.ZERO) == 0 || !entry.getBoolean("e_issuccess")) continue;
                boolean containsPayeeName = StringUtils.contains((CharSequence)entry.getString("payeename"), (CharSequence)searchText);
                boolean containsAcct = StringUtils.contains((CharSequence)entry.getString("payeeacctbank"), (CharSequence)searchText);
                if (searchPayee && !containsPayeeName || searchBankNum && !containsAcct) continue;
                dataList.add(new ReceiptRefund(bill, entry));
            }
        }
        return dataList;
    }

    private static List<QFilter> buildSearchFilter(String searchText, Set<String> searchKeys, String payeeNameKey, String payeeBankNumKey) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(2);
        if (searchKeys.isEmpty() && StringUtils.isEmpty((CharSequence)searchText)) {
            return lstFilters;
        }
        QFilter searchFilter = null;
        if (searchKeys.contains("payee")) {
            searchFilter = new QFilter(payeeNameKey, "ftlike", (Object)searchText);
        }
        if (searchKeys.contains("payeebanknum")) {
            QFilter payeeBankNumFilter = new QFilter(payeeBankNumKey, "ftlike", (Object)searchText);
            QFilter qFilter = searchFilter = searchFilter == null ? payeeBankNumFilter : searchFilter.or(payeeBankNumFilter);
        }
        if (searchKeys.contains("billno")) {
            QFilter billNoFilter = new QFilter("billno", "=", (Object)searchText);
            QFilter qFilter = searchFilter = searchFilter == null ? billNoFilter : searchFilter.or(billNoFilter);
        }
        if (searchFilter != null) {
            lstFilters.add(searchFilter);
        }
        return lstFilters;
    }
}

