/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.refund;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.consts.RefundConstants;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.DynamicListHelper;
import kd.fi.cas.pojo.ReceiptRefund;
import org.apache.commons.lang3.ObjectUtils;

public class RefundRenoteFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(RefundRenoteFormPlugin.class);
    private static final String SELECT_RELE_BILL_ACTION = "select_rele_bill_action";
    private static final String RELE_WITH_INFO = "relewithinfo";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"relebill"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object revId = showParameter.getCustomParam("billId");
        MainEntityType recBillType = EntityMetadataCache.getDataEntityType((String)"cas_recbill");
        DynamicObject revBill = BusinessDataServiceHelper.loadSingle((Object)revId, (DynamicObjectType)recBillType);
        this.setTitle();
        this.loadRecBillData(revBill);
        this.initComboItemList(revBill);
        this.setReleWithInfoAndBillsVisable((String)this.getModel().getValue("relebilltype"));
        this.clearReleBillList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        ChangeData changeData = e.getChangeSet()[0];
        if (RELE_WITH_INFO.equals(property.getName())) {
            this.payBillListVisible((Boolean)changeData.getNewValue());
            if (!"cas_paybill".equals(this.getModel().getValue("relebilltype"))) {
                return;
            }
            DynamicObjectCollection payBillList = this.getModel().getEntryEntity("relebilllist");
            if (CollectionUtils.isEmpty((Collection)payBillList)) {
                return;
            }
            Set<Long> payIds = payBillList.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
            this.loadPayBillList(payIds, true);
            this.setPayBillReleWhitInfoEnable();
        } else if ("relebilltype".equals(property.getName())) {
            this.setReleWithInfoAndBillsVisable((String)changeData.getNewValue());
            this.clearReleBillList();
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("relebill".equals(source.getKey())) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Object revId = showParameter.getCustomParam("billId");
            String operateKey = (String)showParameter.getCustomParam("operateKey");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("cas_refund_rela");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("revBillId", revId);
            parameter.setCustomParam("operateKey", (Object)operateKey);
            parameter.setCustomParam("releBillType", this.getModel().getValue("relebilltype"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_RELE_BILL_ACTION));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (SELECT_RELE_BILL_ACTION.equals(actionId)) {
            List refundList = (List)evt.getReturnData();
            if (CollectionUtils.isEmpty((Collection)refundList)) {
                return;
            }
            String billType = ((ReceiptRefund)refundList.get(0)).getBillType();
            if ("cas_paybill".equals(billType)) {
                Set<Long> payIds = refundList.stream().map(ReceiptRefund::getId).collect(Collectors.toSet());
                this.loadPayBillList(payIds, false);
                this.setPayBillReleWhitInfoEnable();
            } else if ("cas_agentpaybill".equals(billType)) {
                this.loadAgentBillList(refundList);
            } else if ("ifm_transhandlebill".equals(billType)) {
                this.loadIfmBillList(refundList);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "addrelebill": {
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                Object revId = showParameter.getCustomParam("billId");
                String operateKey = (String)showParameter.getCustomParam("operateKey");
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("cas_refund_rela");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("revBillId", revId);
                parameter.setCustomParam("operateKey", (Object)operateKey);
                parameter.setCustomParam("releBillType", this.getModel().getValue("relebilltype"));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_RELE_BILL_ACTION));
                this.getView().showForm(parameter);
                break;
            }
            case "deleteentry": {
                this.setPayBillReleWhitInfoEnable();
            }
        }
    }

    private void setPayBillReleWhitInfoEnable() {
        if ("cas_paybill".equals(this.getModel().getValue("relebilltype"))) {
            DynamicObjectCollection releBillList = this.getModel().getEntryEntity("relebilllist");
            boolean enable = releBillList.isEmpty() || releBillList.stream().noneMatch(r -> r.getBoolean("isdiffcur"));
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{RELE_WITH_INFO});
        }
    }

    private void loadRecBillData(DynamicObject revBill) {
        EntryGrid revlist = (EntryGrid)this.getControl("revlist");
        Set revFields = revlist.getFieldEdits().stream().map(FieldEdit::getFieldKey).collect(Collectors.toSet());
        IDataModel dataModel = this.getModel();
        for (IDataEntityProperty property : revBill.getDataEntityType().getJsonSerializerProperties()) {
            String propertyName = property.getName();
            if (!revFields.contains(propertyName)) continue;
            dataModel.setValue(propertyName, revBill.get(propertyName), 0);
        }
        dataModel.setValue("revid", (Object)revBill.getLong("id"), 0);
        DynamicObject accountBank = revBill.getDynamicObject("accountbank");
        String bankaccountnumber = Optional.ofNullable(accountBank).map(ac -> ac.getString("bankaccountnumber")).orElse("");
        dataModel.setValue("recaccountnumber", (Object)bankaccountnumber, 0);
        DynamicObjectCollection recInfoList = revBill.getDynamicObjectCollection("entry");
        BigDecimal receivableAmt = BigDecimal.ZERO;
        BigDecimal discountAmt = BigDecimal.ZERO;
        BigDecimal actAmt = BigDecimal.ZERO;
        BigDecimal refundableAmt = BigDecimal.ZERO;
        for (DynamicObject revInfo : recInfoList) {
            BigDecimal eReceivableAmt = (BigDecimal)ObjectUtils.defaultIfNull((Object)revInfo.getBigDecimal("e_receivableamt"), (Object)BigDecimal.ZERO);
            BigDecimal eDiscountAmt = (BigDecimal)ObjectUtils.defaultIfNull((Object)revInfo.getBigDecimal("e_discountamt"), (Object)BigDecimal.ZERO);
            BigDecimal eActAmt = (BigDecimal)ObjectUtils.defaultIfNull((Object)revInfo.getBigDecimal("e_actamt"), (Object)BigDecimal.ZERO);
            receivableAmt = receivableAmt.add(eReceivableAmt);
            discountAmt = discountAmt.add(eDiscountAmt);
            actAmt = actAmt.add(eActAmt);
            refundableAmt = refundableAmt.add(eReceivableAmt);
        }
        dataModel.setValue("receivableamt", (Object)receivableAmt, 0);
        dataModel.setValue("discountamt", (Object)discountAmt, 0);
        dataModel.setValue("actamt", (Object)actAmt, 0);
        dataModel.setValue("refundableamt", (Object)refundableAmt, 0);
    }

    private void loadPayBillList(Set<Long> payIds, boolean releWithInfoChanged) {
        String selectFields;
        QFilter qFilter = new QFilter("id", "in", payIds);
        boolean showEntryField = (Boolean)this.getModel().getValue(RELE_WITH_INFO);
        if (showEntryField) {
            selectFields = String.join((CharSequence)",", RefundConstants.REFUND_PAGE_PAY_BILL_FIELDS);
        } else {
            Set selectFieldSet = RefundConstants.REFUND_PAGE_PAY_BILL_FIELDS.stream().filter(f -> !f.startsWith("entry.")).collect(Collectors.toSet());
            selectFields = String.join((CharSequence)",", selectFieldSet);
        }
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"id");
        if (showEntryField && payBills.stream().anyMatch(p -> p.getBoolean("isdiffcur"))) {
            this.getModel().setValue(RELE_WITH_INFO, (Object)false);
            this.loadPayBillList(payIds, releWithInfoChanged);
            return;
        }
        if (!releWithInfoChanged && this.filterExistsBill((List<DynamicObject>)payBills, showEntryField)) {
            return;
        }
        ArrayList dataList = new ArrayList(payBills.size());
        for (DynamicObject bill : payBills) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(23);
            dataMap.put("id", bill.get("id"));
            dataMap.put("relebillno", bill.get("billno"));
            dataMap.put("relesettletype", bill.get("settletype"));
            dataMap.put("payeracctnum", bill.get("payeracctbank.bankaccountnumber"));
            dataMap.put("isdiffcur", bill.get("isdiffcur"));
            dataMap.put("relecurrency", bill.get("dpcurrency"));
            dataMap.put("payamt", bill.get("dpamt"));
            dataMap.put("reccurrency", bill.get("currency"));
            dataMap.put("recamt", bill.get("actpayamt"));
            dataMap.put("description", bill.get("description"));
            dataMap.put("postscript", bill.get("usage"));
            dataMap.put("itempayeetype", bill.get("payeetype"));
            dataMap.put("payeename", bill.get("payeename"));
            dataMap.put("revaccountnum", bill.get("payeebanknum"));
            dataMap.put("totalremainrefundamt", bill.get("totalremainrefundamt"));
            if (showEntryField) {
                dataMap.put("entryid", bill.get("entry.id"));
                dataMap.put("payableamt", bill.get("entry.e_payableamt"));
                dataMap.put("paydiscountamt", bill.get("entry.e_discountamt"));
                dataMap.put("payactamt", bill.get("entry.e_actamt"));
                dataMap.put("remainrefundamt", bill.get("entry.e_remainrefundamt"));
            }
            dataList.add(dataMap);
        }
        DynamicListHelper.fillEntryList((String)"relebilllist", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataList, (boolean)releWithInfoChanged);
    }

    private boolean filterExistsBill(List<DynamicObject> payBills, boolean showEntryField) {
        DynamicObjectCollection releBillList = this.getModel().getEntryEntity("relebilllist");
        payBills.removeIf(paybill -> this.releListContainsBill(releBillList, (DynamicObject)paybill, showEntryField));
        return payBills.isEmpty();
    }

    private void loadAgentBillList(List<ReceiptRefund> refundList) {
        Set agentIds = refundList.stream().map(ReceiptRefund::getId).collect(Collectors.toSet());
        Set entryIds = refundList.stream().map(ReceiptRefund::getEntryid).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", agentIds).and("entry.id", "in", entryIds);
        String selectFields = String.join((CharSequence)",", RefundConstants.REFUND_PAGE_AGENT_BILL_FIELDS);
        DynamicObjectCollection agentBills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"id");
        if (this.filterExistsBill((List<DynamicObject>)agentBills, true)) {
            return;
        }
        ArrayList dataList = new ArrayList(agentBills.size());
        for (DynamicObject agentBill : agentBills) {
            boolean isEncryption = agentBill.getBoolean("isencryption");
            HashMap<String, Object> dataMap = new HashMap<String, Object>(23);
            dataMap.put("id", agentBill.get("id"));
            dataMap.put("relesettletype", agentBill.get("settletype"));
            dataMap.put("relebillno", agentBill.get("billno"));
            dataMap.put("payeracctnum", agentBill.get("payeracctbank.bankaccountnumber"));
            dataMap.put("relecurrency", agentBill.get("currency"));
            dataMap.put("payamt", agentBill.get("payamount"));
            dataMap.put("description", agentBill.get("description"));
            dataMap.put("itempayeetype", agentBill.get("payeetype"));
            dataMap.put("entryid", agentBill.get("entry.id"));
            dataMap.put("postscript", agentBill.get("entry.e_remark"));
            dataMap.put("payeename", agentBill.get("entry.payeename"));
            dataMap.put("revaccountnum", agentBill.get("entry.payeeacctbank"));
            BigDecimal remainRefundAmt = agentBill.getBigDecimal("entry.e_remainrefundamt");
            dataMap.put("remainrefundamt", remainRefundAmt);
            if (isEncryption) {
                dataMap.put("agententryamt", "**.**");
                dataMap.put("agremainrefundamt", "**.**");
            } else {
                String encryptAmtStr = agentBill.getString("entry.e_encryptamount");
                BigDecimal amt = AgentPayBillHelper.decodeAmount((String)encryptAmtStr);
                dataMap.put("agententryamt", RefundRenoteFormPlugin.convertAmtToStr(agentBill, amt));
                dataMap.put("agremainrefundamt", RefundRenoteFormPlugin.convertAmtToStr(agentBill, remainRefundAmt));
            }
            dataList.add(dataMap);
        }
        DynamicListHelper.fillEntryList((String)"relebilllist", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataList);
    }

    private void loadIfmBillList(List<ReceiptRefund> refundList) {
        Set ifmIds = refundList.stream().map(ReceiptRefund::getId).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ifmIds);
        String selectFields = String.join((CharSequence)",", RefundConstants.IFM_BILL_FIELD_MAPPING.values());
        DynamicObjectCollection agentBills = QueryServiceHelper.query((String)"ifm_transhandlebill", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"id");
        ArrayList dataList = new ArrayList(agentBills.size());
        for (DynamicObject bill : agentBills) {
            HashMap dataMap = new HashMap((int)((double)RefundConstants.IFM_BILL_FIELD_MAPPING.size() / 0.75 + 1.0));
            for (Map.Entry billField : RefundConstants.IFM_BILL_FIELD_MAPPING.entrySet()) {
                dataMap.put(billField.getKey(), bill.get((String)billField.getValue()));
            }
            dataList.add(dataMap);
        }
        DynamicListHelper.fillEntryList((String)"relebilllist", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataList);
    }

    private static String convertAmtToStr(DynamicObject bill, BigDecimal amt) {
        DynamicObject agent = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.get("id"), (String)"cas_agentpaybill", (String)"currency.sign,currency.amtprecision");
        String sign = agent.getString("currency.sign");
        int amtprecision = agent.getInt("currency.amtprecision");
        return sign + amt.setScale(amtprecision, RoundingMode.UNNECESSARY);
    }

    private void payBillListVisible(boolean relewithinfo) {
        if (!"cas_paybill".equals(this.getModel().getValue("relebilltype"))) {
            return;
        }
        IFormView view = this.getView();
        if (relewithinfo) {
            view.setVisible(Boolean.valueOf(true), new String[]{"payableamt", "paydiscountamt", "payactamt", "remainrefundamt"});
            view.setVisible(Boolean.valueOf(false), new String[]{"totalremainrefundamt"});
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"totalremainrefundamt"});
            view.setVisible(Boolean.valueOf(false), new String[]{"payableamt", "paydiscountamt", "payactamt", "remainrefundamt"});
        }
    }

    private void setTitle() {
        Label labelTitle = (Label)this.getControl("title");
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String operateKey = (String)showParameter.getCustomParam("operateKey");
        String titleName = "";
        if ("renote".equals(operateKey)) {
            titleName = ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u7968", (String)"ReceivingBillRefundPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        } else if ("refund".equals(operateKey)) {
            titleName = ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u6b3e", (String)"ReceivingBillRefundPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        labelTitle.setText(titleName);
    }

    private void setReleWithInfoAndBillsVisable(String releBillType) {
        IFormView view = this.getView();
        if ("cas_paybill".equals(releBillType)) {
            this.getModel().setValue(RELE_WITH_INFO, (Object)true);
            view.setEnable(Boolean.valueOf(true), new String[]{RELE_WITH_INFO});
            view.setVisible(Boolean.valueOf(true), new String[]{"payableamt", "paydiscountamt", "payactamt", "remainrefundamt", "reccurrency", "recamt"});
            view.setVisible(Boolean.valueOf(false), new String[]{"agententryamt", "agremainrefundamt", "totalremainrefundamt"});
        } else if ("cas_agentpaybill".equals(releBillType)) {
            this.getModel().setValue(RELE_WITH_INFO, (Object)true);
            view.setEnable(Boolean.valueOf(false), new String[]{RELE_WITH_INFO});
            view.setVisible(Boolean.valueOf(true), new String[]{"agententryamt", "agremainrefundamt"});
            view.setVisible(Boolean.valueOf(false), new String[]{"payableamt", "paydiscountamt", "payactamt", "remainrefundamt", "totalremainrefundamt", "reccurrency", "recamt"});
        } else {
            this.getModel().setValue(RELE_WITH_INFO, (Object)false);
            view.setEnable(Boolean.valueOf(false), new String[]{RELE_WITH_INFO});
            view.setVisible(Boolean.valueOf(false), new String[]{"payableamt", "paydiscountamt", "payactamt", "remainrefundamt", "totalremainrefundamt", "agententryamt", "agremainrefundamt"});
        }
    }

    private void initComboItemList(DynamicObject revBill) {
        ComboEdit relebilltypeCombo = (ComboEdit)this.getControl("relebilltype");
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(2);
        if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(revBill.getString("receivingtype.biztype"))) {
            String ifmName = ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406", (String)"RefundReleBillPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            ComboItem ifmItem = new ComboItem(new LocaleString(ifmName), "ifm_transhandlebill");
            itemList.add(ifmItem);
            relebilltypeCombo.setComboItems(itemList);
            this.getModel().setValue("relebilltype", (Object)"ifm_transhandlebill");
        }
    }

    private void clearReleBillList() {
        this.getModel().deleteEntryData("relebilllist");
    }

    private boolean releListContainsBill(DynamicObjectCollection releBillList, DynamicObject bill, boolean filterEntry) {
        if (CollectionUtils.isEmpty((Collection)releBillList)) {
            return false;
        }
        for (DynamicObject rele : releBillList) {
            if (!(filterEntry ? rele.getLong("id") == bill.getLong("id") && rele.getLong("entryid") == bill.getLong("entry.id") : rele.getLong("id") == bill.getLong("id"))) continue;
            return true;
        }
        return false;
    }
}

