/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.sign;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.sign.ISignExecutor;

public class PayBillPushIfmExecutor
implements ISignExecutor {
    private static Log logger = LogFactory.getLog(PayBillPushIfmExecutor.class);
    private List<DynamicObject> payBillList;
    private String payEntityName;
    private List<Object> needCommitBeIdList;
    private boolean isBankBillAudit;
    private StringBuilder errorMessage = new StringBuilder();

    public PayBillPushIfmExecutor(List<DynamicObject> payBillIdList, String payEntityName, List<Object> needCommitBeIdList, boolean bankBillAudit) {
        this.payBillList = payBillIdList;
        this.payEntityName = payEntityName;
        this.needCommitBeIdList = needCommitBeIdList;
        this.isBankBillAudit = bankBillAudit;
    }

    public List<Object> prepareSignData() {
        this.beforeGeneratePayBill();
        this.commitIfm(this.payBillList);
        return new ArrayList<Object>();
    }

    public OperationResult doSignOperation(List<Object> idList, OperateOption option) {
        return null;
    }

    public void doSignOperateSuccess(List<Object> successIdList) {
    }

    private void beforeGeneratePayBill() {
        for (DynamicObject payBill : this.payBillList) {
            payBill.set("iscommitbe", (Object)true);
            payBill.set("billstatus", (Object)BillStatusEnum.BEING.getValue());
            payBill.set("bankpaystatus", (Object)BeBillStatusEnum.OP.getValue());
            payBill.set("commitbetime", (Object)new Date());
            payBill.set("cashier", (Object)CasHelper.getCurrentUser());
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])this.payBillList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
    }

    private void commitIfm(List<DynamicObject> payBillList) {
        OperationResult opResult = null;
        DynamicObject[] dynamicObjects = (DynamicObject[])payBillList.stream().toArray(DynamicObject[]::new);
        ArrayList rollbackPayBillList = new ArrayList(10);
        try {
            opResult = OperateServiceHelper.execOperate((String)"pushifmandsave", (String)"cas_paybill", (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        if (opResult == null || !opResult.isSuccess()) {
            payBillList.forEach(payBill -> {
                payBill.set("iscommitbe", (Object)"0");
                payBill.set("commitbetime", null);
                payBill.set("bankpaystatus", null);
                payBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                payBill.set("cashier", null);
                rollbackPayBillList.add(payBill);
                this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%s\u3011\u751f\u6210\u5185\u90e8\u91d1\u878d\u53d7\u7406\u5355\u5931\u8d25", (String)"PayBillPushIfmExecutor_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), payBill.get("billno"))).append('\n');
            });
        }
        if (rollbackPayBillList.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])rollbackPayBillList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    handle.markRollback();
                    throw e;
                }
            }
        }
    }

    public void doSignOperateFailed(Exception e) {
    }

    public String getId() {
        return "pushifmandsave";
    }

    public String getErrorMessage() {
        return this.errorMessage.length() > 0 ? this.errorMessage.toString() : null;
    }
}

