/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.smartmatch;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.opservice.helper.LoadCalResultDataHelper;
import kd.fi.cas.enums.AutoMatchBillTypeEnum;
import kd.fi.cas.enums.ResultSaveAutoMatchStatus;
import kd.fi.cas.helper.CasHelper;
import org.apache.commons.lang.StringUtils;

public class AutoMatchResultPlugin
extends AbstractListPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel", "close"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BillList list = (BillList)this.getControl("billlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("id,number,rulename,entryentity.record asc");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
        list.setFilter(numberFilter);
        list.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                setFilterEvent.setOrderBy("id,number,rulename,entryentity.record asc");
            }
        });
        list.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listColumns = args.getListColumns();
                FormShowParameter formShowParameter = AutoMatchResultPlugin.this.getView().getFormShowParameter();
                String type = (String)formShowParameter.getCustomParam("type");
                for (IListColumn column : listColumns) {
                    String key = column.getListFieldKey();
                    if (("amount".equals(key) || key.startsWith("rectype")) && "pay".equals(type)) {
                        column.setVisible(0);
                        continue;
                    }
                    if (!"payamount".equals(key) && !key.startsWith("paytype") || "pay".equals(type)) continue;
                    column.setVisible(0);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        LoadCalResultDataHelper.loadCalResultData((String)thisOpnumber);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeTitle();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("num".equals(fieldName)) {
            BillList list = (BillList)this.getControl("billlistap");
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"cas_autocalresult");
            DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
            ListSelectedRow selectedRow = list.getCurrentSelectedRowInfo();
            for (DynamicObject entry : col) {
                if (!entry.get("id").equals(selectedRow.getEntryPrimaryKeyValue())) continue;
                DynamicObject bizDO = entry;
                String str = bizDO.getString("billid");
                AutoMatchBillTypeEnum billTypeEnum = AutoMatchBillTypeEnum.getByValue((String)bizDO.getString("record"));
                String billFlag = billTypeEnum.getBillEntity();
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(billFlag);
                showParameter.setPkId((Object)str);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
        switch (operateKey = op.getOperateKey()) {
            case "cancelmatch": 
            case "confirmmatch": {
                BillList list = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = list.getSelectedRows();
                op.getOption().setVariableValue("selectedRowsData", StringUtils.join((Object[])rows.getPrimaryKeyValues(), (String)","));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        BillList list = (BillList)this.getControl("billlistap");
        String key = evt.getOperateKey();
        String resMsg = "";
        if (!evt.getOperationResult().isSuccess()) {
            return;
        }
        if ("confirmmatch".equals(key)) {
            resMsg = ResManager.loadKDString((String)"\u5339\u914d\u6210\u529f\u3002", (String)"AutoMatchResultPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        } else if ("cancelmatch".equals(key)) {
            resMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u5339\u914d\u6210\u529f\u3002", (String)"AutoMatchResultPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        }
        if ("confirmmatch".equals(key) || "cancelmatch".equals(key)) {
            list.clearSelection();
            list.refresh();
            this.getView().showSuccessNotification(resMsg);
            this.changeTitle();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        HashMap returnData = new HashMap();
        switch (key) {
            case "btncancel": {
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        if (!CasHelper.isEmpty((Object)thisOpnumber)) {
            this.asynDelThisOpData(thisOpnumber);
        }
    }

    private void asynDelThisOpData(Object thisOpnumber) {
        ThreadPools.executeOnceIncludeRequestContext((String)"delThisOpNumber", () -> {
            QFilter thisOpnumberFilter = new QFilter("number", "=", thisOpnumber);
            DeleteServiceHelper.delete((String)"cas_autocalresult", (QFilter[])new QFilter[]{thisOpnumberFilter});
        });
    }

    private void changeTitle() {
        Label label1 = (Label)this.getControl("labelap");
        Label label2 = (Label)this.getControl("labelap1");
        Label label3 = (Label)this.getControl("labelap3");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String thisOpnumber = (String)formShowParameter.getCustomParam("thisOpnumber");
        QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"cas_autocalresult", (String)"id,name,smartmatch,matchstatus,entryentity,entryentity.billid,entryentity.record,entryentity.billentryid", (QFilter[])new QFilter[]{numberFilter});
        if (CasHelper.isEmpty((DynamicObject[])objs) || objs.length <= 0) {
            return;
        }
        long size = Arrays.stream(objs).map(item -> item.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).filter(item -> "0".equals(item.getString("record"))).map(item -> item.getString("billid")).distinct().count();
        int count_matched = 0;
        int count_nomatch = 0;
        for (DynamicObject obj : objs) {
            String matchStatus = obj.getString("matchstatus");
            long entryDetailSize = obj.getDynamicObjectCollection("entryentity").stream().filter(item -> "0".equals(item.getString("record"))).map(item -> item.getString("billid")).distinct().count();
            if (ResultSaveAutoMatchStatus.AlMATCH.getValue().equals(matchStatus)) {
                count_matched = (int)((long)count_matched + entryDetailSize);
                continue;
            }
            if (!ResultSaveAutoMatchStatus.UNMATCH.getValue().equals(matchStatus)) continue;
            count_nomatch = (int)((long)count_nomatch + entryDetailSize);
        }
        String selectedSize = (String)formShowParameter.getCustomParam("selectedSize");
        StringBuilder str1 = new StringBuilder();
        str1.append(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684%s\u6761\u8bb0\u5f55\u4e2d", (String)"AutoMatchResultPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), selectedSize)).append("\uff0c");
        String str2 = String.format(ResManager.loadKDString((String)"%s\u6761\u4ea4\u6613\u660e\u7ec6\u8bb0\u5f55\u53ef\u8fdb\u884c", (String)"AutoMatchResultPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), size);
        String str3 = count_matched + "";
        label1.setText(str1.toString());
        label2.setText(str2);
        label3.setText(str3);
        Boolean flag = !"0".equals(count_nomatch + "");
        this.getView().setEnable(flag, new String[]{"btnok"});
    }
}

