/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.smartmatch;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.fi.cas.enums.AutoMatchBillTypeEnum;
import kd.fi.cas.enums.MatchBizTypeEnum;
import kd.fi.cas.enums.MatchPlanEnum;
import kd.fi.cas.helper.CasHelper;

public class MatchPlanPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initFieldColumn();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        String biztype = (String)customParams.get("biztype");
        String direction = (String)customParams.get("direction");
        boolean matchByEntry = (Boolean)customParams.get("matchByEntry");
        if (MatchBizTypeEnum.REC.getValue().equals(biztype)) {
            this.getFieldColum("cas_recbill", true);
        } else if (MatchBizTypeEnum.PAY.getValue().equals(biztype)) {
            this.getFieldColum("cas_paybill", true);
        } else if (MatchBizTypeEnum.AGENTPAY.getValue().equals(biztype)) {
            this.getFieldColum("cas_agentpaybill", matchByEntry);
        } else if (MatchBizTypeEnum.TRANSUP.getValue().equals(biztype)) {
            this.getFieldColum("fca_transupbill", matchByEntry);
        } else if (MatchBizTypeEnum.TRANSDOWN.getValue().equals(biztype)) {
            this.getFieldColum("fca_transdownbill", matchByEntry);
        } else if (MatchBizTypeEnum.TRANSHANDLE.getValue().equals(biztype)) {
            this.getFieldColum("ifm_transhandlebill", matchByEntry);
        } else if (MatchBizTypeEnum.EXCHANGE.getValue().equals(biztype) && "rec".equals(direction)) {
            this.getExchangBillFieldColumn("fs_buyinginfo");
        } else if (MatchBizTypeEnum.EXCHANGE.getValue().equals(biztype) && "pay".equals(direction)) {
            this.getExchangBillFieldColumn("fs_sellinginfo");
        }
        String str = (String)customParams.get("matchplanInfo");
        if (str != null && !"".equals(str.trim())) {
            List list = (List)SerializationUtils.fromJsonString((String)str, List.class);
            IDataModel model = this.getModel();
            for (Map map : list) {
                int index = model.createNewEntryRow("entryentity");
                Set entrySet = map.entrySet();
                for (Map.Entry entry : entrySet) {
                    model.setValue((String)entry.getKey(), entry.getValue(), index);
                }
                if (map.containsKey("isallnullmatch")) continue;
                model.setValue("isallnullmatch", map.get("isnullmatch"), index);
            }
        } else {
            String clickFile = (String)customParams.get("clickFile");
            if (!this.comeFromDetailOrBiz(clickFile).booleanValue()) {
                this.initEntryEntity(biztype, matchByEntry, direction);
            }
        }
    }

    private void initEntryEntity(String biztype, boolean matchByEntry, String direction) {
        if ("rec".equals(direction)) {
            if (MatchBizTypeEnum.REC.getValue().equals(biztype)) {
                this.initNewEntry("currency.number", "equals", "currency.number");
                this.initNewEntry("accountbank.bankaccountnumber", "equals", "accountbank.bankaccountnumber");
                this.initNewEntry("creditamount", "equals", "actrecamt");
                this.initNewEntry("bizdate", "equals", "bizdate");
            } else if (MatchBizTypeEnum.PAY.getValue().equals(biztype)) {
                this.initNewEntry("bizdate", "equals", "bizdate");
                this.initNewEntry("creditamount", "equals", "dpamt");
                this.initNewEntry("currency.number", "equals", "dpcurrency.number");
                this.initNewEntry("accountbank.bankaccountnumber", "equals", "payeebanknum");
                this.initNewEntry("oppbanknumber", "equals", "payeracctbank.bankaccountnumber");
            } else if (MatchBizTypeEnum.TRANSUP.getValue().equals(biztype)) {
                this.initNewEntry("currency.number", "equals", "currency.number");
                this.initNewEntry("accountbank.bankaccountnumber", "equals", "accountbank.bankaccountnumber");
                this.initNewEntry("creditamount", "equals", "entrys.transamt");
                this.initNewEntry("bizdate", "equals", "transbilldate");
            } else if (MatchBizTypeEnum.EXCHANGE.getValue().equals(biztype)) {
                this.initNewEntry("bizdate", "equals", "bizdate");
                this.initNewEntry("creditamount", "equals", "buyamount");
                this.initNewEntry("currency.number", "equals", "buyingcurrency.number");
                this.initNewEntry("accountbank.bankaccountnumber", "equals", "buyingaccount.bankaccountnumber");
            }
        } else if (MatchBizTypeEnum.REC.getValue().equals(biztype)) {
            this.initNewEntry("currency.number", "equals", "currency.number");
            this.initNewEntry("accountbank.bankaccountnumber", "equals", "payeracctbanknum");
            this.initNewEntry("debitamount", "equals", "actrecamt");
            this.initNewEntry("bizdate", "equals", "bizdate");
            this.initNewEntry("oppbanknumber", "equals", "accountbank.bankaccountnumber");
        } else if (MatchBizTypeEnum.PAY.getValue().equals(biztype)) {
            this.initNewEntry("currency.number", "equals", "dpcurrency.number");
            this.initNewEntry("accountbank.bankaccountnumber", "equals", "payeracctbank.bankaccountnumber");
            this.initNewEntry("debitamount", "equals", "totalpayamt");
            this.initNewEntry("bizdate", "equals", "bizdate");
            this.initNewEntry("oppunit", "equals", "payeename");
        } else if (MatchBizTypeEnum.AGENTPAY.getValue().equals(biztype)) {
            this.initNewEntry("currency.number", "equals", "dpcurrency.number");
            this.initNewEntry("accountbank.bankaccountnumber", "equals", "payeracctbank.bankaccountnumber");
            this.initNewEntry("bizdate", "equals", "bizdate");
            if (matchByEntry) {
                this.initNewEntry("debitamount", "equals", "entry.e_amount");
            }
        } else if (MatchBizTypeEnum.TRANSUP.getValue().equals(biztype)) {
            this.initNewEntry("currency.number", "equals", "currency.number");
            this.initNewEntry("accountbank.bankaccountnumber", "equals", "accountbank.bankaccountnumber");
            this.initNewEntry("creditamount", "equals", "entrys.transamt");
            this.initNewEntry("bizdate", "equals", "transbilldate");
        } else if (MatchBizTypeEnum.TRANSDOWN.getValue().equals(biztype)) {
            this.initNewEntry("currency.number", "equals", "currency.number");
            this.initNewEntry("accountbank.bankaccountnumber", "equals", "accountbank.bankaccountnumber");
            this.initNewEntry("debitamount", "equals", "entrys.transamt");
            this.initNewEntry("bizdate", "equals", "transbilldate");
        } else if (MatchBizTypeEnum.TRANSHANDLE.getValue().equals(biztype)) {
            this.initNewEntry("currency.number", "equals", "currency.number");
            this.initNewEntry("debitamount", "equals", "actpayamt");
            this.initNewEntry("accountbank.bankaccountnumber", "equals", "agentpayeraccount.bankaccountnumber");
            this.initNewEntry("bizdate", "equals", "bizdate");
            this.initNewEntry("oppunit", "equals", "payeename");
        } else if (MatchBizTypeEnum.EXCHANGE.getValue().equals(biztype)) {
            this.initNewEntry("bizdate", "equals", "bizdate");
            this.initNewEntry("debitamount", "equals", "sellamount");
            this.initNewEntry("currency.number", "equals", "sellingcurrency.number");
            this.initNewEntry("accountbank.bankaccountnumber", "equals", "sellingaccount.bankaccountnumber");
        }
    }

    private void initNewEntry(String transdetailfields, String relation, String bizfield) {
        IDataModel model = this.getModel();
        int index = model.createNewEntryRow("entryentity");
        model.setValue("transdetailfields", (Object)transdetailfields, index);
        model.setValue("relation", (Object)relation, index);
        model.setValue("bizfields", (Object)bizfield, index);
        model.setValue("isnullmatch", (Object)false, index);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"num"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            if (this.verify()) {
                this.returnDataToParent();
            }
        } else if ("btncancel".equals(key)) {
            this.getView().close();
        }
    }

    private boolean verify() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        String biztype = (String)customParams.get("biztype");
        boolean matchByEntry = (Boolean)customParams.get("matchByEntry");
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            String blankLine = null;
            String blankLine_num = null;
            String errMessage = null;
            for (int i = 0; i < entryEntity.size(); ++i) {
                int temp;
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                if (entry.get("transdetailfields") == null || entry.get("relation") == null || entry.get("bizfields") == null || "".equals(entry.get("transdetailfields")) || "".equals(entry.get("relation")) || "".equals(entry.get("bizfields"))) {
                    if (blankLine == null) {
                        temp = i + 1;
                        blankLine = temp + ",";
                    } else {
                        temp = i + 1;
                        blankLine = blankLine + temp + ",";
                    }
                }
                if (!MatchPlanEnum.DIFF.getValue().equals(entry.get("relation")) || entry.get("num") != null && !"".equals(entry.get("num"))) continue;
                if (blankLine_num == null) {
                    temp = i + 1;
                    blankLine_num = temp + ",";
                    continue;
                }
                temp = i + 1;
                blankLine_num = blankLine_num + temp + ",";
            }
            if (matchByEntry) {
                String entryName = null;
                if (MatchBizTypeEnum.AGENTPAY.getValue().equals(biztype)) {
                    entryName = "entry.";
                } else if (MatchBizTypeEnum.TRANSUP.getValue().equals(biztype) || MatchBizTypeEnum.TRANSDOWN.getValue().equals(biztype)) {
                    entryName = "entrys.";
                }
                String entryField = entryName;
                if (entryField == null || !entryEntity.stream().anyMatch(item -> item.getString("bizfields").startsWith(entryField))) {
                    errMessage = ResManager.loadKDString((String)"\u6309\u5206\u5f55\u5339\u914d\u7684\u5339\u914d\u65b9\u6848\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u5206\u5f55\u5b57\u6bb5\u3002", (String)"MatchPlanPlugin_15", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                }
            }
            if (blankLine != null) {
                blankLine = blankLine.substring(0, blankLine.length() - 1);
                errMessage = ResManager.loadKDString((String)"\u7b2c", (String)"MatchPlanPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]) + blankLine + ResManager.loadKDString((String)"\u884c\u6709\u672a\u5f55\u5165\u5b57\u6bb5,\u8bf7\u5f55\u5165", (String)"MatchPlanPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (blankLine_num != null) {
                blankLine_num = blankLine_num.substring(0, blankLine_num.length() - 1);
                errMessage = errMessage == null ? ResManager.loadKDString((String)"\u7b2c", (String)"MatchPlanPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]) + blankLine_num + ResManager.loadKDString((String)"\u884c\u8bf7\u9009\u62e9\u76f8\u5dee\u5c0f\u4e8e\u7684\u5929\u6570", (String)"MatchPlanPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]) : errMessage + ";" + ResManager.loadKDString((String)"\u7b2c", (String)"MatchPlanPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]) + blankLine_num + ResManager.loadKDString((String)"\u884c\u8bf7\u9009\u62e9\u76f8\u5dee\u5c0f\u4e8e\u7684\u5929\u6570", (String)"MatchPlanPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (errMessage != null) {
                this.getView().showTipNotification(errMessage);
                return false;
            }
            return true;
        }
        return true;
    }

    private void returnDataToParent() {
        IDataModel model = this.getModel();
        HashMap<String, String> data = new HashMap<String, String>();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            ArrayList list = new ArrayList();
            String str = "";
            StringBuilder stringBuilder = new StringBuilder();
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            EntityTypeUtil entityTypeUtil2 = new EntityTypeUtil();
            for (DynamicObject entry : entryEntity) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("transdetailfields", entry.get("transdetailfields"));
                map.put("relation", entry.get("relation"));
                map.put("bizfields", entry.get("bizfields"));
                map.put("isnullmatch", entry.get("isnullmatch"));
                map.put("isallnullmatch", entry.get("isallnullmatch"));
                map.put("num", entry.get("num"));
                list.add(map);
                String str1 = entry.getString("transdetailfields");
                String str2 = entry.getString("relation");
                String str3 = entry.getString("bizfields");
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas");
                List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
                for (FilterField field : filterFields) {
                    LocaleString caption = field.getCaption();
                    String fullFieldName = field.getFullFieldName();
                    if (!fullFieldName.equals(str1)) continue;
                    stringBuilder.append(" and ").append('\'').append(caption).append('\'');
                }
                if (MatchPlanEnum.EQUALS.getValue().equals(str2)) {
                    stringBuilder.append(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"MatchPlanPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else if (MatchPlanEnum.DIFF.getValue().equals(str2)) {
                    stringBuilder.append(ResManager.loadKDString((String)"\u76f8\u5dee\u5c0f\u4e8e", (String)"MatchPlanPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0])).append(entry.getString("num")).append(ResManager.loadKDString((String)"\u5929", (String)"MatchPlanPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else if (MatchPlanEnum.LIKE.getValue().equals(str2)) {
                    stringBuilder.append(ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d(\u5de6\u5305\u542b\u53f3)", (String)"MatchPlanPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else if (MatchPlanEnum.LIKERIGHT.getValue().equals(str2)) {
                    stringBuilder.append(ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d(\u53f3\u5305\u542b\u5de6)", (String)"MatchPlanPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                } else if (MatchPlanEnum.LIKEBOTH.getValue().equals(str2)) {
                    stringBuilder.append(ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d(\u53cc\u5411)", (String)"MatchPlanPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                }
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                Map customParams = showParameter.getCustomParams();
                String biztype = (String)customParams.get("biztype");
                MainEntityType entityType2 = null;
                AutoMatchBillTypeEnum bizTypeEnum = AutoMatchBillTypeEnum.getByType((String)biztype);
                entityType2 = EntityMetadataCache.getDataEntityType((String)bizTypeEnum.getBillEntity());
                List filterFields2 = entityTypeUtil2.getFilterFields((IDataEntityType)entityType2);
                for (FilterField field : filterFields2) {
                    LocaleString caption = field.getCaption();
                    String fullFieldName = field.getFullFieldName();
                    if (!fullFieldName.equals(str3)) continue;
                    stringBuilder.append('\'').append(caption).append('\'');
                }
            }
            str = stringBuilder.toString();
            String jsonString = SerializationUtils.toJsonString(list);
            data.put("matchplanInfo", jsonString);
            data.put("displayInfo", str.substring(5));
        } else {
            data.put("matchplanInfo", null);
            data.put("displayInfo", "");
        }
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private Boolean comeFromDetailOrBiz(String fileName) {
        if (CasHelper.isNotEmpty((Object)fileName)) {
            return "e_detailcondition".equals(fileName) || "e_bizcondition".equals(fileName);
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        String name = e.getProperty().getName();
        if ("relation".equals(name)) {
            if (newValue != null && (model.getValue("transdetailfields") == null || "".equals(model.getValue("transdetailfields")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5339\u914d\u5173\u7cfb\u524d\u8bf7\u5148\u9009\u62e9\u4ea4\u6613\u660e\u7ec6\u5339\u914d\u5b57\u6bb5", (String)"MatchPlanPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                model.setValue("relation", null);
                return;
            }
            if (!MatchPlanEnum.DIFF.getValue().equals(newValue)) {
                model.setValue("num", null);
            }
            if (MatchPlanEnum.DIFF.getValue().equals(newValue)) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas");
                EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
                List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
                for (FilterField filterField : filterFields) {
                    IDataEntityProperty fieldProp;
                    if (!filterField.getFullFieldName().equals(model.getValue("transdetailfields")) || (fieldProp = filterField.getFieldProp()) instanceof DateProp || fieldProp instanceof TimeProp || fieldProp instanceof DateTimeProp || fieldProp instanceof ModifyDateProp || fieldProp instanceof CreateDateProp) continue;
                    LocaleString caption = filterField.getCaption();
                    String format = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5339\u914d\u5173\u7cfb'%1$s'\u4e0e\u60a8\u9009\u62e9\u7684\u4ea4\u6613\u660e\u7ec6\u5339\u914d\u5b57\u6bb5'%2$s'\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"MatchPlanPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76f8\u5dee\u5c0f\u4e8e", (String)"MatchPlanPlugin_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), caption);
                    model.setValue("relation", null);
                    this.getView().showTipNotification(format);
                }
            } else if (MatchPlanEnum.LIKE.getValue().equals(newValue) || MatchPlanEnum.LIKEBOTH.getValue().equals(newValue) || MatchPlanEnum.LIKERIGHT.getValue().equals(newValue)) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas");
                EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
                List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
                for (FilterField filterField : filterFields) {
                    IDataEntityProperty fieldProp;
                    if (!filterField.getFullFieldName().equals(model.getValue("transdetailfields")) || (fieldProp = filterField.getFieldProp()) instanceof TextProp) continue;
                    LocaleString caption = filterField.getCaption();
                    String format = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5339\u914d\u5173\u7cfb'%1$s'\u4e0e\u60a8\u9009\u62e9\u7684\u4ea4\u6613\u660e\u7ec6\u5339\u914d\u5b57\u6bb5'%2$s'\u4e0d\u5339\u914d,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"MatchPlanPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d", (String)"MatchPlanPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), caption);
                    model.setValue("relation", null);
                    this.getView().showTipNotification(format);
                }
            }
        } else if ("transdetailfields".equals(name)) {
            model.setValue("relation", null);
            model.setValue("num", null);
        }
    }

    private void getExchangBillFieldColumn(String ap) {
        ComboEdit bizFieldsCombo = (ComboEdit)this.getControl("bizfields");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_exchangebill");
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
        String id = MetadataDao.getIdByNumber((String)"cas_exchangebill", (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List<ControlAp<?>> items = formMeta.getItems().stream().filter(i -> ap.equals(i.getKey()) || "fs_baseinfo".equals(i.getKey())).collect(Collectors.toList());
        for (FilterField field : filterFields) {
            String fullFieldName;
            boolean flag = field.isFieldPropAliasEmpty();
            if (flag || !this.checkContains(fullFieldName = field.getFullFieldName(), items)) continue;
            LocaleString caption = field.getCaption();
            ComboItem item = new ComboItem(caption, fullFieldName);
            comboItems.add(item);
        }
        bizFieldsCombo.setComboItems(comboItems);
    }

    private boolean checkContains(String fullFieldName, List<ControlAp<?>> items) {
        for (ControlAp<?> item : items) {
            List fields = ((FieldsetPanelAp)item).getItems();
            for (ControlAp filed : fields) {
                if (!fullFieldName.startsWith(filed.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private void getFieldColum(String pageStr, boolean matchByEntry) {
        ComboEdit fields = (ComboEdit)this.getControl("bizfields");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)pageStr);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
        block0: for (FilterField field : filterFields) {
            String[] propNameArr;
            boolean flag = field.isFieldPropAliasEmpty();
            if (flag) continue;
            LocaleString caption = field.getCaption();
            String fullFieldName = field.getFullFieldName();
            for (String propName : propNameArr = fullFieldName.split("\\.")) {
                DynamicProperty property = entityType.getProperty(propName);
                if (property instanceof EntryProp && !matchByEntry) continue block0;
            }
            ComboItem item = new ComboItem(caption, fullFieldName);
            items.add(item);
        }
        fields.setComboItems(items);
    }

    private void initFieldColumn() {
        ComboEdit fields = (ComboEdit)this.getControl("transdetailfields");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas");
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
        for (FilterField field : filterFields) {
            boolean flag = field.isFieldPropAliasEmpty();
            if (flag) continue;
            LocaleString caption = field.getCaption();
            String fullFieldName = field.getFullFieldName();
            ComboItem item = new ComboItem(caption, fullFieldName);
            items.add(item);
        }
        fields.setComboItems(items);
    }
}

