/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.smartmatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.cas.enums.AutoMatchBillTypeEnum;
import kd.fi.cas.enums.MatchBizTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.EntityFieldTreeOption;
import kd.fi.cas.util.EntityFieldTreeResult;
import kd.fi.cas.util.EntityTreeUtil;
import kd.fi.cas.util.ExpressionType;

public class SmartMatchEdit
extends AbstractBasePlugIn {
    private static final String CALLBACK_KEY_1 = "back_matchplan";
    private static final String NON_FIELDS = "non_fields";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_matchplan", "e_detailcondition", "e_bizcondition", "bizcondition"});
        this.fillOrgF7();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryKey = e.getEntryProp().getName();
        if ("entryentity".equals(entryKey)) {
            boolean flag;
            String bizType = (String)this.getModel().getValue("biztype");
            boolean bl = flag = MatchBizTypeEnum.TRANSUP.getValue().equals(bizType) || MatchBizTypeEnum.TRANSDOWN.getValue().equals(bizType);
            if (flag) {
                Arrays.stream(e.getRowDataEntities()).forEach(m -> m.getDataEntity().set("e_matchbyentry", (Object)true));
                this.getView().updateView("entryentity");
            }
        }
    }

    private void fillOrgF7() {
        BasedataEdit uOrgF7 = (BasedataEdit)this.getControl("u_org");
        uOrgF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            List orgList = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"cas_smartmatch", (String)"47156aff000000ac");
            showParameter.setCustomParam("range", (Object)orgList);
            DynamicObjectCollection uEntryDOC = this.getModel().getEntryEntity("org_entry");
            int row = evt.getRow();
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)uEntryDOC)) {
                ArrayList<Long> yetChooseIdList = new ArrayList<Long>(10);
                for (int i = 0; i < uEntryDOC.size(); ++i) {
                    DynamicObject uEntryDO = (DynamicObject)uEntryDOC.get(i);
                    if (i == row || !EmptyUtil.isNoEmpty((DynamicObject)uEntryDO) || !EmptyUtil.isNoEmpty((DynamicObject)uEntryDO.getDynamicObject("u_org"))) continue;
                    yetChooseIdList.add((Long)uEntryDO.getDynamicObject("u_org").getPkValue());
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList).and(new QFilter("id", "not in", yetChooseIdList)));
            } else {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        IDataModel model = this.getModel();
        Object biztype = model.getValue("biztype");
        switch (key) {
            case "e_matchplan": {
                int index = model.getEntryCurrentRowIndex("entryentity");
                Object value = model.getValue("e_matchplan_real_TAG", index);
                Object matchByEntry = model.getValue("e_matchbyentry", index);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("cas_matchplan");
                showParameter.setCustomParam("biztype", biztype);
                showParameter.setCustomParam("direction", model.getValue("direction"));
                if (value != null) {
                    showParameter.setCustomParam("matchplanInfo", value);
                }
                showParameter.setCustomParam("matchByEntry", matchByEntry);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_1));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
            case "bizcondition": {
                String fileName = "range_bizcondition_real";
                if (EmptyUtil.isEmpty((Object)biztype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u4e1a\u52a1\u5355\u636e\u3002", (String)"SmartMatchEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                AutoMatchBillTypeEnum billTypeEnum = AutoMatchBillTypeEnum.getByType((String)((String)biztype));
                String entity = billTypeEnum.getBillEntity();
                this.showCondition(key, model, entity, fileName);
                break;
            }
            case "e_detailcondition": {
                String fileName = "detailcondition_real";
                String entity = "bei_transdetail_cas";
                this.showCondition(key, model, entity, fileName);
                break;
            }
            case "e_bizcondition": {
                String fileName = "bizcondition_real";
                if (EmptyUtil.isEmpty((Object)biztype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u4e1a\u52a1\u5355\u636e\u3002", (String)"SmartMatchEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                AutoMatchBillTypeEnum billTypeEnum = AutoMatchBillTypeEnum.getByType((String)((String)biztype));
                String entity = billTypeEnum.getBillEntity();
                this.showCondition(key, model, entity, fileName);
            }
        }
    }

    private void showCondition(String key, IDataModel model, String entity, String fileName) {
        this.fillFields(key, ExpressionType.Condition, Boolean.FALSE, null, EntityMetadataCache.getDataEntityType((String)entity));
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        this.showConditionForm(entryCurrentRowIndex, fileName, this.getPageCache().get(key), entity);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (CALLBACK_KEY_1.equals(actionId)) {
            if (returnData != null) {
                IDataModel model = this.getModel();
                int index = model.getEntryCurrentRowIndex("entryentity");
                Map data = (Map)returnData;
                String res = (String)data.get("matchplanInfo");
                String res2 = (String)data.get("displayInfo");
                if (res2.length() > 1024) {
                    model.setValue("e_matchplan", (Object)res2.substring(0, 1024), index);
                } else {
                    model.setValue("e_matchplan", (Object)res2, index);
                }
                model.setValue("e_matchplan_real_TAG", (Object)res, index);
            }
        } else if ("detailcondition_real".equals(actionId) || "bizcondition_real".equals(actionId)) {
            this.receiveExpressionSet(e, "entryentity", actionId);
        } else if ("range_bizcondition_real".equals(actionId)) {
            this.receiveExpressionSet(e, actionId);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String direction;
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("biztype".equals(key) && EmptyUtil.isEmpty((String)(direction = (String)this.getModel().getValue("direction")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6d41\u6c34\u65b9\u5411\u3002", (String)"SmartMatchEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int entryentity = valueSet[0].getRowIndex();
        switch (propName) {
            case "biztype": {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
                this.initBizDatePropComboValues();
                this.setBizDatePropDefaultValue();
                this.showTips();
                break;
            }
            case "e_detailcondition": {
                if (!CasHelper.isEmpty((Object)newValue) && !"".equals(newValue)) break;
                this.getModel().setValue("detailcondition_real", null, entryentity);
                this.getModel().setValue("detailcondition_real_TAG", null, entryentity);
                break;
            }
            case "e_bizcondition": {
                if (!CasHelper.isEmpty((Object)newValue) && !"".equals(newValue)) break;
                this.getModel().setValue("bizcondition_real", null, entryentity);
                this.getModel().setValue("bizcondition_real_TAG", null, entryentity);
                break;
            }
            case "e_matchbyentry": {
                this.getModel().setValue("e_matchplan", null, entryentity);
                this.getModel().setValue("e_matchplan_real", null, entryentity);
                this.getModel().setValue("e_matchplan_real_tag", null, entryentity);
                break;
            }
            case "bizcondition": {
                if (!CasHelper.isEmpty((Object)newValue) && !"".equals(newValue)) break;
                this.getModel().setValue("range_bizcondition_real", null, entryentity);
                this.getModel().setValue("range_bizcondition_real_TAG", null, entryentity);
                break;
            }
            case "direction": {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
                this.initBizTypeComboValues();
                this.showTips();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)opStatus)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "direction", "biztype"});
        }
        this.initBizTypeComboValues();
        this.initBizDatePropComboValues();
        this.showTips();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBizDatePropDefaultValue();
    }

    private void showTips() {
        String direction = (String)this.getModel().getValue("direction");
        String bizType = (String)this.getModel().getValue("biztype");
        if (EmptyUtil.isEmpty((String)direction) || EmptyUtil.isEmpty((String)bizType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_rectips", "flex_paytips"});
        }
        this.getView().setVisible(Boolean.valueOf("rec".equals(direction) && AutoMatchBillTypeEnum.PAYBILL.getBizType().equals(bizType)), new String[]{"flex_rectips"});
        this.getView().setVisible(Boolean.valueOf("pay".equals(direction) && AutoMatchBillTypeEnum.RECBILL.getBizType().equals(bizType)), new String[]{"flex_paytips"});
    }

    private void initBizDatePropComboValues() {
        String bizType = (String)this.getModel().getValue("biztype");
        if (EmptyUtil.isEmpty((String)bizType)) {
            ComboEdit bizDateProp = (ComboEdit)this.getControl("bizdateprop");
            bizDateProp.setComboItems(null);
            return;
        }
        AutoMatchBillTypeEnum bizTypeEnum = AutoMatchBillTypeEnum.getByType((String)bizType);
        String billEntity = bizTypeEnum.getBillEntity();
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        for (FilterField transField : transFields) {
            IDataEntityProperty fieldProp;
            if (!EmptyUtil.isEmpty((String)transField.getRefEntityId()) || !((fieldProp = transField.getFieldProp()) instanceof DateTimeProp)) continue;
            ComboItem comboItem = new ComboItem(new LocaleString(transField.getFullFieldCaption()), transField.getFullFieldName());
            comboItems.add(comboItem);
        }
        ComboEdit bizDateProp = (ComboEdit)this.getControl("bizdateprop");
        bizDateProp.setComboItems(comboItems);
        if (AutoMatchBillTypeEnum.AGENTPAYBILL == bizTypeEnum) {
            ComboEdit entryBizDateProp = (ComboEdit)this.getControl("entrybizdateprop");
            entryBizDateProp.setComboItems(comboItems);
        }
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl("entrybizdateprop");
        fieldEdit.setMustInput(AutoMatchBillTypeEnum.AGENTPAYBILL == bizTypeEnum);
    }

    private void setBizDatePropDefaultValue() {
        String bizType = (String)this.getModel().getValue("biztype");
        if (EmptyUtil.isEmpty((String)bizType)) {
            return;
        }
        boolean isChanged = this.getModel().getDataChanged();
        AutoMatchBillTypeEnum bizTypeEnum = AutoMatchBillTypeEnum.getByType((String)bizType);
        this.getModel().setValue("bizdateprop", (Object)bizTypeEnum.getDefauleDateProp());
        if (AutoMatchBillTypeEnum.AGENTPAYBILL == bizTypeEnum) {
            this.getModel().setValue("entrybizdateprop", (Object)bizTypeEnum.getDefauleDateProp());
        } else {
            this.getModel().setValue("entrybizdateprop", null);
        }
        if (!isChanged) {
            this.getModel().setDataChanged(false);
        }
    }

    private void initBizTypeComboValues() {
        String direction = (String)this.getModel().getValue("direction");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        if ("rec".equals(direction)) {
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.REC);
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.TRANSUP);
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.PAY);
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.EXCHANGE);
        } else if ("pay".equals(direction)) {
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.PAY);
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.AGENTPAY);
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.TRANSDOWN);
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.REC);
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.TRANSHANDLE);
            this.addBizTypeCombo(comboItems, MatchBizTypeEnum.EXCHANGE);
        }
        ComboEdit bizTypeField = (ComboEdit)this.getControl("biztype");
        bizTypeField.setComboItems(comboItems);
    }

    private void addBizTypeCombo(List<ComboItem> comboItems, MatchBizTypeEnum bizTypeEnum) {
        ComboItem comboItem = new ComboItem(new LocaleString(bizTypeEnum.getName()), bizTypeEnum.getValue());
        comboItems.add(comboItem);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        String opKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && StringUtils.equals((CharSequence)(opKey = (oper = (AbstractOperate)args.getSource()).getOperateKey()), (CharSequence)"save")) {
            DynamicObjectCollection entities = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entities)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5339\u914d\u89c4\u5219\u3002", (String)"SmartMatchEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            for (DynamicObject entity : entities) {
                String ruleName = entity.getString("e_rulesname");
                String plan = entity.getString("e_matchplan");
                if (!StringUtils.isBlank((CharSequence)ruleName) && !StringUtils.isEmpty((CharSequence)plan)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u9879\u540d\u79f0\u6216\u5339\u914d\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SmartMatchEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private void fillFields(String key, ExpressionType type, boolean readChildEntity, Class<?> cls, MainEntityType srcMainET) {
        if (srcMainET == null) {
            this.getPageCache().put(key, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(readChildEntity);
            option.setExprType(type);
            option.setFieldType(cls);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(key, toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    private void showConditionForm(int rowIndex, String sourceCtrlKey, String fieldNodes, String entity) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_condition");
        String conditionJson = (String)this.getModel().getValue(sourceCtrlKey + "_TAG", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entity);
        showParameter.getCustomParams().put("onlyheadfield", Boolean.TRUE.toString());
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String descFldKey = "detailcondition_real".equals(expressionFldKey) ? "e_detailcondition" : "e_bizcondition";
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                this.setExpressionValue(expressionFldKey, descFldKey, str, row);
            }
        }
    }

    private void setExpressionValue(String expressionFldKey, String descFldKey, String str, int row) {
        CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
        this.getModel().setValue(expressionFldKey + "_TAG", (Object)str, row);
        String desp = "";
        if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
            desp = filterObj.getExprTran();
        }
        if (desp.length() > 1024) {
            desp = desp.substring(0, 1024);
        }
        this.getModel().setValue(descFldKey, (Object)desp, row);
    }

    private void receiveExpressionSet(ClosedCallBackEvent e, String expressionFldKey) {
        if (e.getReturnData() != null) {
            String descFldKey = "bizcondition";
            String str = (String)e.getReturnData();
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(descFldKey, (Object)"");
            } else {
                this.setExpressionValue(expressionFldKey, descFldKey, str, -1);
            }
        }
    }
}

