/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.transferapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.TransferTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class TransferApplyEdit
extends BillEditPlugin {
    private static final Log logger = LogFactory.getLog(TransferApplyEdit.class);
    protected static final String[] temp = new String[]{"normal", "freeze", "closing"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"refresh"});
        this.applyOrgF7();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("e_payee".equals(key)) {
            Object transfertype = this.getModel().getValue("transfertype");
            String errMsg = "";
            if (Objects.isNull(transfertype)) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8c03\u62e8\u7c7b\u578b\u3002", (String)"TransferApplyEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            if (!StringUtils.isEmpty((CharSequence)errMsg)) {
                this.getView().showTipNotification(errMsg, Integer.valueOf(3000));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("deleteentry".equals(key) || "copyentryrow".equals(key)) {
            this.calPayeeAmountTotal();
            this.calPayAmountTotal();
        } else if ("newentry".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_transferapply_entry");
            this.initEntry(entryEntity.size() - 1);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject standardCurrency;
        super.afterCreateNewData(e);
        DynamicObject applyOrg = this.getDynamicObject("applyorg");
        if (applyOrg == null) {
            return;
        }
        try {
            standardCurrency = SystemStatusCtrolHelper.getStandardCurrency((long)((Long)applyOrg.getPkValue()));
        }
        catch (Exception s) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"PayApplyEdit_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject payCurrency = this.getDynamicObject("paycurrency");
        DynamicObject payeeCurrency = this.getDynamicObject("payeecurrency");
        if (payCurrency == null) {
            this.setValue("paycurrency", standardCurrency);
        }
        if (payeeCurrency == null) {
            this.setValue("payeecurrency", standardCurrency);
        }
        Long orgId = this.getPk("applyorg");
        DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
        if (defaultSettleType != null) {
            String type = defaultSettleType.getString("settlementtype");
            if (!SettleMentTypeEnum.MONEY.getValue().equals(type) && !SettleMentTypeEnum.VIRTUAL.getValue().equals(type)) {
                this.setValue("e_settlementtype", defaultSettleType, 0);
            }
        }
        DynamicObject exrateTable = SystemStatusCtrolHelper.getExrateTable((long)orgId);
        this.setValue("exratetable", exrateTable);
        String transferType = (String)this.getModel().getValue("transfertype");
        String status = (String)this.getModel().getValue("billstatus");
        if (TransferTypeEnum.MAIN_TRANSFER.getValue().equals(status) && TransferTypeEnum.MAIN_TRANSFER.getValue().equals(transferType)) {
            this.setValue("e_payee", null, 0);
        }
        if (TransferTypeEnum.SAME_TRANSFER.getValue().equals(transferType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"e_payee"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"e_accountname"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"e_accountacctname"});
        }
        this.initEntry(null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean invalidflag = (Boolean)this.getValue("invalidflag");
        if (invalidflag) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_print", "bar_refresh", "bar_close", "bar_trackdown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unaudit", "baritemap2", "baritemap"});
        }
        DynamicObjectCollection payApplyEntry = this.getModel().getEntryEntity("cas_transferapply_entry");
        for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
            if (this.getValue("e_payeraccbank", rowIndex) == null) continue;
            String bankAccountNumber = ((DynamicObject)this.getValue("e_payeraccbank", rowIndex)).getString("bankaccountnumber");
            this.setValue("e_payeraccbanknum", bankAccountNumber, rowIndex);
        }
        this.getModel().setDataChanged(false);
        this.getView().setEnable(Boolean.FALSE, new String[]{"e_paymentchannel"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_transferapply_entry");
        int length = entryEntity.size();
        if ("newentry".equals(key)) {
            DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
            if (defaultSettleType != null) {
                DynamicObjectCollection entry;
                Optional<DynamicObject> optional;
                String type = defaultSettleType.getString("settlementtype");
                if (!SettleMentTypeEnum.MONEY.getValue().equals(type) && !SettleMentTypeEnum.VIRTUAL.getValue().equals(type) && (!(optional = (entry = this.getModel().getEntryEntity("cas_transferapply_entry")).stream().filter(e -> e.getDynamicObject("e_settlementtype") != null && SettleMentTypeEnum.DCEP.getValue().equals(e.getDynamicObject("e_settlementtype").getString("settlementtype"))).findFirst()).isPresent() || optional.isPresent() && SettleMentTypeEnum.DCEP.getValue().equals(defaultSettleType.getString("settlementtype")))) {
                    this.getModel().setValue("e_settlementtype", (Object)defaultSettleType, length - 1);
                }
            }
            DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("applyorg");
            this.getModel().setValue("e_payorg", (Object)applyOrg, length - 1);
            String transferType = (String)this.getModel().getValue("transfertype");
            this.getView().setEnable(Boolean.TRUE, length - 1, new String[]{"e_payee"});
            this.getModel().setValue("e_payee", null, length - 1);
            if (Objects.nonNull(transferType) && TransferTypeEnum.SAME_TRANSFER.getValue().equals(transferType)) {
                this.getModel().setValue("e_payeetype", (Object)"bos_org", length - 1);
                this.getModel().setValue("e_payee", this.getModel().getValue("e_payorg"), length - 1);
                this.getView().setEnable(Boolean.FALSE, length - 1, new String[]{"e_payee"});
            }
        }
        if ("copyentryrow".equals(key)) {
            this.getView().setEnable(Boolean.TRUE, length - 1, new String[]{"e_payee"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == null || newValue == oldValue) {
            return;
        }
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        switch (fieldKey) {
            case "transfertype": {
                this.setValue("isdiffcur", "0");
                this.setValue("payeecurrency", this.getDynamicObject("paycurrency"));
                this.clearEntryPayeeInfo();
                String paymentType = (String)newValue;
                this.bindByPaymentType(paymentType);
                break;
            }
            case "paycurrency": {
                if (Boolean.FALSE.equals(isDiffCur)) {
                    this.setValue("payeecurrency", this.getDynamicObject("paycurrency"));
                }
                DynamicObjectCollection entity = this.getModel().getEntryEntity("cas_transferapply_entry");
                for (int i = 0; i < entity.size(); ++i) {
                    this.computeMoney(i);
                    this.getModel().setValue("entrypaycurrency", (Object)this.getDynamicObject("paycurrency"), i);
                }
                if (newValue == null) break;
                DynamicObject payCurrency = (DynamicObject)newValue;
                Long curId = (Long)payCurrency.getPkValue();
                DynamicObjectCollection payInfoEntryCol = this.getModel().getEntryEntity("cas_transferapply_entry");
                for (int i = 0; i < payInfoEntryCol.size(); ++i) {
                    DynamicObjectCollection payerCurrencyCol;
                    Set payerCurrencyList;
                    DynamicObject payerAccBank = (DynamicObject)this.getModel().getValue("e_payeraccbank", i);
                    if (payerAccBank == null || (payerCurrencyList = (payerCurrencyCol = payerAccBank.getDynamicObjectCollection("currency")).stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet())).contains(curId)) continue;
                    this.getModel().setValue("e_payeraccbank", null, i);
                    this.getModel().setValue("e_payerbank", null, i);
                    this.getModel().setValue("e_balance", null, i);
                    this.getModel().setValue("e_lastmodifytime", null, i);
                    this.getModel().setValue("e_paymentchannel", null, i);
                }
                break;
            }
            case "e_payeeamount": {
                this.calPayeeAmountTotal();
                this.computeMoney(rowIndex);
                break;
            }
            case "quotation": {
                this.calPayAmountTotal();
                break;
            }
            case "exchangerate": {
                this.calPayAmountTotal();
                this.calPayeeAmountTotal();
                DynamicObjectCollection dys = this.getModel().getEntryEntity("cas_transferapply_entry");
                for (int i = 0; i < dys.size(); ++i) {
                    this.computeMoney(i);
                }
                break;
            }
            case "payeecurrency": {
                if (Boolean.FALSE.equals(isDiffCur)) {
                    this.setValue("paycurrency", this.getDynamicObject("payeecurrency"));
                }
                this.clearEntryPayeeInfo();
                break;
            }
            case "e_payee": {
                this.setValue("e_payeeaccbank", null, rowIndex);
                this.setValue("e_payeeaccbankid", null, rowIndex);
                this.setValue("e_payeeaccbanknum", null, rowIndex);
                this.setValue("e_useraccbank", null, rowIndex);
                this.setValue("e_payeebank", null, rowIndex);
                this.setValue("e_accountname", null, rowIndex);
                this.setValue("e_accountacctname", null, rowIndex);
                this.orgF7Changed((DynamicObject)newValue, rowIndex);
                String entryValue = (String)this.getModel().getValue("entryquotation", rowIndex);
                if (null == entryValue) {
                    this.initEntry(rowIndex);
                }
                String transferType = (String)this.getModel().getValue("transfertype");
                boolean isMainTransfer = TransferTypeEnum.MAIN_TRANSFER.getValue().equals(transferType);
                long ePayOrgId = 0L;
                long ePayeeId = 0L;
                if (this.getModel().getValue("e_payorg", rowIndex) != null) {
                    ePayOrgId = this.getDynamicObject("e_payorg", rowIndex).getLong("id");
                }
                if (this.getModel().getValue("e_payee", rowIndex) != null) {
                    ePayeeId = this.getDynamicObject("e_payee", rowIndex).getLong("id");
                }
                if (!isMainTransfer || ePayOrgId != ePayeeId || ePayOrgId == 0L || ePayeeId == 0L) break;
                this.getModel().setValue("e_payee", null, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u62e8\u7c7b\u578b\u4e3a\u201c\u8de8\u4e3b\u4f53\u8c03\u62e8\u201d\uff0c\u6536\u6b3e\u4eba\u4e0d\u53ef\u9009\u62e9\u4e0e\u4ed8\u6b3e\u7ec4\u7ec7\u540c\u4e00\u7ec4\u7ec7\u3002", (String)"PayApplyEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "isdiffcur": {
                DynamicObject org = this.getDynamicObject("applyorg");
                if (Objects.nonNull(org)) {
                    DynamicObject exrateTable = SystemStatusCtrolHelper.getExrateTable((long)((Long)org.getPkValue()));
                    this.setValue("exratetable", exrateTable);
                }
                this.setValue("exchangerate", 1);
                this.setValue("paycurrency", this.getDynamicObject("payeecurrency"));
                break;
            }
            case "exratetable": {
                break;
            }
            case "exratedate": 
            case "entryexratetable": 
            case "entryexrate": 
            case "entrypaycurrency": 
            case "standardmoney": {
                this.computeMoney(rowIndex);
            }
            case "paymentmoney": {
                this.calPayAmountTotal();
                break;
            }
            case "e_payorg": {
                this.initEntry(rowIndex);
                break;
            }
            case "applydate": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_transferapply_entry");
                Date value = (Date)this.getValue("applydate");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    this.setValue("entryexratedate", value, i);
                }
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (Objects.equals(operateKey, "save") || Objects.equals(operateKey, "submit")) {
            DynamicObjectCollection payApplyEntry = this.getModel().getEntryEntity("cas_transferapply_entry");
            ArrayList<String> checkPayeeBankNumErrorRows = new ArrayList<String>(payApplyEntry.size());
            ArrayList<String> checkPayerBankNumErrorRows = new ArrayList<String>(payApplyEntry.size());
            for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
                if (StringUtils.isNotBlank((Object)this.getValue("e_payeeaccbanknum", rowIndex)) && Objects.isNull(this.getValue("e_payeeaccbank", rowIndex))) {
                    checkPayeeBankNumErrorRows.add(String.valueOf(rowIndex + 1));
                }
                if (!StringUtils.isNotBlank((Object)this.getValue("e_payeraccbanknum", rowIndex)) || !Objects.isNull(this.getValue("e_payeraccbank", rowIndex))) continue;
                checkPayerBankNumErrorRows.add(String.valueOf(rowIndex + 1));
            }
            if (!checkPayeeBankNumErrorRows.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u7b2c%s\u884c\u5f55\u5165\u6536\u6b3e\u8d26\u53f7\u6709\u8bef\uff0c\u5efa\u8bae\u901a\u8fc7\u9009\u62e9\u65b9\u5f0f\u586b\u5199\u3002", (String)"TransferApplyEdit_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", checkPayeeBankNumErrorRows)));
                args.setCancel(true);
            }
            if (!checkPayerBankNumErrorRows.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u7b2c%s\u884c\u5f55\u5165\u4ed8\u6b3e\u8d26\u53f7\u6709\u8bef\uff0c\u5efa\u8bae\u901a\u8fc7\u9009\u62e9\u65b9\u5f0f\u586b\u5199\u3002", (String)"TransferApplyEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", checkPayerBankNumErrorRows)));
                args.setCancel(true);
            }
        }
    }

    private void initEntry(Integer index) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_transferapply_entry");
        if (entryEntity.isEmpty()) {
            return;
        }
        List e_payorg = entryEntity.stream().map(e -> e.getLong("e_payorg.id")).collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", e_payorg)};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,standardcurrency,exratetable,org.id", (QFilter[])filters);
        if (dynamicObjects == null) {
            return;
        }
        Map<Long, Long> standardCurrency = Arrays.stream(dynamicObjects).collect(Collectors.toMap(e -> e.getLong("org.id"), e -> e.getLong("standardcurrency.id"), (entity1, entity2) -> entity1));
        Map<Long, Long> exrateTable = Arrays.stream(dynamicObjects).collect(Collectors.toMap(e -> e.getLong("org.id"), e -> e.getLong("exratetable.id"), (entity1, entity2) -> entity1));
        if (null == standardCurrency || standardCurrency.entrySet().stream().anyMatch(obj -> obj.getValue() == null)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"TransferApplyEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (null == exrateTable || exrateTable.entrySet().stream().anyMatch(obj -> obj.getValue() == null)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"TransferApplyEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (index != null) {
            this.setEntryValue(standardCurrency, exrateTable, index, entryEntity);
        } else {
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.setEntryValue(standardCurrency, exrateTable, i, entryEntity);
            }
        }
    }

    private void setEntryValue(Map<Long, Long> standardCurrency, Map<Long, Long> exrateTable, Integer index, DynamicObjectCollection entryEntity) {
        DynamicObject payCurrency = this.getDynamicObject("paycurrency");
        this.getModel().setValue("entrypaycurrency", (Object)payCurrency, index.intValue());
        this.getModel().setValue("standardmoney", (Object)standardCurrency.get(((DynamicObject)entryEntity.get(index.intValue())).getLong("e_payorg.id")), index.intValue());
        Long exrateId = exrateTable.get(((DynamicObject)entryEntity.get(index.intValue())).getLong("e_payorg.id"));
        this.getModel().setValue("entryexratetable", (Object)exrateId, index.intValue());
        Date date = (Date)this.getModel().getValue("exratedate");
        this.getModel().setValue("entryexratedate", (Object)date, index.intValue());
        String value = (String)this.getModel().getValue("entryquotation", index.intValue());
        if (null == value && payCurrency != null) {
            Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)payCurrency.getLong("id"), (Long)standardCurrency.get(((DynamicObject)entryEntity.get(index.intValue())).getLong("e_payorg.id")), (Long)exrateId, (Date)date);
            this.setValue("entryexrate", exchangeRateMap.get("exchangeRate"), index);
            this.setValue("entryquotation", (Boolean)exchangeRateMap.get("quoteType") != false ? 1 : 0, index);
        }
    }

    private void computeMoney(Integer rowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cas_transferapply_entry");
        if (entryEntity.isEmpty()) {
            return;
        }
        if (rowIndex < 0 || rowIndex >= entryEntity.size()) {
            logger.error("TransferApplyEdit, computeMoney(),param  rowIndex={}", (Object)rowIndex);
            return;
        }
        String quotation = this.getString("quotation");
        DynamicObject entryData = (DynamicObject)entryEntity.get(rowIndex.intValue());
        if (null == entryData) {
            return;
        }
        String entryQuotation = entryData.getString("entryquotation");
        BigDecimal entryExrate = entryData.getBigDecimal("entryexrate");
        BigDecimal exrate = this.getBigDecimal("exchangerate");
        BigDecimal payeeaMount = entryData.getBigDecimal("e_payeeamount");
        DynamicObject dynamicObject = this.getDynamicObject("entrypaycurrency", rowIndex);
        DynamicObject standard = this.getDynamicObject("standardmoney", rowIndex);
        if (dynamicObject == null || standard == null) {
            return;
        }
        this.setValue("paymentmoney", QuotationHelper.callToCurrency((BigDecimal)payeeaMount, (BigDecimal)exrate, (String)quotation, (int)dynamicObject.getInt("amtprecision")), rowIndex);
        BigDecimal payMoney = entryData.getBigDecimal("paymentmoney");
        this.setValue("dsmoney", QuotationHelper.callToCurrency((BigDecimal)payMoney, (BigDecimal)entryExrate, (String)entryQuotation, (int)standard.getInt("amtprecision")), rowIndex);
    }

    private void bindByPaymentType(String paymentType) {
        DynamicObjectCollection applyEntry = this.getModel().getEntryEntity("cas_transferapply_entry");
        DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("applyorg");
        for (int i = 0; i < applyEntry.size(); ++i) {
            this.getModel().setValue("e_payeetype", (Object)"bos_org", i);
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_payee"});
            this.getModel().setValue("e_payee", null, i);
            if (!TransferTypeEnum.SAME_TRANSFER.getValue().equals(paymentType)) continue;
            this.getModel().setValue("e_payorg", (Object)applyOrg, i);
            this.getModel().setValue("e_payee", this.getModel().getValue("e_payorg"), i);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_payee"});
        }
    }

    private void calPayeeAmountTotal() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("cas_transferapply_entry");
        BigDecimal sum = dynamicObjects.stream().map(item -> item.get("e_payeeamount") == null ? BigDecimal.ZERO : new BigDecimal(item.get("e_payeeamount").toString())).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.setValue("payeeamount", sum);
    }

    private void calPayAmountTotal() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("cas_transferapply_entry");
        BigDecimal sum = dynamicObjects.stream().map(item -> item.get("paymentmoney") == null ? BigDecimal.ZERO : new BigDecimal(item.get("paymentmoney").toString())).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.setValue("payamount", sum);
    }

    private void clearEntryPayeeInfo() {
        DynamicObjectCollection payApplyEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("cas_transferapply_entry");
        for (int i = 0; i < payApplyEntry.size(); ++i) {
            this.getModel().setValue("e_payeeaccbank", null, i);
            this.getModel().setValue("e_payeeaccbankid", null, i);
            this.getModel().setValue("e_payeeaccbanknum", null, i);
            this.getModel().setValue("e_useraccbank", null, i);
            this.getModel().setValue("e_payeebank", null, i);
            this.getModel().setValue("e_accountname", null, i);
            this.getModel().setValue("e_accountacctname", null, i);
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_accountname"});
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_accountacctname"});
        }
    }

    private void orgF7Changed(DynamicObject org, int rowIndex) {
        if (org != null) {
            DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)org.getPkValue()));
            DynamicObject payeeCurrency = (DynamicObject)this.getModel().getValue("payeecurrency");
            if (payeeCurrency == null || defaultRecAccount != null && Objects.equals(defaultRecAccount.getDynamicObject("defaultcurrency").getPkValue(), payeeCurrency.getPkValue())) {
                this.setValue("e_payeeaccbank", defaultRecAccount, rowIndex);
            }
        }
    }

    private void applyOrgF7() {
        BasedataEdit applyOrgF7 = (BasedataEdit)this.getControl("applyorg");
        applyOrgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = ExtendConfigHelper.isInitOnlySet() ? new QFilter("standardcurrency", "is not null", null) : new QFilter("isfinishinit", "=", (Object)"1");
            DynamicObject[] finishInitArrays = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id, org", (QFilter[])filter.toArray());
            List finishInitOrgIds = Arrays.stream(finishInitArrays).filter(f -> f.getDynamicObject("org") != null).map(f -> f.getDynamicObject("org").getPkValue()).collect(Collectors.toList());
            showPara.getListFilterParameter().setFilter(new QFilter("id", "in", finishInitOrgIds));
        });
    }
}

