/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.transferapply.convert;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.enums.PaymentTypeEnum;
import kd.fi.cas.enums.TransferTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public class TransferApply2PayBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObjectCollection entries;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcData = (List)billDataEntity.getValue("ConvertSource");
            Object id = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcData.get(0));
            DynamicObject transferApply = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_transferapply", (String)String.join((CharSequence)",", "e_payee", "transfertype"));
            if (Objects.equals(transferApply.getString("transfertype"), TransferTypeEnum.MAIN_TRANSFER.getValue())) {
                if (EmptyUtil.isEmpty((Object)targetBill.get("paymenttype"))) {
                    targetBill.set("paymenttype", (Object)this.getPaymentTypeByNumber(PayAndRecBizTypeEnum.SPAN_MAIN_PART.getValue()));
                    entries = targetBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        entry.set("e_paymenttype", (Object)this.getPaymentTypeByNumber(PayAndRecBizTypeEnum.SPAN_MAIN_PART.getValue()));
                    }
                }
                targetBill.set("billtype", (Object)this.getBillTypeById(BillTypeConstants.PAYBILL_SPAN));
            } else if (Objects.equals(transferApply.getString("transfertype"), TransferTypeEnum.SAME_TRANSFER.getValue())) {
                if (EmptyUtil.isEmpty((Object)targetBill.get("paymenttype"))) {
                    targetBill.set("paymenttype", (Object)this.getPaymentTypeByNumber(PayAndRecBizTypeEnum.TRANSFER_SAME.getValue()));
                    entries = targetBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        entry.set("e_paymenttype", (Object)this.getPaymentTypeByNumber(PayAndRecBizTypeEnum.TRANSFER_SAME.getValue()));
                    }
                }
                targetBill.set("billtype", (Object)this.getBillTypeById(BillTypeConstants.PAYBILL_SYN));
            }
            targetBill.set("entrance", (Object)PaymentTypeEnum.SPAN.name());
        }
    }

    private DynamicObject getPaymentTypeByNumber(String value) {
        return BusinessDataServiceHelper.loadSingle((String)"cas_paymentbilltype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)value).toArray());
    }

    private DynamicObject getBillTypeById(Long id) {
        return BusinessDataServiceHelper.loadSingle((String)"bos_billtype", (String)"id", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
    }
}

