/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedata.query.BillTypeQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.MatchAmountDealHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.param.AutoMatchInfoParam;

public class HandSelectBillPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(HandSelectBillPlugin.class);
    public static final String IS_ENABLE_CALLBACK = "is_enable_callback";
    public static final String IS_CLEAR_CALLBACK = "is_clear_callback";
    private static final String entrykey = "entrykey";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billno"});
    }

    public void initialize() {
        super.initialize();
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("type");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ArrayList<SourceBillTypeEnum> items = new ArrayList<SourceBillTypeEnum>(10);
        items.add(SourceBillTypeEnum.EXCHANGEBILL);
        items.add(SourceBillTypeEnum.PAYBILL);
        items.add(SourceBillTypeEnum.PAYBILL_SYNONYM);
        items.add(SourceBillTypeEnum.PAYBILL_SPAN);
        items.add(SourceBillTypeEnum.PAYCASHBILL);
        items.add(SourceBillTypeEnum.PAYBILL_DCEP);
        if ("pay".equals(customParam)) {
            items.add(SourceBillTypeEnum.AGENTPAYBILL);
            items.add(SourceBillTypeEnum.TRANSDOWNBILL);
            items.add(SourceBillTypeEnum.TRANSHANDLEBILL);
        } else {
            items.add(SourceBillTypeEnum.RECBILL);
            items.add(SourceBillTypeEnum.TRANSUPBILL);
        }
        for (SourceBillTypeEnum one : items) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(one.getName()));
            comboItem.setValue(one.getValue());
            comboItems.add(comboItem);
        }
        ComboEdit payerTypeField = (ComboEdit)this.getControl("billtype");
        payerTypeField.setComboItems(comboItems);
        this.changeTitle();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        String propertyName = e.getProperty().getName();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        if ("billtype".equals(propertyName)) {
            int entryentity = changeData[0].getRowIndex();
            if (CasHelper.isEmpty((Object)newValue)) {
                this.getModel().setValue("billtype", oldValue, entryentity);
                return;
            }
            String billtype = (String)this.getModel().getValue("billtype", entryentity);
            String billtype1 = this.getPageCache().get("billtype");
            if (entryentity == 0 && !billtype.equals(billtype1)) {
                DynamicObjectCollection entryData = this.getModel().getEntryEntity("entryentity");
                if (entryData.size() > 1 || entryData.stream().anyMatch(o -> Long.compare(o.getLong("billid"), 0L) != 0)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7c7b\u578b\u5df2\u6539\u53d8,\u5206\u5f55\u540e\u9762\u6570\u636e\u5c06\u88ab\u6e05\u9664,\u662f\u5426\u786e\u8ba4\u6e05\u9664\uff1f", (String)"HandSelectBillPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_CLEAR_CALLBACK, (IFormPlugin)this));
                    return;
                }
            } else if (CasHelper.isNotEmpty((Object)billtype) && CasHelper.isNotEmpty((Object)billtype1) && !billtype.equals(billtype1)) {
                this.getModel().setValue("billtype", (Object)billtype1, entryentity);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u7c7b\u578b\u5fc5\u987b\u76f8\u540c,\u8bf7\u68c0\u67e5\u3002", (String)"HandSelectBillPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("billtype", billtype);
        } else if ("billno".equals(propertyName) && CasHelper.isEmpty((Object)newValue)) {
            int entryentity = changeData[0].getRowIndex();
            List<String> entryFieldList = Arrays.asList("billno", "amount", "billid", "tracetype", "unmatchamount", "billentryid", "matchamount");
            for (String entryField : entryFieldList) {
                this.getModel().setValue(entryField, null, entryentity);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)key)) {
            this.showBillF7();
        }
    }

    private void showBillF7() {
        Long currency;
        int currrow = this.getModel().getEntryCurrentRowIndex("entryentity");
        String billtype = (String)this.getModel().getValue("billtype", currrow);
        if (CasHelper.isEmpty((Object)billtype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5355\u636e\u7c7b\u578b", (String)"HandSelectBillPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String oppbanknumber = (String)formShowParameter.getCustomParam("oppbanknumber");
        String type = (String)formShowParameter.getCustomParam("type");
        Object orgId = formShowParameter.getCustomParam("orgId");
        if ("cas_paybill".equals(billtype) && !"pay".equals(type) && CasHelper.isEmpty((Object)oppbanknumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5bf9\u65b9\u8d26\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5339\u914d\u4ed8\u6b3e\u5355\u3002", (String)"HandSelectBillPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        Object obj = formShowParameter.getCustomParam("accountbank");
        Long accountbank = Long.parseLong(String.valueOf(obj));
        List<QFilter> qFilterList = this.getBillQFilter(billtype, type, accountbank, currency = Long.valueOf(Long.parseLong(String.valueOf(obj = formShowParameter.getCustomParam("currency")))), oppbanknumber, orgId);
        if (qFilterList == null || qFilterList.size() < 1) {
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)billtype, (boolean)true, (int)2);
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.getListFilterParameter().getQFilters().addAll(qFilterList);
        logger.info("\u786e\u8ba4\u5165\u8d26\u5339\u914d\u7684" + billtype + "\u8fc7\u6ee4\u6761\u4ef6\u662f:" + lsp.getListFilterParameter().getQFilters());
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectbillno"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<QFilter> getBillQFilter(String billtype, String type, Long accountbank, Long currency, String oppbanknumber, Object orgId) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(0);
        List setIds = this.getModel().getEntryEntity("entryentity").stream().filter(o -> billtype != null && billtype.equals(o.getString("billtype")) && Long.compare(o.getLong("billentryid"), 0L) == 0 && Long.compare(o.getLong("billid"), 0L) != 0).map(o -> o.getLong("billid")).distinct().collect(Collectors.toList());
        if (setIds != null && !setIds.isEmpty() && !"cas_exchangebill".equals(billtype)) {
            qFilterList.add(new QFilter("id", "not in", setIds));
        }
        QFilter needFlowQ = new QFilter("relateotherflow", "=", (Object)"1");
        QFilter canMatchQ = new QFilter("matchflag", "in", Arrays.asList("0", "2"));
        if (MatchAmountDealHelper.BUSINESS_TYPE.contains(billtype)) {
            qFilterList.add(canMatchQ);
            String needType = null;
            needType = "cas_paybill".equals(billtype) || "cas_paybill_synonym".equals(billtype) || "cas_paybill_spanmainpart".equals(billtype) || "cas_paybill_dcep".equals(billtype) ? "cas_paybill" : ("cas_recbill".equals(billtype) ? billtype : "");
            if ("pay".equals(type) && "cas_recbill".equals(needType) || !"pay".equals(type) && "cas_paybill".equals(needType)) {
                qFilterList.add(needFlowQ);
            }
        }
        String unMatchAmount = "pay".equals(type) ? "unmatchamountpay" : "unmatchamountrec";
        switch (billtype) {
            case "cas_paybill": {
                QFilter payercurrency = new QFilter("dpcurrency", "=", (Object)currency);
                if ("pay".equals(type)) {
                    QFilter payeracctbank = new QFilter("payeracctbank", "=", (Object)accountbank);
                    qFilterList.add(payeracctbank.and(payercurrency));
                } else {
                    QFilter payeeacctbank = new QFilter("payeeacctbank", "=", (Object)accountbank);
                    Set sets = (Set)JSON.parseObject((String)oppbanknumber, Set.class);
                    qFilterList.add(payeeacctbank.and(payercurrency));
                    qFilterList.add(new QFilter("payeracctbank.number", "in", (Object)sets));
                    qFilterList.add(new QFilter("org", "=", orgId));
                }
                qFilterList.add(new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue(), BillStatusEnum.DRAFTING.getValue())));
                List billTypeList = Arrays.stream(BillTypeQueryHelper.queryAllBillTypeID((String)"cas_paybill")).filter(o -> !Arrays.asList(BillTypeConstants.PAYBILL_SYN, BillTypeConstants.PAYBILL_DCEP, BillTypeConstants.PAYBILL_CASH).contains(o)).collect(Collectors.toList());
                if (billTypeList != null && billTypeList.size() > 0) {
                    qFilterList.add(new QFilter("billtype", "in", billTypeList));
                }
                qFilterList.add(new QFilter(unMatchAmount, "!=", (Object)0));
                break;
            }
            case "cas_paybill_synonym": {
                QFilter synonymcurrency = new QFilter("dpcurrency", "=", (Object)currency);
                if ("pay".equals(type)) {
                    QFilter synonympayeracctbank = new QFilter("payeracctbank", "=", (Object)accountbank);
                    qFilterList.add(synonymcurrency.and(synonympayeracctbank));
                } else {
                    QFilter synonymrecbank = new QFilter("payeeacctbank", "=", (Object)accountbank);
                    qFilterList.add(synonymrecbank);
                    qFilterList.add(synonymcurrency);
                }
                qFilterList.add(new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue())));
                qFilterList.add(new QFilter("billtype", "=", (Object)BillTypeConstants.PAYBILL_SYN));
                qFilterList.add(new QFilter(unMatchAmount, "!=", (Object)0));
                break;
            }
            case "cas_recbill": {
                qFilterList.add(new QFilter("accountbank", "=", (Object)accountbank));
                qFilterList.add(new QFilter("currency", "=", (Object)currency));
                qFilterList.add(new QFilter("billstatus", "not in", Collections.singletonList(BillStatusEnum.CHARGEBANK.getValue())));
                qFilterList.add(new QFilter(unMatchAmount, "!=", (Object)0));
                break;
            }
            case "cas_agentpaybill": {
                QFilter agentacctbank = new QFilter("payeracctbank", "=", (Object)accountbank);
                QFilter agentcurrency = new QFilter("dpcurrency", "=", (Object)currency);
                qFilterList.add(agentacctbank.and(agentcurrency));
                qFilterList.add(new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue())));
                qFilterList.add(canMatchQ);
                break;
            }
            case "cas_exchangebill": {
                if ("pay".equals(type)) {
                    QFilter paycommissionaccount = new QFilter("paycommissionaccount", "=", (Object)accountbank);
                    QFilter commissioncurrency = new QFilter("commissioncurrency", "=", (Object)currency);
                    QFilter feematchflag = new QFilter("feematchflag", "in", Arrays.asList("0", "2"));
                    QFilter exchangecurrency = new QFilter("sellingcurrency", "=", (Object)currency);
                    QFilter exchangeaccount = new QFilter("sellingaccount", "=", (Object)accountbank);
                    QFilter sellmatchflag = new QFilter("sellmatchflag", "in", Arrays.asList("0", "2"));
                    qFilterList.add(exchangeaccount.and(exchangecurrency).and(sellmatchflag).or(paycommissionaccount.and(commissioncurrency).and(feematchflag)));
                } else {
                    QFilter exchangecurrency = new QFilter("buyingcurrency", "=", (Object)currency);
                    QFilter exchangeaccount = new QFilter("buyingaccount", "=", (Object)accountbank);
                    QFilter buymatchflag = new QFilter("buymatchflag", "in", Arrays.asList("0", "2"));
                    qFilterList.add(exchangecurrency);
                    qFilterList.add(exchangeaccount);
                    qFilterList.add(buymatchflag);
                }
                qFilterList.add(canMatchQ);
                break;
            }
            case "cas_paybill_cash": {
                QFilter currencyQf = new QFilter("dpcurrency", "=", (Object)currency);
                if ("pay".equals(type)) {
                    QFilter businessType = new QFilter("businesstype", "=", (Object)"cashout");
                    QFilter cashPayerAcc = new QFilter("payeracctbank", "=", (Object)accountbank);
                    qFilterList.add(cashPayerAcc);
                    qFilterList.add(businessType);
                } else {
                    QFilter businessType = new QFilter("businesstype", "=", (Object)"cashin");
                    QFilter cashPayeeAcc = new QFilter("payeeacctbank", "=", (Object)accountbank);
                    qFilterList.add(cashPayeeAcc);
                    qFilterList.add(businessType);
                }
                qFilterList.add(currencyQf);
                qFilterList.add(new QFilter("billtype", "=", (Object)BillTypeConstants.PAYBILL_CASH));
                qFilterList.add(new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue())));
                qFilterList.add(new QFilter(unMatchAmount, "!=", (Object)0));
                break;
            }
            case "cas_paybill_dcep": {
                qFilterList.add(new QFilter("dpcurrency", "=", (Object)currency));
                if ("pay".equals(type)) {
                    qFilterList.add(new QFilter("payeracctbank", "=", (Object)accountbank));
                } else {
                    qFilterList.add(new QFilter("payeeacctbank", "=", (Object)accountbank));
                    Set sets = (Set)JSON.parseObject((String)oppbanknumber, Set.class);
                    qFilterList.add(new QFilter("payeracctbank.bankaccountnumber", "in", (Object)sets));
                }
                qFilterList.add(new QFilter("billtype", "=", (Object)BillTypeConstants.PAYBILL_DCEP));
                qFilterList.add(new QFilter(unMatchAmount, "!=", (Object)0));
                break;
            }
            case "cas_paybill_spanmainpart": {
                qFilterList.add(new QFilter("payeracctbank", "=", (Object)accountbank));
                qFilterList.add(new QFilter("dpcurrency", "=", (Object)currency));
                qFilterList.add(new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue())));
                qFilterList.add(new QFilter("billtype", "in", Arrays.asList(BillTypeConstants.PAYBILL_SPAN, BillTypeConstants.PAYBILL_SYN)));
                qFilterList.add(new QFilter(unMatchAmount, "!=", (Object)0));
                break;
            }
            case "fca_transupbill": {
                qFilterList.add(new QFilter("currency", "=", (Object)currency).and("accountbank", "=", (Object)accountbank).and("billstatus", "!=", (Object)"S").and("unmatchamount", ">", (Object)0));
                break;
            }
            case "fca_transdownbill": {
                qFilterList.add(new QFilter("currency", "=", (Object)currency).and("accountbank", "=", (Object)accountbank).and("billstatus", "!=", (Object)"S").and("unmatchamount", ">", (Object)0));
                break;
            }
            case "ifm_transhandlebill": {
                qFilterList.add(new QFilter("currency", "=", (Object)currency).and("agentpayeraccount", "=", (Object)accountbank).and("paidstatus", "!=", (Object)"C"));
                qFilterList.add(new QFilter(unMatchAmount, "!=", (Object)0));
            }
        }
        return qFilterList;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if ("selectbillno".equals(e.getActionId()) && CasHelper.isNotEmpty((Object)returnData)) {
            int currentRowIndex;
            ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)returnData;
            IDataModel model = this.getModel();
            String billtype = (String)model.getValue("billtype", currentRowIndex = model.getEntryCurrentRowIndex("entryentity"));
            if (CasHelper.isEmpty((Object)billtype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5355\u636e\u7c7b\u578b", (String)"HandSelectBillPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean fieldInEntry = false;
            Map<String, String> tBillFieldMap = this.getBillField(billtype);
            Object[] tEntryPrimaryKeyValues = null;
            if (coreBillCollection.getEntryPrimaryKeyValues() != null) {
                tEntryPrimaryKeyValues = Arrays.stream(coreBillCollection.getEntryPrimaryKeyValues()).filter(o -> o != null).toArray();
            }
            QFilter tQFilter = new QFilter("id", "in", (Object)coreBillCollection.getPrimaryKeyValues());
            if (coreBillCollection.size() >= coreBillCollection.getPrimaryKeyValues().length && tEntryPrimaryKeyValues != null && tEntryPrimaryKeyValues.length > 0 && tBillFieldMap.containsKey(entrykey)) {
                fieldInEntry = true;
                tQFilter.and(String.join((CharSequence)".", tBillFieldMap.get(entrykey), "id"), "in", (Object)coreBillCollection.getEntryPrimaryKeyValues());
            }
            DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            boolean isPay = "pay".equals(formShowParameter.getCustomParam("type"));
            Map<String, String> fieldMap = this.getBillFieldMap(isPay, billtype, fieldInEntry);
            String tQueryBillType = "cas_paybill_synonym".equals(billtype) || "cas_paybill_cash".equals(billtype) || "cas_paybill_spanmainpart".equals(billtype) || "cas_paybill_dcep".equals(billtype) ? "cas_paybill" : billtype;
            String SelectFields = Arrays.stream(new String[]{tBillFieldMap.get(billtype), tBillFieldMap.containsKey(entrykey) && fieldInEntry ? tBillFieldMap.get(tBillFieldMap.get(entrykey)) : null, fieldMap.values().stream().distinct().reduce((s1, s2) -> String.join((CharSequence)",", s1, s2)).orElse(null)}).filter(o -> o != null).reduce((s1, s2) -> String.join((CharSequence)",", s1, s2)).orElseGet(() -> EntityMetadataCache.getDataEntityType((String)tQueryBillType).getProperties().stream().map(o -> o.getName()).reduce((s1, s2) -> String.join((CharSequence)",", s1, s2)).orElse("id"));
            DynamicObjectCollection busnessBillCollection = QueryServiceHelper.query((String)tQueryBillType, (String)SelectFields, (QFilter[])tQFilter.toArray());
            Long accountbank = (Long)formShowParameter.getCustomParam("accountbank");
            int j = 0;
            Object currency2 = formShowParameter.getCustomParam("currency");
            Long currency = Long.parseLong(String.valueOf(currency2));
            ArrayList<String> errMsg = new ArrayList<String>(busnessBillCollection.size());
            for (DynamicObject busnessBill : busnessBillCollection) {
                List<String> result = this.checkSelectBill(billtype, busnessBill, fieldInEntry);
                if (result.size() > 0) {
                    errMsg.addAll(result);
                    continue;
                }
                if (isPay) {
                    Long acctId = 0L;
                    Long currency1Id = 0L;
                    Long feeAcctId = 0L;
                    Long feeCurrencyId = 0L;
                    BigDecimal fee = BigDecimal.ZERO;
                    if (CasHelper.isNotEmpty((Object)busnessBill.getLong(fieldMap.get("acct")))) {
                        acctId = busnessBill.getLong(fieldMap.get("acct"));
                    }
                    if (CasHelper.isNotEmpty((Object)busnessBill.getLong(fieldMap.get("currency")))) {
                        currency1Id = busnessBill.getLong(fieldMap.get("currency"));
                    }
                    if (CasHelper.isNotEmpty((Object)busnessBill.getLong(fieldMap.get("feeAcct")))) {
                        feeAcctId = busnessBill.getLong(fieldMap.get("feeAcct"));
                    }
                    if (CasHelper.isNotEmpty((Object)busnessBill.getLong(fieldMap.get("feeCurrency")))) {
                        feeCurrencyId = busnessBill.getLong(fieldMap.get("feeCurrency"));
                    }
                    if (fieldMap.containsKey("feeAmount") && CasHelper.isNotEmpty((Object)busnessBill.getBigDecimal(fieldMap.get("feeAmount")))) {
                        fee = busnessBill.getBigDecimal(fieldMap.get("feeAmount"));
                    }
                    if (accountbank.compareTo(acctId) == 0 && currency.compareTo(currency1Id) == 0 && !this.checkSelectBillInEntry(busnessBill, billtype, tBillFieldMap, fieldInEntry, "sell")) {
                        if (entryentity.size() < currentRowIndex + j + 1 || !billtype.equals(model.getValue("billtype", currentRowIndex + j))) {
                            model.appendEntryRow("entryentity", currentRowIndex + j - 1, 1);
                        }
                        this.getPageCache().put("IndexFlase", "yes");
                        model.setValue("billtype", (Object)billtype, currentRowIndex + j);
                        model.setValue("billno", (Object)busnessBill.getString("billno"), currentRowIndex + j);
                        model.setValue("billid", (Object)busnessBill.getLong("id"), currentRowIndex + j);
                        if (fieldInEntry) {
                            model.setValue("billentryid", (Object)busnessBill.getLong(String.join((CharSequence)".", tBillFieldMap.get(entrykey), "id")), currentRowIndex + j);
                        }
                        model.setValue("currency", (Object)currency, currentRowIndex + j);
                        BigDecimal amount = busnessBill.getBigDecimal(fieldMap.get("amount"));
                        if (SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(billtype)) {
                            model.setValue("tracetype", (Object)"sell", currentRowIndex + j);
                        } else if (SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype)) {
                            amount = amount.add(fee);
                            fee = BigDecimal.ZERO;
                            if ("D".equals(busnessBill.getString("billstatus")) && !busnessBill.getBoolean("isdiffcur") && !fieldInEntry) {
                                amount = busnessBill.getBigDecimal("actpayamount");
                            }
                        }
                        model.setValue("amount", (Object)amount, currentRowIndex + j);
                        model.setValue("unmatchamount", (Object)busnessBill.getBigDecimal(fieldMap.get("unMatchAmount")), currentRowIndex + j);
                        ++j;
                    }
                    if (fieldInEntry || accountbank.compareTo(feeAcctId) != 0 || currency.compareTo(feeCurrencyId) != 0 || BigDecimal.ZERO.compareTo(fee) == 0 || this.checkSelectBillInEntry(busnessBill, billtype, tBillFieldMap, fieldInEntry, "fee")) continue;
                    if (entryentity.size() < currentRowIndex + j + 1 || !billtype.equals(model.getValue("billtype", currentRowIndex + j))) {
                        model.appendEntryRow("entryentity", currentRowIndex + j - 1, 1);
                    }
                    this.getPageCache().put("IndexFlase", "yes");
                    model.setValue("billtype", (Object)billtype, currentRowIndex + j);
                    model.setValue("billno", (Object)busnessBill.getString("billno"), currentRowIndex + j);
                    model.setValue("billid", (Object)busnessBill.getLong("id"), currentRowIndex + j);
                    model.setValue("currency", (Object)currency, currentRowIndex + j);
                    if (SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(billtype)) {
                        model.setValue("tracetype", (Object)"fee", currentRowIndex + j);
                    }
                    model.setValue("amount", (Object)busnessBill.getBigDecimal(fieldMap.get("feeAmount")), currentRowIndex + j);
                    model.setValue("unmatchamount", (Object)busnessBill.getBigDecimal(fieldMap.get("feeUnMatchAmount")), currentRowIndex + j);
                    ++j;
                    continue;
                }
                if (this.checkSelectBillInEntry(busnessBill, billtype, tBillFieldMap, fieldInEntry, "buy")) continue;
                if (entryentity.size() < currentRowIndex + j + 1 || !billtype.equals(model.getValue("billtype", currentRowIndex + j))) {
                    model.appendEntryRow("entryentity", currentRowIndex + j - 1, 1);
                }
                this.getPageCache().put("IndexFlase", "yes");
                model.setValue("billtype", (Object)billtype, currentRowIndex + j);
                model.setValue("billno", (Object)busnessBill.getString("billno"), currentRowIndex + j);
                model.setValue("billid", (Object)busnessBill.getLong("id"), currentRowIndex + j);
                if (fieldInEntry) {
                    model.setValue("billentryid", (Object)busnessBill.getLong(String.join((CharSequence)".", tBillFieldMap.get(entrykey), "id")), currentRowIndex + j);
                }
                model.setValue("currency", (Object)currency, currentRowIndex + j);
                if (SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(billtype)) {
                    model.setValue("tracetype", (Object)"buy", currentRowIndex + j);
                }
                model.setValue("amount", (Object)busnessBill.getBigDecimal(fieldMap.get("amount")), currentRowIndex + j);
                model.setValue("unmatchamount", (Object)busnessBill.getBigDecimal(fieldMap.get("unMatchAmount")), currentRowIndex + j);
                ++j;
            }
            if (errMsg.size() > 0) {
                this.getView().showErrorNotification((String)errMsg.stream().distinct().reduce((s1, s2) -> String.join((CharSequence)"\n", s1, s2)).get());
            }
            model.updateCache();
            BigDecimal totalamount = (BigDecimal)this.getView().getFormShowParameter().getShowParameter().getCustomParam("totalamount");
            this.initMatchAmount(totalamount);
        }
    }

    private boolean checkSelectBillInEntry(DynamicObject busnessBill, String billtype, Map<String, String> tBillFieldMap, boolean fieldInEntry, String tracetype) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (busnessBill == null || billtype == null) {
            return true;
        }
        if (tBillFieldMap.containsKey(entrykey) && fieldInEntry) {
            return entryentity.stream().anyMatch(o -> billtype.equals(o.getString("billtype")) && Long.compare(o.getLong("billid"), busnessBill.getLong("id")) == 0 && Long.compare(o.getLong("billentryid"), busnessBill.getLong(String.join((CharSequence)".", (CharSequence)tBillFieldMap.get(entrykey), "id"))) == 0);
        }
        if (SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(billtype)) {
            if (BigDecimal.ZERO.compareTo(busnessBill.getBigDecimal(tracetype + "unmatchamount")) == 0) {
                return true;
            }
            return entryentity.stream().anyMatch(o -> billtype.equals(o.getString("billtype")) && Long.compare(o.getLong("billid"), busnessBill.getLong("id")) == 0 && o.getString("tracetype").equals(tracetype));
        }
        return entryentity.stream().anyMatch(o -> billtype.equals(o.getString("billtype")) && Long.compare(o.getLong("billid"), busnessBill.getLong("id")) == 0);
    }

    private List<String> checkSelectBill(String billtype, DynamicObject busnessBill, boolean fieldInEntry) {
        ArrayList<String> errMsg = new ArrayList<String>(1);
        if ((SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype) || SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billtype) || SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(billtype)) && busnessBill.getBoolean("ismatchbyhead") && fieldInEntry) {
            errMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u7ecf\u6309\u5934\u5339\u914d\uff0c\u4e0d\u652f\u6301\u6309\u5206\u5f55\u5339\u914d\u3002", (String)"HandSelectBillPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), busnessBill.getString("billno")));
        }
        if (fieldInEntry && (SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billtype) || SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(billtype)) && !"normal".equals(busnessBill.getString("entrys.state"))) {
            errMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u6240\u9009\u5206\u5f55\u72b6\u6001\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u5206\u5f55\u72b6\u6001\u3002", (String)"HandSelectBillPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), busnessBill.getString("billno")));
        }
        if (fieldInEntry && SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype)) {
            if (busnessBill.getBoolean("isencryption")) {
                errMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u6240\u9009\u5206\u5f55\u91d1\u989d\u52a0\u5bc6\uff0c\u4e0d\u652f\u6301\u6309\u5206\u5f55\u5339\u914d\u3002", (String)"HandSelectBillPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), busnessBill.getString("billno")));
            }
            if (busnessBill.getBoolean("isdiffcur")) {
                errMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u4e3a\u5f02\u5e01\u79cd\u4ed8\u6b3e\u5355\u636e\uff0c\u4e0d\u652f\u6301\u6309\u5206\u5f55\u5339\u914d\u3002", (String)"HandSelectBillPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]), busnessBill.getString("billno")));
            }
        }
        return errMsg;
    }

    private Map<String, String> getBillFieldMap(boolean isPay, String billtype, boolean fieldInEntry) {
        Map<String, String> fieldMap = null;
        String unMatchAmount = "unmatchamount";
        if (isPay) {
            unMatchAmount = "unmatchamountpay";
            switch (billtype) {
                case "cas_paybill": {
                    fieldMap = this.getFieldMap("payeracctbank", "dpcurrency", "totalpayamt", "feeactbank", "feecurrency", null, unMatchAmount);
                    break;
                }
                case "cas_paybill_dcep": 
                case "cas_paybill_synonym": {
                    fieldMap = this.getFieldMap("payeracctbank", "dpcurrency", "totalpayamt", "feeactbank", "feecurrency", null, unMatchAmount);
                    break;
                }
                case "cas_paybill_spanmainpart": {
                    fieldMap = this.getFieldMap("payeracctbank", "dpcurrency", "dpamt", "feeactbank", "feecurrency", "fee", unMatchAmount);
                    break;
                }
                case "cas_paybill_cash": {
                    fieldMap = this.getFieldMap("payeracctbank", "dpcurrency", "totalpayamt", "feeactbank", "feecurrency", null, unMatchAmount);
                    break;
                }
                case "cas_recbill": {
                    fieldMap = this.getFieldMap("actrecamt", unMatchAmount);
                    break;
                }
                case "ifm_transhandlebill": {
                    fieldMap = this.getFieldMap("agentpayeraccount", "currency", "actpayamt", "agentpayeraccount", "currency", null, unMatchAmount);
                    break;
                }
                case "cas_agentpaybill": {
                    if (fieldInEntry) {
                        fieldMap = this.getFieldMap("payeracctbank", "currency", "entry.e_amount", "feeactbank", "feecurrency", null, "entry.entryunmatchamount");
                        break;
                    }
                    fieldMap = this.getFieldMap("payeracctbank", "dpcurrency", "dpamt", "feeactbank", "feecurrency", "fee", "unmatchamount");
                    break;
                }
                case "cas_exchangebill": {
                    fieldMap = this.getFieldMap("sellingaccount", "sellingcurrency", "sellamount", "paycommissionaccount", "commissioncurrency", "commissionamount", "sellunmatchamount", "feeunmatchamount");
                    break;
                }
                case "fca_transdownbill": {
                    fieldMap = fieldInEntry ? this.getFieldMap("accountbank", "currency", "entrys.transamt", "accountbank", "currency", null, "entrys.entryunmatchamount") : this.getFieldMap("accountbank", "currency", "amount", "accountbank", "currency", null, "unmatchamount");
                }
            }
        } else {
            unMatchAmount = "unmatchamountrec";
            if ("cas_recbill".equals(billtype)) {
                fieldMap = this.getFieldMap("actrecamt", unMatchAmount);
            } else if ("cas_exchangebill".equals(billtype)) {
                fieldMap = this.getFieldMap("buyamount", "buyunmatchamount");
            } else if ("cas_paybill".equals(billtype) || "cas_paybill_synonym".equals(billtype) || "cas_paybill_cash".equals(billtype) || "cas_paybill_spanmainpart".equals(billtype) || "cas_paybill_dcep".equals(billtype)) {
                fieldMap = this.getFieldMap("dpamt", unMatchAmount);
            } else if (SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billtype)) {
                fieldMap = fieldInEntry ? this.getFieldMap("entrys.transamt", "entrys.entryunmatchamount") : this.getFieldMap("amount", "unmatchamount");
            }
        }
        return fieldMap;
    }

    private Map<String, String> getFieldMap(String acct, String currency, String amount, String feeAcct, String feeCurrency, String feeAmount, String unMatchAmount, String feeUnMatchAmount) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(8);
        fieldMap.put("amount", amount);
        fieldMap.put("unMatchAmount", unMatchAmount);
        fieldMap.put("feeUnMatchAmount", feeUnMatchAmount);
        fieldMap.put("acct", acct);
        fieldMap.put("currency", currency);
        fieldMap.put("feeAcct", feeAcct);
        fieldMap.put("feeCurrency", feeCurrency);
        if (feeAmount != null) {
            fieldMap.put("feeAmount", feeAmount);
        }
        return fieldMap;
    }

    private Map<String, String> getFieldMap(String acct, String currency, String amount, String feeAcct, String feeCurrency, String feeAmount, String unMatchAmount) {
        return this.getFieldMap(acct, currency, amount, feeAcct, feeCurrency, feeAmount, unMatchAmount, unMatchAmount);
    }

    private Map<String, String> getFieldMap(String amount, String unMatchAmount) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(2);
        fieldMap.put("amount", amount);
        fieldMap.put("unMatchAmount", unMatchAmount);
        return fieldMap;
    }

    private Map<String, String> getBillField(String billtype) {
        HashMap<String, String> tBillField = new HashMap<String, String>(3);
        tBillField.put(billtype, "id,billno");
        if (SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billtype) || SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(billtype)) {
            tBillField.put(billtype, "id,billno,ismatchbyhead");
            tBillField.put(entrykey, "entrys");
            tBillField.put("entrys", "entrys.id,entrys.state");
        } else if (SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype)) {
            tBillField.put(billtype, "id,billno,ismatchbyhead,isencryption,actpayamount,billstatus,isdiffcur");
            tBillField.put(entrykey, "entry");
            tBillField.put("entry", "entry.id");
        }
        return tBillField;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes) && callBackId.equals(IS_ENABLE_CALLBACK)) {
            this.confirmToAccount();
        } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes) && callBackId.equals(IS_CLEAR_CALLBACK)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            String billtype = entryentity.stream().filter(o -> CasHelper.isNotEmpty((Object)o.getString("billtype"))).map(o -> o.getString("billtype")).findFirst().orElse(null);
            this.getPageCache().put("billtype", billtype);
            List<String> entryFieldList = Arrays.asList("billno", "amount", "billid", "tracetype", "unmatchamount", "billentryid", "matchamount");
            for (int i = 0; i < entryentity.size(); ++i) {
                this.getModel().setValue("billtype", (Object)billtype, i);
                for (String entryField : entryFieldList) {
                    this.getModel().setValue(entryField, null, i);
                }
            }
        } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Cancel) && callBackId.equals(IS_CLEAR_CALLBACK)) {
            this.getPageCache().put("IndexFlase", "yes");
            String billtype = this.getPageCache().get("billtype");
            int entryentity = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("billtype", (Object)billtype, entryentity);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("btnok".equals(operateKey) && opResult.isSuccess()) {
            BigDecimal totalamount = (BigDecimal)this.getView().getFormShowParameter().getShowParameter().getCustomParam("totalamount");
            this.initMatchAmount(totalamount);
            DynamicObjectCollection entryentity = (DynamicObjectCollection)this.getModel().getValue("entryentity");
            BigDecimal amount = entryentity.stream().map(o -> o.getBigDecimal("unmatchamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (amount.compareTo(totalamount) > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5408\u8ba1\u91d1\u989d\u4e0d\u7b49\u4e8e\u4ea4\u6613\u660e\u7ec6\u53d1\u751f\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\u5173\u8054\uff1f", (String)"HandSelectBillPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_ENABLE_CALLBACK, (IFormPlugin)this));
                return;
            }
            if (amount.compareTo(totalamount) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e1a\u52a1\u5355\u636e\u672a\u5339\u914d\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u4ea4\u6613\u660e\u7ec6\u91d1\u989d\u3002", (String)"HandSelectBillPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.confirmToAccount();
        }
    }

    private void confirmToAccount() {
        Object selectId1 = this.getView().getFormShowParameter().getCustomParam("selectId");
        List selectId = JSONArray.parseArray((String)selectId1.toString(), Object.class);
        String bunessType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String tDataEntityType = "pay".equals(bunessType) ? "bei_intelpay" : "bei_intelrec";
        DynamicObject[] details = BusinessDataServiceHelper.load((Object[])selectId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)tDataEntityType));
        List collect = this.getModel().getEntryEntity("entryentity").stream().filter(o -> o.get("billid") != null).collect(Collectors.toList());
        Set CheckCollect = collect.stream().map(o -> String.join((CharSequence)",", o.getString("billid"), o.getString("billentryid"), o.getString("tracetype"))).collect(Collectors.toSet());
        ArrayList tAutoMatchInfoList = new ArrayList(details.length * CheckCollect.size());
        if (details.length > 1) {
            if (CheckCollect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u6761\u4ea4\u6613\u660e\u7ec6\u53ea\u80fd\u5173\u8054\u4e00\u6761\u4e1a\u52a1\u5355\u636e,\u8bf7\u68c0\u67e5\u3002", (String)"HandSelectBillPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (CheckCollect.size() == 1 && ((DynamicObject)collect.get(0)).getString("billno") != null) {
                String billtype = ((DynamicObject)collect.get(0)).getString("billtype");
                String billno = ((DynamicObject)collect.get(0)).getString("billno");
                Long billid = ((DynamicObject)collect.get(0)).getLong("billid");
                Long billEntryId = ((DynamicObject)collect.get(0)).getLong("billentryid");
                String tracetype = ((DynamicObject)collect.get(0)).getString("tracetype");
                Date traceDate = Arrays.stream(details).map(o -> o.getDate("bizdate")).reduce((a, b) -> a.compareTo((Date)b) > 0 ? a : b).orElse(null);
                String amountProp = "pay".equals(bunessType) ? "debitamount" : "creditamount";
                Arrays.stream(details).forEach(entryEntity -> tAutoMatchInfoList.add(new AutoMatchInfoParam(tDataEntityType, entryEntity.getString("billno"), Long.valueOf(entryEntity.getLong("id")), billtype, billno, billid, billEntryId, Long.valueOf(entryEntity.getLong("currency.id")), tracetype, entryEntity.getBigDecimal(amountProp), entryEntity.getString("bankcheckflag"), traceDate)));
            }
        } else {
            List<DynamicObject> entryentityList = this.getModel().getEntryEntity("entryentity").stream().filter(dynamicObject -> {
                String billtype = dynamicObject.getString("billtype");
                if (billtype == null || billtype.length() < 1) {
                    return false;
                }
                if (Long.compare(dynamicObject.getLong("billid"), 0L) <= 0) {
                    return false;
                }
                return BigDecimal.ZERO.compareTo(dynamicObject.getBigDecimal("matchamount")) != 0;
            }).collect(Collectors.toList());
            String bankcheckflag = details[0].getString("bankcheckflag");
            Date traceDate = details[0].getDate("bizdate");
            entryentityList.forEach(entryEntity -> tAutoMatchInfoList.add(new AutoMatchInfoParam(tDataEntityType, details[0].getString("billno"), Long.valueOf(details[0].getLong("id")), entryEntity.getString("billtype"), entryEntity.getString("billno"), Long.valueOf(entryEntity.getLong("billid")), Long.valueOf(entryEntity.getLong("billentryid")), Long.valueOf(details[0].getLong("currency.id")), entryEntity.getString("tracetype"), entryEntity.getBigDecimal("matchamount"), bankcheckflag, traceDate)));
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{tAutoMatchInfoList, ReceredWayEnum.HANDMATCH.getValue(), null, true, null});
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("flag", "ok");
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void initMatchAmount(BigDecimal totalamount) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        BigDecimal canMatchAmount = totalamount;
        if (canMatchAmount == null) {
            canMatchAmount = BigDecimal.ZERO;
        }
        BigDecimal unMatchAmount = null;
        List sortedEntity = entryentity.stream().sorted(Comparator.comparing(v -> v.getBigDecimal("unmatchamount"))).collect(Collectors.toList());
        for (int i = 0; i < sortedEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)sortedEntity.get(i);
            if (Long.compare(entry.getLong("billid"), 0L) == 0) continue;
            int seq = entry.getInt("seq");
            unMatchAmount = entry.getBigDecimal("unmatchamount");
            if (BigDecimal.ZERO.compareTo(canMatchAmount) != 0 && canMatchAmount.compareTo(unMatchAmount) >= 0) {
                this.getModel().setValue("matchamount", (Object)unMatchAmount, seq - 1);
                canMatchAmount = canMatchAmount.subtract(unMatchAmount);
                continue;
            }
            this.getModel().setValue("matchamount", (Object)canMatchAmount, seq - 1);
            canMatchAmount = BigDecimal.ZERO;
        }
    }

    private void changeTitle() {
        Label label1 = (Label)this.getControl("labelap");
        Label label2 = (Label)this.getControl("labelap1");
        Object selectId1 = this.getView().getFormShowParameter().getCustomParam("selectId");
        List selectId = JSONArray.parseArray((String)selectId1.toString(), Object.class);
        StringBuilder str1 = new StringBuilder();
        BigDecimal totalamount = (BigDecimal)this.getView().getFormShowParameter().getCustomParam("totalamount");
        str1.append(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684%s\u6761\u4ea4\u6613\u660e\u7ec6\u4e2d", (String)"HandSelectBillPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), selectId.size())).append("\uff0c");
        String str2 = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u91d1\u989d\u4e3a%s", (String)"HandSelectBillPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), totalamount.setScale(4, 4));
        label1.setText(str1.toString());
        label2.setText(str2);
    }
}

