/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.consts.ResultRpc;
import kd.fi.cas.helper.CasHelper;

public class MulitEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static Log logger = LogFactory.getLog(MulitEdit.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object receiptID = formShowParameter.getCustomParam("receiptID");
        String detailIds = (String)formShowParameter.getCustomParam("detailIds");
        String receiptNo = (String)formShowParameter.getCustomParam("receiptNo");
        logger.info("\u6253\u5f00\u8054\u67e5\u7535\u5b50\u56de\u5355\u4e0e\u4ea4\u6613\u660e\u7ec6\u9875\u9762");
        logger.info("\u5bf9\u8d26\u6807\u8bc6\u7801receiptID=" + receiptID);
        logger.info("\u4ea4\u6613\u660e\u7ec6detailIds=" + detailIds);
        logger.info("\u7535\u5b50\u56de\u5355\u53f7receiptNo=" + receiptNo);
        if (CasHelper.isNotEmpty((Object)detailIds)) {
            String entityName = (String)formShowParameter.getCustomParam("entityName");
            HashSet hashSet = (HashSet)JSON.parseObject((String)detailIds, HashSet.class);
            if (StringUtils.isNotBlank((CharSequence)entityName)) {
                logger.info("\u5355\u636e\u9875\u9762\u5143\u6570\u636e\u6807\u8bc6" + entityName);
                this.showBill(hashSet, entityName);
            } else {
                this.showBill(hashSet, "bei_transdetail");
            }
        }
        if (CasHelper.isNotEmpty((Object)receiptID) || CasHelper.isNotEmpty((Object)receiptNo)) {
            this.showReceiptForm((String)receiptID, receiptNo);
        }
    }

    private void showReceiptForm(String receiptID, String receiptNo) {
        logger.info("\u6253\u5f00\u7535\u5b50\u56de\u5355\u9875\u9762");
        String[] receiptIdArray = new String[]{};
        String[] receiptNoArray = new String[]{};
        if (receiptID != null) {
            receiptIdArray = receiptID.split(",");
        }
        if (CasHelper.isNotEmpty((Object)receiptNo)) {
            ArrayList receiptNoList = (ArrayList)JSON.parseObject((String)receiptNo, ArrayList.class);
            receiptNoArray = receiptNoList.toArray(new String[0]);
        }
        ArrayList<String> bankcheckflagList = new ArrayList<String>(0);
        ArrayList<String> receiptNoList = new ArrayList<String>(0);
        for (String id : receiptIdArray) {
            if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
            bankcheckflagList.add(id);
        }
        for (String receiptNo1 : receiptNoArray) {
            if (!StringUtils.isNotEmpty((CharSequence)receiptNo1)) continue;
            receiptNoList.add(receiptNo1);
        }
        logger.info("\u8c03\u7528bei\u83b7\u53d6\u7535\u5b50\u56de\u5355\u94fe\u63a5\u5fae\u670d\u52a1");
        logger.info("\u5bf9\u8d26\u6807\u8bc6\u7801:" + bankcheckflagList);
        ArrayList list = new ArrayList(0);
        if (bankcheckflagList.size() > 0) {
            logger.info("\u8c03\u7528bei\u83b7\u53d6\u7535\u5b50\u56de\u5355\u94fe\u63a5\u5fae\u670d\u52a1\u53c2\u6570bankcheckflagList=" + ((Object)bankcheckflagList).toString());
            list.addAll((Collection)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"getElec", (Object[])new Object[]{this.getView().getPageId(), bankcheckflagList.toArray()}));
        }
        if (receiptNoList.size() > 0) {
            logger.info("\u8c03\u7528bei\u83b7\u53d6\u7535\u5b50\u56de\u5355\u94fe\u63a5\u5fae\u670d\u52a1\u53c2\u6570receiptNoList=" + ((Object)receiptNoList).toString());
            list.addAll((Collection)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"getElecByReceiptno", (Object[])new Object[]{this.getView().getPageId(), receiptNoList.toArray()}));
        }
        ArrayList<String> result = new ArrayList<String>(list.size());
        logger.info("\u5fae\u670d\u52a1\u8fd4\u56de\u4fe1\u606f:" + list);
        for (String resultRpcStr : list) {
            ResultRpc resultRpc = (ResultRpc)JSON.parseObject((String)resultRpcStr, ResultRpc.class);
            this.receiptResult(resultRpc, result);
        }
        if (result.size() == 1) {
            this.getView().showTipNotification((String)result.get(0));
            return;
        }
        if (result.size() > 1) {
            StringBuilder errorSb = new StringBuilder();
            for (String msg : result) {
                errorSb.append(msg);
                errorSb.append('\n');
            }
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6b64\u4ee3\u53d1\u5355\u6570\u636e\u8054\u67e5\u4e0d\u5230\u7684\u56de\u5355\u6570\u636e\u5171\u6709:%s\u6761", (String)"MulitEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), result.size()), errorSb.toString(), MessageTypes.Default);
        }
    }

    private void receiptResult(ResultRpc resultRpc, List<String> result) {
        logger.info("\u5904\u7406\u7535\u5b50\u56de\u5355\u6570\u636e");
        if (resultRpc != null) {
            IFormView view = this.getView();
            int openType = resultRpc.getOpenType();
            logger.info("openType=" + openType);
            if (openType == 2) {
                logger.info("message=" + resultRpc.getMsg());
                result.add(resultRpc.getMsg());
            } else if (openType == 0) {
                String url = resultRpc.getUrl();
                logger.info("url=" + resultRpc.getUrl());
                IFormView mainView = view.getMainView();
                if (mainView == null) {
                    view.openUrl(url);
                    logger.info("mainView\u4e3a\u7a7a, view.openUrl(" + url + ")");
                } else {
                    logger.info("mainView\u4e0d\u4e3a\u7a7a, \u901a\u8fc7formShowParameter\u6253\u5f00URL:" + url);
                    FormShowParameter parm = this.buildParameter(url);
                    parm.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u56de\u5355", (String)"ViewReceiptService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                    view.showForm(parm);
                    view.sendFormAction(view.getViewNoPlugin(view.getFormShowParameter().getParentPageId()));
                }
            }
        }
    }

    private FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = appId != null && "cas".equals(appId) || "cbei".equals(appId) ? "cbei" : "bei";
        para.setAppId(appId);
        para.setFormId("cas_printview");
        para.getOpenStyle().setShowType(ShowType.NewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        para.getOpenStyle().setTargetKey("tabap");
        return para;
    }

    private void showBill(HashSet<Long> detailIds, String entityBeidetail) {
        if (CasHelper.isNotEmpty(detailIds) && detailIds.size() > 0) {
            int size = detailIds.size();
            if (size == 1) {
                BillShowParameter para = new BillShowParameter();
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = appId != null && "cas".equals(appId) || "cbei".equals(appId) ? "cbei" : "bei";
                para.setAppId(appId);
                para.setFormId(entityBeidetail);
                para.setPkId((Object)detailIds.iterator().next());
                para.getOpenStyle().setShowType(ShowType.NewTabPage);
                para.getOpenStyle().setTargetKey("tabap");
                this.getView().showForm((FormShowParameter)para);
            } else {
                ListShowParameter para = new ListShowParameter();
                String appId = this.getView().getFormShowParameter().getAppId();
                appId = appId != null && "cas".equals(appId) || "cbei".equals(appId) ? "cbei" : "bei";
                ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(1);
                qFilterArrayList.add(new QFilter("id", "in", detailIds));
                para.setAppId(appId);
                para.setBillFormId(entityBeidetail);
                para.getListFilterParameter().setQFilters(qFilterArrayList);
                para.getOpenStyle().setShowType(ShowType.NewTabPage);
                para.setCustomParam("setDefaultFilters", (Object)Boolean.TRUE);
                para.setCustomParam("bizdate", (Object)"");
                para.setCustomParam("company.id", (Object)"");
                para.setCustomParam("accountbank.id", (Object)"");
                para.getOpenStyle().setTargetKey("tabap");
                this.getView().showForm((FormShowParameter)para);
            }
        }
    }
}

