/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.workbench.BillSummaryInfo;
import kd.fi.cas.formplugin.workbench.PayStatusEnum;
import kd.fi.cas.util.AutoSumableDataProvider;
import kd.fi.cas.util.ComboKey;
import kd.fi.cas.util.DataSetUtil;
import kd.fi.cas.util.DateUtils;

public class PayWorkbenchDataCenter {
    private Date beginDate;
    private Date endDate;
    private Long convertCurrency;
    private Map<ComboKey, Collection<Long>> curErtAccountMap = new HashMap<ComboKey, Collection<Long>>();
    private Map<ComboKey, BigDecimal> exchangerateCache = new HashMap<ComboKey, BigDecimal>();
    private AutoSumableDataProvider paymentDataProvider;
    private AutoSumableDataProvider agentPayDataProvider;
    private AutoSumableDataProvider transdetailDataProvider;
    private AutoSumableDataProvider mergedPayableDataProvider;

    public PayWorkbenchDataCenter(Collection<Long> accountPks, Date beginDate, Date endDate, Long convertCurrency) {
        this.beginDate = DateUtils.truncateDate((Date)beginDate);
        this.endDate = DateUtils.truncateDate((Date)endDate);
        this.convertCurrency = convertCurrency;
        this.curErtAccountMap = this.groupByBaseCurrency(accountPks);
        this.cacheExchangerate();
        if (this.curErtAccountMap.isEmpty()) {
            this.paymentDataProvider = new AutoSumableDataProvider("cas_paybill");
            this.agentPayDataProvider = new AutoSumableDataProvider("cas_agentpaybill");
            this.transdetailDataProvider = new AutoSumableDataProvider("bei_transdetail_cas");
        } else {
            this.loadPayBillData();
            this.loadAgentPayBillData();
            this.loadTransdetailData();
        }
    }

    private Map<ComboKey, Collection<Long>> groupByBaseCurrency(Collection<Long> accountPks) {
        Map<Long, Collection<Long>> orgAccountMap = this.groupByOrg(accountPks);
        HashMap<Long, ComboKey> orgCurErtMap = new HashMap<Long, ComboKey>();
        Set<Long> orgIds = orgAccountMap.keySet();
        String selectors = String.join((CharSequence)",", "standardcurrency", "exratetable", "org");
        DynamicObjectCollection cashMgtInfos = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)selectors, (QFilter[])new QFilter("org", "in", orgIds).toArray());
        for (DynamicObject cashMgt : cashMgtInfos) {
            Function<Long, ComboKey> comboKeyFunc = k -> new ComboKey(new Object[]{cashMgt.getLong("standardcurrency"), cashMgt.getLong("exratetable")});
            orgCurErtMap.computeIfAbsent(cashMgt.getLong("org"), comboKeyFunc);
        }
        HashMap<ComboKey, Collection<Long>> curErtAccountMap = new HashMap<ComboKey, Collection<Long>>();
        if (orgAccountMap == null || orgAccountMap.size() == 0) {
            return curErtAccountMap;
        }
        for (Map.Entry<Long, Collection<Long>> orgEntry : orgAccountMap.entrySet()) {
            Long orgId = orgEntry.getKey();
            if (!orgCurErtMap.containsKey(orgId)) {
                orgAccountMap.remove(orgId);
                continue;
            }
            ComboKey curErt = (ComboKey)orgCurErtMap.get(orgId);
            Collection<Long> accountList = orgEntry.getValue();
            curErtAccountMap.compute(curErt, (k, v) -> {
                if (v == null) {
                    return accountList;
                }
                v.addAll(accountList);
                return v;
            });
        }
        return curErtAccountMap;
    }

    private Map<Long, Collection<Long>> groupByOrg(Collection<Long> accountPks) {
        HashMap<Long, Collection<Long>> map = new HashMap<Long, Collection<Long>>();
        String accountSelector = String.join((CharSequence)",", "company", "id");
        DynamicObjectCollection accountBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)accountSelector, (QFilter[])new QFilter[]{new QFilter("id", "in", accountPks)});
        for (DynamicObject account : accountBanks) {
            Long orgId = account.getLong("company");
            map.compute(orgId, (k, v) -> {
                if (v == null) {
                    v = new LinkedList<Long>();
                }
                v.add(account.getLong("id"));
                return v;
            });
        }
        return map;
    }

    private void cacheExchangerate() {
        this.curErtAccountMap.keySet().forEach(currency -> {
            if (this.convertCurrency == null || currency.getKey(0).equals(this.convertCurrency)) {
                this.exchangerateCache.put((ComboKey)currency, BigDecimal.ONE);
            } else {
                BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)((Long)currency.getKey(1)), (Long)((Long)currency.getKey(0)), (Long)this.convertCurrency, (Date)new Date());
                if (exchangeRate == null) {
                    exchangeRate = BigDecimal.ONE;
                }
                this.exchangerateCache.put((ComboKey)currency, exchangeRate);
            }
        });
    }

    private void loadPayBillData() {
        for (Map.Entry<ComboKey, Collection<Long>> entry : this.curErtAccountMap.entrySet()) {
            Collection<Long> accountPks = entry.getValue();
            QFilter accountFilter = new QFilter("payeracctbank", "in", accountPks);
            QFilter dateFilter = new QFilter("bizdate", ">=", (Object)this.beginDate).and("bizdate", "<=", (Object)this.endDate);
            QFilter[] filters = new QFilter[]{accountFilter, dateFilter};
            AutoSumableDataProvider temProvider = new AutoSumableDataProvider("cas_paybill");
            temProvider.filter(filters).groupBy(new String[]{"iscommitbe", "bankpaystatus as bankbillstatus", "billstatus", "case when sourcebilltype='bei_transdetail' then 1 else 0 end as isfromtransdetail"}).sum(new String[]{"localamt", "1 as count"}).query();
            BigDecimal exchangeRate = this.exchangerateCache.getOrDefault(entry.getKey(), BigDecimal.ONE);
            this.convertAmountValue(temProvider, exchangeRate, "localamt");
            if (this.paymentDataProvider == null) {
                this.paymentDataProvider = temProvider;
                continue;
            }
            this.paymentDataProvider = AutoSumableDataProvider.merge((AutoSumableDataProvider)this.paymentDataProvider, (AutoSumableDataProvider)temProvider);
        }
    }

    private void loadAgentPayBillData() {
        for (Map.Entry<ComboKey, Collection<Long>> entry : this.curErtAccountMap.entrySet()) {
            Collection<Long> accountPks = entry.getValue();
            QFilter accountFilter = new QFilter("payeracctbank", "in", accountPks);
            QFilter dateFilter = new QFilter("bizdate", ">=", (Object)this.beginDate).and("bizdate", "<=", (Object)this.endDate);
            AutoSumableDataProvider temProvider = new AutoSumableDataProvider("cas_agentpaybill");
            temProvider.filter(new QFilter[]{accountFilter, dateFilter}).groupBy(new String[]{"iscommitbe", "billstatus", "bankagentpaystatus as bankbillstatus", "0 as isfromtransdetail"}).sum(new String[]{"1 as count", "localamt", "actpayamount*exchangerate as actpayamt"}).query();
            BigDecimal exchangeRate = this.exchangerateCache.getOrDefault(entry.getKey(), BigDecimal.ONE);
            this.convertAmountValue(temProvider, exchangeRate, "localamt", "actpayamt");
            if (this.agentPayDataProvider == null) {
                this.agentPayDataProvider = temProvider;
                continue;
            }
            this.agentPayDataProvider = AutoSumableDataProvider.merge((AutoSumableDataProvider)this.agentPayDataProvider, (AutoSumableDataProvider)temProvider);
        }
    }

    private void loadTransdetailData() {
        for (Map.Entry<ComboKey, Collection<Long>> entry : this.curErtAccountMap.entrySet()) {
            Collection<Long> accountPks = entry.getValue();
            QFilter accountFilter = new QFilter("accountbank", "in", accountPks);
            QFilter dateFilter = new QFilter("bizdate", ">=", (Object)this.beginDate).and("bizdate", "<=", (Object)this.endDate);
            QFilter KDFilter = new QFilter("iskdretflag", "=", (Object)false);
            QFilter directionFilter = new QFilter("debitamount", ">", (Object)0);
            QFilter[] filters = new QFilter[]{accountFilter, dateFilter, KDFilter, directionFilter};
            AutoSumableDataProvider temProvider = new AutoSumableDataProvider("bei_transdetail_cas");
            temProvider.filter(filters).groupBy(new String[]{"isreced as booked"}).sum(new String[]{"debitamount", "1 as count"}).query();
            BigDecimal exchangeRate = this.exchangerateCache.getOrDefault(entry.getKey(), BigDecimal.ONE);
            this.convertAmountValue(temProvider, exchangeRate, "debitamount");
            if (this.transdetailDataProvider == null) {
                this.transdetailDataProvider = temProvider;
                continue;
            }
            this.transdetailDataProvider = AutoSumableDataProvider.merge((AutoSumableDataProvider)this.transdetailDataProvider, (AutoSumableDataProvider)temProvider);
        }
    }

    private void convertAmountValue(AutoSumableDataProvider dataProvider, BigDecimal exchangeRate, String ... amountKeys) {
        if (exchangeRate.compareTo(BigDecimal.ONE) == 0) {
            return;
        }
        dataProvider.getDsRowIterator().forEachRemaining(row -> {
            for (String key : amountKeys) {
                BigDecimal value = row.getBigDecimal(key);
                value = value.multiply(exchangeRate);
                DataSetUtil.setRowValue((AbstractRow)((AbstractRow)row), (String)key, (Object)value);
            }
        });
    }

    public BillSummaryInfo getPayableSummaryData(String entity, PayStatusEnum billstatus, boolean isFromTransdetail) {
        Function<Row, BillSummaryInfo> sourceAndStatusFunc = row -> {
            Iterable<PayStatusEnum> status;
            if (row.getBoolean("isfromtransdetail").equals(isFromTransdetail) && (status = this.getStatus((Row)row)) != null) {
                for (PayStatusEnum as : status) {
                    if (billstatus != as) continue;
                    return this.createSummaryInfo((Row)row, as);
                }
            }
            return new BillSummaryInfo();
        };
        if ("cas_paybill".equals(entity)) {
            BillSummaryInfo result = (BillSummaryInfo)this.paymentDataProvider.compute(sourceAndStatusFunc);
            return result == null ? new BillSummaryInfo() : result;
        }
        if ("cas_agentpaybill".equals(entity)) {
            BillSummaryInfo result = (BillSummaryInfo)this.agentPayDataProvider.compute(sourceAndStatusFunc);
            return result == null ? new BillSummaryInfo() : result;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u5b9e\u4f53\u6807\u8bc6\uff1a%s\u3002", (String)"PayWorkbenchDataCenter_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), entity));
    }

    public BillSummaryInfo getPayableTotalSummaryData(PayStatusEnum ... summaryStatus) {
        this.mergePayableDataProviders();
        BillSummaryInfo totalSummary = (BillSummaryInfo)this.mergedPayableDataProvider.compute(row -> {
            if (!row.getBoolean("isfromtransdetail").booleanValue()) {
                return this.createSummaryInfo((Row)row, null);
            }
            return new BillSummaryInfo();
        });
        return totalSummary == null ? new BillSummaryInfo() : totalSummary;
    }

    private BillSummaryInfo createSummaryInfo(Row row, PayStatusEnum status) {
        if (this.isAgentRow(row)) {
            if (PayStatusEnum.FAILD == status) {
                BigDecimal failedAmount = row.getBigDecimal("localamt").subtract(row.getBigDecimal("actpayamt"));
                return new BillSummaryInfo(failedAmount, row.getInteger("count"));
            }
            if (PayStatusEnum.PAYED == status) {
                return new BillSummaryInfo(row.getBigDecimal("actpayamt"), row.getInteger("count"));
            }
        }
        return new BillSummaryInfo(row.getBigDecimal("localamt"), row.getInteger("count"));
    }

    private boolean isAgentRow(Row row) {
        return DataSetUtil.containsKey((AbstractRow)((AbstractRow)row), (String)"actpayamt");
    }

    private void mergePayableDataProviders() {
        if (this.mergedPayableDataProvider == null) {
            this.mergedPayableDataProvider = AutoSumableDataProvider.merge((AutoSumableDataProvider)this.paymentDataProvider, (AutoSumableDataProvider)this.agentPayDataProvider);
        }
    }

    public Map<PayStatusEnum, BillSummaryInfo> getPayableStatusGroupSummaryData(PayStatusEnum ... summaryStatus) {
        BiFunction<Row, PayStatusEnum, BillSummaryInfo> vFunc = (row, status) -> this.createSummaryInfo((Row)row, (PayStatusEnum)((Object)status));
        Function<Row, Iterable> kFunc = row -> {
            Iterable<PayStatusEnum> status;
            LinkedList<PayStatusEnum> matchedStatus = new LinkedList<PayStatusEnum>();
            if (!row.getBoolean("isfromtransdetail").booleanValue() && (status = this.getStatus((Row)row)) != null) {
                for (PayStatusEnum aimStatus : summaryStatus) {
                    for (PayStatusEnum as : status) {
                        if (aimStatus != as) continue;
                        matchedStatus.add(as);
                    }
                }
            }
            return matchedStatus;
        };
        this.mergePayableDataProviders();
        Map groupSummaryData = this.mergedPayableDataProvider.computeMutiKey(kFunc, vFunc);
        for (PayStatusEnum aimStatus : summaryStatus) {
            groupSummaryData.computeIfAbsent(aimStatus, k -> new BillSummaryInfo());
        }
        return groupSummaryData;
    }

    public BillSummaryInfo getTransdetailSummaryData(boolean onlyNotyetBooked) {
        BillSummaryInfo result = null;
        if (onlyNotyetBooked) {
            Function<Row, BillSummaryInfo> func = row -> {
                if (!row.getBoolean("booked").booleanValue()) {
                    return new BillSummaryInfo(row.getBigDecimal("debitamount"), row.getInteger("count"));
                }
                return new BillSummaryInfo();
            };
            result = (BillSummaryInfo)this.transdetailDataProvider.compute(func);
        } else {
            result = (BillSummaryInfo)this.transdetailDataProvider.compute(row -> new BillSummaryInfo(row.getBigDecimal("debitamount"), row.getInteger("count")));
        }
        return result == null ? new BillSummaryInfo() : result;
    }

    private Iterable<PayStatusEnum> getStatus(Row row) {
        String billstatus = row.getString("billstatus");
        if (BillStatusEnum.SAVE.getValue().equals(billstatus)) {
            return Collections.singletonList(PayStatusEnum.TOSUBMIT);
        }
        if (BillStatusEnum.SUBMIT.getValue().equals(billstatus)) {
            return Collections.singletonList(PayStatusEnum.TOAUDIT);
        }
        if (BillStatusEnum.AUDIT.getValue().equals(billstatus)) {
            return Collections.singletonList(PayStatusEnum.TOPAY);
        }
        if (row.getBoolean("iscommitbe").booleanValue()) {
            String bankBillStatus = row.getString("bankbillstatus");
            if ("TF".equals(bankBillStatus)) {
                return Collections.singletonList(PayStatusEnum.FAILD);
            }
            if ("TS".equals(bankBillStatus)) {
                if (this.isAgentRow(row) && row.getBigDecimal("localamt").compareTo(row.getBigDecimal("actpayamt")) != 0) {
                    return Arrays.asList(PayStatusEnum.FAILD, PayStatusEnum.PAYED);
                }
                return Collections.singletonList(PayStatusEnum.PAYED);
            }
            return Collections.singletonList(PayStatusEnum.TOSYNC);
        }
        if (BillStatusEnum.PAY.getValue().equals(billstatus)) {
            return Collections.singletonList(PayStatusEnum.PAYED);
        }
        return null;
    }
}

