/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.consts.Constants;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.workbench.BillSummaryInfo;
import kd.fi.cas.formplugin.workbench.PayStatusEnum;
import kd.fi.cas.formplugin.workbench.PayWorkbenchDataCenter;
import kd.fi.cas.formplugin.workbench.WorkbenchList;
import kd.fi.cas.helper.LspWapper;
import kd.fi.cas.util.ComboKey;

public class PayWorkbenchPlugin
extends WorkbenchList {
    private DecimalFormat amountFormatter = new DecimalFormat("##,##.##");
    private static final String[] staticContainers = new String[]{"paypanel_tosubmit", "paypanel_topay", "paypanel_failed", "paypanel_tosync", "paypanel_paid", "agentpanel_tosubmit", "agentpanel_topay", "agentpanel_failed", "agentpanel_tosync", "agentpanel_paid", "transdetailpanel_all", "transdetailpanel_toacct", "bepay_tosubmit", "bepay_toaudit", "bepay_topay", "bepay_paid"};
    private static final String[] staticCardFields = new String[]{"flexpanel1", "flexpanel2", "flexpanel3"};

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setEntityId("bei_transdetail_cas");
        filterContainer.setTitle(new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u4e2d\u5fc3", (String)"PayWorkbenchPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0])));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String[] containers = staticContainers;
        for (int i = 0; i < containers.length; ++i) {
            Container container = (Container)this.getView().getControl(containers[i]);
            container.addClickListener((ClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        if ("comunit".equals(key)) {
            this.viewCard();
        } else if ("currency".equals(key)) {
            DynamicObject convertCurrency = (DynamicObject)this.getModel().getValue("currency");
            if (convertCurrency == null) {
                return;
            }
            this.viewCard(false);
        }
    }

    private boolean checkExchangeRate(DynamicObjectCollection cashMgtInfos) {
        DynamicObject convertCurrency = (DynamicObject)this.getModel().getValue("currency");
        HashSet<ComboKey> curErtSet = new HashSet<ComboKey>();
        for (DynamicObject cashMgt : cashMgtInfos) {
            BigDecimal exchangeRate;
            ComboKey comboKey;
            long baseCurrencyId = cashMgt.getLong("standardcurrency");
            long exchangerateTableId = cashMgt.getLong("exratetable");
            long orgId = cashMgt.getLong("org");
            if (orgId == 0L || baseCurrencyId == 0L || exchangerateTableId == 0L || curErtSet.contains(comboKey = new ComboKey(new Object[]{baseCurrencyId, exchangerateTableId}))) continue;
            curErtSet.add(comboKey);
            long convertCurrencyId = (Long)convertCurrency.getPkValue();
            if (baseCurrencyId == convertCurrencyId || (exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangerateTableId, (Long)baseCurrencyId, (Long)convertCurrencyId, (Date)new Date())) != null) continue;
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"name");
            DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)baseCurrencyId, (String)"bd_currency", (String)"name,number");
            DynamicObject exchangerateTable = BusinessDataServiceHelper.loadSingle((Object)exchangerateTableId, (String)"bd_exratetable", (String)"name,number");
            String message = String.format(ResManager.loadKDString((String)"%1$s\u4f7f\u7528\u7684\u6c47\u7387\u8868\u201c%2$s\u201d\u4e2d\u7f3a\u5c11%3$s\u201c%4$s\u201d\u5230%5$s\u201c%5$s\u201d\u7684\u6c47\u7387\u3002", (String)"PayWorkbenchPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), org.getString("name"), exchangerateTable.getString("name"), currency.getString("name"), currency.getString("number"), convertCurrency.getString("name"), convertCurrency.getString("number"));
            this.getView().showErrorNotification(message);
            return false;
        }
        return true;
    }

    protected void viewCard(boolean resetCurrency) {
        List<Long> accountPks = this.getSelectedAccountPks();
        Date beginDate = this.getSelectedBeginDate();
        Date endDate = this.getSelectedEndDate();
        if (accountPks == null || beginDate == null || endDate == null) {
            return;
        }
        List<Long> orgPks = this.getSelectedOrgPks();
        String selectors = String.join((CharSequence)",", "standardcurrency", "exratetable", "org");
        DynamicObjectCollection cashMgtInfos = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)selectors, (QFilter[])new QFilter("org", "in", orgPks).toArray());
        if (resetCurrency) {
            this.resetCurrency(cashMgtInfos);
        }
        if (!this.checkExchangeRate(cashMgtInfos)) {
            return;
        }
        this.amountFormatter = this.getAmountFormater();
        PayWorkbenchDataCenter dataCenter = new PayWorkbenchDataCenter(accountPks, beginDate, endDate, null);
        IDataModel model = this.getModel();
        BigDecimal unit = new BigDecimal((String)model.getValue("comunit"));
        BillSummaryInfo totalSummaryData = dataCenter.getPayableTotalSummaryData(PayStatusEnum.TOSUBMIT, PayStatusEnum.TOAUDIT, PayStatusEnum.TOPAY, PayStatusEnum.TOSYNC, PayStatusEnum.FAILD, PayStatusEnum.PAYED);
        model.setValue("allcount", (Object)totalSummaryData.getCount());
        model.setValue("allamount", (Object)this.amountFormatter.format(totalSummaryData.getAmount().divide(unit)));
        Map<PayStatusEnum, BillSummaryInfo> payableStatusGroupSummaryData = dataCenter.getPayableStatusGroupSummaryData(PayStatusEnum.TOSUBMIT, PayStatusEnum.TOPAY, PayStatusEnum.TOSYNC, PayStatusEnum.FAILD, PayStatusEnum.PAYED);
        this.showPieChart(payableStatusGroupSummaryData);
        Map<String, ComboKey> fieldMapper = this.getFieldMapper();
        fieldMapper.forEach((field, v) -> {
            BillSummaryInfo payableSummaryData = dataCenter.getPayableSummaryData((String)v.getKey(0), (PayStatusEnum)((Object)((Object)v.getKey(2))), (Boolean)v.getKey(1));
            boolean isAmount = (Boolean)v.getKey(3);
            if (isAmount) {
                model.setValue(field, (Object)this.amountFormatter.format(payableSummaryData.getAmount().divide(unit)));
            } else {
                model.setValue(field, (Object)payableSummaryData.getCount());
            }
        });
        BillSummaryInfo transdetailSummaryData = dataCenter.getTransdetailSummaryData(false);
        model.setValue("beallcount", (Object)transdetailSummaryData.getCount());
        model.setValue("beallamount", (Object)this.amountFormatter.format(transdetailSummaryData.getAmount().divide(unit)));
        transdetailSummaryData = dataCenter.getTransdetailSummaryData(true);
        model.setValue("bedairunum", (Object)transdetailSummaryData.getCount());
        model.setValue("bedairuamount", (Object)this.amountFormatter.format(transdetailSummaryData.getAmount().divide(unit)));
        String[] cardfields = staticCardFields;
        for (int i = 0; i < cardfields.length; ++i) {
            this.getView().updateView(cardfields[i]);
        }
    }

    @Override
    protected void viewCard() {
        this.viewCard(true);
    }

    private void resetCurrency(DynamicObjectCollection cashMgtInfos) {
        for (DynamicObject cashMgt : cashMgtInfos) {
            long baseCurrency = cashMgt.getLong("standardcurrency");
            if (baseCurrency == 0L) continue;
            this.getModel().beginInit();
            this.getModel().setValue("currency", (Object)baseCurrency);
            this.getModel().endInit();
            return;
        }
    }

    private void showPieChart(Map<PayStatusEnum, BillSummaryInfo> payableStatusGroupSummaryData) {
        PieChart pieChart = (PieChart)this.getControl("handlechart");
        pieChart.clearData();
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ee3\u53d1\u5206\u6790", (String)"PayWorkbenchPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        ItemValue[] items = this.getDefaultProfitData(payableStatusGroupSummaryData);
        series.setData(items);
        pieChart.setName(new LocaleString(ResManager.loadKDString((String)"\u5360\u6bd4", (String)"PayWorkbenchPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        series.setRadius("60%", "80%");
        pieChart.setShowTitle(true);
        pieChart.setShowLegend(false);
        pieChart.setLegendVertical(true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("color", "#7F93BC");
        map.put("fontSize", 20);
        map.put("fontWeight", "lighter");
        pieChart.setTitlePropValue("textStyle", map);
        map = new HashMap();
        HashMap<String, Boolean> normalMap = new HashMap<String, Boolean>();
        map.put("normal", normalMap);
        normalMap.put("show", Boolean.FALSE);
        series.setPropValue("label", map);
        series.setPropValue("labelLine", map);
        pieChart.refresh();
    }

    private ItemValue[] getDefaultProfitData(Map<PayStatusEnum, BillSummaryInfo> payableStatusGroupSummaryData) {
        ItemValue item5;
        ItemValue item4;
        ItemValue item3;
        ItemValue item2;
        ItemValue item1;
        ItemValue[] items = new ItemValue[5];
        int sumcount = 0;
        for (BillSummaryInfo v : payableStatusGroupSummaryData.values()) {
            sumcount += v.getCount();
        }
        String tipTemplate = ResManager.loadKDString((String)"%1$s\u7b14\uff0c\n\u91d1\u989d\u4e3a%2$s\n\u5360\u6bd4%3$s", (String)"PayWorkbenchPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
        BillSummaryInfo toSubmit = payableStatusGroupSummaryData.get((Object)PayStatusEnum.TOSUBMIT);
        String confirmMessage = String.format(tipTemplate, toSubmit.getCount(), this.amountFormatter.format(toSubmit.getAmount()), this.formatPercentage(sumcount, toSubmit.getCount()));
        items[0] = item1 = new ItemValue(String.format(ResManager.loadKDString((String)"\u5f85\u63d0\u4ea4%s", (String)"PayWorkbenchPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), confirmMessage), (Number)toSubmit.getCount(), "#648CF9");
        BillSummaryInfo toPay = payableStatusGroupSummaryData.get((Object)PayStatusEnum.TOPAY);
        confirmMessage = String.format(tipTemplate, toPay.getCount(), this.amountFormatter.format(toPay.getAmount()), this.formatPercentage(sumcount, toPay.getCount()));
        items[1] = item2 = new ItemValue(String.format(ResManager.loadKDString((String)"\u5f85\u4ed8\u6b3e%s", (String)"PayWorkbenchPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]), confirmMessage), (Number)toPay.getCount(), "#48A4F6");
        BillSummaryInfo failed = payableStatusGroupSummaryData.get((Object)PayStatusEnum.FAILD);
        confirmMessage = String.format(tipTemplate, failed.getCount(), this.amountFormatter.format(failed.getAmount()), this.formatPercentage(sumcount, failed.getCount()));
        items[2] = item3 = new ItemValue(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25%s", (String)"PayWorkbenchPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]), confirmMessage), (Number)failed.getCount(), "#bf00bf");
        BillSummaryInfo toSync = payableStatusGroupSummaryData.get((Object)PayStatusEnum.TOSYNC);
        confirmMessage = String.format(tipTemplate, toSync.getCount(), this.amountFormatter.format(toSync.getAmount()), this.formatPercentage(sumcount, toSync.getCount()));
        items[3] = item4 = new ItemValue(String.format(ResManager.loadKDString((String)"\u5f85\u540c\u6b65%s", (String)"PayWorkbenchPlugin_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), confirmMessage), (Number)toSync.getCount(), "#7f007f");
        BillSummaryInfo payed = payableStatusGroupSummaryData.get((Object)PayStatusEnum.PAYED);
        confirmMessage = String.format(tipTemplate, payed.getCount(), this.amountFormatter.format(payed.getAmount()), this.formatPercentage(sumcount, payed.getCount()));
        items[4] = item5 = new ItemValue(String.format(ResManager.loadKDString((String)"\u5df2\u4ed8\u6b3e%s", (String)"PayWorkbenchPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), confirmMessage), (Number)payed.getCount(), "#0000ff");
        return items;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key)) {
            this.refresh();
        }
    }

    private String formatPercentage(int totalCount, int count) {
        NumberFormat nt = NumberFormat.getPercentInstance();
        nt.setMinimumFractionDigits(2);
        BigDecimal bigcount = new BigDecimal(count);
        if (bigcount.compareTo(Constants.ZERO) == 0) {
            return "0%";
        }
        return nt.format(bigcount.divide(BigDecimal.valueOf(totalCount), 2, RoundingMode.DOWN));
    }

    private Map<String, ComboKey> getFieldMapper() {
        HashMap<String, ComboKey> fieldMap = new HashMap<String, ComboKey>(40);
        fieldMap.put("submitnum", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.TOSUBMIT, Boolean.FALSE}));
        fieldMap.put("submitamount", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.TOSUBMIT, Boolean.TRUE}));
        fieldMap.put("daifukuancount", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.TOPAY, Boolean.FALSE}));
        fieldMap.put("daifukuanamount", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.TOPAY, Boolean.TRUE}));
        fieldMap.put("shibaicount", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.FAILD, Boolean.FALSE}));
        fieldMap.put("shibaiamount", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.FAILD, Boolean.TRUE}));
        fieldMap.put("tongbucount", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.TOSYNC, Boolean.FALSE}));
        fieldMap.put("tongbuamount", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.TOSYNC, Boolean.TRUE}));
        fieldMap.put("fukuancount", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.PAYED, Boolean.FALSE}));
        fieldMap.put("fukuanamount", new ComboKey(new Object[]{"cas_paybill", Boolean.FALSE, PayStatusEnum.PAYED, Boolean.TRUE}));
        fieldMap.put("agsubmitnum", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.TOSUBMIT, Boolean.FALSE}));
        fieldMap.put("agsubmitamount", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.TOSUBMIT, Boolean.TRUE}));
        fieldMap.put("agdaifukuancount", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.TOPAY, Boolean.FALSE}));
        fieldMap.put("agdaifukuanamount", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.TOPAY, Boolean.TRUE}));
        fieldMap.put("agshibaicount", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.FAILD, Boolean.FALSE}));
        fieldMap.put("agshibaiamount", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.FAILD, Boolean.TRUE}));
        fieldMap.put("agtongbucount", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.TOSYNC, Boolean.FALSE}));
        fieldMap.put("agtongbuamount", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.TOSYNC, Boolean.TRUE}));
        fieldMap.put("agfukuancount", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.PAYED, Boolean.FALSE}));
        fieldMap.put("agfukuanamount", new ComboKey(new Object[]{"cas_agentpaybill", Boolean.FALSE, PayStatusEnum.PAYED, Boolean.TRUE}));
        fieldMap.put("bedaitijaocount", new ComboKey(new Object[]{"cas_paybill", Boolean.TRUE, PayStatusEnum.TOSUBMIT, Boolean.FALSE}));
        fieldMap.put("bedaitijiaoamount", new ComboKey(new Object[]{"cas_paybill", Boolean.TRUE, PayStatusEnum.TOSUBMIT, Boolean.TRUE}));
        fieldMap.put("bedaishencount", new ComboKey(new Object[]{"cas_paybill", Boolean.TRUE, PayStatusEnum.TOAUDIT, Boolean.FALSE}));
        fieldMap.put("bedaishenamount", new ComboKey(new Object[]{"cas_paybill", Boolean.TRUE, PayStatusEnum.TOAUDIT, Boolean.TRUE}));
        fieldMap.put("bedaifukuancount", new ComboKey(new Object[]{"cas_paybill", Boolean.TRUE, PayStatusEnum.TOPAY, Boolean.FALSE}));
        fieldMap.put("bedaifukuanamount", new ComboKey(new Object[]{"cas_paybill", Boolean.TRUE, PayStatusEnum.TOPAY, Boolean.TRUE}));
        fieldMap.put("beyifucount", new ComboKey(new Object[]{"cas_paybill", Boolean.TRUE, PayStatusEnum.PAYED, Boolean.FALSE}));
        fieldMap.put("beyifuamount", new ComboKey(new Object[]{"cas_paybill", Boolean.TRUE, PayStatusEnum.PAYED, Boolean.TRUE}));
        return fieldMap;
    }

    private DecimalFormat getAmountFormater() {
        int amtprecision = 2;
        DynamicObject currencyDy = (DynamicObject)this.getModel().getValue("currency");
        if (currencyDy != null) {
            amtprecision = currencyDy.getInt("amtprecision");
        }
        StringBuilder stringBuilder = new StringBuilder("##,##0.");
        for (int i = 0; i < amtprecision; ++i) {
            stringBuilder.append('0');
        }
        String format = stringBuilder.toString();
        return new DecimalFormat(format);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String entity = null;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (source.getKey().startsWith("agent")) {
            entity = "cas_agentpaybill";
            qFilters.add(this.getListQfilter("payeracctbank"));
        } else if (source.getKey().startsWith("transdetail")) {
            entity = "bei_transdetail_cas";
            qFilters.add(this.getListQfilter("accountbank"));
            qFilters.add(new QFilter("iskdretflag", "!=", (Object)true));
            qFilters.add(new QFilter("receredtype", "!=", (Object)3));
        } else {
            entity = "cas_paybill";
            qFilters.add(this.getListQfilter("payeracctbank"));
        }
        String status = BillStatusEnum.SAVE.getValue();
        if (source.getKey().equals("paypanel_tosubmit")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            filter.and(new QFilter("sourcebilltype", "!=", (Object)"bei_transdetail_cas"));
            qFilters.add(filter);
            status = BillStatusEnum.SAVE.getValue();
        } else if (source.getKey().equals("paypanel_topay")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            filter.and(new QFilter("sourcebilltype", "!=", (Object)"bei_transdetail_cas"));
            qFilters.add(filter);
            status = BillStatusEnum.AUDIT.getValue();
        } else if (source.getKey().equals("paypanel_failed")) {
            QFilter filter = new QFilter("bankpaystatus", "=", (Object)BeBillStatusEnum.TF.getValue());
            filter.and(new QFilter("iscommitbe", "=", (Object)true));
            qFilters.add(filter);
            status = BillStatusEnum.PAY.getValue();
        } else if (source.getKey().equals("paypanel_tosync")) {
            QFilter filter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.PAY.getValue());
            filter.and(new QFilter("iscommitbe", "=", (Object)true));
            qFilters.add(filter);
            status = BillStatusEnum.BEING.getValue();
        } else if (source.getKey().equals("paypanel_paid")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
            filter.and(new QFilter("sourcebilltype", "!=", (Object)"bei_transdetail_cas"));
            qFilters.add(filter);
            status = BillStatusEnum.PAY.getValue();
        } else if (source.getKey().equals("agentpanel_tosubmit")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            filter.and(new QFilter("sourcebilltype", "!=", (Object)"bei_transdetail_cas"));
            qFilters.add(filter);
            status = BillStatusEnum.SAVE.getValue();
        } else if (source.getKey().equals("agentpanel_topay")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            filter.and(new QFilter("sourcebilltype", "!=", (Object)"bei_transdetail_cas"));
            qFilters.add(filter);
            status = BillStatusEnum.AUDIT.getValue();
        } else if (source.getKey().equals("agentpanel_failed")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
            filter.and(new QFilter("sourcebilltype", "!=", (Object)"bei_transdetail_cas"));
            filter.and(new QFilter("iscommitbe", "=", (Object)true));
            filter.and(new QFilter("entry.e_issuccess", "=", (Object)false));
            qFilters.add(filter);
            status = BillStatusEnum.PAY.getValue();
        } else if (source.getKey().equals("agentpanel_tosync")) {
            QFilter filter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.PAY.getValue());
            filter.and(new QFilter("sourcebilltype", "!=", (Object)"bei_transdetail_cas"));
            filter.and(new QFilter("iscommitbe", "=", (Object)true));
            qFilters.add(filter);
            status = BillStatusEnum.BEING.getValue();
        } else if (source.getKey().equals("agentpanel_paid")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
            filter.and(new QFilter("sourcebilltype", "!=", (Object)"bei_transdetail_cas"));
            filter.and(new QFilter("entry.e_issuccess", "=", (Object)true));
            qFilters.add(filter);
            status = BillStatusEnum.PAY.getValue();
        } else if (source.getKey().equals("transdetailpanel_toacct")) {
            QFilter filter = new QFilter("debitamount", ">", (Object)0);
            filter.and(new QFilter("iskdretflag", "=", (Object)false));
            filter.and(new QFilter("isreced", "=", (Object)false));
            qFilters.add(filter);
        } else if (source.getKey().equals("bepay_tosubmit")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            filter.and(new QFilter("sourcebilltype", "=", (Object)"bei_transdetail_cas"));
            qFilters.add(filter);
            status = BillStatusEnum.SAVE.getValue();
        } else if (source.getKey().equals("bepay_toaudit")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
            filter.and(new QFilter("sourcebilltype", "=", (Object)"bei_transdetail_cas"));
            qFilters.add(filter);
            status = BillStatusEnum.SUBMIT.getValue();
        } else if (source.getKey().equals("bepay_topay")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            filter.and(new QFilter("sourcebilltype", "=", (Object)"bei_transdetail_cas"));
            qFilters.add(filter);
            status = BillStatusEnum.AUDIT.getValue();
        } else if (source.getKey().equals("bepay_paid")) {
            QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
            filter.and(new QFilter("sourcebilltype", "=", (Object)"bei_transdetail_cas"));
            qFilters.add(filter);
            status = BillStatusEnum.PAY.getValue();
        }
        this.showHyperList(qFilters, entity, status);
    }

    private void showHyperList(List<QFilter> filters, String entity, String billstatus) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(entity);
        LspWapper lspWapper = new LspWapper(lsp);
        if ("bei_transdetail_cas".equals(entity)) {
            lspWapper.clearPlugins();
            lspWapper.registerPlugin("kd.tmc.bei.formplugin.detail.TransDetailHyperlinkList");
            lsp.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u6536\u4ed8\u5904\u7406", (String)"PayWorkbenchPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            lsp.setCustomParam("company.id", this.getSelectedOrgPks());
        } else {
            lsp.setCustomParam("org.id", this.getSelectedOrgPks());
        }
        lspWapper.coverFilters(filters.toArray(new QFilter[0]));
        lspWapper.setStyleWithParentView(this.getView());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<String> dataRange = Arrays.asList(dateFormat.format(this.getSelectedBeginDate()), dateFormat.format(this.getSelectedEndDate()));
        lsp.setCustomParam("isopenbyhyperlink", (Object)true);
        lsp.setCustomParam("bizdate", dataRange);
        lsp.setCustomParam("accountbank.id", this.getSelectedAccountPks());
        lsp.setCustomParam("billstatus", Collections.singletonList(billstatus));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private QFilter getListQfilter(String accountFieldKey) {
        QFilter filter = new QFilter(accountFieldKey, "in", this.getSelectedAccountPks());
        filter.and(new QFilter("bizdate", ">=", (Object)this.getSelectedBeginDate()));
        filter.and(new QFilter("bizdate", "<=", (Object)this.getSelectedEndDate()));
        return filter;
    }
}

