/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workbench;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.formplugin.workbench.WorkbenchList;
import kd.fi.cas.helper.LspWapper;

public class RecWorkbenchPlugin
extends WorkbenchList {
    private static Log logger = LogFactory.getLog(RecWorkbenchPlugin.class);
    private static final String CAS_INTELREC = "cas_intelrec";
    private static final Log LOGGER = LogFactory.getLog(RecWorkbenchPlugin.class);
    private static final String[] staticCardFields = new String[]{"accounted_panel", "noaccounted_panel", "all_panel", "rec_panel"};

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setEntityId("bei_transdetail_cas");
        filterContainer.setTitle(new LocaleString(ResManager.loadKDString((String)"\u6536\u6b3e\u5165\u8d26\u4e2d\u5fc3", (String)"RecWorkbenchPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0])));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"rec_panel"});
        this.tabChange();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("progtext", (Object)ResManager.loadKDString((String)"\u5df2\u5165\u8d26", (String)"RecWorkbenchPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("progtext1", (Object)ResManager.loadKDString((String)"\u5f85\u5165\u8d26", (String)"RecWorkbenchPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("progtext2", (Object)ResManager.loadKDString((String)"\u5168\u90e8", (String)"RecWorkbenchPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("progtext3", (Object)ResManager.loadKDString((String)"\u5728\u9014\u6536\u6b3e\u5355", (String)"RecWorkbenchPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "recordbotn": {
                this.refreshList();
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private void cancelEnter(ListSelectedRowCollection selectedRows) {
    }

    private void cancelHandlinK(DynamicObject detail) {
    }

    private void confirmEnter(ListSelectedRowCollection selectedRows, String thisOpnumber) {
    }

    private void cancelMatch(BillList list, ListSelectedRowCollection selectedRows) {
    }

    private void matchEnter(ListSelectedRowCollection selectedRows, String thisOpnumber) {
    }

    private void ruleEnter(ListSelectedRowCollection selectedRows, String thisOpnumber) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String operateKey = source.getKey();
        if (operateKey.equals("rec_panel")) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter filter = new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue(), BillStatusEnum.BEING.getValue()});
            filter.and(new QFilter("sourcebilltype", "=", (Object)"bei_transdetail"));
            qFilters.add(filter);
            qFilters.add(this.getListQfilter());
            this.showHyperList(qFilters, "cas_recbill");
        }
    }

    private void showHyperList(List<QFilter> qFilters, String entity) {
        ListShowParameter listShowParameter = new ListShowParameter();
        ArrayList<String> statuList = new ArrayList<String>();
        statuList.add(BillStatusEnum.SAVE.getValue());
        statuList.add(BillStatusEnum.SUBMIT.getValue());
        statuList.add(BillStatusEnum.AUDIT.getValue());
        statuList.add(BillStatusEnum.BEING.getValue());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<String> dataRange = Arrays.asList(dateFormat.format(this.getSelectedBeginDate()), dateFormat.format(this.getSelectedEndDate()));
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("isopenbyhyperlink", Boolean.TRUE);
        customParams.put("org.id", this.getSelectedOrgPks());
        customParams.put("bizdate", dataRange);
        customParams.put("billstatus", statuList);
        listShowParameter.setCustomParams(customParams);
        listShowParameter.setBillFormId(entity);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        LspWapper lspWapper = new LspWapper(listShowParameter);
        lspWapper.coverFilters(qFilters);
        lspWapper.setStyleWithParentView(this.getView());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private QFilter getListQfilter() {
        QFilter filter = new QFilter("accountbank", "in", this.getSelectedAccountPks());
        filter.and(new QFilter("bizdate", ">=", (Object)this.getSelectedBeginDate()));
        filter.and(new QFilter("bizdate", "<=", (Object)this.getSelectedEndDate()));
        return filter;
    }

    @Override
    protected void viewCard() {
    }

    private void receredOp(String opName, DynamicObject[] transdetails, DynamicObjectType type) {
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
    }

    private void showOperationResultMulti(OperationResult operationResult, String operateName, boolean isHasMatch) {
    }

    public OperateErrorInfo getOperateErrorInfo(Object pk, String meg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }
}

