/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin.workflow;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.SplitContainer;
import org.apache.commons.lang.StringUtils;

public class CasWorkFlowlPlugin
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.hideWorkFlowPanel();
    }

    protected void hideWorkFlowPanel() {
        if (this.isNoApproval()) {
            SplitContainer splitcontainer = (SplitContainer)this.getControl(this.getContainer());
            splitcontainer.setCollapse(this.getCollapse(), true);
        }
    }

    private boolean isNoApproval() {
        String billStatus;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        BillOperationStatus status = BillOperationStatus.VIEW;
        if (view.getFormShowParameter() instanceof BillShowParameter) {
            status = ((BillShowParameter)view.getFormShowParameter()).getBillStatus();
        }
        return (billStatus = (String)model.getValue("billstatus")) != null && "A".equals(billStatus) || BillOperationStatus.ADDNEW.compareTo((Enum)status) == 0 || this.isFlow(view);
    }

    private boolean isFlow(IFormView view) {
        if (view != null) {
            FormShowParameter parameter = view.getFormShowParameter();
            String fromId = parameter.getParentFormId();
            if (fromId != null && fromId.contains("task_")) {
                return true;
            }
            if (parameter != null) {
                Map customParams = parameter.getCustomParams();
                String sceneSign = "SCENE";
                if (customParams != null && customParams.size() >= 1 && customParams.get(sceneSign) != null) {
                    return StringUtils.equalsIgnoreCase((String)"AUDITFLOW", (String)customParams.get(sceneSign).toString());
                }
                return false;
            }
        }
        return false;
    }

    public String getContainer() {
        return "splitcontainerap";
    }

    public String getCollapse() {
        return "splitpanelap1";
    }
}

