/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.result;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.cas.compare.CompareUnit;
import kd.fi.cas.compare.concurrent.MultiThreadOperationExecutor;
import kd.fi.cas.compare.result.CompareUnitResult;
import kd.fi.cas.util.StopWatchWithSummary;

public class CompareUnitResultCalcModel {
    @Deprecated
    private static final int MAX_CNT = 500;
    private static final int CONCURRENT_MIN_DATA_CNT = 1000;
    private static final int INTERSECT_THREAD_CNT = 8;
    private List<CompareUnitResult> normalList = new ArrayList<CompareUnitResult>();
    private Set<CompareUnitResult> entireWaitMatchList = new HashSet<CompareUnitResult>();
    private Set<CompareUnitResult> entireMatchedList = new HashSet<CompareUnitResult>();
    private final Map<Object, Set<Object>> resultMap;
    private int weight = -1;
    private Map<Object, List<SrcListIndex>> srcIndexMap;
    private StopWatchWithSummary watch;

    private CompareUnitResultCalcModel(Map<Object, Set<Object>> resultMap) {
        this.resultMap = resultMap;
        this.srcIndexMap = new HashMap<Object, List<SrcListIndex>>();
    }

    public static List<CompareUnitResultCalcModel> fromUnitList(List<CompareUnit> compareUnitList) {
        ArrayList<CompareUnitResultCalcModel> calcList = new ArrayList<CompareUnitResultCalcModel>(compareUnitList.size());
        HashMap<Object, Set<Object>> resultMap = new HashMap<Object, Set<Object>>();
        StopWatchWithSummary stopWatch = StopWatchWithSummary.createUnstarted();
        for (CompareUnit compareUnit : compareUnitList) {
            List<CompareUnitResult> unitResult = compareUnit.getResult();
            CompareUnitResultCalcModel calcModel = new CompareUnitResultCalcModel(resultMap);
            calcModel.watch = stopWatch;
            for (CompareUnitResult compareUnitResult : unitResult) {
                Set<Object> srcSet = compareUnitResult.getSrcIdSet();
                calcModel.normalList.add(compareUnitResult);
            }
            calcModel.buildSrcIndex(0);
            calcList.add(calcModel);
        }
        return calcList;
    }

    public void initFirstModel() {
        this.entireMatchedList.addAll(this.entireWaitMatchList);
        this.entireWaitMatchList.clear();
    }

    public void intersection(CompareUnitResultCalcModel model) {
        this.intersectEntireArea(model);
        this.intersectNormalArea(model);
    }

    private void intersectEntireArea(CompareUnitResultCalcModel model) {
        this.watch.nextStep(ResManager.loadKDString((String)"WS\u533a\u4ea4\u96c6", (String)"CompareUnitResultCalcModel_0", (String)"fi-cas-common", (Object[])new Object[0]));
        ArrayList<CompareUnitResult> waitRemoveCurWList = new ArrayList<CompareUnitResult>();
        ArrayList<CompareUnitResult> waitRemovePrevSList = new ArrayList<CompareUnitResult>();
        if (this.entireWaitMatchList.size() == 0 || model.entireMatchedList.size() == 0) {
            int endIndex;
            if (this.entireWaitMatchList.size() != 0) {
                endIndex = this.normalList.size();
                this.normalList.addAll(this.entireWaitMatchList);
                this.buildSrcIndex(endIndex);
                this.entireWaitMatchList.clear();
            }
            if (model.entireMatchedList.size() != 0) {
                endIndex = model.normalList.size();
                model.normalList.addAll(model.entireMatchedList);
                model.buildSrcIndex(endIndex);
                model.entireMatchedList.clear();
            }
        } else {
            for (CompareUnitResult curW : this.entireWaitMatchList) {
                for (CompareUnitResult prevS : model.entireMatchedList) {
                    HashSet<Object> srcRes;
                    HashSet tarRes = new HashSet(Sets.intersection(curW.getTarIdSet(), prevS.getTarIdSet()));
                    if (tarRes.size() <= 0 || (srcRes = new HashSet<Object>((Collection<Object>)Sets.intersection(curW.getSrcIdSet(), prevS.getSrcIdSet()))).size() <= 0) continue;
                    CompareUnitResult successResult = new CompareUnitResult();
                    successResult.setSrcIdSet(srcRes);
                    successResult.setTarIdSet(new HashSet<Object>(tarRes));
                    this.entireMatchedList.add(successResult);
                    curW.getTarIdSet().removeAll(successResult.getTarIdSet());
                    prevS.getTarIdSet().removeAll(successResult.getTarIdSet());
                    if (prevS.getTarIdSet().size() == 0) {
                        waitRemovePrevSList.add(prevS);
                        continue;
                    }
                    model.normalList.add(prevS);
                    model.buildSrcIndex(model.normalList.size() - 1);
                }
                if (curW.getTarIdSet().size() == 0) {
                    waitRemoveCurWList.add(curW);
                    continue;
                }
                this.normalList.add(curW);
                this.buildSrcIndex(this.normalList.size() - 1);
            }
        }
        this.entireWaitMatchList.removeAll(waitRemoveCurWList);
        model.entireMatchedList.removeAll(waitRemovePrevSList);
        this.watch.reset();
    }

    private void intersectNormalArea(CompareUnitResultCalcModel model) {
        this.watch.nextStep(ResManager.loadKDString((String)"N\u533a\u6c42\u4ea4\u96c6", (String)"CompareUnitResultCalcModel_1", (String)"fi-cas-common", (Object[])new Object[0]));
        if (this.srcIndexMap.size() > 1000) {
            new MultiThreadOperationExecutor().doBatchOperation(new ArrayList<Map.Entry<Object, List<SrcListIndex>>>(this.srcIndexMap.entrySet()), 8, dataList -> {
                this.intersect(dataList, model);
                return null;
            });
        } else {
            this.intersect(new ArrayList<Map.Entry<Object, List<SrcListIndex>>>(this.srcIndexMap.entrySet()), model);
        }
        this.watch.reset();
    }

    private void intersect(List<Map.Entry<Object, List<SrcListIndex>>> dataList, CompareUnitResultCalcModel model) {
        for (Map.Entry<Object, List<SrcListIndex>> entry : dataList) {
            List<SrcListIndex> curSrcIdxList = entry.getValue();
            List<SrcListIndex> prevSrcIdxList = model.srcIndexMap.get(entry.getKey());
            if (prevSrcIdxList == null) {
                entry.getValue().clear();
                continue;
            }
            for (SrcListIndex curSrcIndex : curSrcIdxList) {
                HashSet<Object> intersectSrcSet = new HashSet<Object>();
                for (SrcListIndex prevSrcIndex : prevSrcIdxList) {
                    Set<Object> prevSrcSet = model.getActualSrcSet(prevSrcIndex);
                    Set<Object> curSrcSet = this.getActualSrcSet(curSrcIndex);
                    intersectSrcSet.addAll((Collection<Object>)Sets.intersection(curSrcSet, prevSrcSet));
                }
                if (curSrcIndex.isRemain()) {
                    curSrcIndex.setRemainSrcSet(intersectSrcSet);
                    continue;
                }
                Set<Object> actualSrcIdSet = this.normalList.get(curSrcIndex.getResultListIndex()).getSrcIdSet();
                if (intersectSrcSet.size() < actualSrcIdSet.size() / 2) {
                    curSrcIndex.setRemain(true);
                    curSrcIndex.setRemainSrcSet(intersectSrcSet);
                    curSrcIndex.getRemoveSrcSet().clear();
                    continue;
                }
                HashSet<Object> copy2 = new HashSet<Object>(actualSrcIdSet);
                copy2.removeAll(intersectSrcSet);
                curSrcIndex.setRemain(false);
                curSrcIndex.getRemoveSrcSet().addAll(copy2);
            }
        }
    }

    public Map<Object, Set<Object>> getFinalResult() {
        this.watch.nextStep(ResManager.loadKDString((String)"\u83b7\u53d6\u6700\u7ec8\u7ed3\u679c", (String)"CompareUnitResultCalcModel_2", (String)"fi-cas-common", (Object[])new Object[0]));
        HashMap<Object, Set<Object>> resultMap = new HashMap<Object, Set<Object>>(this.srcIndexMap.size());
        for (Map.Entry<Object, List<SrcListIndex>> entry : this.srcIndexMap.entrySet()) {
            List<SrcListIndex> srcIndexList = entry.getValue();
            HashSet<Object> srcIdSet = new HashSet<Object>();
            for (SrcListIndex listIndex : srcIndexList) {
                srcIdSet.addAll(this.getActualSrcSet(listIndex));
            }
            resultMap.put(entry.getKey(), srcIdSet);
        }
        this.watch.printSummary();
        return resultMap;
    }

    private Set<Object> getActualSrcSet(SrcListIndex listIndex) {
        Set<Object> actualSrcSet;
        if (listIndex.isRemain()) {
            actualSrcSet = listIndex.getRemainSrcSet();
        } else {
            actualSrcSet = new HashSet<Object>(this.normalList.get(listIndex.getResultListIndex()).getSrcIdSet());
            actualSrcSet.removeAll(listIndex.getRemoveSrcSet());
        }
        return actualSrcSet;
    }

    public int getWeight() {
        if (this.weight == -1) {
            this.entireWaitMatchList.stream().map(o -> o.getSrcIdSet().size()).max(Comparator.comparingInt(Integer::valueOf)).ifPresent(o -> {
                this.weight = o;
            });
        }
        return this.weight;
    }

    public Map<Object, Set<Object>> getResultMap() {
        return this.resultMap;
    }

    public Set<CompareUnitResult> getEntireMatchedList() {
        return this.entireMatchedList;
    }

    private void buildSrcIndex(int startIndex) {
        for (int i = startIndex; i < this.normalList.size(); ++i) {
            CompareUnitResult result = this.normalList.get(i);
            Set<Object> tarIdSet = result.getTarIdSet();
            for (Object tarId : tarIdSet) {
                List indexList = this.srcIndexMap.computeIfAbsent(tarId, t -> new ArrayList());
                if (tarIdSet.size() == 0) continue;
                SrcListIndex idx = new SrcListIndex();
                idx.setResultListIndex(i);
                if (result.getSrcIdSet().size() < SrcListIndex.REMOVE_MODE_MIN_LEN) {
                    idx.setRemain(true);
                    idx.setRemainSrcSet(result.getSrcIdSet());
                } else {
                    idx.setRemain(false);
                }
                indexList.add(idx);
            }
        }
    }

    private static class SrcListIndex {
        private static int REMOVE_MODE_MIN_LEN = 200;
        private boolean isRemain;
        private Integer resultListIndex;
        private Set<Object> remainSrcSet;
        private Set<Object> removeSrcSet;

        public SrcListIndex() {
            this.remainSrcSet = new HashSet<Object>();
            this.removeSrcSet = new HashSet<Object>();
        }

        public SrcListIndex(boolean isRemain, Integer resultListIndex, Set<Object> remainSrcSet, Set<Object> removeSrcSet) {
            this.isRemain = isRemain;
            this.resultListIndex = resultListIndex;
            this.remainSrcSet = remainSrcSet;
            this.removeSrcSet = removeSrcSet;
        }

        public boolean isRemain() {
            return this.isRemain;
        }

        public void setRemain(boolean remain) {
            this.isRemain = remain;
        }

        public Integer getResultListIndex() {
            return this.resultListIndex;
        }

        public void setResultListIndex(Integer resultListIndex) {
            this.resultListIndex = resultListIndex;
        }

        public Set<Object> getRemainSrcSet() {
            return this.remainSrcSet;
        }

        public void setRemainSrcSet(Set<Object> remainSrcSet) {
            this.remainSrcSet = remainSrcSet;
        }

        public Set<Object> getRemoveSrcSet() {
            return this.removeSrcSet;
        }

        public void setRemoveSrcSet(Set<Object> removeSrcSet) {
            this.removeSrcSet = removeSrcSet;
        }
    }
}

