/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.strategy;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.cas.compare.data.CompareData;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.strategy.AbstractMultiRuleCompareStrategy;

public class MultiRuleOneToOneCompareStrategy
extends AbstractMultiRuleCompareStrategy {
    public MultiRuleOneToOneCompareStrategy(List<List<CompareRule>> ruleList) {
        super(ruleList);
    }

    @Override
    protected void handleResult(List<CompareResult> successList, List<CompareResult> resultList, List<CompareData> srcDataList, List<CompareData> tarDataList) {
        HashMap<Object, Integer> srcIdPresentCntMap = new HashMap<Object, Integer>();
        for (CompareResult compareResult : resultList) {
            Set<Object> srcIdSet = compareResult.getSrcIdSet();
            for (Object object : srcIdSet) {
                Integer pCnt = srcIdPresentCntMap.computeIfAbsent(object, t -> 0);
                int tarSize = compareResult.getTarIdSet().size();
                srcIdPresentCntMap.put(object, pCnt + tarSize);
            }
        }
        Set<Object> multiSrcIdSet = srcIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        for (CompareResult compareResult : resultList) {
            compareResult.getSrcIdSet().removeAll(multiSrcIdSet);
        }
        this.removeFromDataList(srcDataList, multiSrcIdSet);
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> waitRemoveTarIdSet = new HashSet<Object>();
        HashMap<Object, Integer> tarIdPresentCntMap = new HashMap<Object, Integer>();
        for (CompareResult result : resultList) {
            Set<Object> tarIdSet = result.getTarIdSet();
            for (Object tarId : tarIdSet) {
                Integer pCnt = srcIdPresentCntMap.computeIfAbsent(tarId, t -> 0);
                int srcSize = result.getSrcIdSet().size();
                tarIdPresentCntMap.put(tarId, pCnt + srcSize);
            }
        }
        Set set = tarIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        ArrayList<CompareResult> waitRemoveResultList = new ArrayList<CompareResult>();
        for (CompareResult result : resultList) {
            Sets.SetView intersection;
            if (result.getSrcIdSet().size() == 0 || (intersection = Sets.intersection(set, result.getTarIdSet())).size() <= 0) continue;
            successList.add(result);
            hashSet.addAll(result.getSrcIdSet());
            waitRemoveTarIdSet.addAll(result.getTarIdSet());
            waitRemoveResultList.add(result);
        }
        resultList.removeAll(waitRemoveResultList);
        Set multiMatchTarIdSet = tarIdPresentCntMap.entrySet().stream().filter(o -> (Integer)o.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashSet<Object> matchedTarIdSet = new HashSet<Object>();
        for (CompareResult result : resultList) {
            Set<Object> tarIdSet = result.getTarIdSet();
            if (result.getSrcIdSet().size() == 0) continue;
            for (Object tarId : tarIdSet) {
                if (!multiMatchTarIdSet.contains(tarId) || !matchedTarIdSet.add(tarId)) continue;
                Object srcId = result.getSrcIdSet().iterator().next();
                hashSet.add(srcId);
                waitRemoveTarIdSet.add(tarId);
                successList.add(new CompareResult(Collections.singleton(tarId), Collections.singleton(srcId)));
            }
        }
        this.removeFromDataList(srcDataList, hashSet);
        this.removeFromDataList(tarDataList, waitRemoveTarIdSet);
    }
}

