/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.test.data;

import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.test.ITestDataProvider;
import kd.fi.cas.compare.test.TestUtil;

public class DateDiffCompareDataProvider
implements ITestDataProvider {
    private static final DateFormat FMT = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public List<Map<String, Object>> getSrcDataList() {
        LinkedList<Map<String, Object>> srcList = new LinkedList<Map<String, Object>>();
        srcList.add(this.generateDate(new Date(), -5, "src"));
        srcList.add(this.generateDate(new Date(), -4, "src"));
        srcList.add(this.generateDate(new Date(), -3, "src"));
        srcList.add(this.generateDate(new Date(), -2, "src"));
        srcList.add(this.generateDate(new Date(), -1, "src"));
        srcList.add(this.generateDate(new Date(), 0, "src"));
        srcList.add(this.generateDate(new Date(), 1, "src"));
        srcList.add(this.generateDate(new Date(), 2, "src"));
        srcList.add(this.generateDate(new Date(), 3, "src"));
        srcList.add(this.generateDate(new Date(), 4, "src"));
        srcList.add(this.generateDate(new Date(), 5, "src"));
        srcList.add(this.generateDate(new Date(), 6, "src"));
        srcList.add(this.generateNullData(true));
        srcList.add(this.generateNullData(false));
        return srcList;
    }

    @Override
    public List<Map<String, Object>> getTarDataList() {
        LinkedList<Map<String, Object>> tarList = new LinkedList<Map<String, Object>>();
        tarList.add(this.generateDate(new Date(), -5, "tar"));
        tarList.add(this.generateDate(new Date(), -4, "tar"));
        tarList.add(this.generateDate(new Date(), -3, "tar"));
        tarList.add(this.generateDate(new Date(), -2, "tar"));
        tarList.add(this.generateDate(new Date(), -1, "tar"));
        tarList.add(this.generateDate(new Date(), 0, "tar"));
        tarList.add(this.generateDate(new Date(), 1, "tar"));
        tarList.add(this.generateDate(new Date(), 2, "tar"));
        tarList.add(this.generateDate(new Date(), 3, "tar"));
        tarList.add(this.generateDate(new Date(), 4, "tar"));
        tarList.add(this.generateDate(new Date(), 5, "tar"));
        tarList.add(this.generateDate(new Date(), 6, "tar"));
        tarList.add(this.generateNullData(true));
        tarList.add(this.generateNullData(false));
        return tarList;
    }

    private Map<String, Object> generateDate(Date date, int dayDiff, String suffix) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, dayDiff);
        data.put("id", FMT.format(calendar.getTime()) + suffix);
        data.put("date", calendar.getTime());
        return data;
    }

    private Map<String, Object> generateNullData(boolean isBlankStr) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", TestUtil.getRandomId(new SecureRandom(), 18));
        data.put("date", isBlankStr ? "" : null);
        return data;
    }

    @Override
    public List<List<CompareRule>> getRule() {
        return Collections.singletonList(Collections.singletonList(new CompareRule(CompareRule.Symbol.DATE_DIFF, 3, "date", "date", true)));
    }

    @Override
    public String getName() {
        return "DateDiffCompareDataProvider";
    }

    @Override
    public List<CompareResult> runBruteForce() {
        return new ArrayList<CompareResult>();
    }
}

