/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.test.data;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.test.ITestDataProvider;
import kd.fi.cas.compare.test.TestUtil;

public class SubStringCompareTestProvider
implements ITestDataProvider {
    private static final int TAR_LEN = 4;
    private static final int TAR_CNT = 25000;
    private static final int SRC_CNT = 25000;
    private static final int SRC_LEN = 50;
    private List<Map<String, Object>> srcList;
    private List<Map<String, Object>> tarList;

    @Override
    public List<Map<String, Object>> getSrcDataList() {
        this.srcList = this.getDataList(18, 50, 25000);
        return this.srcList;
    }

    @Override
    public List<Map<String, Object>> getTarDataList() {
        this.tarList = new ArrayList<Map<String, Object>>();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < this.srcList.size() && i != 25000; ++i) {
            Map<String, Object> srcMap = this.srcList.get(i);
            HashMap<String, Object> tarMap = new HashMap<String, Object>(srcMap);
            int startIndex = random.nextInt(46);
            tarMap.put("str", ((String)tarMap.get("str")).substring(startIndex, startIndex + 4));
            this.tarList.add(tarMap);
        }
        Collections.shuffle(this.tarList);
        return this.tarList;
    }

    private List<Map<String, Object>> getDataList(int idLen, int strLen, int size) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(size);
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", i);
            data.put("str", TestUtil.getRandomString(random, strLen));
            dataList.add(data);
        }
        return dataList;
    }

    @Override
    public List<List<CompareRule>> getRule() {
        return Collections.singletonList(Collections.singletonList(new CompareRule(CompareRule.Symbol.STR_MATCH, "str")));
    }

    @Override
    public String getName() {
        return "SubStringComparator";
    }

    @Override
    public List<CompareResult> runBruteForce() {
        ArrayList<CompareResult> resultList = new ArrayList<CompareResult>();
        for (Map<String, Object> tar : this.tarList) {
            CompareResult result = new CompareResult(Collections.singleton(tar.get("id")), new HashSet<Object>());
            Set<Object> srcResList = result.getSrcIdSet();
            for (Map<String, Object> src : this.srcList) {
                String tarStr;
                String srcStr = (String)src.get("str");
                if (!srcStr.contains(tarStr = (String)tar.get("str"))) continue;
                srcResList.add(src.get("id"));
            }
            if (srcResList.size() <= 0) continue;
            resultList.add(result);
        }
        return resultList;
    }
}

